/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.LogFormatter;
import com.twitter.finagle.ssl.session.ServiceIdentity;
import com.twitter.finagle.transport.Transport$;
import com.twitter.util.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0002\u0005\u0001'!)a\u0004\u0001C\u0001?!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0017\u0001A\u0003%1\u0005C\u0003'\u0001\u0011\u0005a\u0006C\u0003I\u0001\u0011\u0005\u0011\nC\u0003b\u0001\u0011\u0005!M\u0001\nD_6lwN\u001c'pO\u001a{'/\\1ui\u0016\u0014(BA\u0005\u000b\u0003\u00191\u0017\u000e\u001c;fe*\u00111\u0002D\u0001\u0005QR$\bO\u0003\u0002\u000e\u001d\u00059a-\u001b8bO2,'BA\b\u0011\u0003\u001d!x/\u001b;uKJT\u0011!E\u0001\u0004G>l7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\taAj\\4G_Jl\u0017\r\u001e;fe\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u00037\u0001\t!\u0002R1uK\u001a{'/\\1u+\u0005\u0019\u0003C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003\u00191wN]7bi*\u0011\u0001&K\u0001\u0005i&lWMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051*#!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0006YA)\u0019;f\r>\u0014X.\u0019;!)\u0011ySg\u000f!\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IJ\u0013\u0001\u00027b]\u001eL!\u0001N\u0019\u0003\rM#(/\u001b8h\u0011\u00151D\u00011\u00018\u0003\u001d\u0011X-];fgR\u0004\"\u0001O\u001d\u000e\u0003)I!A\u000f\u0006\u0003\u000fI+\u0017/^3ti\")A\b\u0002a\u0001{\u0005A!/Z:q_:\u001cX\r\u0005\u00029}%\u0011qH\u0003\u0002\t%\u0016\u001c\bo\u001c8tK\")\u0011\t\u0002a\u0001\u0005\u0006a!/Z:q_:\u001cX\rV5nKB\u00111IR\u0007\u0002\t*\u0011QID\u0001\u0005kRLG.\u0003\u0002H\t\nAA)\u001e:bi&|g.A\bg_Jl\u0017\r^#yG\u0016\u0004H/[8o)\u0011QE+\u00161\u0011\u0005-\u0013fB\u0001'Q!\tie#D\u0001O\u0015\ty%#\u0001\u0004=e>|GOP\u0005\u0003#Z\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001bT\u0015\t\tf\u0003C\u00037\u000b\u0001\u0007q\u0007C\u0003W\u000b\u0001\u0007q+A\u0005uQJ|w/\u00192mKB\u0011\u0001,\u0018\b\u00033ns!!\u0014.\n\u0003]I!\u0001\u0018\f\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u0018\f\t\u000b\u0005+\u0001\u0019\u0001\"\u0002\u001b\u0019|'/\\1ui\u0016$G)\u0019;f)\u0005Q\u0005")
public class CommonLogFormatter
implements LogFormatter {
    private final DateTimeFormatter DateFormat;

    @Override
    public String escape(String s) {
        return LogFormatter.escape$(this, s);
    }

    public DateTimeFormatter DateFormat() {
        return this.DateFormat;
    }

    public String format(Request request, Response response, Duration responseTime) {
        String string;
        String remoteAddr = request.remoteAddress().getHostAddress();
        Option option = Transport$.MODULE$.sslSessionInfo().peerIdentity();
        if (option instanceof Some) {
            Some some = (Some)option;
            ServiceIdentity identity = (ServiceIdentity)some.value();
            string = identity.name();
        } else {
            string = "-";
        }
        String remoteUser = string;
        int contentLength = response.length();
        String contentLengthStr = contentLength > 0 ? ((Object)BoxesRunTime.boxToInteger((int)contentLength)).toString() : "-";
        String uaStr = (String)request.userAgent().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "-");
        StringBuilder builder = new StringBuilder();
        builder.append(remoteAddr);
        builder.append(" - ");
        builder.append(remoteUser);
        builder.append(" [");
        builder.append(this.formattedDate());
        builder.append("] \"");
        builder.append(this.escape(request.method().toString()));
        builder.append(' ');
        builder.append(this.escape(request.uri()));
        builder.append(' ');
        builder.append(this.escape(request.version().toString()));
        builder.append("\" ");
        builder.append(((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString());
        builder.append(' ');
        builder.append(contentLengthStr);
        builder.append(' ');
        builder.append(responseTime.inMillis());
        builder.append(" \"");
        builder.append(this.escape(uaStr));
        builder.append('\"');
        return builder.toString();
    }

    public String formatException(Request request, Throwable throwable, Duration responseTime) {
        throw new UnsupportedOperationException("Log throwables as empty 500s instead");
    }

    public String formattedDate() {
        return ZonedDateTime.now().format(this.DateFormat());
    }

    public CommonLogFormatter() {
        LogFormatter.$init$(this);
        this.DateFormat = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withLocale(Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    }
}

