/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.finagle.tracing.Tracing;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import scala.Function1;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class HttpTracingFilter$
extends SimpleFilter<Request, Response> {
    public static HttpTracingFilter$ MODULE$;
    private final Stack.Role Role;

    static {
        new HttpTracingFilter$();
    }

    public Stack.Role Role() {
        return this.Role;
    }

    public Future<Response> apply(Request request, Service<Request, Response> service) {
        Tracing tracing = Trace$.MODULE$.apply();
        this.traceHttpRequest(request, tracing);
        Future rep = service.apply((Object)request);
        return this.traceHttpResponse((Future<Response>)rep, tracing);
    }

    public void traceHttpRequest(Request request, Tracing tracing) {
        block0: {
            if (!tracing.isActivelyTracing()) break block0;
            tracing.recordRpc(request.method().toString());
            tracing.recordBinary("http.method", (Object)request.method().toString());
            tracing.recordBinary("http.uri", (Object)this.stripParameters(request.uri()));
        }
    }

    public Future<Response> traceHttpResponse(Future<Response> rep, Tracing tracing) {
        return !tracing.isActivelyTracing() ? rep : rep.flatMap((Function1 & java.io.Serializable & Serializable)r -> {
            tracing.recordBinary("http.status_code", (Object)BoxesRunTime.boxToInteger((int)r.statusCode()));
            return Future$.MODULE$.value(r);
        });
    }

    private String stripParameters(String uri) {
        String string;
        int n = uri.indexOf(63);
        switch (n) {
            case -1: {
                string = uri;
                break;
            }
            default: {
                string = uri.substring(0, n);
                break;
            }
        }
        return string;
    }

    public Stackable<ServiceFactory<Request, Response>> module() {
        return new Stack.Module0<ServiceFactory<Request, Response>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(ServiceFactory<Request, Response> next) {
                return HttpTracingFilter$.MODULE$.andThen(next);
            }
            {
                this.role = HttpTracingFilter$.MODULE$.Role();
                this.description = "Record http annotation for completed spans";
            }
        };
    }

    private HttpTracingFilter$() {
        MODULE$ = this;
        this.Role = new Stack.Role("HttpTracing");
    }
}

