/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.context.Deadline;
import com.twitter.finagle.context.Deadline$;
import com.twitter.finagle.context.Retries;
import com.twitter.finagle.context.Retries$;
import com.twitter.finagle.http.Message;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Time$;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class HttpContext$ {
    public static HttpContext$ MODULE$;
    private final String Prefix;
    private final String DeadlineHeaderKey;
    private final String RetriesHeaderKey;
    private final Logger log;
    private final Function1<String, Option<Deadline>> unmarshalDeadline;
    private final Function1<String, Option<Retries>> unmarshalRetries;

    static {
        new HttpContext$();
    }

    private Logger log() {
        return this.log;
    }

    public void removeDeadline(Message msg) {
        msg.headerMap().remove((Object)this.DeadlineHeaderKey);
    }

    private String marshalDeadline(Deadline deadline) {
        return deadline.timestamp().inNanoseconds() + " " + deadline.deadline().inNanoseconds();
    }

    private String marshalRetries(Retries retries) {
        return ((Object)BoxesRunTime.boxToInteger((int)retries.retries())).toString();
    }

    public <R> R read(Message msg, Function0<R> fn) {
        Context.Env env = Contexts$.MODULE$.broadcast().env();
        Option option = msg.headerMap().get((Object)this.DeadlineHeaderKey).flatMap(this.unmarshalDeadline);
        if (option instanceof Some) {
            Some some = (Some)option;
            Deadline deadline = (Deadline)some.value();
            env = env.bound((Object)Deadline$.MODULE$, (Object)deadline);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        Option option2 = msg.headerMap().get((Object)this.RetriesHeaderKey).flatMap(this.unmarshalRetries);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Retries retries = (Retries)some.value();
            env = env.bound((Object)Retries$.MODULE$, (Object)retries);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option2);
        }
        return (R)Contexts$.MODULE$.broadcast().let(env, fn);
    }

    public void write(Message msg) {
        BoxedUnit boxedUnit;
        Option option = Deadline$.MODULE$.current();
        if (option instanceof Some) {
            Some some = (Some)option;
            Deadline deadline = (Deadline)some.value();
            boxedUnit = msg.headerMap().set(this.DeadlineHeaderKey, this.marshalDeadline(deadline));
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        Option option2 = Retries$.MODULE$.current();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Retries retries = (Retries)some.value();
            msg.headerMap().set(this.RetriesHeaderKey, this.marshalRetries(retries));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option2);
        }
    }

    private HttpContext$() {
        MODULE$ = this;
        this.Prefix = "Finagle-Ctx-";
        this.DeadlineHeaderKey = this.Prefix + Deadline$.MODULE$.id();
        this.RetriesHeaderKey = this.Prefix + Retries$.MODULE$.id();
        this.log = Logger$.MODULE$.apply(this.getClass().getName());
        this.unmarshalDeadline = (Function1 & Serializable & scala.Serializable)header -> {
            None$ none$;
            try {
                String[] values = new StringOps(Predef$.MODULE$.augmentString(header)).split(' ');
                long timestamp = new StringOps(Predef$.MODULE$.augmentString(values[0])).toLong();
                long deadline = new StringOps(Predef$.MODULE$.augmentString(values[1])).toLong();
                none$ = new Some((Object)new Deadline(Time$.MODULE$.fromNanoseconds(timestamp), Time$.MODULE$.fromNanoseconds(deadline)));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    if (this.log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not unmarshal Deadline from header value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                } else {
                    throw throwable;
                }
                None$ none$2 = None$.MODULE$;
                none$ = none$2;
            }
            return none$;
        };
        this.unmarshalRetries = (Function1 & Serializable & scala.Serializable)header -> {
            Some some;
            try {
                some = new Some((Object)new Retries(new StringOps(Predef$.MODULE$.augmentString(header)).toInt()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    if (this.log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not unmarshal Retries from header value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                } else {
                    throw throwable;
                }
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        };
    }
}

