/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.http.Fields$;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class ResponseConformanceFilter$
extends SimpleFilter<Request, Response> {
    public static ResponseConformanceFilter$ MODULE$;
    private final Logger logger;

    static {
        new ResponseConformanceFilter$();
    }

    public Future<Response> apply(Request request, Service<Request, Response> service) {
        return service.apply((Object)request).map((Function1 & java.io.Serializable & Serializable)rep -> {
            this.validate(request, (Response)rep);
            return rep;
        });
    }

    private void validate(Request req, Response rep) {
        Method method = req.method();
        Method.Head$ head$ = Method.Head$.MODULE$;
        if (!(method != null ? !method.equals(head$) : head$ != null)) {
            this.handleHeadResponse(req, rep);
        } else if (rep.isChunked()) {
            this.handleChunkedResponse(rep);
        } else {
            this.handleFullyBufferedResponse(rep);
        }
    }

    private void handleFullyBufferedResponse(Response rep) {
        block0: {
            if (!rep.contentLength().isEmpty()) break block0;
            rep.contentLength_$eq((long)rep.content().length());
        }
    }

    private void handleChunkedResponse(Response rep) {
        rep.headerMap().set(Fields$.MODULE$.TransferEncoding(), "chunked");
        rep.headerMap().remove((Object)Fields$.MODULE$.ContentLength());
    }

    private void handleHeadResponse(Request request, Response response) {
        block2: {
            response.headerMap().remove((Object)Fields$.MODULE$.TransferEncoding());
            if (response.isChunked()) {
                response.headerMap().remove((Object)Fields$.MODULE$.ContentLength());
                response.reader().discard();
                response.setChunked(false);
            }
            if (response.content().isEmpty()) break block2;
            this.logger.error("Received response to HEAD request (%s) that contained a static body of length %d. Discarding body. If this is desired behavior, consider adding HeadFilter to your service", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.toString(), BoxesRunTime.boxToInteger((int)response.content().length())}));
            if (response.contentLength().isEmpty()) {
                response.contentLength_$eq((long)response.content().length());
            }
            response.clearContent();
        }
    }

    private ResponseConformanceFilter$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.get(this.getClass().getName());
    }
}

