/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.HttpTracing$;
import com.twitter.finagle.http.HttpTracing$Header$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.tracing.Flags;
import com.twitter.finagle.tracing.Flags$;
import com.twitter.finagle.tracing.SpanId;
import com.twitter.finagle.tracing.SpanId$;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.finagle.tracing.TraceId;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TraceInfo$ {
    public static TraceInfo$ MODULE$;

    static {
        new TraceInfo$();
    }

    private void removeAllHeaders(HeaderMap headers) {
        Iterator iter = HttpTracing$Header$.MODULE$.All().iterator();
        while (iter.hasNext()) {
            headers.$minus$eq(iter.next());
        }
    }

    public <R> R letTraceIdFromRequestHeaders(Request request, Function0<R> f) {
        Object object;
        Some some;
        if (HttpTracing$Header$.MODULE$.hasAllRequired(request.headerMap())) {
            None$ none$;
            Option spanId = SpanId$.MODULE$.fromString((String)request.headerMap().apply((Object)HttpTracing$Header$.MODULE$.SpanId()));
            Option option = spanId;
            if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else if (option instanceof Some) {
                Some some2 = (Some)option;
                SpanId sid = (SpanId)some2.value();
                Option traceId = SpanId$.MODULE$.fromString((String)request.headerMap().apply((Object)HttpTracing$Header$.MODULE$.TraceId()));
                None$ parentSpanId = request.headerMap().contains((Object)HttpTracing$Header$.MODULE$.ParentSpanId()) ? SpanId$.MODULE$.fromString((String)request.headerMap().apply((Object)HttpTracing$Header$.MODULE$.ParentSpanId())) : None$.MODULE$;
                String maybeSampled = request.headerMap().getOrNull(HttpTracing$Header$.MODULE$.Sampled());
                None$ sampled = maybeSampled == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToBoolean(("1".equals(maybeSampled) || Predef$.MODULE$.Boolean2boolean(Boolean.valueOf(maybeSampled)) ? 1 : 0) != 0));
                Flags flags = this.getFlags(request);
                none$ = new Some((Object)new TraceId(traceId, (Option)parentSpanId, sid, (Option)sampled, flags));
            } else {
                throw new MatchError((Object)option);
            }
            some = none$;
        } else if (request.headerMap().contains((Object)HttpTracing$Header$.MODULE$.Flags())) {
            TraceId qual$1 = Trace$.MODULE$.nextId();
            Flags x$86 = this.getFlags(request);
            Option x$87 = qual$1.copy$default$1();
            Option x$88 = qual$1.copy$default$2();
            SpanId x$89 = qual$1.copy$default$3();
            Option x$90 = qual$1.copy$default$4();
            Some some3 = new Some((Object)qual$1.copy(x$87, x$88, x$89, x$90, x$86));
            some = some3;
        } else {
            some = new Some((Object)Trace$.MODULE$.nextId());
        }
        Some id = some;
        this.removeAllHeaders(request.headerMap());
        Some some4 = id;
        if (some4 instanceof Some) {
            Some some5 = some4;
            TraceId tid = (TraceId)some5.value();
            object = Trace$.MODULE$.letId(tid, Trace$.MODULE$.letId$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
                this.traceRpc(request);
                return f.apply();
            });
        } else if (None$.MODULE$.equals(some4)) {
            this.traceRpc(request);
            object = f.apply();
        } else {
            throw new MatchError((Object)some4);
        }
        return (R)object;
    }

    public void setClientRequestHeaders(Request request) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        this.removeAllHeaders(request.headerMap());
        TraceId traceId = Trace$.MODULE$.id();
        request.headerMap().add(HttpTracing$Header$.MODULE$.TraceId(), traceId.traceId().toString());
        request.headerMap().add(HttpTracing$Header$.MODULE$.SpanId(), traceId.spanId().toString());
        Option option = traceId._parentId();
        if (option instanceof Some) {
            Some some = (Some)option;
            SpanId id = (SpanId)some.value();
            boxedUnit2 = request.headerMap().add(HttpTracing$Header$.MODULE$.ParentSpanId(), id.toString());
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        Option option2 = traceId.sampled();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            boolean sampled = BoxesRunTime.unboxToBoolean((Object)some.value());
            boxedUnit = request.headerMap().add(HttpTracing$Header$.MODULE$.Sampled(), ((Object)BoxesRunTime.boxToBoolean((boolean)sampled)).toString());
        } else if (None$.MODULE$.equals(option2)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option2);
        }
        request.headerMap().add(HttpTracing$Header$.MODULE$.Flags(), Long.toString(traceId.flags().toLong()));
        this.traceRpc(request);
    }

    public void traceRpc(Request request) {
        block0: {
            if (!Trace$.MODULE$.isActivelyTracing()) break block0;
            Trace$.MODULE$.recordRpc(request.method().toString());
            Trace$.MODULE$.recordBinary("http.uri", (Object)HttpTracing$.MODULE$.stripParameters(request.uri()));
        }
    }

    public Flags getFlags(Request request) {
        Flags flags;
        if (!request.headerMap().contains((Object)HttpTracing$Header$.MODULE$.Flags())) {
            flags = Flags$.MODULE$.apply();
        } else {
            try {
                flags = new Flags(Long.parseLong((String)request.headerMap().apply((Object)HttpTracing$Header$.MODULE$.Flags())));
            }
            catch (NumberFormatException numberFormatException) {
                flags = Flags$.MODULE$.apply();
            }
        }
        return flags;
    }

    private TraceInfo$() {
        MODULE$ = this;
    }
}

