/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.finagle.tracing.Tracing;
import com.twitter.util.Future;
import java.io.Serializable;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HttpTracingFilter$
extends SimpleFilter<Request, Response> {
    public static final HttpTracingFilter$ MODULE$ = new HttpTracingFilter$();
    private static final Stack.Role Role = new Stack.Role("HttpTracing");

    public Stack.Role Role() {
        return Role;
    }

    public Future<Response> apply(Request request, Service<Request, Response> service) {
        Tracing tracing = Trace$.MODULE$.apply();
        Future rep = service.apply((Object)request);
        this.traceHttpRequest(request, tracing);
        this.traceHttpResponse((Future<Response>)rep, tracing);
        return rep;
    }

    public void traceHttpRequest(Request request, Tracing tracing) {
        block0: {
            if (!tracing.isActivelyTracing()) break block0;
            tracing.recordRpc(request.method().toString());
            tracing.recordBinary("http.method", (Object)request.method().toString());
            tracing.recordBinary("http.uri", (Object)this.stripParameters(request.uri()));
        }
    }

    public void traceHttpResponse(Future<Response> rep, Tracing tracing) {
        block0: {
            if (!tracing.isActivelyTracing()) break block0;
            rep.onSuccess((Function1 & Serializable)r -> {
                tracing.recordBinary("http.status_code", (Object)BoxesRunTime.boxToInteger((int)r.statusCode()));
                return BoxedUnit.UNIT;
            });
        }
    }

    private String stripParameters(String uri) {
        String string;
        int n = uri.indexOf(63);
        switch (n) {
            case -1: {
                string = uri;
                break;
            }
            default: {
                string = uri.substring(0, n);
                break;
            }
        }
        return string;
    }

    public Stackable<ServiceFactory<Request, Response>> module() {
        return new Stack.Module0<ServiceFactory<Request, Response>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(ServiceFactory<Request, Response> next) {
                return HttpTracingFilter$.MODULE$.andThen(next);
            }
            {
                this.role = HttpTracingFilter$.MODULE$.Role();
                this.description = "Record http annotation for completed spans";
            }
        };
    }

    private HttpTracingFilter$() {
    }
}

