/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.memcached;

import com.twitter.finagle.memcached.Entry;
import com.twitter.finagle.memcached.Interpreter$;
import com.twitter.finagle.memcached.protocol.Add;
import com.twitter.finagle.memcached.protocol.Append;
import com.twitter.finagle.memcached.protocol.Cas;
import com.twitter.finagle.memcached.protocol.ClientError;
import com.twitter.finagle.memcached.protocol.Command;
import com.twitter.finagle.memcached.protocol.Decr;
import com.twitter.finagle.memcached.protocol.Delete;
import com.twitter.finagle.memcached.protocol.Deleted$;
import com.twitter.finagle.memcached.protocol.Get;
import com.twitter.finagle.memcached.protocol.Gets;
import com.twitter.finagle.memcached.protocol.Incr;
import com.twitter.finagle.memcached.protocol.NoOp$;
import com.twitter.finagle.memcached.protocol.NotFound$;
import com.twitter.finagle.memcached.protocol.NotStored$;
import com.twitter.finagle.memcached.protocol.Number;
import com.twitter.finagle.memcached.protocol.Prepend;
import com.twitter.finagle.memcached.protocol.Replace;
import com.twitter.finagle.memcached.protocol.Response;
import com.twitter.finagle.memcached.protocol.Set;
import com.twitter.finagle.memcached.protocol.Stored$;
import com.twitter.finagle.memcached.protocol.Value;
import com.twitter.finagle.memcached.protocol.Value$;
import com.twitter.finagle.memcached.protocol.Values;
import com.twitter.finagle.memcached.util.AtomicMap;
import com.twitter.finagle.memcached.util.ParserUtils$;
import com.twitter.io.Buf;
import com.twitter.util.Time;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0003\u0006\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003,\u0001\u0011\u0005A\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003=\u0001\u0011%Qh\u0002\u0004P\u0015!\u0005!\u0002\u0015\u0004\u0007\u0013)A\tAC)\t\u000b-2A\u0011\u0001*\t\rM3A\u0011\u0001\u0006U\u0005-Ie\u000e^3saJ,G/\u001a:\u000b\u0005-a\u0011!C7f[\u000e\f7\r[3e\u0015\tia\"A\u0004gS:\fw\r\\3\u000b\u0005=\u0001\u0012a\u0002;xSR$XM\u001d\u0006\u0002#\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u00075\f\u0007\u000f\u0005\u0003\u001d?\u0005:S\"A\u000f\u000b\u0005yQ\u0011\u0001B;uS2L!\u0001I\u000f\u0003\u0013\u0005#x.\\5d\u001b\u0006\u0004\bC\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u000f\u0003\tIw.\u0003\u0002'G\t\u0019!)\u001e4\u0011\u0005!JS\"\u0001\u0006\n\u0005)R!!B#oiJL\u0018A\u0002\u001fj]&$h\b\u0006\u0002.]A\u0011\u0001\u0006\u0001\u0005\u00065\t\u0001\raG\u0001\u0006CB\u0004H.\u001f\u000b\u0003c]\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0006\u0002\u0011A\u0014x\u000e^8d_2L!AN\u001a\u0003\u0011I+7\u000f]8og\u0016DQ\u0001O\u0002A\u0002e\nqaY8n[\u0006tG\r\u0005\u00023u%\u00111h\r\u0002\b\u0007>lW.\u00198e\u0003%9W\r\u001e\"z\u0017\u0016L8\u000f\u0006\u0002?\u0003B\u0011!gP\u0005\u0003\u0001N\u0012aAV1mk\u0016\u001c\b\"\u0002\"\u0005\u0001\u0004\u0019\u0015\u0001B6fsN\u00042\u0001\u0012'\"\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I%\u00051AH]8pizJ\u0011aF\u0005\u0003\u0017Z\tq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-3\u0012aC%oi\u0016\u0014\bO]3uKJ\u0004\"\u0001\u000b\u0004\u0014\u0005\u0019!B#\u0001)\u0002#\u001d,g.\u001a:bi\u0016\u001c\u0015m]+oSF,X\r\u0006\u0002\"+\")a\u000b\u0003a\u0001C\u0005)a/\u00197vK\u0002")
public class Interpreter {
    private final AtomicMap<Buf, Entry> map;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response apply(Command command) {
        Command command2 = command;
        if (command2 instanceof Set) {
            Set set = (Set)command2;
            Buf key2 = set.key();
            Time expiry = set.expiry();
            Buf value = set.value();
            return (Response)this.map.lock(key2, (Function1 & Serializable & scala.Serializable)data -> {
                data.update((Object)key2, (Object)new Entry(value, expiry));
                return Stored$.MODULE$;
            });
        }
        if (command2 instanceof Add) {
            Add add = (Add)command2;
            Buf key3 = add.key();
            Time expiry = add.expiry();
            Buf value = add.value();
            return (Response)this.map.lock(key3, (Function1 & Serializable & scala.Serializable)data -> {
                Response response;
                Some some;
                Entry entry;
                Option existing = data.get((Object)key3);
                Option option = existing;
                if (option instanceof Some && (entry = (Entry)(some = (Some)option).value()).valid()) {
                    response = NotStored$.MODULE$;
                } else {
                    data.update((Object)key3, (Object)new Entry(value, expiry));
                    response = Stored$.MODULE$;
                }
                return response;
            });
        }
        if (command2 instanceof Replace) {
            Replace replace = (Replace)command2;
            Buf key4 = replace.key();
            Time expiry = replace.expiry();
            Buf value = replace.value();
            return (Response)this.map.lock(key4, (Function1 & Serializable & scala.Serializable)data -> {
                void var4_12;
                Option existing = data.get((Object)key4);
                boolean bl = false;
                Some some = null;
                Option option = existing;
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    Entry entry = (Entry)some.value();
                    if (entry.valid()) {
                        data.update((Object)key4, (Object)new Entry(value, expiry));
                        Stored$ stored$ = Stored$.MODULE$;
                        return var4_12;
                    }
                }
                if (bl) {
                    data.remove((Object)key4);
                    NotStored$ notStored$ = NotStored$.MODULE$;
                    return var4_12;
                }
                NotStored$ notStored$ = NotStored$.MODULE$;
                return var4_12;
            });
        }
        if (command2 instanceof Append) {
            Append append = (Append)command2;
            Buf key5 = append.key();
            Time expiry = append.expiry();
            Buf value = append.value();
            if (value != null) {
                Buf buf = value;
                return (Response)this.map.lock(key5, (Function1 & Serializable & scala.Serializable)data -> {
                    void var4_12;
                    Option existing = data.get((Object)key5);
                    boolean bl = false;
                    Some some = null;
                    Option option = existing;
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        Entry entry = (Entry)some.value();
                        if (entry.valid()) {
                            data.update((Object)key5, (Object)new Entry(entry.value().concat(buf), expiry));
                            Stored$ stored$ = Stored$.MODULE$;
                            return var4_12;
                        }
                    }
                    if (bl) {
                        data.remove((Object)key5);
                        NotStored$ notStored$ = NotStored$.MODULE$;
                        return var4_12;
                    }
                    NotStored$ notStored$ = NotStored$.MODULE$;
                    return var4_12;
                });
            }
        }
        if (command2 instanceof Cas) {
            Cas cas = (Cas)command2;
            Buf key6 = cas.key();
            Time expiry = cas.expiry();
            Buf value = cas.value();
            Buf casUnique = cas.casUnique();
            return (Response)this.map.lock(key6, (Function1 & Serializable & scala.Serializable)data -> {
                NotStored$ notStored$;
                Some some;
                Entry entry;
                Option existing = data.get((Object)key6);
                Option option = existing;
                if (option instanceof Some && (entry = (Entry)(some = (Some)option).value()).valid()) {
                    Response response;
                    Buf currentValue = entry.value();
                    if (casUnique.equals((Object)Interpreter$.MODULE$.generateCasUnique(currentValue))) {
                        data.update((Object)key6, (Object)new Entry(value, expiry));
                        response = Stored$.MODULE$;
                    } else {
                        response = NotStored$.MODULE$;
                    }
                    notStored$ = response;
                } else {
                    notStored$ = NotStored$.MODULE$;
                }
                return notStored$;
            });
        }
        if (command2 instanceof Prepend) {
            Prepend prepend = (Prepend)command2;
            Buf key7 = prepend.key();
            Time expiry = prepend.expiry();
            Buf value = prepend.value();
            return (Response)this.map.lock(key7, (Function1 & Serializable & scala.Serializable)data -> {
                void var4_12;
                Option existing = data.get((Object)key7);
                boolean bl = false;
                Some some = null;
                Option option = existing;
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    Entry entry = (Entry)some.value();
                    if (entry.valid()) {
                        data.update((Object)key7, (Object)new Entry(value.concat(entry.value()), expiry));
                        Stored$ stored$ = Stored$.MODULE$;
                        return var4_12;
                    }
                }
                if (bl) {
                    data.remove((Object)key7);
                    NotStored$ notStored$ = NotStored$.MODULE$;
                    return var4_12;
                }
                NotStored$ notStored$ = NotStored$.MODULE$;
                return var4_12;
            });
        }
        if (command2 instanceof Get) {
            Get get = (Get)command2;
            Seq<Buf> keys = get.keys();
            return new Values((Seq<Value>)((Seq)keys.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable((Option)$this.map.lock((Buf)key, (Function1 & Serializable & scala.Serializable)data -> data.get(key).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)Interpreter.$anonfun$apply$9(data, key, entry))).map((Function1 & Serializable & scala.Serializable)entry -> new Value((Buf)key, entry.value(), Value$.MODULE$.apply$default$3(), Value$.MODULE$.apply$default$4())))), Seq$.MODULE$.canBuildFrom())));
        }
        if (command2 instanceof Gets) {
            Gets gets = (Gets)command2;
            Seq<Buf> keys = gets.keys();
            return this.getByKeys(keys);
        }
        if (command2 instanceof Delete) {
            Delete delete = (Delete)command2;
            Buf key8 = delete.key();
            return (Response)this.map.lock(key8, (Function1 & Serializable & scala.Serializable)data -> data.remove((Object)key8).isDefined() ? Deleted$.MODULE$ : NotFound$.MODULE$);
        }
        if (command2 instanceof Incr) {
            Incr incr = (Incr)command2;
            Buf key9 = incr.key();
            long delta = incr.value();
            return (Response)this.map.lock(key9, (Function1 & Serializable & scala.Serializable)data -> {
                void var4_18;
                Option existing = data.get((Object)key9);
                boolean bl = false;
                Some some = null;
                Option option = existing;
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    Entry entry = (Entry)some.value();
                    if (entry.valid()) {
                        String existingString;
                        Buf buf = entry.value();
                        Some some2 = Buf.Utf8$.MODULE$.unapply(buf);
                        if (some2.isEmpty()) throw new MatchError((Object)buf);
                        String string = existingString = (String)some2.get();
                        String existingString2 = string;
                        if (!existingString2.isEmpty() && !ParserUtils$.MODULE$.isDigits(entry.value())) {
                            throw new ClientError("cannot increment or decrement non-numeric value");
                        }
                        long existingValue = existingString2.isEmpty() ? 0L : new StringOps(Predef$.MODULE$.augmentString(existingString2)).toLong();
                        long result = existingValue + delta;
                        data.update((Object)key9, (Object)new Entry(Buf.Utf8$.MODULE$.apply(((Object)BoxesRunTime.boxToLong((long)result)).toString()), entry.expiry()));
                        Number number = new Number(result);
                        return var4_18;
                    }
                }
                if (bl) {
                    data.remove((Object)key9);
                    NotFound$ notFound$ = NotFound$.MODULE$;
                    return var4_18;
                }
                NotFound$ notFound$ = NotFound$.MODULE$;
                return var4_18;
            });
        }
        if (!(command2 instanceof Decr)) return NoOp$.MODULE$;
        Decr decr = (Decr)command2;
        Buf key10 = decr.key();
        long value = decr.value();
        return (Response)this.map.lock(key10, (Function1 & Serializable & scala.Serializable)data -> this.apply(new Incr(key10, -value)));
    }

    private Values getByKeys(Seq<Buf> keys) {
        return new Values((Seq<Value>)((Seq)keys.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable((Option)$this.map.lock((Buf)key, (Function1 & Serializable & scala.Serializable)data -> data.get(key).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)entry.valid())).map((Function1 & Serializable & scala.Serializable)entry -> {
            Buf value = entry.value();
            return new Value((Buf)key, value, (Option<Buf>)new Some((Object)Interpreter$.MODULE$.generateCasUnique(value)), Value$.MODULE$.apply$default$4());
        }))), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$apply$9(Map data$1, Buf key$7, Entry entry) {
        Object object = !entry.valid() ? data$1.remove((Object)key$7) : BoxedUnit.UNIT;
        return entry.valid();
    }

    public Interpreter(AtomicMap<Buf, Entry> map) {
        this.map = map;
    }
}

