/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.memcached;

import com.twitter.finagle.memcached.KeyValidation;
import com.twitter.finagle.memcached.KeyValidation$KeyTooLong$;
import com.twitter.finagle.memcached.KeyValidation$NullKey$;
import com.twitter.finagle.memcached.KeyValidation$ValidKey$;
import com.twitter.finagle.memcached.KeyValidation$processor$;
import com.twitter.finagle.memcached.util.Bufs$;
import com.twitter.io.Buf;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KeyValidation$ {
    public static KeyValidation$ MODULE$;
    private final int MaxKeyLength;
    private final Function1<Buf, BoxedUnit> KeyCheck;

    static {
        new KeyValidation$();
    }

    public void checkKeys(Iterable<Buf> keys) {
        Iterable<Buf> ks = keys;
        if (ks == null) {
            throw new IllegalArgumentException("Invalid keys: cannot have null for keys");
        }
        ks.foreach(this.KeyCheck);
    }

    public void checkKey(Buf key) {
        KeyValidation.KeyValidationResult keyValidationResult = this.validateKeyBuf(key);
        if (!KeyValidation$ValidKey$.MODULE$.equals(keyValidationResult)) {
            if (KeyValidation$NullKey$.MODULE$.equals(keyValidationResult)) {
                throw new IllegalArgumentException("Invalid keys: key cannot be null");
            }
            if (KeyValidation$KeyTooLong$.MODULE$.equals(keyValidationResult)) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Invalid keys: key cannot be longer than ").append(this.MaxKeyLength).append(" bytes (").append(key.length()).append(")").toString());
            }
            if (keyValidationResult instanceof KeyValidation.InvalidCharacter) {
                byte ch;
                KeyValidation.InvalidCharacter invalidCharacter = (KeyValidation.InvalidCharacter)keyValidationResult;
                byte arg$macro$1 = ch = invalidCharacter.ch();
                throw new IllegalArgumentException(new StringOps("Invalid keys: key cannot have whitespace or control characters: '0x%x'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)arg$macro$1)})));
            }
            throw new MatchError((Object)keyValidationResult);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean validateKey(String key) {
        boolean bl;
        KeyValidation.KeyValidationResult keyValidationResult = this.validateKeyBuf(Bufs$.MODULE$.nonEmptyStringToBuf(key));
        if (KeyValidation$ValidKey$.MODULE$.equals(keyValidationResult)) {
            bl = true;
        } else {
            boolean bl2 = keyValidationResult instanceof KeyValidation.InvalidCharacter ? true : (KeyValidation$KeyTooLong$.MODULE$.equals(keyValidationResult) ? true : KeyValidation$NullKey$.MODULE$.equals(keyValidationResult));
            if (bl2) {
                bl = false;
            } else {
                throw new MatchError((Object)keyValidationResult);
            }
        }
        return bl;
    }

    private KeyValidation.KeyValidationResult validateKeyBuf(Buf key) {
        KeyValidation.KeyValidationResult keyValidationResult;
        if (key == null) {
            keyValidationResult = KeyValidation$NullKey$.MODULE$;
        } else if (this.tooLong(key)) {
            keyValidationResult = KeyValidation$KeyTooLong$.MODULE$;
        } else {
            int index = this.invalidByteIndex(key);
            if (index != -1) {
                byte ch = key.get(index);
                keyValidationResult = new KeyValidation.InvalidCharacter(ch);
            } else {
                keyValidationResult = KeyValidation$ValidKey$.MODULE$;
            }
        }
        return keyValidationResult;
    }

    private int invalidByteIndex(Buf key) {
        return key.process((Buf.Processor)KeyValidation$processor$.MODULE$);
    }

    private boolean tooLong(Buf key) {
        return key.length() > this.MaxKeyLength;
    }

    public boolean com$twitter$finagle$memcached$KeyValidation$$invalidChar(byte b) {
        return b <= 32 && (b == 10 || b == 0 || b == 13 || b == 32);
    }

    private KeyValidation$() {
        MODULE$ = this;
        this.MaxKeyLength = 250;
        this.KeyCheck = (Function1 & java.io.Serializable & Serializable)x$1 -> {
            KeyValidation$.MODULE$.checkKey(x$1);
            return BoxedUnit.UNIT;
        };
    }
}

