/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.memcached.protocol.text.client;

import com.twitter.finagle.memcached.protocol.Add;
import com.twitter.finagle.memcached.protocol.Append;
import com.twitter.finagle.memcached.protocol.Cas;
import com.twitter.finagle.memcached.protocol.Command;
import com.twitter.finagle.memcached.protocol.Decr;
import com.twitter.finagle.memcached.protocol.Delete;
import com.twitter.finagle.memcached.protocol.Get;
import com.twitter.finagle.memcached.protocol.Gets;
import com.twitter.finagle.memcached.protocol.Getv;
import com.twitter.finagle.memcached.protocol.Incr;
import com.twitter.finagle.memcached.protocol.Prepend;
import com.twitter.finagle.memcached.protocol.Quit;
import com.twitter.finagle.memcached.protocol.Replace;
import com.twitter.finagle.memcached.protocol.Set;
import com.twitter.finagle.memcached.protocol.Stats;
import com.twitter.finagle.memcached.protocol.Upsert;
import com.twitter.finagle.memcached.protocol.text.client.AbstractCommandToBuf;
import com.twitter.io.Buf;
import com.twitter.util.Time;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3Q\u0001F\u000b\u0001;\rBQ\u0001\f\u0001\u0005\u00029Ba\u0001\r\u0001!\u0002\u0013\t\u0004BB\u001c\u0001A\u0003%\u0011\u0007\u0003\u00049\u0001\u0001\u0006I!\r\u0005\u0007s\u0001\u0001\u000b\u0011B\u0019\t\ri\u0002\u0001\u0015!\u00032\u0011\u0019Y\u0004\u0001)A\u0005c!1A\b\u0001Q\u0001\nEBa!\u0010\u0001!\u0002\u0013\t\u0004B\u0002 \u0001A\u0003%\u0011\u0007\u0003\u0004@\u0001\u0001\u0006I!\r\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u0019\t\r\u0005\u0003\u0001\u0015!\u00032\u0011\u0019\u0011\u0005\u0001)A\u0005c!11\t\u0001Q\u0001\nEBa\u0001\u0012\u0001!\u0002\u0013\t\u0004BB#\u0001A\u0003%\u0011\u0007\u0003\u0004G\u0001\u0001&Ia\u0012\u0005\u0006!\u0002!\t!\u0015\u0002\r\u0007>lW.\u00198e)>\u0014UO\u001a\u0006\u0003-]\taa\u00197jK:$(B\u0001\r\u001a\u0003\u0011!X\r\u001f;\u000b\u0005iY\u0012\u0001\u00039s_R|7m\u001c7\u000b\u0005qi\u0012!C7f[\u000e\f7\r[3e\u0015\tqr$A\u0004gS:\fw\r\\3\u000b\u0005\u0001\n\u0013a\u0002;xSR$XM\u001d\u0006\u0002E\u0005\u00191m\\7\u0014\u0005\u0001!\u0003cA\u0013'Q5\tQ#\u0003\u0002(+\t!\u0012IY:ue\u0006\u001cGoQ8n[\u0006tG\rV8Ck\u001a\u0004\"!\u000b\u0016\u000e\u0003eI!aK\r\u0003\u000f\r{W.\\1oI\u00061A(\u001b8jiz\u001a\u0001\u0001F\u00010!\t)\u0003!A\u0002H\u000bR\u0003\"AM\u001b\u000e\u0003MR!\u0001N\u0010\u0002\u0005%|\u0017B\u0001\u001c4\u0005\r\u0011UOZ\u0001\u0005\u000f\u0016#6+\u0001\u0004E\u000b2+E+R\u0001\u0005\u0013:\u001b%+\u0001\u0003E\u000b\u000e\u0013\u0016aA!E\t\u0006\u00191+\u0012+\u0002\r\u0005\u0003\u0006+\u0012(E\u0003\u001d\u0001&+\u0012)F\u001d\u0012\u000bqAU#Q\u0019\u0006\u001bU)A\u0002D\u0003N\u000bAaR#U-\u00061Q\u000bU*F%R\u000bA!U+J)\u0006)1\u000bV!U'\u00069!,\u001a:p\u0005V4\u0017!C5oiR{W\u000b\u001e49)\t\t\u0004\nC\u0003J%\u0001\u0007!*A\u0001j!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\rIe\u000e^\u0001\u0007K:\u001cw\u000eZ3\u0015\u0005E\u0012\u0006\"B*\u0014\u0001\u0004A\u0013aB7fgN\fw-\u001a")
public class CommandToBuf
extends AbstractCommandToBuf<Command> {
    private final Buf GET = Buf.Utf8$.MODULE$.apply("get");
    private final Buf GETS = Buf.Utf8$.MODULE$.apply("gets");
    private final Buf DELETE = Buf.Utf8$.MODULE$.apply("delete");
    private final Buf INCR = Buf.Utf8$.MODULE$.apply("incr");
    private final Buf DECR = Buf.Utf8$.MODULE$.apply("decr");
    private final Buf ADD = Buf.Utf8$.MODULE$.apply("add");
    private final Buf SET = Buf.Utf8$.MODULE$.apply("set");
    private final Buf APPEND = Buf.Utf8$.MODULE$.apply("append");
    private final Buf PREPEND = Buf.Utf8$.MODULE$.apply("prepend");
    private final Buf REPLACE = Buf.Utf8$.MODULE$.apply("replace");
    private final Buf CAS = Buf.Utf8$.MODULE$.apply("cas");
    private final Buf GETV = Buf.Utf8$.MODULE$.apply("getv");
    private final Buf UPSERT = Buf.Utf8$.MODULE$.apply("upsert");
    private final Buf QUIT = Buf.Utf8$.MODULE$.apply("quit");
    private final Buf STATS = Buf.Utf8$.MODULE$.apply("stats");
    private final Buf ZeroBuf = Buf.Utf8$.MODULE$.apply("0");

    private Buf intToUtf8(int i) {
        return i == 0 ? this.ZeroBuf : Buf.Utf8$.MODULE$.apply(((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    @Override
    public Buf encode(Command message) {
        Buf buf;
        Command command = message;
        if (command instanceof Add) {
            Add add = (Add)command;
            Buf key = add.key();
            int flags = add.flags();
            Time expiry = add.expiry();
            Buf value = add.value();
            buf = this.encodeCommandWithData(this.ADD, key, this.intToUtf8(flags), this.intToUtf8(expiry.inSeconds()), value, this.encodeCommandWithData$default$6());
        } else if (command instanceof Set) {
            Set set = (Set)command;
            Buf key = set.key();
            int flags = set.flags();
            Time expiry = set.expiry();
            Buf value = set.value();
            buf = this.encodeCommandWithData(this.SET, key, this.intToUtf8(flags), this.intToUtf8(expiry.inSeconds()), value, this.encodeCommandWithData$default$6());
        } else if (command instanceof Replace) {
            Replace replace = (Replace)command;
            Buf key = replace.key();
            int flags = replace.flags();
            Time expiry = replace.expiry();
            Buf value = replace.value();
            buf = this.encodeCommandWithData(this.REPLACE, key, this.intToUtf8(flags), this.intToUtf8(expiry.inSeconds()), value, this.encodeCommandWithData$default$6());
        } else if (command instanceof Append) {
            Append append = (Append)command;
            Buf key = append.key();
            int flags = append.flags();
            Time expiry = append.expiry();
            Buf value = append.value();
            buf = this.encodeCommandWithData(this.APPEND, key, this.intToUtf8(flags), this.intToUtf8(expiry.inSeconds()), value, this.encodeCommandWithData$default$6());
        } else if (command instanceof Prepend) {
            Prepend prepend = (Prepend)command;
            Buf key = prepend.key();
            int flags = prepend.flags();
            Time expiry = prepend.expiry();
            Buf value = prepend.value();
            buf = this.encodeCommandWithData(this.PREPEND, key, this.intToUtf8(flags), this.intToUtf8(expiry.inSeconds()), value, this.encodeCommandWithData$default$6());
        } else if (command instanceof Cas) {
            Cas cas = (Cas)command;
            Buf key = cas.key();
            int flags = cas.flags();
            Time expiry = cas.expiry();
            Buf value = cas.value();
            Buf casUnique = cas.casUnique();
            buf = this.encodeCommandWithData(this.CAS, key, this.intToUtf8(flags), this.intToUtf8(expiry.inSeconds()), value, (Option<Buf>)new Some((Object)casUnique));
        } else if (command instanceof Upsert) {
            Upsert upsert = (Upsert)command;
            Buf key = upsert.key();
            int flags = upsert.flags();
            Time expiry = upsert.expiry();
            Buf value = upsert.value();
            Buf version = upsert.version();
            buf = this.encodeCommandWithData(this.UPSERT, key, this.intToUtf8(flags), this.intToUtf8(expiry.inSeconds()), value, (Option<Buf>)new Some((Object)version));
        } else if (command instanceof Get) {
            Get get = (Get)command;
            Seq<Buf> keys = get.keys();
            Buf buf2 = this.GET;
            buf = this.encodeCommand((Seq<Buf>)((Seq)keys.$plus$colon((Object)buf2, Seq$.MODULE$.canBuildFrom())));
        } else if (command instanceof Gets) {
            Gets gets = (Gets)command;
            Seq<Buf> keys = gets.keys();
            Buf buf3 = this.GETS;
            buf = this.encodeCommand((Seq<Buf>)((Seq)keys.$plus$colon((Object)buf3, Seq$.MODULE$.canBuildFrom())));
        } else if (command instanceof Getv) {
            Getv getv = (Getv)command;
            Seq<Buf> keys = getv.keys();
            Buf buf4 = this.GETV;
            buf = this.encodeCommand((Seq<Buf>)((Seq)keys.$plus$colon((Object)buf4, Seq$.MODULE$.canBuildFrom())));
        } else if (command instanceof Incr) {
            Incr incr = (Incr)command;
            Buf key = incr.key();
            long amount = incr.value();
            buf = this.encodeCommand((Seq<Buf>)((Seq)new .colon.colon((Object)this.INCR, (List)new .colon.colon((Object)key, (List)new .colon.colon((Object)Buf.Utf8$.MODULE$.apply(((Object)BoxesRunTime.boxToLong((long)amount)).toString()), (List)Nil$.MODULE$)))));
        } else if (command instanceof Decr) {
            Decr decr = (Decr)command;
            Buf key = decr.key();
            long amount = decr.value();
            buf = this.encodeCommand((Seq<Buf>)((Seq)new .colon.colon((Object)this.DECR, (List)new .colon.colon((Object)key, (List)new .colon.colon((Object)Buf.Utf8$.MODULE$.apply(((Object)BoxesRunTime.boxToLong((long)amount)).toString()), (List)Nil$.MODULE$)))));
        } else if (command instanceof Delete) {
            Delete delete = (Delete)command;
            Buf key = delete.key();
            buf = this.encodeCommand((Seq<Buf>)((Seq)new .colon.colon((Object)this.DELETE, (List)new .colon.colon((Object)key, (List)Nil$.MODULE$))));
        } else if (command instanceof Stats) {
            Stats stats = (Stats)command;
            Seq<Buf> args = stats.args();
            Buf buf5 = this.STATS;
            buf = this.encodeCommand((Seq<Buf>)((Seq)args.$plus$colon((Object)buf5, Seq$.MODULE$.canBuildFrom())));
        } else if (command instanceof Quit) {
            buf = this.encodeCommand((Seq<Buf>)((Seq)new .colon.colon((Object)this.QUIT, (List)Nil$.MODULE$)));
        } else {
            throw new MatchError((Object)command);
        }
        return buf;
    }
}

