/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.memcached.protocol.text.server;

import com.twitter.conversions.DurationOps;
import com.twitter.conversions.DurationOps$;
import com.twitter.finagle.memcached.protocol.ClientError;
import com.twitter.finagle.memcached.util.Bufs$;
import com.twitter.finagle.memcached.util.ParserUtils$;
import com.twitter.io.Buf;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class MemcachedServerDecoder$ {
    public static MemcachedServerDecoder$ MODULE$;
    private final Buf NOREPLY;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$SET;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$ADD;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$REPLACE;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$APPEND;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$PREPEND;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GET;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GETS;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DELETE;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$INCR;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DECR;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$QUIT;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$STATS;
    private final Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$CAS;
    private final int RealtimeMaxdelta;

    static {
        new MemcachedServerDecoder$();
    }

    private Buf NOREPLY() {
        return this.NOREPLY;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$SET() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$SET;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$ADD() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$ADD;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$REPLACE() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$REPLACE;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$APPEND() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$APPEND;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$PREPEND() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$PREPEND;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GET() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GET;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GETS() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GETS;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DELETE() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DELETE;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$INCR() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$INCR;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DECR() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DECR;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$QUIT() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$QUIT;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$STATS() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$STATS;
    }

    public Buf com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$CAS() {
        return this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$CAS;
    }

    public Tuple2<Buf, Object> com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$validateArithmeticCommand(Seq<Buf> tokens) {
        if (tokens.size() < 2) {
            throw new ClientError("Too few arguments");
        }
        if (tokens.size() == 3) {
            Object object = tokens.last();
            Buf buf = this.NOREPLY();
            if (object == null ? buf != null : !object.equals(buf)) {
                throw new ClientError("Too many arguments");
            }
        }
        if (!ParserUtils$.MODULE$.isDigits((Buf)tokens.apply(1))) {
            throw new ClientError("Delta is not a number");
        }
        return new Tuple2(tokens.head(), (Object)BoxesRunTime.boxToLong((long)Bufs$.MODULE$.RichBuf((Buf)tokens.apply(1)).toLong()));
    }

    public Buf validateDeleteCommand(Seq<Buf> tokens) {
        if (tokens.size() < 1) {
            throw new ClientError("No key");
        }
        if (tokens.size() == 2 && !ParserUtils$.MODULE$.isDigits((Buf)tokens.last())) {
            throw new ClientError("Timestamp is poorly formed");
        }
        if (tokens.size() > 2) {
            throw new ClientError("Too many arguments");
        }
        return (Buf)tokens.head();
    }

    public Tuple4<Buf, Object, Time, Buf> validateStorageCommand(Seq<Buf> tokens, Buf data) {
        Time expiry = this.getExpiry(tokens);
        return new Tuple4(tokens.apply(0), (Object)BoxesRunTime.boxToInteger((int)Bufs$.MODULE$.RichBuf((Buf)tokens.apply(1)).toInt()), (Object)expiry, (Object)data);
    }

    public Tuple5<Buf, Object, Time, Buf, Buf> validateCasCommand(Seq<Buf> tokens, Buf data, Buf casUnique) {
        Time expiry = this.getExpiry(tokens);
        return new Tuple5(tokens.apply(0), (Object)BoxesRunTime.boxToInteger((int)Bufs$.MODULE$.RichBuf((Buf)tokens.apply(1)).toInt()), (Object)expiry, (Object)data, (Object)casUnique);
    }

    private Time getExpiry(Seq<Buf> tokens) {
        Time time;
        int n = Bufs$.MODULE$.RichBuf((Buf)tokens.apply(2)).toInt();
        switch (n) {
            case 0: {
                time = Time$.MODULE$.epoch();
                break;
            }
            default: {
                if (n > this.RealtimeMaxdelta) {
                    time = Time$.MODULE$.fromSeconds(n);
                    break;
                }
                time = DurationOps.RichDuration$.MODULE$.seconds$extension(DurationOps$.MODULE$.richDurationFromInt(n)).fromNow();
                break;
            }
        }
        return time;
    }

    private MemcachedServerDecoder$() {
        MODULE$ = this;
        this.NOREPLY = Buf.Utf8$.MODULE$.apply("noreply");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$SET = Buf.Utf8$.MODULE$.apply("set");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$ADD = Buf.Utf8$.MODULE$.apply("add");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$REPLACE = Buf.Utf8$.MODULE$.apply("replace");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$APPEND = Buf.Utf8$.MODULE$.apply("append");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$PREPEND = Buf.Utf8$.MODULE$.apply("prepend");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GET = Buf.Utf8$.MODULE$.apply("get");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$GETS = Buf.Utf8$.MODULE$.apply("gets");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DELETE = Buf.Utf8$.MODULE$.apply("delete");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$INCR = Buf.Utf8$.MODULE$.apply("incr");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$DECR = Buf.Utf8$.MODULE$.apply("decr");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$QUIT = Buf.Utf8$.MODULE$.apply("quit");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$STATS = Buf.Utf8$.MODULE$.apply("stats");
        this.com$twitter$finagle$memcached$protocol$text$server$MemcachedServerDecoder$$CAS = Buf.Utf8$.MODULE$.apply("cas");
        this.RealtimeMaxdelta = 2592000;
    }
}

