/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.memcached.protocol.text.server;

import com.twitter.finagle.memcached.protocol.Deleted$;
import com.twitter.finagle.memcached.protocol.Error;
import com.twitter.finagle.memcached.protocol.Exists$;
import com.twitter.finagle.memcached.protocol.Info;
import com.twitter.finagle.memcached.protocol.InfoLines;
import com.twitter.finagle.memcached.protocol.NoOp$;
import com.twitter.finagle.memcached.protocol.NotFound$;
import com.twitter.finagle.memcached.protocol.NotStored$;
import com.twitter.finagle.memcached.protocol.Number;
import com.twitter.finagle.memcached.protocol.Response;
import com.twitter.finagle.memcached.protocol.Stored$;
import com.twitter.finagle.memcached.protocol.Value;
import com.twitter.finagle.memcached.protocol.Values;
import com.twitter.finagle.memcached.protocol.ValuesAndErrors;
import com.twitter.finagle.memcached.protocol.text.EncodingConstants$;
import com.twitter.finagle.memcached.protocol.text.server.ExceptionHandler$;
import com.twitter.io.Buf;
import com.twitter.io.BufByteWriter;
import com.twitter.io.BufByteWriter$;
import com.twitter.io.ByteWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class ResponseToBuf$ {
    public static ResponseToBuf$ MODULE$;
    private final Buf ZERO;
    private final Buf VALUE;
    private final Buf STORED;
    private final Buf NOT_STORED;
    private final Buf EXISTS;
    private final Buf NOT_FOUND;
    private final Buf DELETED;

    static {
        new ResponseToBuf$();
    }

    private Buf encodeResponse(Seq<Buf> response) {
        BufByteWriter bw = BufByteWriter$.MODULE$.dynamic(10 * response.size() + 2);
        response.foreach((Function1 & Serializable & scala.Serializable)token -> {
            bw.writeBytes(token);
            return (BufByteWriter)bw.writeBytes(EncodingConstants$.MODULE$.SPACE());
        });
        bw.writeBytes(EncodingConstants$.MODULE$.DELIMITER());
        return bw.owned();
    }

    private ByteWriter writeResponseWithData(Seq<Buf> response, Buf data, Option<Buf> casUnique, ByteWriter bw) {
        response.foreach((Function1 & Serializable & scala.Serializable)token -> {
            bw.writeBytes(token);
            return bw.writeBytes(EncodingConstants$.MODULE$.SPACE());
        });
        bw.writeBytes(((Object)BoxesRunTime.boxToInteger((int)data.length())).toString().getBytes(StandardCharsets.US_ASCII));
        casUnique.foreach((Function1 & Serializable & scala.Serializable)token -> {
            bw.writeBytes(EncodingConstants$.MODULE$.SPACE());
            return bw.writeBytes(token);
        });
        bw.writeBytes(EncodingConstants$.MODULE$.DELIMITER());
        bw.writeBytes(data);
        bw.writeBytes(EncodingConstants$.MODULE$.DELIMITER());
        return bw;
    }

    private Buf encodeResponseLines(Seq<Seq<Buf>> lines) {
        BufByteWriter bw = BufByteWriter$.MODULE$.dynamic(100 * lines.size() + 5);
        lines.foreach((Function1 & Serializable & scala.Serializable)tokens -> {
            tokens.foreach((Function1 & Serializable & scala.Serializable)token -> {
                bw.writeBytes(token);
                return (BufByteWriter)bw.writeBytes(EncodingConstants$.MODULE$.SPACE());
            });
            return (BufByteWriter)bw.writeBytes(EncodingConstants$.MODULE$.DELIMITER());
        });
        bw.writeBytes(EncodingConstants$.MODULE$.END());
        bw.writeBytes(EncodingConstants$.MODULE$.DELIMITER());
        return bw.owned();
    }

    public Buf encode(Response message) {
        Buf buf;
        Response response = message;
        if (Stored$.MODULE$.equals(response)) {
            buf = this.encodeResponse((Seq<Buf>)((Seq)new .colon.colon((Object)this.STORED, (List)Nil$.MODULE$)));
        } else if (NotStored$.MODULE$.equals(response)) {
            buf = this.encodeResponse((Seq<Buf>)((Seq)new .colon.colon((Object)this.NOT_STORED, (List)Nil$.MODULE$)));
        } else if (Exists$.MODULE$.equals(response)) {
            buf = this.encodeResponse((Seq<Buf>)((Seq)new .colon.colon((Object)this.EXISTS, (List)Nil$.MODULE$)));
        } else if (Deleted$.MODULE$.equals(response)) {
            buf = this.encodeResponse((Seq<Buf>)((Seq)new .colon.colon((Object)this.DELETED, (List)Nil$.MODULE$)));
        } else if (NotFound$.MODULE$.equals(response)) {
            buf = this.encodeResponse((Seq<Buf>)((Seq)new .colon.colon((Object)this.NOT_FOUND, (List)Nil$.MODULE$)));
        } else if (NoOp$.MODULE$.equals(response)) {
            buf = this.encodeResponse((Seq<Buf>)Nil$.MODULE$);
        } else if (response instanceof Number) {
            Number number = (Number)response;
            long value = number.value();
            buf = this.encodeResponse((Seq<Buf>)((Seq)new .colon.colon((Object)Buf.Utf8$.MODULE$.apply(((Object)BoxesRunTime.boxToLong((long)value)).toString()), (List)Nil$.MODULE$)));
        } else if (response instanceof Error) {
            Error error = (Error)response;
            Exception cause = error.cause();
            Seq<byte[]> formatted = ExceptionHandler$.MODULE$.format(cause);
            buf = this.encodeResponse((Seq<Buf>)((Seq)formatted.map((Function1 & Serializable & scala.Serializable)x$1 -> Buf.ByteArray$.Owned$.MODULE$.apply(x$1), Seq$.MODULE$.canBuildFrom())));
        } else {
            if (response instanceof ValuesAndErrors) {
                throw new IllegalStateException("ValuesAndErrors is expected only on the client side");
            }
            if (response instanceof InfoLines) {
                InfoLines infoLines = (InfoLines)response;
                Seq<Info> lines = infoLines.lines();
                Seq statLines = (Seq)lines.map((Function1 & Serializable & scala.Serializable)line -> {
                    Buf key = line.key();
                    Seq<Buf> values = line.values();
                    return (Seq)((TraversableLike)new .colon.colon((Object)key, (List)Nil$.MODULE$)).$plus$plus(values, Seq$.MODULE$.canBuildFrom());
                }, Seq$.MODULE$.canBuildFrom());
                buf = this.encodeResponseLines((Seq<Seq<Buf>>)statLines);
            } else if (response instanceof Values) {
                Values values = (Values)response;
                Seq<Value> values2 = values.values();
                BufByteWriter bw = BufByteWriter$.MODULE$.dynamic(100 * values2.size() + 5);
                values2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Value value = x0$1;
                    if (value != null) {
                        Buf key = value.key();
                        Buf value2 = value.value();
                        Option<Buf> casUnique = value.casUnique();
                        Option<Buf> option = value.flags();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Buf flags = (Buf)some.value();
                            return (BufByteWriter)MODULE$.writeResponseWithData((Seq<Buf>)((Seq)new .colon.colon((Object)ResponseToBuf$.MODULE$.VALUE, (List)new .colon.colon((Object)key, (List)new .colon.colon((Object)flags, (List)Nil$.MODULE$)))), value2, casUnique, (ByteWriter)bw);
                        }
                    }
                    if (value == null) throw new MatchError((Object)value);
                    Buf key = value.key();
                    Buf value3 = value.value();
                    Option<Buf> casUnique = value.casUnique();
                    Option<Buf> option = value.flags();
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)value);
                    return (BufByteWriter)MODULE$.writeResponseWithData((Seq<Buf>)((Seq)new .colon.colon((Object)ResponseToBuf$.MODULE$.VALUE, (List)new .colon.colon((Object)key, (List)new .colon.colon((Object)ResponseToBuf$.MODULE$.ZERO, (List)Nil$.MODULE$)))), value3, casUnique, (ByteWriter)bw);
                });
                bw.writeBytes(EncodingConstants$.MODULE$.END());
                bw.writeBytes(EncodingConstants$.MODULE$.DELIMITER());
                buf = bw.owned();
            } else {
                throw new MatchError((Object)response);
            }
        }
        return buf;
    }

    private ResponseToBuf$() {
        MODULE$ = this;
        this.ZERO = Buf.Utf8$.MODULE$.apply("0");
        this.VALUE = Buf.Utf8$.MODULE$.apply("VALUE");
        this.STORED = Buf.Utf8$.MODULE$.apply("STORED");
        this.NOT_STORED = Buf.Utf8$.MODULE$.apply("NOT_STORED");
        this.EXISTS = Buf.Utf8$.MODULE$.apply("EXISTS");
        this.NOT_FOUND = Buf.Utf8$.MODULE$.apply("NOT_FOUND");
        this.DELETED = Buf.Utf8$.MODULE$.apply("DELETED");
    }
}

