/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.transport;

import com.twitter.finagle.Dentry;
import com.twitter.finagle.Dentry$;
import com.twitter.finagle.Dtab;
import com.twitter.finagle.Dtab$;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.NameTree$;
import com.twitter.finagle.Path;
import com.twitter.finagle.Path$;
import com.twitter.finagle.mux.transport.BadMessageException;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$Init$;
import com.twitter.finagle.mux.transport.Message$ReplyStatus$;
import com.twitter.finagle.mux.transport.Message$Tags$;
import com.twitter.finagle.mux.transport.Message$Treq$Keys$;
import com.twitter.finagle.mux.transport.Message$Types$;
import com.twitter.finagle.netty4.Bufs$;
import com.twitter.finagle.tracing.Flags;
import com.twitter.finagle.tracing.SpanId;
import com.twitter.finagle.tracing.SpanId$;
import com.twitter.finagle.tracing.TraceId;
import com.twitter.finagle.util.BufReader;
import com.twitter.finagle.util.BufReader$;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Message$ {
    public static final Message$ MODULE$;
    private final Buf[] com$twitter$finagle$mux$transport$Message$$bufOfChar;
    public final byte[] com$twitter$finagle$mux$transport$Message$$noBytes;

    static {
        new Message$();
    }

    private Buf mkByte(byte b) {
        return Buf.ByteArray$.Owned$.MODULE$.apply(new byte[]{b});
    }

    public Buf[] com$twitter$finagle$mux$transport$Message$$bufOfChar() {
        return this.com$twitter$finagle$mux$transport$Message$$bufOfChar;
    }

    public String decodeUtf8(Buf buf) {
        String str;
        Buf buf2 = buf;
        Option option = Buf.Utf8$.MODULE$.unapply(buf2);
        if (option.isEmpty()) {
            throw this.throwBadMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Utf8 string, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buf})));
        }
        String string = str = (String)option.get();
        return string;
    }

    public Buf encodeString(String str) {
        return Buf.Utf8$.MODULE$.apply(str);
    }

    private Message.Treq decodeTreq(int tag, Buf buf) {
        None$ none$;
        block19: {
            None$ none$2;
            BufReader br;
            block18: {
                block17: {
                    Some some;
                    Tuple3 tuple3;
                    if (buf.length() < 1) {
                        throw this.throwBadMessageException("short Treq");
                    }
                    br = BufReader$.MODULE$.apply(buf);
                    int nkeys = br.readByte();
                    if (nkeys < 0) {
                        throw this.throwBadMessageException("Treq: too many keys");
                    }
                    None$ trace3 = None$.MODULE$;
                    long traceFlags = 0L;
                    while (nkeys > 0) {
                        Buf buf2;
                        int vsize;
                        if (br.remaining() < 2) {
                            throw this.throwBadMessageException("short Treq (header)");
                        }
                        byte key = br.readByte();
                        int n = br.readByte();
                        switch (n) {
                            default: 
                        }
                        int n2 = vsize = n < 0 ? n + 256 : n;
                        if (br.remaining() < vsize) {
                            throw this.throwBadMessageException("short Treq (vsize)");
                        }
                        byte by = key;
                        if (Message$Treq$Keys$.MODULE$.TraceId() == by) {
                            if (vsize != 24) {
                                throw this.throwBadMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bad traceid size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vsize)})));
                            }
                            trace3 = new Some((Object)new Tuple3((Object)SpanId$.MODULE$.apply(br.readLongBE()), (Object)SpanId$.MODULE$.apply(br.readLongBE()), (Object)SpanId$.MODULE$.apply(br.readLongBE())));
                            buf2 = BoxedUnit.UNIT;
                        } else if (Message$Treq$Keys$.MODULE$.TraceFlag() == by) {
                            BoxedUnit boxedUnit;
                            Object object = vsize > 1 ? br.readBytes(vsize - 1) : BoxedUnit.UNIT;
                            if (vsize > 0) {
                                traceFlags = br.readByte();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            buf2 = boxedUnit;
                        } else {
                            buf2 = br.readBytes(vsize);
                        }
                        --nkeys;
                    }
                    none$ = trace3;
                    if (!(none$ instanceof Some) || (tuple3 = (Tuple3)(some = (Some)none$).x()) == null) break block17;
                    SpanId spanId = (SpanId)tuple3._1();
                    SpanId parentId = (SpanId)tuple3._2();
                    SpanId traceId = (SpanId)tuple3._3();
                    none$2 = new Some((Object)new TraceId((Option)new Some((Object)traceId), (Option)new Some((Object)parentId), spanId, (Option)None$.MODULE$, new Flags(traceFlags)));
                    break block18;
                }
                if (!None$.MODULE$.equals(none$)) break block19;
                none$2 = None$.MODULE$;
            }
            None$ id = none$2;
            return new Message.Treq(tag, (Option<TraceId>)id, br.readAll());
        }
        throw new MatchError((Object)none$);
    }

    private Seq<Tuple2<Buf, Buf>> decodeContexts(BufReader br) {
        int n = br.readShortBE();
        if (n == 0) {
            return Nil$.MODULE$;
        }
        Tuple2[] contexts = new Tuple2[n];
        for (int i = 0; i < n; ++i) {
            Buf k = br.readBytes((int)br.readShortBE());
            Buf v = br.readBytes((int)br.readShortBE());
            contexts[i] = new Tuple2((Object)this.coerceTrimmed(k), (Object)this.coerceTrimmed(v));
        }
        return Predef$.MODULE$.wrapRefArray((Object[])contexts);
    }

    private Message.Tdispatch decodeTdispatch(int tag, Buf buf) {
        Dtab dtab;
        BufReader br = BufReader$.MODULE$.apply(buf);
        Seq<Tuple2<Buf, Buf>> contexts = this.decodeContexts(br);
        short ndst = br.readShortBE();
        Path dst = ndst == 0 ? Path$.MODULE$.empty() : Path$.MODULE$.read(this.decodeUtf8(br.readBytes((int)ndst)));
        int nd = br.readShortBE();
        if (nd == 0) {
            dtab = Dtab$.MODULE$.empty();
        } else {
            Dentry[] delegations = new Dentry[nd];
            for (int i = 0; i < nd; ++i) {
                String src = this.decodeUtf8(br.readBytes((int)br.readShortBE()));
                String dst2 = this.decodeUtf8(br.readBytes((int)br.readShortBE()));
                delegations[i] = Dentry$.MODULE$.apply(Path$.MODULE$.read(src), NameTree$.MODULE$.read(dst2));
            }
            dtab = new Dtab((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])delegations));
        }
        Dtab dtab2 = dtab;
        return new Message.Tdispatch(tag, contexts, dst, dtab2, br.readAll());
    }

    private Message.Rdispatch decodeRdispatch(int tag, Buf buf) {
        block5: {
            Message.Rdispatch rdispatch;
            block3: {
                byte by;
                Seq<Tuple2<Buf, Buf>> contexts;
                block4: {
                    Buf rest;
                    block2: {
                        BufReader br = BufReader$.MODULE$.apply(buf);
                        byte status = br.readByte();
                        contexts = this.decodeContexts(br);
                        rest = br.readAll();
                        by = status;
                        if (Message$ReplyStatus$.MODULE$.Ok() != by) break block2;
                        rdispatch = new Message.RdispatchOk(tag, contexts, rest);
                        break block3;
                    }
                    if (Message$ReplyStatus$.MODULE$.Error() != by) break block4;
                    rdispatch = new Message.RdispatchError(tag, contexts, this.decodeUtf8(rest));
                    break block3;
                }
                if (Message$ReplyStatus$.MODULE$.Nack() != by) break block5;
                rdispatch = new Message.RdispatchNack(tag, contexts);
            }
            return rdispatch;
        }
        throw this.throwBadMessageException("invalid Rdispatch status");
    }

    private Message.Rreq decodeRreq(int tag, Buf buf) {
        block7: {
            Message.Rreq rreq;
            block5: {
                byte by;
                block6: {
                    Buf rest;
                    block4: {
                        if (buf.length() < 1) {
                            throw this.throwBadMessageException("short Rreq");
                        }
                        BufReader br = BufReader$.MODULE$.apply(buf);
                        byte status = br.readByte();
                        rest = br.readAll();
                        by = status;
                        if (Message$ReplyStatus$.MODULE$.Ok() != by) break block4;
                        rreq = new Message.RreqOk(tag, rest);
                        break block5;
                    }
                    if (Message$ReplyStatus$.MODULE$.Error() != by) break block6;
                    rreq = new Message.RreqError(tag, this.decodeUtf8(rest));
                    break block5;
                }
                if (Message$ReplyStatus$.MODULE$.Nack() != by) break block7;
                rreq = new Message.RreqNack(tag);
            }
            return rreq;
        }
        throw this.throwBadMessageException("invalid Rreq status");
    }

    private Message.Tdiscarded decodeTdiscarded(Buf buf) {
        if (buf.length() < 3) {
            throw this.throwBadMessageException("short Tdiscarded message");
        }
        BufReader br = BufReader$.MODULE$.apply(buf);
        int which = (br.readByte() & 0xFF) << 16 | (br.readByte() & 0xFF) << 8 | br.readByte() & 0xFF;
        return new Message.Tdiscarded(which, this.decodeUtf8(br.readAll()));
    }

    private Message.Tlease decodeTlease(Buf buf) {
        if (buf.length() < 9) {
            throw this.throwBadMessageException("short Tlease message");
        }
        BufReader br = BufReader$.MODULE$.apply(buf);
        byte unit = br.readByte();
        long howMuch = br.readLongBE();
        return new Message.Tlease(unit, howMuch);
    }

    /*
     * WARNING - void declaration
     */
    public Message decode(Buf buf) {
        try {
            void var5_4;
            void var7_6;
            byte by;
            block26: {
                Product product;
                block9: {
                    Product product2;
                    block12: {
                        Buf rest;
                        block25: {
                            block24: {
                                int tag;
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        block17: {
                                                            block16: {
                                                                block15: {
                                                                    block13: {
                                                                        Tuple2<Object, Seq<Tuple2<Buf, Buf>>> tuple2;
                                                                        block14: {
                                                                            Tuple2 tuple22;
                                                                            block10: {
                                                                                Tuple2<Object, Seq<Tuple2<Buf, Buf>>> tuple23;
                                                                                block11: {
                                                                                    Tuple2 tuple24;
                                                                                    byte typ;
                                                                                    block8: {
                                                                                        if (buf.length() < 4) {
                                                                                            throw this.throwBadMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"short message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Buf$.MODULE$.slowHexString(buf)})));
                                                                                        }
                                                                                        BufReader br = BufReader$.MODULE$.apply(buf);
                                                                                        int head = br.readIntBE();
                                                                                        rest = br.readAll();
                                                                                        typ = Message$Tags$.MODULE$.extractType(head);
                                                                                        tag = Message$Tags$.MODULE$.extractTag(head);
                                                                                        if (!Message$Tags$.MODULE$.isFragment(tag)) break block8;
                                                                                        product = new Message.Fragment(typ, tag, rest);
                                                                                        break block9;
                                                                                    }
                                                                                    by = typ;
                                                                                    if (Message$Types$.MODULE$.Tinit() != by) break block10;
                                                                                    tuple23 = Message$Init$.MODULE$.decode(rest);
                                                                                    if (tuple23 == null) break block11;
                                                                                    short version = BoxesRunTime.unboxToShort((Object)tuple23._1());
                                                                                    Seq ctx = (Seq)tuple23._2();
                                                                                    Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)ctx);
                                                                                    short version2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                                                                                    Seq ctx2 = (Seq)tuple25._2();
                                                                                    product2 = new Message.Tinit(tag, version2, (Seq<Tuple2<Buf, Buf>>)ctx2);
                                                                                    break block12;
                                                                                }
                                                                                throw new MatchError(tuple23);
                                                                            }
                                                                            if (Message$Types$.MODULE$.Rinit() != by) break block13;
                                                                            tuple2 = Message$Init$.MODULE$.decode(rest);
                                                                            if (tuple2 == null) break block14;
                                                                            short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                                                            Seq ctx = (Seq)tuple2._2();
                                                                            Tuple2 tuple26 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)ctx);
                                                                            short version3 = BoxesRunTime.unboxToShort((Object)tuple26._1());
                                                                            Seq ctx3 = (Seq)tuple26._2();
                                                                            product2 = new Message.Rinit(tag, version3, (Seq<Tuple2<Buf, Buf>>)ctx3);
                                                                            break block12;
                                                                        }
                                                                        throw new MatchError(tuple2);
                                                                    }
                                                                    if (Message$Types$.MODULE$.Treq() != by) break block15;
                                                                    product2 = this.decodeTreq(tag, rest);
                                                                    break block12;
                                                                }
                                                                if (Message$Types$.MODULE$.Rreq() != by) break block16;
                                                                product2 = (Product)this.decodeRreq(tag, rest);
                                                                break block12;
                                                            }
                                                            if (Message$Types$.MODULE$.Tdispatch() != by) break block17;
                                                            product2 = this.decodeTdispatch(tag, rest);
                                                            break block12;
                                                        }
                                                        if (Message$Types$.MODULE$.Rdispatch() != by) break block18;
                                                        product2 = (Product)this.decodeRdispatch(tag, rest);
                                                        break block12;
                                                    }
                                                    if (Message$Types$.MODULE$.Tdrain() != by) break block19;
                                                    product2 = new Message.Tdrain(tag);
                                                    break block12;
                                                }
                                                if (Message$Types$.MODULE$.Rdrain() != by) break block20;
                                                product2 = new Message.Rdrain(tag);
                                                break block12;
                                            }
                                            if (Message$Types$.MODULE$.Tping() != by) break block21;
                                            product2 = new Message.Tping(tag);
                                            break block12;
                                        }
                                        if (Message$Types$.MODULE$.Rping() != by) break block22;
                                        product2 = new Message.Rping(tag);
                                        break block12;
                                    }
                                    boolean bl = Message$Types$.MODULE$.Rerr() == by ? true : Message$Types$.MODULE$.BAD_Rerr() == by;
                                    if (!bl) break block23;
                                    product2 = new Message.Rerr(tag, this.decodeUtf8(rest));
                                    break block12;
                                }
                                if (Message$Types$.MODULE$.Rdiscarded() != by) break block24;
                                product2 = new Message.Rdiscarded(tag);
                                break block12;
                            }
                            boolean bl = Message$Types$.MODULE$.Tdiscarded() == by ? true : Message$Types$.MODULE$.BAD_Tdiscarded() == by;
                            if (!bl) break block25;
                            product2 = this.decodeTdiscarded(rest);
                            break block12;
                        }
                        if (Message$Types$.MODULE$.Tlease() != by) break block26;
                        product2 = this.decodeTlease(rest);
                    }
                    product = product2;
                }
                Message.Fragment res = product;
                return res;
            }
            throw this.throwBadMessageException(this.unknownMessageDescription(by, (int)var7_6, (Buf)var5_4));
        }
        finally {
            Bufs$.MODULE$.releaseDirect(buf);
        }
    }

    public Buf encode(Message msg) {
        Message message;
        block6: {
            Buf buf;
            block5: {
                block4: {
                    message = msg;
                    if (!(message instanceof Message.PreEncodedTping)) break block4;
                    Message.PreEncodedTping preEncodedTping = (Message.PreEncodedTping)message;
                    buf = preEncodedTping.buf();
                    break block5;
                }
                if (message == null) break block6;
                Message message2 = message;
                if (message2.tag() < Message$Tags$.MODULE$.MarkerTag() || (message2.tag() & ~Message$Tags$.MODULE$.TagMSB()) > Message$Tags$.MODULE$.MaxTag()) {
                    throw this.throwBadMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid tag number ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)message2.tag())})));
                }
                byte[] head = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{message2.typ(), (byte)(message2.tag() >> 16 & 0xFF), (byte)(message2.tag() >> 8 & 0xFF), (byte)(message2.tag() & 0xFF)}), ClassTag$.MODULE$.Byte());
                buf = Buf.ByteArray$.Owned$.MODULE$.apply(head).concat(message2.buf());
            }
            return buf;
        }
        throw new MatchError((Object)message);
    }

    private Nothing$ throwBadMessageException(String why) {
        throw Failure$.MODULE$.wrap((Throwable)new BadMessageException(why));
    }

    private String unknownMessageDescription(byte tpe, int tag, Buf payload) {
        Buf toWrite = payload.slice(0, 16);
        String bytesStr = Buf$.MODULE$.slowHexString(toWrite);
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unknown message type: ", " [tag=", "]. Payload bytes: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)tpe), BoxesRunTime.boxToInteger((int)tag), BoxesRunTime.boxToInteger((int)payload.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First ", " bytes of the payload: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)toWrite.length()), bytesStr}))).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Buf coerceTrimmed(Buf buf) {
        Buf.ByteArray byteArray;
        Option option;
        Buf buf2 = buf;
        if (buf2.isEmpty()) {
            return Buf$.MODULE$.Empty();
        }
        if (buf2 instanceof Buf.ByteArray && !(option = Buf.ByteArray$.Owned$.MODULE$.unapply(byteArray = (Buf.ByteArray)buf2)).isEmpty()) {
            byte[] bytes = (byte[])((Tuple3)option.get())._1();
            int begin = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._2());
            int end = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3());
            if (begin == 0 && end == bytes.length) {
                return buf;
            }
        }
        byte[] bytes = Buf.ByteArray$.Owned$.MODULE$.extract(buf2);
        return Buf.ByteArray$.Owned$.MODULE$.apply(bytes);
    }

    private Message$() {
        MODULE$ = this;
        this.com$twitter$finagle$mux$transport$Message$$bufOfChar = (Buf[])((Object[])new Buf[]{this.mkByte((byte)0), this.mkByte((byte)1), this.mkByte((byte)2)});
        this.com$twitter$finagle$mux$transport$Message$$noBytes = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

