/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux;

import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Try;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\t-\u0011q\u0001\u0016:bG.,'O\u0003\u0002\u0004\t\u0005\u0019Q.\u001e=\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001+\ta!d\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aDQ\u0001\u0006\u0001\u0005\u0002U\ta\u0001P5oSRtD#\u0001\f\u0011\u0007]\u0001\u0001$D\u0001\u0003!\tI\"\u0004\u0004\u0001\u0005\u000bm\u0001!\u0019\u0001\u000f\u0003\u0003Q\u000b\"!\b\u0011\u0011\u00059q\u0012BA\u0010\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AD\u0011\n\u0005\tz!aA!os\"1A\u0005\u0001Q\u0001\n\u0015\nq\u0001]3oI&tw\r\u0005\u0003'[=\u0012T\"A\u0014\u000b\u0005!J\u0013AC2p]\u000e,(O]3oi*\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059:#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011a\u0002M\u0005\u0003c=\u00111!\u00138u!\r\u0019TgN\u0007\u0002i)\u0011!FB\u0005\u0003mQ\u0012aAR;ukJ,\u0007C\u0001\b9\u0013\tItB\u0001\u0003V]&$\bBB\u001e\u0001A\u0003%A(\u0001\u0005`IJ\f\u0017N\\3e!\r\u0019ThN\u0005\u0003}Q\u0012q\u0001\u0015:p[&\u001cX\r\u0003\u0004A\u0001\u0001\u0006I!Q\u0001\u0006gR\fG/\u001a\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u001e\na!\u0019;p[&\u001c\u0017B\u0001$D\u00055\tEo\\7jG&sG/Z4fe\"1\u0001\n\u0001Q\u0005\n%\u000bQ!\u001a8uKJ$\u0012A\u0013\t\u0003\u001d-K!\u0001T\b\u0003\u000f\t{w\u000e\\3b]\"\u0012qI\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#>\t!\"\u00198o_R\fG/[8o\u0013\t\u0019\u0006KA\u0004uC&d'/Z2\t\rU\u0003\u0001\u0015\"\u0003W\u0003\u0011)\u00070\u001b;\u0015\u0003]B#\u0001\u0016(\t\u000be\u0003A\u0011\u0001.\u0002\u000bQ\u0014\u0018mY6\u0015\u0007m#g\r\u0006\u000239\")Q\f\u0017a\u0001=\u00069\u0001O]8dKN\u001c\b\u0003\u0002\b`CJJ!\u0001Y\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u001ac1%\u00111\r\u000e\u0002\u0004)JL\b\"B3Y\u0001\u0004y\u0013a\u0001;bO\")q\r\u0017a\u0001Q\u0006)!/\u001a9msB\u00191'\u000e\r\t\u000b)\u0004A\u0011A6\u0002\u0007\u001d,G\u000f\u0006\u0002m_B\u0019a\"\u001c\u001a\n\u00059|!AB(qi&|g\u000eC\u0003fS\u0002\u0007q\u0006C\u0003r\u0001\u0011\u0005!/\u0001\u0003uC\u001e\u001cX#A:\u0011\u0007Q\\xF\u0004\u0002vsB\u0011aoD\u0007\u0002o*\u0011\u0001PC\u0001\u0007yI|w\u000e\u001e \n\u0005i|\u0011A\u0002)sK\u0012,g-\u0003\u0002}{\n\u00191+\u001a;\u000b\u0005i|\u0001\"B@\u0001\t\u000b1\u0016!\u00023sC&t\u0007F\u0001@O\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\t!\"[:Ee\u0006Lg.\u001b8h+\u0005Q\u0005bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\bIJ\f\u0017N\\3e+\u0005\u0011\u0004bBA\t\u0001\u0011\u0005\u00111C\u0001\u000bSN$&/Y2lS:<Gc\u0001&\u0002\u0016!1Q-a\u0004A\u0002=Bq!!\u0007\u0001\t\u0003\tY\"\u0001\u0005oa\u0016tG-\u001b8h+\u0005y\u0003")
public class Tracker<T> {
    private final ConcurrentHashMap<Object, Future<BoxedUnit>> pending = new ConcurrentHashMap();
    private final Promise<BoxedUnit> _drained = new Promise();
    private final AtomicInteger state = new AtomicInteger(1);

    private boolean enter() {
        boolean bl;
        block1: {
            int n;
            do {
                if ((n = this.state.get()) > 0) continue;
                bl = false;
                break block1;
            } while (!this.state.compareAndSet(n, n + 1));
            bl = true;
        }
        return bl;
    }

    private void exit() {
        block3: {
            BoxedUnit boxedUnit;
            int n;
            do {
                if ((n = this.state.get()) >= 0) continue;
                if (this.state.incrementAndGet() == -1) {
                    this._drained.setDone(Predef$.MODULE$.$conforms());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                break block3;
            } while (!this.state.compareAndSet(n, n - 1));
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Future<BoxedUnit> track(int tag, Future<T> reply, Function1<Try<T>, Future<BoxedUnit>> process) {
        if (!this.enter()) {
            return reply.transform(process);
        }
        Future f = reply.transform(process);
        this.pending.put(BoxesRunTime.boxToInteger((int)tag), (Future<BoxedUnit>)f);
        return f.ensure((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            $this.pending.remove(BoxesRunTime.boxToInteger((int)tag));
            this.exit();
        });
    }

    public Option<Future<BoxedUnit>> get(int tag) {
        return Option$.MODULE$.apply(this.pending.get(BoxesRunTime.boxToInteger((int)tag)));
    }

    public Set<Object> tags() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.pending.keySet()).asScala()).toSet();
    }

    public final void drain() {
        BoxedUnit boxedUnit;
        int n;
        do {
            if ((n = this.state.get()) >= 0) continue;
            return;
        } while (!this.state.compareAndSet(n, -n));
        if (n == 1) {
            this._drained.setDone(Predef$.MODULE$.$conforms());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean isDraining() {
        return this.state.get() < 0;
    }

    public Future<BoxedUnit> drained() {
        return this._drained;
    }

    public boolean isTracking(int tag) {
        return this.pending.containsKey(BoxesRunTime.boxToInteger((int)tag));
    }

    public int npending() {
        return package$.MODULE$.abs(this.state.get()) - 1;
    }
}

