/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.exp.pushsession;

import com.twitter.finagle.ChannelClosedException;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.Status;
import com.twitter.finagle.exp.pushsession.PushChannelHandle;
import com.twitter.finagle.exp.pushsession.PushSession;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.exp.pushsession.MuxClientNegotiatingSession$;
import com.twitter.finagle.mux.exp.pushsession.MuxClientSession;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.Verbosity$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g!B\u0001\u0003\u0005!q!aG'vq\u000ec\u0017.\u001a8u\u001d\u0016<w\u000e^5bi&twmU3tg&|gN\u0003\u0002\u0004\t\u0005Y\u0001/^:ig\u0016\u001c8/[8o\u0015\t)a!A\u0002fqBT!a\u0002\u0005\u0002\u00075,\bP\u0003\u0002\n\u0015\u00059a-\u001b8bO2,'BA\u0006\r\u0003\u001d!x/\u001b;uKJT\u0011!D\u0001\u0004G>l7C\u0001\u0001\u0010!\u0011\u00012#F\u000e\u000e\u0003EQ!a\u0001\n\u000b\u0005\u0015A\u0011B\u0001\u000b\u0012\u0005-\u0001Vo\u001d5TKN\u001c\u0018n\u001c8\u0011\u0005YIR\"A\f\u000b\u0005aQ\u0011AA5p\u0013\tQrC\u0001\u0006CsR,'+Z1eKJ\u0004\"A\u0006\u000f\n\u0005u9\"a\u0001\"vM\"Aq\u0004\u0001B\u0001B\u0003%\u0011%\u0001\u0004iC:$G.Z\u0002\u0001!\u0011\u0001\"%F\u000e\n\u0005\r\n\"!\u0005)vg\"\u001c\u0005.\u00198oK2D\u0015M\u001c3mK\"AQ\u0005\u0001B\u0001B\u0003%a%A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000bMCwN\u001d;\t\u00115\u0002!\u0011!Q\u0001\n9\n!B\\3h_RL\u0017\r^8s!\u00119s&\r$\n\u0005AB#!\u0003$v]\u000e$\u0018n\u001c82!\r9#\u0007N\u0005\u0003g!\u0012aa\u00149uS>t\u0007CA\u001bD\u001d\t1\u0014I\u0004\u00028\u0001:\u0011\u0001h\u0010\b\u0003syr!AO\u001f\u000e\u0003mR!\u0001\u0010\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011!IB\u0001\n\u0011\u0006tGm\u001d5bW\u0016L!\u0001R#\u0003\u000f!+\u0017\rZ3sg*\u0011!I\u0002\t\u0003\u000f\"k\u0011AA\u0005\u0003\u0013\n\u0011\u0001#T;y\u00072LWM\u001c;TKN\u001c\u0018n\u001c8\t\u0011-\u0003!\u0011!Q\u0001\n1\u000bq\u0001[3bI\u0016\u00148\u000f\u0005\u0002N\u0007:\u0011a*Q\u0007\u0002\r!A\u0001\u000b\u0001B\u0001B\u0003%\u0011+\u0001\u0003oC6,\u0007C\u0001*W\u001d\t\u0019F\u000b\u0005\u0002;Q%\u0011Q\u000bK\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002VQ!A!\f\u0001B\u0001B\u0003%1,A\u0003ti\u0006$8\u000f\u0005\u0002]=6\tQL\u0003\u0002[\u0011%\u0011q,\u0018\u0002\u000e'R\fGo\u001d*fG\u0016Lg/\u001a:\t\u000b\u0005\u0004A\u0011\u00012\u0002\rqJg.\u001b;?)\u001d\u0019G-\u001a4hQ&\u0004\"a\u0012\u0001\t\u000b}\u0001\u0007\u0019A\u0011\t\u000b\u0015\u0002\u0007\u0019\u0001\u0014\t\u000b5\u0002\u0007\u0019\u0001\u0018\t\u000b-\u0003\u0007\u0019\u0001'\t\u000bA\u0003\u0007\u0019A)\t\u000bi\u0003\u0007\u0019A.\t\r-\u0004\u0001\u0015!\u0003m\u0003EqWmZ8uS\u0006$X\rZ*fgNLwN\u001c\t\u0004[B4U\"\u00018\u000b\u0005=T\u0011\u0001B;uS2L!!\u001d8\u0003\u000fA\u0013x.\\5tK\"11\u000f\u0001Q\u0001\nQ\f\u0001c\u001d;beRtUmZ8uS\u0006$\u0018n\u001c8\u0011\u0005UlX\"\u0001<\u000b\u0005]D\u0018AB1u_6L7M\u0003\u0002zu\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005=\\(\"\u0001?\u0002\t)\fg/Y\u0005\u0003}Z\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA\u0001\u0001\u0001\u0006I!a\u0001\u0002!9,wm\u001c;jCRLgnZ$bk\u001e,\u0007c\u0001/\u0002\u0006%\u0019\u0011qA/\u0003\u000b\u001d\u000bWoZ3\u0006\r\u0005-\u0001\u0001BA\u0007\u0005\u0015\u0001\u0006.Y:f!\u00199s&a\u0004\u0002\u001cA!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0019\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\n\t\u0005e\u00111\u0003\u0002\b\u001b\u0016\u001c8/Y4f!\r9\u0013QD\u0005\u0004\u0003?A#\u0001B+oSRD\u0001\"a\t\u0001A\u0003&\u0011QE\u0001\u0006a\"\f7/\u001a\t\u0005\u0003O\tI!D\u0001\u0001\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\t\u0011B\\3h_RL\u0017\r^3\u0015\u0005\u0005=\u0002\u0003B7\u00022\u0019K1!a\ro\u0005\u00191U\u000f^;sK\"9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012aB8o\u00072|7/Z\u000b\u0003\u0003w\u0001R!\\A\u0019\u00037Aq!a\u0010\u0001\t\u0003\t\t%A\u0003dY>\u001cX\r\u0006\u0003\u0002<\u0005\r\u0003\u0002CA#\u0003{\u0001\r!a\u0012\u0002\u0011\u0011,\u0017\r\u001a7j]\u0016\u00042!\\A%\u0013\r\tYE\u001c\u0002\u0005)&lW\rC\u0004\u0002P\u0001!\t!!\u0015\u0002\rM$\u0018\r^;t+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005]S\"\u0001\u0005\n\u0007\u0005e\u0003B\u0001\u0004Ti\u0006$Xo\u001d\u0005\b\u0003;\u0002A\u0011AA0\u0003\u001d\u0011XmY3jm\u0016$B!a\u0007\u0002b!9\u00111MA.\u0001\u0004)\u0012A\u0002:fC\u0012,'\u000f\u0003\u0005\u0002h\u0001\u0001K\u0011BA5\u0003Y\u0001\b.Y:f%\u0016\u001cW-\u001b<f\u001b\u0006\u00148.\u001a:SKJ\u0014H\u0003BA\u000e\u0003WB\u0001\"!\u001c\u0002f\u0001\u0007\u0011qB\u0001\b[\u0016\u001c8/Y4f\u0011!\t\t\b\u0001Q\u0005\n\u0005M\u0014!\u00059iCN,'+Z2fSZ,'+\u001b8jiR!\u00111DA;\u0011!\ti'a\u001cA\u0002\u0005=\u0001\u0002CA=\u0001\u0001&I!a\u001f\u0002#\u0019Lg.[:i\u001d\u0016<w\u000e^5bi&|g\u000e\u0006\u0003\u0002\u001c\u0005u\u0004bBA@\u0003o\u0002\r!M\u0001\u000eg\u0016\u0014h/\u001a:IK\u0006$WM]:\t\u0011\u0005\r\u0005\u0001)C\u0005\u0003\u000b\u000bQBZ1jY\"\u000bg\u000eZ:iC.,G\u0003BA\u000e\u0003\u000fC\u0001\"!#\u0002\u0002\u0002\u0007\u00111R\u0001\u0004Kb\u001c\u0007\u0003BAG\u0003/sA!a$\u0002\u0014:\u0019!(!%\n\u0003%J1!!&)\u0003\u001d\u0001\u0018mY6bO\u0016LA!!'\u0002\u001c\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003+Cs\u0001CAP\u0005!\u0005\u0001\"!)\u000275+\bp\u00117jK:$h*Z4pi&\fG/\u001b8h'\u0016\u001c8/[8o!\r9\u00151\u0015\u0004\b\u0003\tA\t\u0001CAS'\u0011\t\u0019+a*\u0011\u0007\u001d\nI+C\u0002\u0002,\"\u0012a!\u00118z%\u00164\u0007bB1\u0002$\u0012\u0005\u0011q\u0016\u000b\u0003\u0003CC!\"a-\u0002$\n\u0007I\u0011BA[\u0003\rawnZ\u000b\u0003\u0003o\u0003B!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{S\u0011a\u00027pO\u001eLgnZ\u0005\u0005\u0003\u0003\fYL\u0001\u0004M_\u001e<WM\u001d\u0005\n\u0003\u000b\f\u0019\u000b)A\u0005\u0003o\u000bA\u0001\\8hA!Q\u0011\u0011ZAR\u0005\u0004%\t!a3\u0002\u00155\u000b'o[3s%\u0016\u0014(/\u0006\u0002\u0002NB!\u0011qZAk\u001d\u0011\t\t\"!5\n\t\u0005M\u00171C\u0001\b\u001b\u0016\u001c8/Y4f\u0013\u0011\t9.!7\u0003\tI+'O\u001d\u0006\u0005\u0003'\f\u0019\u0002C\u0005\u0002^\u0006\r\u0006\u0015!\u0003\u0002N\u0006YQ*\u0019:lKJ\u0014VM\u001d:!\u0001")
public final class MuxClientNegotiatingSession
extends PushSession<ByteReader, Buf> {
    private final PushChannelHandle<ByteReader, Buf> handle;
    private final short version;
    private final Function1<Option<Seq<Tuple2<Buf, Buf>>>, MuxClientSession> negotiator;
    private final Seq<Tuple2<Buf, Buf>> headers;
    private final String name;
    private final Promise<MuxClientSession> negotiatedSession;
    private final AtomicBoolean startNegotiation;
    private final Gauge negotiatingGauge;
    private Function1<Message, BoxedUnit> phase;

    public static Message.Rerr MarkerRerr() {
        return MuxClientNegotiatingSession$.MODULE$.MarkerRerr();
    }

    public Future<MuxClientSession> negotiate() {
        if (this.startNegotiation.compareAndSet(false, true)) {
            MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().debug("Sending Tinit probe to %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name}));
            this.handle.sendAndForget((Object)Message$.MODULE$.encode(MuxClientNegotiatingSession$.MODULE$.MarkerRerr()));
        } else {
            MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning("Attempted to negotiate multiple times with %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name}));
        }
        return this.negotiatedSession;
    }

    public Future<BoxedUnit> onClose() {
        return this.handle.onClose();
    }

    public Future<BoxedUnit> close(Time deadline) {
        return this.handle.close(deadline);
    }

    public Status status() {
        return this.handle.status();
    }

    public void receive(ByteReader reader) {
        block7: {
            try {
                try {
                    Message message = Message$.MODULE$.decode(reader);
                    if (!this.startNegotiation.get()) {
                        MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning("Received a message from %s before negotiation has started: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name, message}));
                    }
                    this.phase.apply((Object)message);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        this.failHandshake(t);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    throw throwable;
                }
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void phaseReceiveMarkerRerr(Message message2) {
        Message message3 = message2;
        if (message3 instanceof Message.Rerr) {
            Message.Rerr rerr = (Message.Rerr)message3;
            int n = rerr.tag();
            String string = rerr.error();
            if (Handshake$.MODULE$.TinitTag() == n) {
                String string2 = Handshake$.MODULE$.CanTinitMsg();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.phase = (Function1 & Serializable & scala.Serializable)message -> {
                        this.phaseReceiveRinit(message);
                        return BoxedUnit.UNIT;
                    };
                    this.handle.sendAndForget((Object)Message$.MODULE$.encode(new Message.Tinit(Handshake$.MODULE$.TinitTag(), this.version, this.headers)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        this.finishNegotiation((Option<Seq<Tuple2<Buf, Buf>>>)None$.MODULE$);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void phaseReceiveRinit(Message message) {
        Message message2 = message;
        if (message2 instanceof Message.Rinit) {
            Message.Rinit rinit = (Message.Rinit)message2;
            short v = rinit.version();
            Seq<Tuple2<Buf, Buf>> serverHeaders = rinit.headers();
            if (v == this.version) {
                this.finishNegotiation((Option<Seq<Tuple2<Buf, Buf>>>)new Some(serverHeaders));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (message2 instanceof Message.Rerr) {
            Message.Rerr rerr = (Message.Rerr)message2;
            String msg = rerr.error();
            this.failHandshake((Throwable)Failure$.MODULE$.apply(msg));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid Tinit response from ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name, message}));
        IllegalStateException exc = new IllegalStateException(msg);
        MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning((Throwable)exc, msg, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.failHandshake(exc);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void finishNegotiation(Option<Seq<Tuple2<Buf, Buf>>> serverHeaders) {
        MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().debug("Init result: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serverHeaders}));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (MuxClientSession)((Object)((Object)$this.negotiator.apply((Object)serverHeaders))));
        if (try_ instanceof Return) {
            BoxedUnit boxedUnit;
            Return return_ = (Return)try_;
            MuxClientSession clientSession = (MuxClientSession)((Object)return_.r());
            this.handle.registerSession((PushSession)clientSession);
            if (!this.negotiatedSession.updateIfEmpty((Try)new Return((Object)clientSession))) {
                MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().debug("Finished negotiation with %s but handle already closed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable exc = throw_.e();
            MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning(exc, "Mux negotiation failed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.failHandshake(exc);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private void failHandshake(Throwable exc) {
        block0: {
            if (!this.negotiatedSession.updateIfEmpty((Try)new Throw(exc))) break block0;
            this.handle.close();
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(MuxClientNegotiatingSession $this, Try reason) {
        Throwable throwable;
        Try try_ = reason;
        if (try_ instanceof Return) {
            throwable = (Throwable)new ChannelClosedException($this.handle.remoteAddress()).flagged(FailureFlags$.MODULE$.Retryable());
        } else if (try_ instanceof Throw) {
            Throwable t;
            Throw throw_ = (Throw)try_;
            throwable = t = throw_.e();
        } else {
            throw new MatchError((Object)try_);
        }
        Throwable exc = throwable;
        $this.failHandshake(exc);
    }

    public MuxClientNegotiatingSession(PushChannelHandle<ByteReader, Buf> handle, short version, Function1<Option<Seq<Tuple2<Buf, Buf>>>, MuxClientSession> negotiator, Seq<Tuple2<Buf, Buf>> headers, String name, StatsReceiver stats) {
        this.handle = handle;
        this.version = version;
        this.negotiator = negotiator;
        this.headers = headers;
        this.name = name;
        super(handle);
        this.negotiatedSession = Promise$.MODULE$.apply();
        this.startNegotiation = new AtomicBoolean(false);
        this.negotiatingGauge = stats.addGauge(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"negotiating"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> $this.startNegotiation.get() ? 1.0f : 0.0f);
        this.negotiatedSession.ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.negotiatingGauge.remove());
        this.phase = (Function1 & Serializable & scala.Serializable)message -> {
            this.phaseReceiveMarkerRerr(message);
            return BoxedUnit.UNIT;
        };
        handle.onClose().respond((Function1 & Serializable & scala.Serializable)reason -> {
            MuxClientNegotiatingSession.$anonfun$new$2(this, reason);
            return BoxedUnit.UNIT;
        });
    }
}

