/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.exp.pushsession;

import com.twitter.finagle.Mux$;
import com.twitter.finagle.Service;
import com.twitter.finagle.Status;
import com.twitter.finagle.exp.pushsession.PushChannelHandle;
import com.twitter.finagle.exp.pushsession.PushSession;
import com.twitter.finagle.exp.pushsession.RefPushSession;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.exp.pushsession.MuxChannelHandle;
import com.twitter.finagle.mux.exp.pushsession.MuxServerNegotiator$;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.io.ByteReader$;
import com.twitter.logging.Level;
import com.twitter.util.Closable;
import com.twitter.util.Closable$;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Timer;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005%g!B\u0001\u0003\u0001!q!aE'vqN+'O^3s\u001d\u0016<w\u000e^5bi>\u0014(BA\u0002\u0005\u0003-\u0001Xo\u001d5tKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011aA3ya*\u0011q\u0001C\u0001\u0004[VD(BA\u0005\u000b\u0003\u001d1\u0017N\\1hY\u0016T!a\u0003\u0007\u0002\u000fQ<\u0018\u000e\u001e;fe*\tQ\"A\u0002d_6\u001c\"\u0001A\b\u0011\tA\u0019RcG\u0007\u0002#)\u00111A\u0005\u0006\u0003\u000b!I!\u0001F\t\u0003\u0017A+8\u000f[*fgNLwN\u001c\t\u0003-ei\u0011a\u0006\u0006\u00031)\t!![8\n\u0005i9\"A\u0003\"zi\u0016\u0014V-\u00193feB\u0011a\u0003H\u0005\u0003;]\u00111AQ;g\u0011!y\u0002A!A!\u0002\u0013\t\u0013A\u0003:fMN+7o]5p]\u000e\u0001\u0001\u0003\u0002\t#+mI!aI\t\u0003\u001dI+g\rU;tQN+7o]5p]\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\u0004iC:$G.\u001a\t\u0003O!j\u0011AA\u0005\u0003S\t\u0011\u0001#T;y\u0007\"\fgN\\3m\u0011\u0006tG\r\\3\t\u0011-\u0002!\u0011!Q\u0001\n1\nqa]3sm&\u001cW\r\u0005\u0003.]A\"T\"\u0001\u0005\n\u0005=B!aB*feZL7-\u001a\t\u0003cIj\u0011AB\u0005\u0003g\u0019\u0011qAU3rk\u0016\u001cH\u000f\u0005\u00022k%\u0011aG\u0002\u0002\t%\u0016\u001c\bo\u001c8tK\"A\u0001\b\u0001B\u0001B\u0003%\u0011(\u0001\tnC.,Gj\\2bY\"+\u0017\rZ3sgB!!(P @\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$!\u0003$v]\u000e$\u0018n\u001c82!\t\u0001eJ\u0004\u0002B\u0019:\u0011!i\u0013\b\u0003\u0007*s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0003\u0013A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u001b\u001a\t\u0011\u0002S1oIND\u0017m[3\n\u0005=\u0003&a\u0002%fC\u0012,'o\u001d\u0006\u0003\u001b\u001aA\u0001B\u0015\u0001\u0003\u0002\u0003\u0006IaU\u0001\n]\u0016<w\u000e^5bi\u0016\u0004RA\u000f+-->I!!V\u001e\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001\u001eX\u007f%\u0011\u0001l\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011i\u0003!\u0011!Q\u0001\nm\u000bQ\u0001^5nKJ\u0004\"\u0001X0\u000e\u0003uS!A\u0018\u0006\u0002\tU$\u0018\u000e\\\u0005\u0003Av\u0013Q\u0001V5nKJDQA\u0019\u0001\u0005\n\r\fa\u0001P5oSRtDc\u00023fM\u001eD\u0017N\u001b\t\u0003O\u0001AQaH1A\u0002\u0005BQ!J1A\u0002\u0019BQaK1A\u00021BQ\u0001O1A\u0002eBQAU1A\u0002MCQAW1A\u0002m+a\u0001\u001c\u0001!\u0002\u0013i'!\u0002)iCN,\u0007\u0003\u0002\u001e>]R\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0004\u0002\u0013Q\u0014\u0018M\\:q_J$\u0018BA:q\u0005\u001diUm]:bO\u0016\u0004\"AO;\n\u0005Y\\$\u0001B+oSRDa\u0001\u001f\u0001!\u0002\u0013I\u0018\u0001C:fgNLwN\u001c)\u0011\u0007qSx\"\u0003\u0002|;\n9\u0001K]8nSN,\u0007BB?\u0001A\u0003&a0\u0001\biC:$7\u000f[1lKBC\u0017m]3\u0011\u0005}\\W\"\u0001\u0001\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u00059qN\\\"m_N,WCAA\u0004!\u0011a\u0016\u0011\u0002;\n\u0007\u0005-QL\u0001\u0004GkR,(/\u001a\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003\u0015\u0019Gn\\:f)\u0011\t9!a\u0005\t\u0011\u0005U\u0011Q\u0002a\u0001\u0003/\t\u0001\u0002Z3bI2Lg.\u001a\t\u00049\u0006e\u0011bAA\u000e;\n!A+[7f\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\taa\u001d;biV\u001cXCAA\u0012!\ri\u0013QE\u0005\u0004\u0003OA!AB*uCR,8\u000fC\u0004\u0002,\u0001!\t!!\f\u0002\u000fI,7-Z5wKR\u0019A/a\f\t\u000f\u0005E\u0012\u0011\u0006a\u0001+\u00059Q.Z:tC\u001e,\u0007\u0002CA\u001b\u0001\u0001&I!a\u000e\u0002\u001d\rDWmY6SKJ\u0014\b\u000b[1tKV\ta\u0010\u0003\u0005\u0002<\u0001\u0001K\u0011BA\u001c\u000319W\r^%oSR\u0004\u0006.Y:f\u0011!\ty\u0004\u0001Q\u0005\n\u0005\u0005\u0013a\u0005:f[>$X-\u00113ee\u0016\u001c8o\u0015;sS:<WCAA\"!\u0011\t)%!\u0014\u000f\t\u0005\u001d\u0013\u0011\n\t\u0003\u000bnJ1!a\u0013<\u0003\u0019\u0001&/\u001a3fM&!\u0011qJA)\u0005\u0019\u0019FO]5oO*\u0019\u00111J\u001e\t\u0011\u0005U\u0003\u0001)C\u0005\u0003/\naA\\8J]&$Hc\u0001;\u0002Z!9\u0011\u0011GA*\u0001\u0004q\u0007\u0002CA/\u0001\u0001&I!a\u0018\u0002%9,wm\u001c;jCRLwN\\*vG\u000e,7o\u001d\u000b\u0004i\u0006\u0005\u0004bBA2\u00037\u0002\raD\u0001\bg\u0016\u001c8/[8o\u0011!\t9\u0007\u0001Q\u0005\n\u0005%\u0014A\u00058fO>$\u0018.\u0019;j_:4\u0015-\u001b7ve\u0016$R\u0001^A6\u0003kB\u0001\"!\u001c\u0002f\u0001\u0007\u0011qN\u0001\u0004i\u0006<\u0007c\u0001\u001e\u0002r%\u0019\u00111O\u001e\u0003\u0007%sG\u000f\u0003\u0005\u0002x\u0005\u0015\u0004\u0019AA=\u0003\u0005!\b\u0003BA>\u0003\u000bsA!! \u0002\u0002:\u0019Q)a \n\u0003qJ1!a!<\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\"\u0002\n\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u0007[t\u0001CAG\u0005!\u0005\u0001\"a$\u0002'5+\bpU3sm\u0016\u0014h*Z4pi&\fGo\u001c:\u0011\u0007\u001d\n\tJB\u0004\u0002\u0005!\u0005\u0001\"a%\u0014\t\u0005E\u0015Q\u0013\t\u0004u\u0005]\u0015bAAMw\t1\u0011I\\=SK\u001aDqAYAI\t\u0003\ti\n\u0006\u0002\u0002\u0010\"Q\u0011\u0011UAI\u0005\u0004%I!a)\u0002\u00071|w-\u0006\u0002\u0002&B!\u0011qUAW\u001b\t\tIKC\u0002\u0002,*\tq\u0001\\8hO&tw-\u0003\u0003\u00020\u0006%&A\u0002'pO\u001e,'\u000fC\u0005\u00024\u0006E\u0005\u0015!\u0003\u0002&\u0006!An\\4!\u0011!\t9,!%\u0005\u0002\u0005e\u0016!\u00022vS2$G#\u0004;\u0002<\u0006}\u0016\u0011YAb\u0003\u000b\f9\rC\u0004\u0002>\u0006U\u0006\u0019A\u0011\u0002\u0007I,g\r\u0003\u0004&\u0003k\u0003\rA\n\u0005\u0007W\u0005U\u0006\u0019\u0001\u0017\t\ra\n)\f1\u0001:\u0011\u0019\u0011\u0016Q\u0017a\u0001'\"1!,!.A\u0002m\u0003")
public class MuxServerNegotiator
extends PushSession<ByteReader, Buf> {
    private final RefPushSession<ByteReader, Buf> refSession;
    private final MuxChannelHandle handle;
    private final Service<Request, Response> service;
    private final Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> makeLocalHeaders;
    private final Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> negotiate;
    private final Timer timer;
    private final Promise<PushSession<ByteReader, Buf>> sessionP;
    private Function1<Message, BoxedUnit> handshakePhase;

    public static void build(RefPushSession<ByteReader, Buf> refPushSession, MuxChannelHandle muxChannelHandle, Service<Request, Response> service, Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> function1, Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> function2, Timer timer) {
        MuxServerNegotiator$.MODULE$.build(refPushSession, muxChannelHandle, service, function1, function2, timer);
    }

    public Future<BoxedUnit> onClose() {
        return this.handle.onClose();
    }

    public Future<BoxedUnit> close(Time deadline) {
        return this.sessionP.by(deadline, this.timer).transform((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Return) {
                Return return_ = (Return)try_;
                PushSession session = (PushSession)return_.r();
                future = session.close(deadline);
            } else if (try_ instanceof Throw) {
                future = Closable$.MODULE$.all((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Closable[]{$this.handle, $this.service})).close();
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        });
    }

    public Status status() {
        return this.handle.status();
    }

    public void receive(ByteReader message) {
        try {
            try {
                Message msg = Message$.MODULE$.decode(message);
                this.handshakePhase.apply((Object)msg);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    this.close();
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            message.close();
        }
    }

    private Function1<Message, BoxedUnit> checkRerrPhase() {
        return (Function1 & Serializable & scala.Serializable)x0$2 -> {
            MuxServerNegotiator.$anonfun$checkRerrPhase$1(this, x0$2);
            return BoxedUnit.UNIT;
        };
    }

    private Function1<Message, BoxedUnit> getInitPhase() {
        return (Function1 & Serializable & scala.Serializable)x0$3 -> {
            MuxServerNegotiator.$anonfun$getInitPhase$1(this, x0$3);
            return BoxedUnit.UNIT;
        };
    }

    private String remoteAddressString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remote: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.handle.remoteAddress()}));
    }

    private void noInit(Message message) {
        try {
            PushSession session = (PushSession)this.negotiate.apply(this.service, (Object)None$.MODULE$);
            this.negotiationSuccess((PushSession<ByteReader, Buf>)session);
            session.receive((Object)ByteReader$.MODULE$.apply(Message$.MODULE$.encode(message)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.negotiationFailure(message.tag(), t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void negotiationSuccess(PushSession<ByteReader, Buf> session) {
        this.refSession.updateRef(session);
        this.sessionP.setValue(session);
        this.handshakePhase = (Function1 & Serializable & scala.Serializable)m -> {
            MuxServerNegotiator.$anonfun$negotiationSuccess$1(this, m);
            return BoxedUnit.UNIT;
        };
    }

    private void negotiationFailure(int tag, Throwable t) {
        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().warning(t, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Negotiation failed. Closing session. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.handshakePhase = (Function1 & Serializable & scala.Serializable)msg -> {
            MuxServerNegotiator.$anonfun$negotiationFailure$1(this, t, msg);
            return BoxedUnit.UNIT;
        };
        this.handle.send(Message$.MODULE$.encode(new Message.Rerr(tag, t.getMessage())), (Function1 & Serializable & scala.Serializable)x$1 -> {
            MuxServerNegotiator.$anonfun$negotiationFailure$2(this, t, x$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$checkRerrPhase$1(MuxServerNegotiator $this, Message x0$2) {
        Message message = x0$2;
        if (message instanceof Message.Rerr) {
            Message.Rerr rerr = (Message.Rerr)message;
            int n = rerr.tag();
            String string = rerr.error();
            if (Handshake$.MODULE$.TinitTag() == n) {
                String string2 = Handshake$.MODULE$.CanTinitMsg();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received Rerr prelude to Tinit. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    $this.handshakePhase = $this.getInitPhase();
                    $this.handle.sendAndForget(Message$.MODULE$.encode(new Message.Rerr(Handshake$.MODULE$.TinitTag(), Handshake$.MODULE$.CanTinitMsg())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rerr prelude not detected (received ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getClass().getSimpleName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping Init phase. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        $this.noInit(message);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$getInitPhase$1(MuxServerNegotiator $this, Message x0$3) {
        boolean bl = false;
        Message.Tinit tinit = null;
        Message message = x0$3;
        if (message instanceof Message.Tinit) {
            bl = true;
            tinit = (Message.Tinit)message;
            int tag = tinit.tag();
            short s = tinit.version();
            Seq<Tuple2<Buf, Buf>> headers = tinit.headers();
            if (Mux$.MODULE$.LatestVersion() == s) {
                BoxedUnit boxedUnit;
                try {
                    Seq localHeaders = (Seq)$this.makeLocalHeaders.apply(headers);
                    $this.handle.sendNowAndForget(Message$.MODULE$.encode(new Message.Rinit(tag, Mux$.MODULE$.LatestVersion(), (Seq<Tuple2<Buf, Buf>>)localHeaders)));
                    PushSession session = (PushSession)$this.negotiate.apply($this.service, (Object)new Some(headers));
                    $this.negotiationSuccess((PushSession<ByteReader, Buf>)session);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option.get();
                    $this.negotiationFailure(tag, t);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
                return;
            }
        }
        if (bl) {
            int tag = tinit.tag();
            short v = tinit.version();
            IllegalStateException ex = new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Mux version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)v)})));
            $this.negotiationFailure(tag, ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().warning("Received Rerr init probe but didn't receive a follow up " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tinit (received a ", "). ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getClass().getSimpleName(), $this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            $this.noInit(message);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$negotiationSuccess$1(MuxServerNegotiator $this, Message m) {
        String msg = "After negotiation success, more messages were sent to the " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"negotiating session: ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.getClass().getSimpleName(), $this.remoteAddressString()}));
        IllegalStateException ex = new IllegalStateException(msg);
        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().error((Throwable)ex, msg, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.handle.close();
    }

    public static final /* synthetic */ void $anonfun$negotiationFailure$1(MuxServerNegotiator $this, Throwable t$1, Message msg) {
        block0: {
            if (!MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) break block0;
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().debug(t$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Session negotiation failed. Swallowing message "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") that raced shutdown. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg.getClass().getSimpleName(), $this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }

    public static final /* synthetic */ void $anonfun$negotiationFailure$2(MuxServerNegotiator $this, Throwable t$1, Try x$1) {
        $this.close().ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.sessionP.setException(t$1));
    }

    public MuxServerNegotiator(RefPushSession<ByteReader, Buf> refSession, MuxChannelHandle handle, Service<Request, Response> service, Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> makeLocalHeaders, Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> negotiate, Timer timer) {
        this.refSession = refSession;
        this.handle = handle;
        this.service = service;
        this.makeLocalHeaders = makeLocalHeaders;
        this.negotiate = negotiate;
        this.timer = timer;
        super((PushChannelHandle)handle);
        this.sessionP = Promise$.MODULE$.apply();
        this.handshakePhase = this.checkRerrPhase();
        handle.onClose().ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ($this.sessionP.isDefined()) break block0;
                this.close();
            }
        });
    }
}

