/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.exp.pushsession;

import com.twitter.finagle.Mux;
import com.twitter.finagle.Mux$param$OppTls$;
import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.exp.pushsession.PushChannelHandle;
import com.twitter.finagle.exp.pushsession.PushSession;
import com.twitter.finagle.liveness.FailureDetector;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.exp.pushsession.FragmentDecoder;
import com.twitter.finagle.mux.exp.pushsession.FragmentingMessageWriter;
import com.twitter.finagle.mux.exp.pushsession.MessageWriter;
import com.twitter.finagle.mux.exp.pushsession.MuxChannelHandle;
import com.twitter.finagle.mux.exp.pushsession.MuxClientSession;
import com.twitter.finagle.mux.exp.pushsession.MuxMessageDecoder;
import com.twitter.finagle.mux.exp.pushsession.MuxServerSession;
import com.twitter.finagle.mux.transport.IncompatibleNegotiationException;
import com.twitter.finagle.mux.transport.MuxFramer$Header$;
import com.twitter.finagle.mux.transport.OpportunisticTls;
import com.twitter.finagle.mux.transport.OpportunisticTls$;
import com.twitter.finagle.mux.transport.OpportunisticTls$Header$;
import com.twitter.finagle.mux.transport.OpportunisticTls$Off$;
import com.twitter.finagle.param.Label;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.param.Timer;
import com.twitter.finagle.param.Timer$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015fAB\u0001\u0003\u0003\u0003AaBA\u0006OK\u001e|G/[1uS>t'BA\u0002\u0005\u0003-\u0001Xo\u001d5tKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011aA3ya*\u0011q\u0001C\u0001\u0004[VD(BA\u0005\u000b\u0003\u001d1\u0017N\\1hY\u0016T!a\u0003\u0007\u0002\u000fQ<\u0018\u000e\u001e;fe*\tQ\"A\u0002d_6\u001c\"\u0001A\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0011!1\u0002A!A!\u0002\u0013A\u0012A\u00029be\u0006l7o\u0001\u0001\u0011\u0005eibB\u0001\u000e\u001c\u001b\u0005A\u0011B\u0001\u000f\t\u0003\u0015\u0019F/Y2l\u0013\tqrD\u0001\u0004QCJ\fWn\u001d\u0006\u00039!AQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDCA\u0012&!\t!\u0003!D\u0001\u0003\u0011\u00151\u0002\u00051\u0001\u0019\t\u00159\u0003A!\u0001)\u0005!\u0019Vm]:j_:$\u0016CA\u0015-!\t\u0001\"&\u0003\u0002,#\t9aj\u001c;iS:<\u0007\u0003B\u00171eaj\u0011A\f\u0006\u0003\u0007=R!!\u0002\u0005\n\u0005Er#a\u0003)vg\"\u001cVm]:j_:\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0006\u0002\u0005%|\u0017BA\u001c5\u0005)\u0011\u0015\u0010^3SK\u0006$WM\u001d\t\u0003geJ!A\u000f\u001b\u0003\u0007\t+h\r\u0003\u0004=\u0001\u0001\u0006I!P\u0001\u0004Y><\u0007C\u0001 B\u001b\u0005y$B\u0001!\u000b\u0003\u001dawnZ4j]\u001eL!AQ \u0003\r1{wmZ3s\u0011\u0019!\u0005\u0001)A\u0005\u000b\u0006i1\u000f^1ugJ+7-Z5wKJ\u0004\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0005\u0002\u000bM$\u0018\r^:\n\u0005);%!D*uCR\u001c(+Z2fSZ,'\u000fC\u0003M\u0001\u0019EQ*A\u0004ck&dG-\u001a:\u0015\t9\u0003VK\u0017\t\u0003\u001f\u001aj\u0011\u0001\u0001\u0005\u0006#.\u0003\rAU\u0001\u0007Q\u0006tG\r\\3\u0011\t5\u001a&\u0007O\u0005\u0003):\u0012\u0011\u0003U;tQ\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7f\u0011\u001516\n1\u0001X\u0003\u00199(/\u001b;feB\u0011A\u0005W\u0005\u00033\n\u0011Q\"T3tg\u0006<Wm\u0016:ji\u0016\u0014\b\"B.L\u0001\u0004a\u0016a\u00023fG>$WM\u001d\t\u0003IuK!A\u0018\u0002\u0003#5+\b0T3tg\u0006<W\rR3d_\u0012,'\u000f\u0003\u0004a\u0001\u0001&I!Y\u0001\u0014e\u0016lw\u000e^3BI\u0012\u0014Xm]:TiJLgn\u001a\u000b\u0003E6\u0004\"a\u00196\u000f\u0005\u0011D\u0007CA3\u0012\u001b\u00051'BA4\u0018\u0003\u0019a$o\\8u}%\u0011\u0011.E\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j#!)\u0011k\u0018a\u0001]B\u001aqN]=\u0011\t5\u001a\u0006\u000f\u001f\t\u0003cJd\u0001\u0001B\u0005t[\u0006\u0005\t\u0011!B\u0001i\n\u0019q\fJ\u0019\u0012\u0005%*\bC\u0001\tw\u0013\t9\u0018CA\u0002B]f\u0004\"!]=\u0005\u0013il\u0017\u0011!A\u0001\u0006\u0003!(aA0%e!1A\u0010\u0001Q\u0005\nu\fqB\\3h_RL\u0017\r^3PaB$Fn\u001d\u000b\u0006}\u0006\r\u0011Q\u0001\t\u0003!}L1!!\u0001\u0012\u0005\u0011)f.\u001b;\t\u000bE[\b\u0019\u0001*\t\u000f\u0005\u001d1\u00101\u0001\u0002\n\u0005Y\u0001/Z3s\u0011\u0016\fG-\u001a:t!\u0015\u0001\u00121BA\b\u0013\r\ti!\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0011q\u0005\b\u0005\u0003'\t\u0019C\u0004\u0003\u0002\u0016\u0005\u0005b\u0002BA\f\u0003?qA!!\u0007\u0002\u001e9\u0019Q-a\u0007\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\r\t)CB\u0001\n\u0011\u0006tGm\u001d5bW\u0016LA!!\u000b\u0002,\t9\u0001*Z1eKJ\u001c(bAA\u0013\r!9\u0011q\u0006\u0001\u0005\u0006\u0005E\u0012!\u00038fO>$\u0018.\u0019;f)\u0015q\u00151GA\u001b\u0011\u0019\t\u0016Q\u0006a\u0001%\"A\u0011qAA\u0017\u0001\u0004\tIa\u0002\u0005\u0002:\tA\t\u0001CA\u001e\u0003-qUmZ8uS\u0006$\u0018n\u001c8\u0011\u0007\u0011\niDB\u0004\u0002\u0005!\u0005\u0001\"a\u0010\u0014\u0007\u0005ur\u0002C\u0004\"\u0003{!\t!a\u0011\u0015\u0005\u0005mbaBA$\u0003{\u0011\u0011\u0011\n\u0002\u0007\u00072LWM\u001c;\u0014\u0007\u0005\u00153\u0005C\u0005\u0017\u0003\u000b\u0012\t\u0011)A\u00051!9\u0011%!\u0012\u0005\u0002\u0005=C\u0003BA)\u0003+\u0002B!a\u0015\u0002F5\u0011\u0011Q\b\u0005\u0007-\u00055\u0003\u0019\u0001\r\u0006\r\u001d\n)\u0005IA-!\r!\u00131L\u0005\u0004\u0003;\u0012!\u0001E'vq\u000ec\u0017.\u001a8u'\u0016\u001c8/[8o\u0011\u001da\u0015Q\tC\t\u0003C\"\u0002\"!\u0017\u0002d\u0005\u0015\u0014q\r\u0005\u0007#\u0006}\u0003\u0019\u0001*\t\rY\u000by\u00061\u0001X\u0011\u0019Y\u0016q\fa\u00019\u001a9\u00111NA\u001f\u0005\u00055$AB*feZ,'oE\u0002\u0002j\rB\u0011BFA5\u0005\u0003\u0005\u000b\u0011\u0002\r\t\u0017\u0005M\u0014\u0011\u000eB\u0001B\u0003%\u0011QO\u0001\bg\u0016\u0014h/[2f!\u001dQ\u0012qOA>\u0003\u0007K1!!\u001f\t\u0005\u001d\u0019VM\u001d<jG\u0016\u0004B!! \u0002\u00005\ta!C\u0002\u0002\u0002\u001a\u0011qAU3rk\u0016\u001cH\u000f\u0005\u0003\u0002~\u0005\u0015\u0015bAAD\r\tA!+Z:q_:\u001cX\rC\u0004\"\u0003S\"\t!a#\u0015\r\u00055\u0015qRAI!\u0011\t\u0019&!\u001b\t\rY\tI\t1\u0001\u0019\u0011!\t\u0019(!#A\u0002\u0005UTAB\u0014\u0002j\u0001\n)\nE\u0002%\u0003/K1!!'\u0003\u0005AiU\u000f_*feZ,'oU3tg&|g\u000eC\u0004M\u0003S\"\t\"!(\u0015\u0011\u0005U\u0015qTAQ\u0003GCa!UAN\u0001\u0004\u0011\u0006B\u0002,\u0002\u001c\u0002\u0007q\u000b\u0003\u0004\\\u00037\u0003\r\u0001\u0018")
public abstract class Negotiation {
    private final Stack.Params params;
    private final Logger log;
    private final StatsReceiver statsReceiver;

    public abstract PushSession builder(PushChannelHandle<ByteReader, Buf> var1, MessageWriter var2, MuxMessageDecoder var3);

    private String remoteAddressString(PushChannelHandle<?, ?> handle) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remote: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{handle.remoteAddress()}));
    }

    private void negotiateOppTls(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
        OpportunisticTls.Level level;
        OpportunisticTls.Level localEncryptLevel = (OpportunisticTls.Level)((Mux.param.OppTls)this.params.apply(Mux$param$OppTls$.MODULE$.param())).level().getOrElse((Function0 & Serializable & scala.Serializable)() -> OpportunisticTls$Off$.MODULE$);
        Option option = peerHeaders.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Handshake$.MODULE$.valueOf(OpportunisticTls$Header$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)x$1));
        if (option instanceof Some) {
            Some some = (Some)option;
            Buf buf = (Buf)some.value();
            level = OpportunisticTls$Header$.MODULE$.decodeLevel(buf);
        } else if (None$.MODULE$.equals(option)) {
            this.log.debug("Peer either didn't negotiate or didn't send an Opportunistic Tls preference: " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"defaulting to remote encryption level of Off. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddressString(handle)})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            level = OpportunisticTls$Off$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        OpportunisticTls.Level remoteEncryptLevel = level;
        try {
            boolean useTls = OpportunisticTls$.MODULE$.negotiate(localEncryptLevel, remoteEncryptLevel);
            if (this.log.isLoggable((Level)Level.DEBUG$.MODULE$)) {
                this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully negotiated TLS with remote peer. Using TLS: ", " local level: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)useTls)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", remote level: ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{localEncryptLevel, remoteEncryptLevel, this.remoteAddressString(handle)})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            if (useTls) {
                this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tls", "upgrade", "success"})).incr();
                this.turnOnTls$1(handle);
            }
        }
        catch (IncompatibleNegotiationException exn) {
            this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tls", "upgrade", "incompatible"})).incr();
            this.log.fatal((Throwable)exn, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The local peer wanted ", " and the remote peer wanted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{localEncryptLevel})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " which are incompatible. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{remoteEncryptLevel, this.remoteAddressString(handle)})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            throw exn;
        }
    }

    public final PushSession negotiate(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
        this.negotiateOppTls(handle, peerHeaders);
        StatsReceiver framingStats = this.statsReceiver.scope("framer");
        int fragmentSize = BoxesRunTime.unboxToInt((Object)peerHeaders.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Handshake$.MODULE$.valueOf(MuxFramer$Header$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)x$2)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)MuxFramer$Header$.MODULE$.decodeFrameSize(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
        FragmentingMessageWriter writeManager = new FragmentingMessageWriter(handle, fragmentSize, framingStats);
        FragmentDecoder messageDecoder = new FragmentDecoder(framingStats);
        return this.builder(handle, writeManager, messageDecoder);
    }

    private final void turnOnTls$1(PushChannelHandle handle$1) {
        PushChannelHandle pushChannelHandle = handle$1;
        if (!(pushChannelHandle instanceof MuxChannelHandle)) {
            throw new IllegalStateException("Expected to find a MuxChannelHandle, instead found " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Couldn't turn on TLS. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pushChannelHandle, this.remoteAddressString(handle$1)})));
        }
        MuxChannelHandle muxChannelHandle = (MuxChannelHandle)pushChannelHandle;
        muxChannelHandle.turnOnTls();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Negotiation(Stack.Params params) {
        this.params = params;
        this.log = Logger$.MODULE$.get();
        this.statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
    }

    public static final class Client
    extends Negotiation {
        private final Stack.Params params;

        @Override
        public MuxClientSession builder(PushChannelHandle<ByteReader, Buf> handle, MessageWriter writer, MuxMessageDecoder decoder) {
            return new MuxClientSession(handle, decoder, writer, ((FailureDetector.Param)this.params.apply(FailureDetector.Param$.MODULE$.param())).param(), ((Label)this.params.apply(Label$.MODULE$.param())).label(), ((Stats)this.params.apply(Stats$.MODULE$.param())).statsReceiver(), ((Timer)this.params.apply(Timer$.MODULE$.param())).timer());
        }

        public Client(Stack.Params params) {
            this.params = params;
            super(params);
        }
    }

    public static final class Server
    extends Negotiation {
        private final Stack.Params params;
        private final Service<Request, Response> service;

        @Override
        public MuxServerSession builder(PushChannelHandle<ByteReader, Buf> handle, MessageWriter writer, MuxMessageDecoder decoder) {
            return new MuxServerSession(this.params, decoder, writer, handle, this.service);
        }

        public Server(Stack.Params params, Service<Request, Response> service) {
            this.params = params;
            this.service = service;
            super(params);
        }
    }
}

