/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.util;

import com.twitter.finagle.mux.util.TagMap$;
import io.netty.util.collection.IntObjectHashMap;
import java.util.BitSet;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001C\u0001\u0003!\u0003\r\n\u0001\u0002\u0007\u0003\rQ\u000bw-T1q\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003\riW\u000f\u001f\u0006\u0003\u000f!\tqAZ5oC\u001edWM\u0003\u0002\n\u0015\u00059Ao^5ui\u0016\u0014(\"A\u0006\u0002\u0007\r|W.\u0006\u0002\u000eKM\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001a\u0011A\f\u0002\tML'0Z\u0002\u0001+\u0005A\u0002CA\b\u001a\u0013\tQ\u0002CA\u0002J]RDQ\u0001\b\u0001\u0007\u0002u\t1!\\1q)\tq\u0012\u0005E\u0002\u0010?aI!\u0001\t\t\u0003\r=\u0003H/[8o\u0011\u0015\u00113\u00041\u0001$\u0003\t)G\u000e\u0005\u0002%K1\u0001A!\u0002\u0014\u0001\u0005\u00049#!\u0001+\u0012\u0005!Z\u0003CA\b*\u0013\tQ\u0003CA\u0004O_RD\u0017N\\4\u0011\u0005=a\u0013BA\u0017\u0011\u0005\r\te.\u001f\u0005\u0006_\u00011\t\u0001M\u0001\u000b[\u0006L(-\u001a*f[\u0006\u0004HcA\u00193iA\u0019qbH\u0012\t\u000bMr\u0003\u0019\u0001\r\u0002\u0007Q\fw\rC\u00036]\u0001\u00071%A\u0003oK^,E\u000eC\u00038\u0001\u0019\u0005\u0001(A\u0003v]6\f\u0007\u000f\u0006\u00022s!)1G\u000ea\u00011!)1\b\u0001D\u0001y\u0005AQO\\7ba\u0006cG\u000eF\u0001>!\rqdi\t\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\f\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA#\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0007M+\u0017O\u0003\u0002F!\u001d1!J\u0001E\u0001\t-\u000ba\u0001V1h\u001b\u0006\u0004\bC\u0001'N\u001b\u0005\u0011aAB\u0001\u0003\u0011\u0003!aj\u0005\u0002N\u001d!)\u0001+\u0014C\u0001#\u00061A(\u001b8jiz\"\u0012a\u0013\u0005\u0006'6#\t\u0001V\u0001\u0006CB\u0004H._\u000b\u0003+b#2AV-d!\ra\u0005a\u0016\t\u0003Ia#QA\n*C\u0002\u001dBQA\u0017*A\u0002m\u000bQA]1oO\u0016\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u0013%lW.\u001e;bE2,'B\u00011\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u0013QAU1oO\u0016DQ\u0001\u001a*A\u0002a\t1\"\u001b8ji&\fGnU5{K\u001a1a-\u0014Q\u0001\n\u001d\u0014!\u0002V1h\u001b\u0006\u0004\u0018*\u001c9m+\tA7nE\u0002f\u001d%\u00042\u0001\u0014\u0001k!\t!3\u000eB\u0003'K\n\u0007q\u0005\u0003\u0005nK\n\u0005\t\u0015!\u0003o\u0003\r\u0019X\r\u001e\t\u0003_Bl\u0011!\u0014\u0004\u0006c6\u0013!A\u001d\u0002\u0007)\u0006<7+\u001a;\u0014\u0005At\u0001\u0002\u0003.q\u0005\u000b\u0007I\u0011\u0001;\u0016\u0003mC\u0001B\u001e9\u0003\u0002\u0003\u0006IaW\u0001\u0007e\u0006tw-\u001a\u0011\t\u000bA\u0003H\u0011\u0001=\u0015\u00059L\b\"\u0002.x\u0001\u0004Y\u0006BB>qA\u0003%\u0001$A\u0003ti\u0006\u0014H\u000f\u0003\u0004~a\u0002\u0006IA`\u0001\u0005E&$8\u000fE\u0002\u0000\u0003\u000fi!!!\u0001\u000b\u0007\r\t\u0019A\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\u0011\tI!!\u0001\u0003\r\tKGoU3u\u0011\u001d\ti\u0001\u001dC\u0001\u0003\u001f\tq!Y2rk&\u0014X\rF\u0001\u001f\u0011\u001d\t\u0019\u0002\u001dC\u0001\u0003+\tQa\u00197fCJ$\"!a\u0006\u0011\u0007=\tI\"C\u0002\u0002\u001cA\u0011A!\u00168ji\"9\u0011q\u00049\u0005\u0002\u0005\u0005\u0012a\u0002:fY\u0016\f7/\u001a\u000b\u0005\u0003/\t\u0019\u0003\u0003\u00044\u0003;\u0001\r\u0001\u0007\u0005\b\u0003O\u0001H\u0011AA\u0015\u0003\u0015!xnU3r+\t\tY\u0003E\u0002?\rbA\u0001\u0002Z3\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\u0007!\u0016$\t!!\r\u0015\r\u0005M\u0012QGA\u001c!\ryWM\u001b\u0005\u0007[\u0006=\u0002\u0019\u00018\t\r\u0011\fy\u00031\u0001\u0019\u0011\u0015)R\r\"\u0001\u0018\u0011!\ti$\u001aQ\u0001\n\u0005}\u0012A\u0002<bYV,7\u000fE\u0003\u0002B\u0005=#.\u0004\u0002\u0002D)\u0019\u0001-!\u0012\u000b\u0007\r\t9E\u0003\u0003\u0002J\u0005-\u0013!\u00028fiRL(BAA'\u0003\tIw.\u0003\u0003\u0002R\u0005\r#\u0001E%oi>\u0013'.Z2u\u0011\u0006\u001c\b.T1q\u0011\u0019aR\r\"\u0001\u0002VQ\u0019a$a\u0016\t\r\t\n\u0019\u00061\u0001k\u0011\u0019yS\r\"\u0001\u0002\\Q1\u0011QLA0\u0003C\u00022aD\u0010k\u0011\u0019\u0019\u0014\u0011\fa\u00011!1Q'!\u0017A\u0002)DaaN3\u0005\u0002\u0005\u0015D\u0003BA/\u0003OBaaMA2\u0001\u0004A\u0002bBA6K\u0012\u0005\u0011QN\u0001\u0004O\u0016$H\u0003BA/\u0003_BaaMA5\u0001\u0004A\u0002BB\u001ef\t\u0003\t\u0019\b\u0006\u0002\u0002vA\u0019aH\u00126\t\u0011\u0005eT\r)C\u0005\u0003w\nq!\u001b8SC:<W\r\u0006\u0003\u0002~\u0005\r\u0005cA\b\u0002\u0000%\u0019\u0011\u0011\u0011\t\u0003\u000f\t{w\u000e\\3b]\"11'a\u001eA\u0002aAq!a\"f\t\u0003\nI)\u0001\u0005u_N#(/\u001b8h)\t\tY\t\u0005\u0003\u0002\u000e\u0006Ue\u0002BAH\u0003#\u0003\"\u0001\u0011\t\n\u0007\u0005M\u0005#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\u000bIJ\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'\u0003\u0002")
public interface TagMap<T> {
    public static <T> TagMap<T> apply(Range range, int n) {
        return TagMap$.MODULE$.apply(range, n);
    }

    public int size();

    public Option<Object> map(T var1);

    public Option<T> maybeRemap(int var1, T var2);

    public Option<T> unmap(int var1);

    public Seq<T> unmapAll();

    public static class TagMapImpl<T>
    implements TagMap<T> {
        private final TagSet set;
        private final IntObjectHashMap<T> values;

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Option<Object> map(T el) {
            None$ none$;
            Option<Object> option = this.set.acquire();
            if (option instanceof Some) {
                Some some = (Some)option;
                int tag = BoxesRunTime.unboxToInt((Object)some.value());
                this.values.put(tag, el);
                none$ = some;
            } else if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            return none$;
        }

        @Override
        public Option<T> maybeRemap(int tag, T newEl) {
            None$ none$;
            if (!this.inRange(tag)) {
                none$ = None$.MODULE$;
            } else {
                Object oldEl = this.values.put(tag, newEl);
                none$ = Option$.MODULE$.apply(oldEl);
            }
            return none$;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Option<T> unmap(int tag) {
            None$ none$;
            if (!this.inRange(tag)) {
                none$ = None$.MODULE$;
            } else {
                void var3_3;
                Object oldEl = this.values.remove(tag);
                Option res = Option$.MODULE$.apply(oldEl);
                this.set.release(tag);
                none$ = var3_3;
            }
            return none$;
        }

        public Option<T> get(int tag) {
            return !this.inRange(tag) ? None$.MODULE$ : Option$.MODULE$.apply(this.values.get(tag));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Seq<T> unmapAll() {
            void var1_1;
            List results = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.values.values()).asScala()).toList();
            this.set.clear();
            this.values.clear();
            return var1_1;
        }

        private boolean inRange(int tag) {
            return tag >= this.set.range().start() && tag <= this.set.range().end();
        }

        public String toString() {
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.values.keySet()).asScala()).mkString("TagMap[", ", ", "]");
        }

        public TagMapImpl(TagSet set, int initialSize) {
            this.set = set;
            Predef$.MODULE$.require(initialSize >= 0);
            Predef$.MODULE$.require(set.range().start() >= 0);
            this.values = new IntObjectHashMap(initialSize);
        }
    }

    public static final class TagSet {
        private final Range range;
        private final int start;
        private final BitSet bits;

        public Range range() {
            return this.range;
        }

        public Option<Object> acquire() {
            None$ none$;
            int tag = this.bits.nextClearBit(this.start);
            if (!this.range().contains(tag)) {
                none$ = None$.MODULE$;
            } else {
                this.bits.set(tag);
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)tag));
            }
            return none$;
        }

        public void clear() {
            this.bits.clear();
        }

        public void release(int tag) {
            this.bits.clear(tag);
        }

        public Seq<Object> toSeq() {
            return this.build$1(0, new ListBuffer());
        }

        private final Seq build$1(int i, ListBuffer buffer) {
            int next;
            while ((next = this.bits.nextSetBit(i)) != -1) {
                buffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)next));
                i = next + 1;
            }
            return buffer.result();
        }

        public TagSet(Range range) {
            this.range = range;
            Predef$.MODULE$.require(range.step() == 1);
            this.start = range.start();
            this.bits = new BitSet();
        }
    }
}

