/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.lease.exp;

import com.twitter.conversions.StorageUnitOps;
import com.twitter.conversions.StorageUnitOps$;
import com.twitter.finagle.mux.lease.exp.GenerationalRandom;
import com.twitter.finagle.mux.lease.exp.JvmInfo;
import com.twitter.finagle.mux.lease.exp.LogsReceiver;
import com.twitter.finagle.mux.lease.exp.NullLogsReceiver$;
import com.twitter.finagle.mux.lease.exp.RequestSnooper;
import com.twitter.util.StorageUnit;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114Qa\u0004\t\u0001%qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tS\u0001\u0011)\u0019!C\u0001U!A\u0011\u0007\u0001B\u0001B\u0003%1\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u0003,\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011m\u0002!\u0011!Q\u0001\nqBQa\u0010\u0001\u0005\u0002\u0001CQa\u0010\u0001\u0005\u0002!CQa\u0010\u0001\u0005\u00029Caa\u0015\u0001!\u0002\u0013!\u0006\"B0\u0001\t\u0003\u0001\u0007\"B1\u0001\t\u0003Q\u0003\"\u00022\u0001\t\u0003\u001a'aC'f[>\u0014\u0018p\u00159bG\u0016T!!\u0005\n\u0002\u0007\u0015D\bO\u0003\u0002\u0014)\u0005)A.Z1tK*\u0011QCF\u0001\u0004[VD(BA\f\u0019\u0003\u001d1\u0017N\\1hY\u0016T!!\u0007\u000e\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1$A\u0002d_6\u001c\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003\u0011IgNZ8\u0004\u0001A\u0011aeJ\u0007\u0002!%\u0011\u0001\u0006\u0005\u0002\b\u0015Zl\u0017J\u001c4p\u0003-i\u0017N\u001c#jg\u000e|WO\u001c;\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\r\u0002\tU$\u0018\u000e\\\u0005\u0003a5\u00121b\u0015;pe\u0006<W-\u00168ji\u0006aQ.\u001b8ESN\u001cw.\u001e8uA\u0005YQ.\u0019=ESN\u001cw.\u001e8u\u0003!\u00118K\\8pa\u0016\u0014\bC\u0001\u00146\u0013\t1\u0004C\u0001\bSKF,Xm\u001d;T]>|\u0007/\u001a:\u0002\u00051\u0014\bC\u0001\u0014:\u0013\tQ\u0004C\u0001\u0007M_\u001e\u001c(+Z2fSZ,'/A\u0002s]\u0012\u0004\"AJ\u001f\n\u0005y\u0002\"AE$f]\u0016\u0014\u0018\r^5p]\u0006d'+\u00198e_6\fa\u0001P5oSRtDcB!C\u0007\u0012+ei\u0012\t\u0003M\u0001AQa\t\u0005A\u0002\u0015BQ!\u000b\u0005A\u0002-BQA\r\u0005A\u0002-BQa\r\u0005A\u0002QBQa\u000e\u0005A\u0002aBQa\u000f\u0005A\u0002q\"b!Q%K\u00172k\u0005\"B\u0012\n\u0001\u0004)\u0003\"B\u0015\n\u0001\u0004Y\u0003\"\u0002\u001a\n\u0001\u0004Y\u0003\"B\u001a\n\u0001\u0004!\u0004\"B\u001c\n\u0001\u0004AD#B!P!F\u0013\u0006\"B\u0012\u000b\u0001\u0004)\u0003\"B\u0015\u000b\u0001\u0004Y\u0003\"\u0002\u001a\u000b\u0001\u0004Y\u0003\"B\u001a\u000b\u0001\u0004!\u0014A\u00059sS:$\u0018M\u00197f5\u0016\u0014xNQ=uKN\u0004\"!\u0016/\u000f\u0005YS\u0006CA, \u001b\u0005A&BA-%\u0003\u0019a$o\\8u}%\u00111lH\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\?\u0005AA-[:d_VtG\u000fF\u0001,\u0003\u0011aWM\u001a;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u0016")
public class MemorySpace {
    private final JvmInfo info;
    private final StorageUnit minDiscount;
    private final StorageUnit maxDiscount;
    private final RequestSnooper rSnooper;
    private final LogsReceiver lr;
    private final GenerationalRandom rnd;
    private final String printableZeroBytes;

    public StorageUnit minDiscount() {
        return this.minDiscount;
    }

    public StorageUnit discount() {
        StorageUnit storageUnit;
        StorageUnit handleBytes = this.rSnooper.handleBytes();
        this.lr.record("discountHandleBytes", handleBytes.toString());
        if (handleBytes.$less((Object)this.maxDiscount)) {
            StorageUnit low = handleBytes.max(this.minDiscount());
            StorageUnit discountWin = StorageUnitOps.RichStorageUnit$.MODULE$.bytes$extension(StorageUnitOps$.MODULE$.RichStorageUnit((long)this.rnd.apply() % this.maxDiscount.$minus(low).inBytes()));
            this.lr.record("discountWin", discountWin.toString());
            StorageUnit discountTotal = low.$plus(discountWin);
            this.lr.record("discountTotal", discountTotal.toString());
            storageUnit = discountTotal;
        } else {
            this.lr.record("discountWin", this.printableZeroBytes);
            this.lr.record("discountTotal", this.printableZeroBytes);
            storageUnit = this.maxDiscount;
        }
        return storageUnit;
    }

    public StorageUnit left() {
        return this.info.remaining().$minus(this.minDiscount());
    }

    public String toString() {
        return new StringBuilder(36).append("MemorySpace(left=").append(this.left()).append(", discount=").append(this.discount()).append(", info=").append(this.info).append(")").toString();
    }

    public MemorySpace(JvmInfo info, StorageUnit minDiscount, StorageUnit maxDiscount, RequestSnooper rSnooper, LogsReceiver lr, GenerationalRandom rnd) {
        this.info = info;
        this.minDiscount = minDiscount;
        this.maxDiscount = maxDiscount;
        this.rSnooper = rSnooper;
        this.lr = lr;
        this.rnd = rnd;
        this.printableZeroBytes = StorageUnitOps.RichStorageUnit$.MODULE$.bytes$extension(StorageUnitOps$.MODULE$.richStorageUnitFromInt(0)).toString();
    }

    public MemorySpace(JvmInfo info, StorageUnit minDiscount, StorageUnit maxDiscount, RequestSnooper rSnooper, LogsReceiver lr) {
        this(info, minDiscount, maxDiscount, rSnooper, lr, new GenerationalRandom(info));
    }

    public MemorySpace(JvmInfo info, StorageUnit minDiscount, StorageUnit maxDiscount, RequestSnooper rSnooper) {
        this(info, minDiscount, maxDiscount, rSnooper, NullLogsReceiver$.MODULE$);
    }
}

