/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.pushsession;

import com.twitter.finagle.mux.pushsession.MuxMessageDecoder;
import com.twitter.finagle.mux.pushsession.SharedNegotiationStats;
import com.twitter.finagle.mux.pushsession.SharedNegotiationStats$;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.finagle.mux.transport.Message$Tags$;
import com.twitter.finagle.mux.transport.Message$Types$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.io.ByteReader$;
import io.netty.util.collection.IntObjectHashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4Q!\u0003\u0006\u0003\u0019QA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006=\u0001!\ta\b\u0005\u0006=\u0001!\tA\t\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u0016\t\u000bm\u0002A\u0011\u0003\u001f\t\r!\u0003\u0001\u0015\"\u0003J\u0011\u0019A\u0006\u0001)C\u00053\"1q\f\u0001Q\u0005\n\u0001\u0014qB\u0012:bO6,g\u000e\u001e#fG>$WM\u001d\u0006\u0003\u00171\t1\u0002];tQN,7o]5p]*\u0011QBD\u0001\u0004[VD(BA\b\u0011\u0003\u001d1\u0017N\\1hY\u0016T!!\u0005\n\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1#A\u0002d_6\u001c\"\u0001A\u000b\u0011\u0005Y9R\"\u0001\u0006\n\u0005aQ!!E'vq6+7o]1hK\u0012+7m\u001c3fe\u0006)1\u000f^1ug\u000e\u0001\u0001C\u0001\f\u001d\u0013\ti\"B\u0001\fTQ\u0006\u0014X\r\u001a(fO>$\u0018.\u0019;j_:\u001cF/\u0019;t\u0003\u0019a\u0014N\\5u}Q\u0011\u0001%\t\t\u0003-\u0001AQ!\u0007\u0002A\u0002m!\"\u0001I\u0012\t\u000be\u0019\u0001\u0019\u0001\u0013\u0011\u0005\u0015:S\"\u0001\u0014\u000b\u0005eq\u0011B\u0001\u0015'\u00055\u0019F/\u0019;t%\u0016\u001cW-\u001b<fe\u0006IaM]1h[\u0016tGo\u001d\t\u0004WQ2T\"\u0001\u0017\u000b\u00055r\u0013AC2pY2,7\r^5p]*\u0011q\u0006M\u0001\u0005kRLGN\u0003\u00022e\u0005)a.\u001a;us*\t1'\u0001\u0002j_&\u0011Q\u0007\f\u0002\u0011\u0013:$xJ\u00196fGRD\u0015m\u001d5NCB\u0004\"aN\u001d\u000e\u0003aR!a\r\t\n\u0005iB$a\u0001\"vM\u0006AAm\u001c#fG>$W\r\u0006\u0002>\u0007B\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tD\u0001\niJ\fgn\u001d9peRL!AQ \u0003\u000f5+7o]1hK\")A)\u0002a\u0001\u000b\u00061!/Z1eKJ\u0004\"a\u000e$\n\u0005\u001dC$A\u0003\"zi\u0016\u0014V-\u00193fe\u0006IA.Y:u\u0007\",hn\u001b\u000b\u0005{)\u0013v\u000bC\u0003L\r\u0001\u0007A*A\u0002uC\u001e\u0004\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u00131!\u00138u\u0011\u0015\u0019f\u00011\u0001U\u0003\r!\u0018\u0010\u001d\t\u0003\u001bVK!A\u0016(\u0003\t\tKH/\u001a\u0005\u0006\t\u001a\u0001\r!R\u0001\u0013C\u000e\u001cW/\\;mCR,gI]1h[\u0016tG\u000fF\u0002[;z\u0003\"!T.\n\u0005qs%\u0001B+oSRDQaS\u0004A\u00021CQ\u0001R\u0004A\u0002\u0015\u000baaZ3u\u0017\u0016LHC\u0001'b\u0011\u0015Y\u0005\u00021\u0001M\u0001")
public final class FragmentDecoder
extends MuxMessageDecoder {
    private final SharedNegotiationStats stats;
    private final IntObjectHashMap<Buf> fragments;

    @Override
    public Message doDecode(ByteReader reader) {
        Message message;
        this.stats.readStreamBytes().add((float)reader.remaining());
        int header = reader.readIntBE();
        byte typ = Message$Tags$.MODULE$.extractType(header);
        int tag = Message$Tags$.MODULE$.extractTag(header);
        if (!Message$Tags$.MODULE$.isFragment(tag)) {
            message = this.lastChunk(tag, typ, reader);
        } else {
            this.accumulateFragment(tag, reader);
            message = null;
        }
        return message;
    }

    private Message lastChunk(int tag, byte typ, ByteReader reader) {
        Message message;
        if (Message$Types$.MODULE$.isDiscard(typ)) {
            int n;
            Message msg = Message$.MODULE$.decodeMessageBody(typ, tag, reader);
            Message message2 = msg;
            if (message2 instanceof Message.Tdiscarded) {
                int tagToRemove;
                Message.Tdiscarded tdiscarded = (Message.Tdiscarded)message2;
                n = tagToRemove = tdiscarded.which();
            } else {
                n = tag;
            }
            int tagToRemove = n;
            if (this.fragments.remove(this.getKey(tagToRemove)) != null) {
                this.stats.pendingReadStreams().decrement();
            }
            message = msg;
        } else {
            ByteReader fullMessageBody;
            Buf existing = (Buf)this.fragments.remove(this.getKey(tag));
            ByteReader byteReader = fullMessageBody = existing == null ? reader : ByteReader$.MODULE$.apply(existing.concat(reader.readAll()));
            if (existing != null) {
                this.stats.pendingReadStreams().decrement();
            }
            message = Message$.MODULE$.decodeMessageBody(typ, tag, fullMessageBody);
        }
        return message;
    }

    private void accumulateFragment(int tag, ByteReader reader) {
        block0: {
            int key = this.getKey(tag);
            Buf tail = reader.readAll();
            Buf head = (Buf)this.fragments.get(key);
            Buf chunk = head != null ? head.concat(tail) : tail;
            this.fragments.put(key, (Object)chunk);
            if (head != null) break block0;
            this.stats.pendingReadStreams().increment();
        }
    }

    private int getKey(int tag) {
        return Message$Tags$.MODULE$.setMsb(tag);
    }

    public FragmentDecoder(SharedNegotiationStats stats) {
        this.stats = stats;
        this.fragments = new IntObjectHashMap();
    }

    public FragmentDecoder(StatsReceiver stats) {
        this(new SharedNegotiationStats(stats, SharedNegotiationStats$.MODULE$.$lessinit$greater$default$2(), SharedNegotiationStats$.MODULE$.$lessinit$greater$default$3()));
    }
}

