/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.pushsession;

import com.twitter.finagle.Mux$;
import com.twitter.finagle.Service;
import com.twitter.finagle.Status;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.pushsession.MuxChannelHandle;
import com.twitter.finagle.mux.pushsession.MuxServerNegotiator$;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.finagle.pushsession.PushChannelHandle;
import com.twitter.finagle.pushsession.PushSession;
import com.twitter.finagle.pushsession.RefPushSession;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.io.ByteReader$;
import com.twitter.logging.Level;
import com.twitter.util.Closable;
import com.twitter.util.Closable$;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Timer;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg!B\u000e\u001d\u0001\u00012\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011i\u0002!\u0011!Q\u0001\nmB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003m\u0011\u0015\u0011\b\u0001\"\u0003t\u000b\u0019Y\b\u0001)A\u0005y\"A\u0011Q\u0002\u0001!\u0002\u0013\ty\u0001\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0015BA\f\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!A\u0011Q\t\u0001!\n\u0013\t9\u0005\u0003\u0005\u0002J\u0001\u0001K\u0011BA$\u0011!\tY\u0005\u0001Q\u0005\n\u00055\u0003\u0002CA0\u0001\u0001&I!!\u0019\t\u0011\u0005\u0015\u0004\u0001)C\u0005\u0003OB\u0001\"!\u001c\u0001A\u0013%\u0011qN\u0004\t\u0003#c\u0002\u0012\u0001\u0011\u0002\u0014\u001a91\u0004\bE\u0001A\u0005U\u0005B\u0002:\u0017\t\u0003\ti\nC\u0005\u0002 Z\u0011\r\u0011\"\u0003\u0002\"\"A\u0011q\u0016\f!\u0002\u0013\t\u0019\u000bC\u0004\u00022Z!\t!a-\u0003'5+\bpU3sm\u0016\u0014h*Z4pi&\fGo\u001c:\u000b\u0005uq\u0012a\u00039vg\"\u001cXm]:j_:T!a\b\u0011\u0002\u00075,\bP\u0003\u0002\"E\u00059a-\u001b8bO2,'BA\u0012%\u0003\u001d!x/\u001b;uKJT\u0011!J\u0001\u0004G>l7C\u0001\u0001(!\u0011A#\u0006\f\u001a\u000e\u0003%R!!\b\u0011\n\u0005-J#a\u0003)vg\"\u001cVm]:j_:\u0004\"!\f\u0019\u000e\u00039R!a\f\u0012\u0002\u0005%|\u0017BA\u0019/\u0005)\u0011\u0015\u0010^3SK\u0006$WM\u001d\t\u0003[MJ!\u0001\u000e\u0018\u0003\u0007\t+h-\u0001\u0006sK\u001a\u001cVm]:j_:\u001c\u0001\u0001\u0005\u0003)q1\u0012\u0014BA\u001d*\u00059\u0011VM\u001a)vg\"\u001cVm]:j_:\fa\u0001[1oI2,\u0007C\u0001\u001f>\u001b\u0005a\u0012B\u0001 \u001d\u0005AiU\u000f_\"iC:tW\r\u001c%b]\u0012dW-A\u0004tKJ4\u0018nY3\u0011\t\u0005\u0013E\tS\u0007\u0002A%\u00111\t\t\u0002\b'\u0016\u0014h/[2f!\t)e)D\u0001\u001f\u0013\t9eDA\u0004SKF,Xm\u001d;\u0011\u0005\u0015K\u0015B\u0001&\u001f\u0005!\u0011Vm\u001d9p]N,\u0017\u0001E7bW\u0016dunY1m\u0011\u0016\fG-\u001a:t!\u0011i\u0005K\u0015*\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0005M\u000bgB\u0001+`\u001d\t)fL\u0004\u0002W;:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u00035Z\na\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005\r\"\u0013BA\u0011#\u0013\ty\u0002%\u0003\u0002a=\u0005I\u0001*\u00198eg\"\f7.Z\u0005\u0003E\u000e\u0014q\u0001S3bI\u0016\u00148O\u0003\u0002a=\u0005Ia.Z4pi&\fG/\u001a\t\u0006\u001b\u001a\u0004\u0005nJ\u0005\u0003O:\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u00075K'+\u0003\u0002k\u001d\n1q\n\u001d;j_:\fQ\u0001^5nKJ\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003c:\u0014Q\u0001V5nKJ\fa\u0001P5oSRtDc\u0002;vm^D\u0018P\u001f\t\u0003y\u0001AQ!N\u0004A\u0002]BQAO\u0004A\u0002mBQaP\u0004A\u0002\u0001CQaS\u0004A\u00021CQ\u0001Z\u0004A\u0002\u0015DQa[\u0004A\u00021\u0014Q\u0001\u00155bg\u0016\u0004R!\u0014)~\u0003\u000f\u00012A`A\u0002\u001b\u0005y(bAA\u0001=\u0005IAO]1ogB|'\u000f^\u0005\u0004\u0003\u000by(aB'fgN\fw-\u001a\t\u0004\u001b\u0006%\u0011bAA\u0006\u001d\n!QK\\5u\u0003!\u0019Xm]:j_:\u0004\u0006\u0003B7\u0002\u0012\u001dJ1!a\u0005o\u0005\u001d\u0001&o\\7jg\u0016\fa\u0002[1oIND\u0017m[3QQ\u0006\u001cX\rE\u0002\u0002\u001a!i\u0011\u0001A\u0001\b_:\u001cEn\\:f+\t\ty\u0002E\u0003n\u0003C\t9!C\u0002\u0002$9\u0014aAR;ukJ,\u0017!B2m_N,G\u0003BA\u0010\u0003SAq!a\u000b\r\u0001\u0004\ti#\u0001\u0005eK\u0006$G.\u001b8f!\ri\u0017qF\u0005\u0004\u0003cq'\u0001\u0002+j[\u0016\faa\u001d;biV\u001cXCAA\u001c!\r\t\u0015\u0011H\u0005\u0004\u0003w\u0001#AB*uCR,8/A\u0004sK\u000e,\u0017N^3\u0015\t\u0005\u001d\u0011\u0011\t\u0005\u0007\u0003\u0007r\u0001\u0019\u0001\u0017\u0002\u000f5,7o]1hK\u0006q1\r[3dWJ+'O\u001d)iCN,WCAA\f\u000319W\r^%oSR\u0004\u0006.Y:f\u0003M\u0011X-\\8uK\u0006#GM]3tgN#(/\u001b8h+\t\ty\u0005\u0005\u0003\u0002R\u0005ec\u0002BA*\u0003+\u0002\"\u0001\u0017(\n\u0007\u0005]c*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\niF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/r\u0015A\u00028p\u0013:LG\u000f\u0006\u0003\u0002\b\u0005\r\u0004BBA\"%\u0001\u0007Q0\u0001\noK\u001e|G/[1uS>t7+^2dKN\u001cH\u0003BA\u0004\u0003SBa!a\u001b\u0014\u0001\u00049\u0013aB:fgNLwN\\\u0001\u0013]\u0016<w\u000e^5bi&|gNR1jYV\u0014X\r\u0006\u0004\u0002\b\u0005E\u00141\u0010\u0005\b\u0003g\"\u0002\u0019AA;\u0003\r!\u0018m\u001a\t\u0004\u001b\u0006]\u0014bAA=\u001d\n\u0019\u0011J\u001c;\t\u000f\u0005uD\u00031\u0001\u0002\u0000\u0005\tA\u000f\u0005\u0003\u0002\u0002\u0006-e\u0002BAB\u0003\u000fs1\u0001WAC\u0013\u0005y\u0015bAAE\u001d\u00069\u0001/Y2lC\u001e,\u0017\u0002BAG\u0003\u001f\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005%e*A\nNkb\u001cVM\u001d<fe:+wm\u001c;jCR|'\u000f\u0005\u0002=-M\u0019a#a&\u0011\u00075\u000bI*C\u0002\u0002\u001c:\u0013a!\u00118z%\u00164GCAAJ\u0003\rawnZ\u000b\u0003\u0003G\u0003B!!*\u0002,6\u0011\u0011q\u0015\u0006\u0004\u0003S\u0013\u0013a\u00027pO\u001eLgnZ\u0005\u0005\u0003[\u000b9K\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0003ck&dG\r\u0006\b\u0002\b\u0005U\u0016\u0011XA^\u0003{\u000by,!1\t\r\u0005]&\u00041\u00018\u0003\r\u0011XM\u001a\u0005\u0006ui\u0001\ra\u000f\u0005\u0006\u007fi\u0001\r\u0001\u0011\u0005\u0006\u0017j\u0001\r\u0001\u0014\u0005\u0006Ij\u0001\r!\u001a\u0005\u0006Wj\u0001\r\u0001\u001c")
public class MuxServerNegotiator
extends PushSession<ByteReader, Buf> {
    private final RefPushSession<ByteReader, Buf> refSession;
    private final MuxChannelHandle handle;
    private final Service<Request, Response> service;
    private final Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> makeLocalHeaders;
    private final Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> negotiate;
    private final Timer timer;
    private final Promise<PushSession<ByteReader, Buf>> sessionP;
    private Function1<Message, BoxedUnit> handshakePhase;

    public static void build(RefPushSession<ByteReader, Buf> refPushSession, MuxChannelHandle muxChannelHandle, Service<Request, Response> service, Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> function1, Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> function2, Timer timer) {
        MuxServerNegotiator$.MODULE$.build(refPushSession, muxChannelHandle, service, function1, function2, timer);
    }

    public Future<BoxedUnit> onClose() {
        return this.handle.onClose();
    }

    public Future<BoxedUnit> close(Time deadline) {
        return this.sessionP.by(deadline, this.timer).transform((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Return) {
                Return return_ = (Return)try_;
                PushSession session = (PushSession)return_.r();
                future = session.close(deadline);
            } else if (try_ instanceof Throw) {
                future = Closable$.MODULE$.all((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Closable[]{$this.handle, $this.service})).close();
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        });
    }

    public Status status() {
        return this.handle.status();
    }

    public void receive(ByteReader message) {
        try {
            try {
                Message msg = Message$.MODULE$.decode(message);
                this.handshakePhase.apply((Object)msg);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    this.close();
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            message.close();
        }
    }

    private Function1<Message, BoxedUnit> checkRerrPhase() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            MuxServerNegotiator.$anonfun$checkRerrPhase$1(this, x0$1);
            return BoxedUnit.UNIT;
        };
    }

    private Function1<Message, BoxedUnit> getInitPhase() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            MuxServerNegotiator.$anonfun$getInitPhase$1(this, x0$1);
            return BoxedUnit.UNIT;
        };
    }

    private String remoteAddressString() {
        return new StringBuilder(8).append("remote: ").append(this.handle.remoteAddress()).toString();
    }

    private void noInit(Message message) {
        try {
            PushSession session = (PushSession)this.negotiate.apply(this.service, (Object)None$.MODULE$);
            this.negotiationSuccess((PushSession<ByteReader, Buf>)session);
            session.receive((Object)ByteReader$.MODULE$.apply(Message$.MODULE$.encode(message)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.negotiationFailure(message.tag(), t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void negotiationSuccess(PushSession<ByteReader, Buf> session) {
        this.refSession.updateRef(session);
        this.sessionP.setValue(session);
        this.handshakePhase = (Function1 & Serializable & scala.Serializable)m -> {
            MuxServerNegotiator.$anonfun$negotiationSuccess$1(this, m);
            return BoxedUnit.UNIT;
        };
    }

    private void negotiationFailure(int tag, Throwable t) {
        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().warning(t, new StringBuilder(37).append("Negotiation failed. Closing session. ").append(this.remoteAddressString()).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.handshakePhase = (Function1 & Serializable & scala.Serializable)msg -> {
            MuxServerNegotiator.$anonfun$negotiationFailure$1(this, t, msg);
            return BoxedUnit.UNIT;
        };
        this.handle.send(Message$.MODULE$.encode(new Message.Rerr(tag, t.getMessage())), (Function1 & Serializable & scala.Serializable)x$1 -> {
            MuxServerNegotiator.$anonfun$negotiationFailure$2(this, t, x$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$checkRerrPhase$1(MuxServerNegotiator $this, Message x0$1) {
        Message message = x0$1;
        if (message instanceof Message.Rerr) {
            Message.Rerr rerr = (Message.Rerr)message;
            int n = rerr.tag();
            String string = rerr.error();
            if (Handshake$.MODULE$.TinitTag() == n) {
                String string2 = Handshake$.MODULE$.CanTinitMsg();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().debug(new StringBuilder(32).append("Received Rerr prelude to Tinit. ").append($this.remoteAddressString()).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    $this.handshakePhase = $this.getInitPhase();
                    $this.handle.sendAndForget(Message$.MODULE$.encode(new Message.Rerr(Handshake$.MODULE$.TinitTag(), Handshake$.MODULE$.CanTinitMsg())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().debug(new StringBuilder(59).append("Rerr prelude not detected (received ").append(message.getClass().getSimpleName()).append(". ").append("Skipping Init phase. ").append($this.remoteAddressString()).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        $this.noInit(message);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$getInitPhase$1(MuxServerNegotiator $this, Message x0$1) {
        boolean bl = false;
        Message.Tinit tinit = null;
        Message message = x0$1;
        if (message instanceof Message.Tinit) {
            bl = true;
            tinit = (Message.Tinit)message;
            int tag = tinit.tag();
            short s = tinit.version();
            Seq<Tuple2<Buf, Buf>> headers = tinit.headers();
            if (Mux$.MODULE$.LatestVersion() == s) {
                BoxedUnit boxedUnit;
                try {
                    Seq localHeaders = (Seq)$this.makeLocalHeaders.apply(headers);
                    if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.TRACE$.MODULE$)) {
                        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().trace(new StringBuilder(56).append("Server received client headers ").append(headers).append("; Server sending headers ").append(localHeaders).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    $this.handle.sendNowAndForget(Message$.MODULE$.encode(new Message.Rinit(tag, Mux$.MODULE$.LatestVersion(), (Seq<Tuple2<Buf, Buf>>)localHeaders)));
                    if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.TRACE$.MODULE$)) {
                        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().trace(new StringBuilder(16).append("Server has sent ").append(localHeaders).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    PushSession session = (PushSession)$this.negotiate.apply($this.service, (Object)new Some(headers));
                    $this.negotiationSuccess((PushSession<ByteReader, Buf>)session);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option.get();
                    $this.negotiationFailure(tag, t);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
                return;
            }
        }
        if (bl) {
            int tag = tinit.tag();
            short v = tinit.version();
            IllegalStateException ex = new IllegalStateException(new StringBuilder(25).append("Unsupported Mux version: ").append(v).toString());
            $this.negotiationFailure(tag, ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().warning(new StringBuilder(77).append("Received Rerr init probe but didn't receive a follow up ").append("Tinit (received a ").append(message.getClass().getSimpleName()).append("). ").append($this.remoteAddressString()).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            $this.noInit(message);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$negotiationSuccess$1(MuxServerNegotiator $this, Message m) {
        String msg = new StringBuilder(81).append("After negotiation success, more messages were sent to the ").append("negotiating session: ").append(m.getClass().getSimpleName()).append(". ").append($this.remoteAddressString()).toString();
        IllegalStateException ex = new IllegalStateException(msg);
        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().error((Throwable)ex, msg, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.handle.close();
    }

    public static final /* synthetic */ void $anonfun$negotiationFailure$1(MuxServerNegotiator $this, Throwable t$1, Message msg) {
        block0: {
            if (!MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) break block0;
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$pushsession$MuxServerNegotiator$$log().debug(t$1, new StringBuilder(71).append("Session negotiation failed. Swallowing message ").append("(").append(msg.getClass().getSimpleName()).append(") that raced shutdown. ").append($this.remoteAddressString()).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }

    public static final /* synthetic */ void $anonfun$negotiationFailure$2(MuxServerNegotiator $this, Throwable t$1, Try x$1) {
        $this.close().ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.sessionP.setException(t$1));
    }

    public MuxServerNegotiator(RefPushSession<ByteReader, Buf> refSession, MuxChannelHandle handle, Service<Request, Response> service, Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> makeLocalHeaders, Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> negotiate, Timer timer) {
        this.refSession = refSession;
        this.handle = handle;
        this.service = service;
        this.makeLocalHeaders = makeLocalHeaders;
        this.negotiate = negotiate;
        this.timer = timer;
        super((PushChannelHandle)handle);
        this.sessionP = Promise$.MODULE$.apply();
        this.handshakePhase = this.checkRerrPhase();
        handle.onClose().ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ($this.sessionP.isDefined()) break block0;
                this.close();
            }
        });
    }
}

