/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.util;

import com.twitter.finagle.mux.util.TagMap$;
import io.netty.util.collection.IntObjectHashMap;
import java.util.BitSet;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001C\u0011#!\u0003\r\n\u0001\n\u0017\t\u000bQ\u0002a\u0011\u0001\u001c\t\u000bi\u0002a\u0011A\u001e\t\u000b1\u0003a\u0011A'\t\u000bM\u0003a\u0011\u0001+\t\u000bY\u0003a\u0011A,\b\r\u0011\u0014\u0003\u0012\u0001\u0013f\r\u0019\t#\u0005#\u0001%O\")\u0001n\u0002C\u0001S\")!n\u0002C\u0001W\u001a1Ap\u0002Q\u0001\nuD!\"!\u0002\u000b\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011!Y(B!A!\u0002\u00139\u0004B\u00025\u000b\t\u0003\t\u0019\u0005C\u00035\u0015\u0011\u0005a\u0007\u0003\u0005\u0002L)\u0001\u000b\u0011BA'\u0011\u0019Q$\u0002\"\u0001\u0002b!1AJ\u0003C\u0001\u0003KBaa\u0015\u0006\u0005\u0002\u00055\u0004bBA9\u0015\u0011\u0005\u00111\u000f\u0005\u0007-*!\t!a\u001e\t\u0011\u0005m$\u0002)C\u0005\u0003{Bq!a\"\u000b\t\u0003\nIIB\u0004\u0002\f\u001d\u0011!%!\u0004\t\u0013E<\"Q1A\u0005\u0002\u0005=\u0001\"CA\t/\t\u0005\t\u0015!\u0003s\u0011\u0019Aw\u0003\"\u0001\u0002\u0014!9\u0011qC\f!\u0002\u00139\u0004\u0002CA\r/\u0001\u0006I!a\u0007\t\u000f\u0005%r\u0003\"\u0001\u0002,!9\u0011QF\f\u0005\u0002\u0005=\u0002bBA\u001c/\u0011\u0005\u0011\u0011\b\u0005\b\u0003{9B\u0011AA \u0005\u0019!\u0016mZ'ba*\u00111\u0005J\u0001\u0005kRLGN\u0003\u0002&M\u0005\u0019Q.\u001e=\u000b\u0005\u001dB\u0013a\u00024j]\u0006<G.\u001a\u0006\u0003S)\nq\u0001^<jiR,'OC\u0001,\u0003\r\u0019w.\\\u000b\u0003[\r\u001b\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0011\u0019\u0018N_3\u0004\u0001U\tq\u0007\u0005\u00020q%\u0011\u0011\b\r\u0002\u0004\u0013:$\u0018aA7baR\u0011Ah\u0010\t\u0004_u:\u0014B\u0001 1\u0005\u0019y\u0005\u000f^5p]\")\u0001I\u0001a\u0001\u0003\u0006\u0011Q\r\u001c\t\u0003\u0005\u000ec\u0001\u0001B\u0003E\u0001\t\u0007QIA\u0001U#\t1\u0015\n\u0005\u00020\u000f&\u0011\u0001\n\r\u0002\b\u001d>$\b.\u001b8h!\ty#*\u0003\u0002La\t\u0019\u0011I\\=\u0002\u00155\f\u0017PY3SK6\f\u0007\u000fF\u0002O\u001fF\u00032aL\u001fB\u0011\u0015\u00016\u00011\u00018\u0003\r!\u0018m\u001a\u0005\u0006%\u000e\u0001\r!Q\u0001\u0006]\u0016<X\t\\\u0001\u0006k:l\u0017\r\u001d\u000b\u0003\u001dVCQ\u0001\u0015\u0003A\u0002]\n\u0001\"\u001e8nCB\fE\u000e\u001c\u000b\u00021B\u0019\u0011,Y!\u000f\u0005i{fBA._\u001b\u0005a&BA/6\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u0002aa\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005\r\u0019V-\u001d\u0006\u0003AB\na\u0001V1h\u001b\u0006\u0004\bC\u00014\b\u001b\u0005\u00113CA\u0004/\u0003\u0019a\u0014N\\5u}Q\tQ-A\u0003baBd\u00170\u0006\u0002m_R\u0019Q\u000e\u001d>\u0011\u0007\u0019\u0004a\u000e\u0005\u0002C_\u0012)A)\u0003b\u0001\u000b\")\u0011/\u0003a\u0001e\u0006)!/\u00198hKB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\nS6lW\u000f^1cY\u0016T!a\u001e\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002zi\n)!+\u00198hK\")10\u0003a\u0001o\u0005Y\u0011N\\5uS\u0006d7+\u001b>f\u0005)!\u0016mZ'ba&k\u0007\u000f\\\u000b\u0004}\u0006\r1c\u0001\u0006/\u007fB!a\rAA\u0001!\r\u0011\u00151\u0001\u0003\u0006\t*\u0011\r!R\u0001\u0004g\u0016$\bcAA\u0005/5\tqA\u0001\u0004UC\u001e\u001cV\r^\n\u0003/9*\u0012A]\u0001\u0007e\u0006tw-\u001a\u0011\u0015\t\u0005\u001d\u0011Q\u0003\u0005\u0006cj\u0001\rA]\u0001\u0006gR\f'\u000f^\u0001\u0005E&$8\u000f\u0005\u0003\u0002\u001e\u0005\u0015RBAA\u0010\u0015\r\u0019\u0013\u0011\u0005\u0006\u0003\u0003G\tAA[1wC&!\u0011qEA\u0010\u0005\u0019\u0011\u0015\u000e^*fi\u00069\u0011mY9vSJ,G#\u0001\u001f\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005E\u0002cA\u0018\u00024%\u0019\u0011Q\u0007\u0019\u0003\tUs\u0017\u000e^\u0001\be\u0016dW-Y:f)\u0011\t\t$a\u000f\t\u000bA{\u0002\u0019A\u001c\u0002\u000bQ|7+Z9\u0016\u0005\u0005\u0005\u0003cA-boQ1\u0011QIA$\u0003\u0013\u0002R!!\u0003\u000b\u0003\u0003Aq!!\u0002\u000e\u0001\u0004\t9\u0001C\u0003|\u001b\u0001\u0007q'\u0001\u0004wC2,Xm\u001d\t\u0007\u0003\u001f\ni&!\u0001\u000e\u0005\u0005E#bA<\u0002T)\u00191%!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u00037\n!![8\n\t\u0005}\u0013\u0011\u000b\u0002\u0011\u0013:$xJ\u00196fGRD\u0015m\u001d5NCB$2\u0001PA2\u0011\u0019\u0001\u0005\u00031\u0001\u0002\u0002Q1\u0011qMA5\u0003W\u0002BaL\u001f\u0002\u0002!)\u0001+\u0005a\u0001o!1!+\u0005a\u0001\u0003\u0003!B!a\u001a\u0002p!)\u0001K\u0005a\u0001o\u0005\u0019q-\u001a;\u0015\t\u0005\u001d\u0014Q\u000f\u0005\u0006!N\u0001\ra\u000e\u000b\u0003\u0003s\u0002B!W1\u0002\u0002\u00059\u0011N\u001c*b]\u001e,G\u0003BA@\u0003\u000b\u00032aLAA\u0013\r\t\u0019\t\r\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001V\u00031\u00018\u0003!!xn\u0015;sS:<GCAAF!\u0011\ti)!&\u000f\t\u0005=\u0015\u0011\u0013\t\u00037BJ1!a%1\u0003\u0019\u0001&/\u001a3fM&!\u0011qSAM\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0013\u0019")
public interface TagMap<T> {
    public static <T> TagMap<T> apply(Range range, int n) {
        return TagMap$.MODULE$.apply(range, n);
    }

    public int size();

    public Option<Object> map(T var1);

    public Option<T> maybeRemap(int var1, T var2);

    public Option<T> unmap(int var1);

    public Seq<T> unmapAll();

    public static class TagMapImpl<T>
    implements TagMap<T> {
        private final TagSet set;
        private final IntObjectHashMap<T> values;

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Option<Object> map(T el) {
            None$ none$;
            Option<Object> option = this.set.acquire();
            if (option instanceof Some) {
                Some some = (Some)option;
                int tag = BoxesRunTime.unboxToInt((Object)some.value());
                this.values.put(tag, el);
                none$ = some;
            } else if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            return none$;
        }

        @Override
        public Option<T> maybeRemap(int tag, T newEl) {
            None$ none$;
            if (!this.inRange(tag)) {
                none$ = None$.MODULE$;
            } else {
                Object oldEl = this.values.put(tag, newEl);
                none$ = Option$.MODULE$.apply(oldEl);
            }
            return none$;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Option<T> unmap(int tag) {
            None$ none$;
            if (!this.inRange(tag)) {
                none$ = None$.MODULE$;
            } else {
                void var3_3;
                Object oldEl = this.values.remove(tag);
                Option res = Option$.MODULE$.apply(oldEl);
                this.set.release(tag);
                none$ = var3_3;
            }
            return none$;
        }

        public Option<T> get(int tag) {
            return !this.inRange(tag) ? None$.MODULE$ : Option$.MODULE$.apply(this.values.get(tag));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Seq<T> unmapAll() {
            void var1_1;
            List results = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.values.values()).asScala()).toList();
            this.set.clear();
            this.values.clear();
            return var1_1;
        }

        private boolean inRange(int tag) {
            return tag >= this.set.range().start() && tag <= this.set.range().end();
        }

        public String toString() {
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.values.keySet()).asScala()).mkString("TagMap[", ", ", "]");
        }

        public TagMapImpl(TagSet set, int initialSize) {
            this.set = set;
            Predef$.MODULE$.require(initialSize >= 0);
            Predef$.MODULE$.require(set.range().start() >= 0);
            this.values = new IntObjectHashMap(initialSize);
        }
    }

    public static final class TagSet {
        private final Range range;
        private final int start;
        private final BitSet bits;

        public Range range() {
            return this.range;
        }

        public Option<Object> acquire() {
            None$ none$;
            int tag = this.bits.nextClearBit(this.start);
            if (!this.range().contains(tag)) {
                none$ = None$.MODULE$;
            } else {
                this.bits.set(tag);
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)tag));
            }
            return none$;
        }

        public void clear() {
            this.bits.clear();
        }

        public void release(int tag) {
            this.bits.clear(tag);
        }

        public Seq<Object> toSeq() {
            return this.build$1(0, new ListBuffer());
        }

        private final Seq build$1(int i, ListBuffer buffer) {
            int next;
            while ((next = this.bits.nextSetBit(i)) != -1) {
                buffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)next));
                i = next + 1;
            }
            return buffer.result();
        }

        public TagSet(Range range) {
            this.range = range;
            Predef$.MODULE$.require(range.step() == 1);
            this.start = range.start();
            this.bits = new BitSet();
        }
    }
}

