/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.lease.exp;

import com.twitter.finagle.mux.lease.exp.ByteCounter;
import com.twitter.finagle.mux.lease.exp.JvmInfo;
import com.twitter.finagle.mux.lease.exp.WindowedByteCounter$;
import com.twitter.util.Closable;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Local;
import com.twitter.util.Local$;
import com.twitter.util.StorageUnit;
import com.twitter.util.StorageUnit$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055d!B\u0010!\u0001\tb\u0003\u0002C \u0001\u0005\u000b\u0007I\u0011A!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\tC\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0007/\u0002!\tA\t-\t\u000b]\u0003A\u0011\u0001/\t\ry\u0003\u0001\u0015!\u0003`\u0011\u0019A\u0007\u0001)C\u0005S\"1!\u000e\u0001Q!\n-DaA\u001d\u0001!B\u0013\u0019\bbB<\u0001\u0001\u0004%\t\u0001\u001f\u0005\by\u0002\u0001\r\u0011\"\u0001~\u0011\u001d\t9\u0001\u0001Q!\neD\u0001\"a\u0003\u0001A\u0003&\u0011Q\u0002\u0005\u000b\u0003+\u0001\u0001\u0019!C\u0001E\u0005]\u0001BCA\r\u0001\u0001\u0007I\u0011\u0001\u0012\u0002\u001c!9\u0011q\u0004\u0001!B\u0013\u0019\bbBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\t\u0003[\u0001\u0001\u0015\"\u0003\u0002&!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003{\u0001A\u0011AA \u000f!\tY\u0005\tE\u0001E\u00055caB\u0010!\u0011\u0003\u0011\u0013q\n\u0005\u0007/^!\t!a\u0016\t\u0015\u0005esC1A\u0005\u0002\t\nY\u0006\u0003\u0005\u0002d]\u0001\u000b\u0011BA/\u0011)\t)g\u0006b\u0001\n\u0003\u0011\u00131\f\u0005\t\u0003O:\u0002\u0015!\u0003\u0002^!Q\u0011\u0011N\fC\u0002\u0013\u0005!%a\u0006\t\u000f\u0005-t\u0003)A\u0005g\n\u0019r+\u001b8e_^,GMQ=uK\u000e{WO\u001c;fe*\u0011\u0011EI\u0001\u0004Kb\u0004(BA\u0012%\u0003\u0015aW-Y:f\u0015\t)c%A\u0002nkbT!a\n\u0015\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011FK\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0013aA2p[N!\u0001!L\u001b:!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003mC:<'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012a\u0001\u00165sK\u0006$\u0007C\u0001\u001c8\u001b\u0005\u0001\u0013B\u0001\u001d!\u0005-\u0011\u0015\u0010^3D_VtG/\u001a:\u0011\u0005ijT\"A\u001e\u000b\u0005qB\u0013\u0001B;uS2L!AP\u001e\u0003\u0011\rcwn]1cY\u0016\fA!\u001b8g_\u000e\u0001Q#\u0001\"\u0011\u0005Y\u001a\u0015B\u0001#!\u0005\u001dQe/\\%oM>\fQ!\u001b8g_\u0002\n1a\u0019;y!\tAEK\u0004\u0002J%:\u0011!*\u0015\b\u0003\u0017Bs!\u0001T(\u000e\u00035S!A\u0014!\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0013BA\u0015+\u0013\ta\u0004&\u0003\u0002Tw\u0005)Aj\\2bY&\u0011QK\u0016\u0002\b\u0007>tG/\u001a=u\u0015\t\u00196(\u0001\u0004=S:LGO\u0010\u000b\u00043j[\u0006C\u0001\u001c\u0001\u0011\u0015yD\u00011\u0001C\u0011\u00151E\u00011\u0001H)\tIV\fC\u0003@\u000b\u0001\u0007!)\u0001\u0004bY2|7m\u001d\t\u0004A\u000e,W\"A1\u000b\u0003\t\fQa]2bY\u0006L!\u0001Z1\u0003\u000b\u0005\u0013(/Y=\u0011\u0005i2\u0017BA4<\u0005-\u0019Fo\u001c:bO\u0016,f.\u001b;\u0002\u0007M,X\u000eF\u0001f\u0003\u0015\u0019w.\u001e8u!\t\u0001G.\u0003\u0002nC\n!Aj\u001c8hQ\tAq\u000e\u0005\u0002aa&\u0011\u0011/\u0019\u0002\tm>d\u0017\r^5mK\u0006\u0019\u0011\u000e\u001a=\u0011\u0005\u0001$\u0018BA;b\u0005\rIe\u000e\u001e\u0015\u0003\u0013=\fa\u0001\\1ti\u001e\u001bW#A=\u0011\u0005iR\u0018BA><\u0005\u0011!\u0016.\\3\u0002\u00151\f7\u000f^$d?\u0012*\u0017\u000fF\u0002\u007f\u0003\u0007\u0001\"\u0001Y@\n\u0007\u0005\u0005\u0011M\u0001\u0003V]&$\b\u0002CA\u0003\u0017\u0005\u0005\t\u0019A=\u0002\u0007a$\u0013'A\u0004mCN$xi\u0019\u0011)\u00051y\u0017a\u0002:v]:Lgn\u001a\t\u0004A\u0006=\u0011bAA\tC\n9!i\\8mK\u0006t\u0007FA\u0007p\u0003%\u0001\u0018m]:D_VtG/F\u0001t\u00035\u0001\u0018m]:D_VtGo\u0018\u0013fcR\u0019a0!\b\t\u0011\u0005\u0015q\"!AA\u0002M\f!\u0002]1tg\u000e{WO\u001c;!Q\t\u0001r.\u0001\u0003sCR,GCAA\u0014!\r\u0001\u0017\u0011F\u0005\u0004\u0003W\t'A\u0002#pk\ndW-\u0001\u0005mCN$(+\u0019;f\u0003!!xn\u0015;sS:<GCAA\u001a!\rq\u0013QG\u0005\u0004\u0003oy#AB*ue&tw-A\u0002sk:$\u0012A`\u0001\u0006G2|7/\u001a\u000b\u0005\u0003\u0003\n9\u0005\u0005\u0003;\u0003\u0007r\u0018bAA#w\t1a)\u001e;ve\u0016Da!!\u0013\u0016\u0001\u0004I\u0018\u0001\u00033fC\u0012d\u0017N\\3\u0002']Kg\u000eZ8xK\u0012\u0014\u0015\u0010^3D_VtG/\u001a:\u0011\u0005Y:2cA\f\u0002RA\u0019\u0001-a\u0015\n\u0007\u0005U\u0013M\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u001b\n\u0011aV\u000b\u0003\u0003;\u00022AOA0\u0013\r\t\tg\u000f\u0002\t\tV\u0014\u0018\r^5p]\u0006\u0011q\u000bI\u0001\u0002!\u0006\u0011\u0001\u000bI\u0001\u0002\u001d\u0006\u0011a\n\t")
public class WindowedByteCounter
extends Thread
implements ByteCounter,
Closable {
    private final JvmInfo info;
    private final Local.Context ctx;
    private final StorageUnit[] allocs;
    private volatile long count;
    private volatile int idx;
    private volatile Time lastGc;
    private volatile boolean running;
    private volatile int passCount;

    public final Future<BoxedUnit> close() {
        return Closable.close$((Closable)this);
    }

    public Future<BoxedUnit> close(Duration after) {
        return Closable.close$((Closable)this, (Duration)after);
    }

    @Override
    public JvmInfo info() {
        return this.info;
    }

    private StorageUnit sum() {
        int n = this.idx;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        return (StorageUnit)Predef$.MODULE$.wrapRefArray((Object[])this.allocs).reduce((Function2 & Serializable)(x$2, x$3) -> x$2.$plus(x$3));
    }

    @Override
    public Time lastGc() {
        return this.lastGc;
    }

    public void lastGc_$eq(Time x$1) {
        this.lastGc = x$1;
    }

    public int passCount() {
        return this.passCount;
    }

    public void passCount_$eq(int x$1) {
        this.passCount = x$1;
    }

    @Override
    public double rate() {
        return this.sum().inBytes() / WindowedByteCounter$.MODULE$.W().inMilliseconds();
    }

    private double lastRate() {
        return this.allocs[this.idx].inBytes() / WindowedByteCounter$.MODULE$.P().inMilliseconds();
    }

    @Override
    public String toString() {
        return new StringBuilder(64).append("WindowedByteCounter(windowed=").append(this.rate()).append("bpms; last=").append(this.lastRate()).append("bpms; count=").append(this.count).append("; sum=").append(this.sum()).append("bytes)").toString();
    }

    @Override
    public void run() {
        Local$.MODULE$.restore(this.ctx);
        StorageUnit prevUsed = this.info().used();
        while (this.running) {
            Time$.MODULE$.sleep(WindowedByteCounter$.MODULE$.P());
            StorageUnit curUsed = this.info().used();
            long curCount = this.info().generation();
            StorageUnit newlyUsed = curUsed.$minus(prevUsed);
            if (curCount == this.count && newlyUsed.$greater((Object)StorageUnit$.MODULE$.zero())) {
                int nextIdx = (this.idx + 1) % WindowedByteCounter$.MODULE$.N();
                this.allocs[this.idx] = newlyUsed;
                this.idx = nextIdx;
            } else if (curCount == this.count) {
                this.lastGc_$eq(Time$.MODULE$.now());
                this.count = this.info().generation();
            } else {
                this.lastGc_$eq(Time$.MODULE$.now());
                this.count = curCount;
            }
            prevUsed = curUsed;
            this.passCount_$eq(this.passCount() + 1);
        }
    }

    public Future<BoxedUnit> close(Time deadline) {
        this.running = false;
        return Future$.MODULE$.Done();
    }

    public WindowedByteCounter(JvmInfo info, Local.Context ctx) {
        this.info = info;
        this.ctx = ctx;
        super("WindowedByteClock");
        Closable.$init$((Closable)this);
        this.allocs = (StorageUnit[])Array$.MODULE$.fill(WindowedByteCounter$.MODULE$.N(), (Function0 & Serializable)() -> StorageUnit$.MODULE$.zero(), ClassTag$.MODULE$.apply(StorageUnit.class));
        this.count = info.generation();
        this.idx = 0;
        this.lastGc = Time$.MODULE$.now();
        this.running = true;
        this.passCount = 0;
        this.setDaemon(true);
    }

    public WindowedByteCounter(JvmInfo info) {
        this(info, Local.Context$.MODULE$.empty());
    }
}

