/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.pushsession;

import com.twitter.finagle.Mux;
import com.twitter.finagle.Mux$param$CompressionPreferences$;
import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.liveness.FailureDetector;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.pushsession.FragmentDecoder;
import com.twitter.finagle.mux.pushsession.FragmentingMessageWriter;
import com.twitter.finagle.mux.pushsession.MessageWriter;
import com.twitter.finagle.mux.pushsession.MuxClientSession;
import com.twitter.finagle.mux.pushsession.MuxMessageDecoder;
import com.twitter.finagle.mux.pushsession.MuxServerSession;
import com.twitter.finagle.mux.pushsession.NegotiatingHandle;
import com.twitter.finagle.mux.pushsession.SharedNegotiationStats;
import com.twitter.finagle.mux.transport.Compression;
import com.twitter.finagle.mux.transport.Compression$;
import com.twitter.finagle.mux.transport.CompressionNegotiation;
import com.twitter.finagle.mux.transport.CompressionNegotiation$;
import com.twitter.finagle.mux.transport.CompressionNegotiation$ClientHeader$;
import com.twitter.finagle.mux.transport.CompressionNegotiation$ServerHeader$;
import com.twitter.finagle.mux.transport.IncompatibleNegotiationException;
import com.twitter.finagle.mux.transport.MuxFramer$Header$;
import com.twitter.finagle.mux.transport.OpportunisticTls$;
import com.twitter.finagle.mux.transport.OpportunisticTls$Header$;
import com.twitter.finagle.param.Label;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.param.OppTls;
import com.twitter.finagle.param.OppTls$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.pushsession.PushChannelHandle;
import com.twitter.finagle.pushsession.PushSession;
import com.twitter.finagle.ssl.OpportunisticTls;
import com.twitter.finagle.ssl.OpportunisticTls$Off$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Return;
import com.twitter.util.Return$;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.io.Serializable;
import java.util.logging.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tmaAB\u0012%\u0003\u0003Ac\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00038\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b!\u0003A\u0011A%\u0005\u000b9\u0003!\u0011A(\t\r\u0005\u0004\u0001\u0015!\u0003c\u0011\u0019A\u0007\u0001)A\u0005S\")A\u000f\u0001D\tk\"9\u0011Q\u0005\u0001\u0007\u0012\u0005\u001d\u0002bBA\"\u0001\u0011U\u0011Q\t\u0005\t\u0003'\u0002\u0001\u0015\"\u0003\u0002V!A\u00111\u000f\u0001!\n\u0013\t)\b\u0003\u0005\u0002\u0012\u0002\u0001K\u0011BAJ\u0011!\tY\n\u0001Q\u0005\n\u0005u\u0005bBAR\u0001\u0011\u0015\u0011Q\u0015\u0005\b\u0003W\u0003AQAAW\u000f!\tI\f\nE\u0001Q\u0005mfaB\u0012%\u0011\u0003A\u0013Q\u0018\u0005\u0007\u0011J!\t!a0\u0007\r\u0005\u0005'CAAb\u0011!)DC!A!\u0002\u00139\u0004\u0002C \u0015\u0005\u0003\u0005\u000b\u0011\u0002!\t\r!#B\u0011AAc\u000b\u0015qE\u0003IAh\u0011\u0019!H\u0003\"\u0005\u0002V\"9\u0011Q\u0005\u000b\u0005\u0012\u0005mgABAr%\t\t)\u000f\u0003\u000567\t\u0005\t\u0015!\u00038\u0011!y4D!A!\u0002\u0013\u0001\u0005BCAt7\t\u0005\t\u0015!\u0003\u0002j\"1\u0001j\u0007C\u0001\u0003{,QAT\u000e!\u0005\u000fAa\u0001^\u000e\u0005\u0012\t5\u0001bBA\u00137\u0011E!1\u0003\u0002\f\u001d\u0016<w\u000e^5bi&|gN\u0003\u0002&M\u0005Y\u0001/^:ig\u0016\u001c8/[8o\u0015\t9\u0003&A\u0002nkbT!!\u000b\u0016\u0002\u000f\u0019Lg.Y4mK*\u00111\u0006L\u0001\bi^LG\u000f^3s\u0015\u0005i\u0013aA2p[N\u0011\u0001a\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0002\rA\f'/Y7t\u0007\u0001\u0001\"\u0001\u000f\u001f\u000f\u0005eRT\"\u0001\u0015\n\u0005mB\u0013!B*uC\u000e\\\u0017BA\u001f?\u0005\u0019\u0001\u0016M]1ng*\u00111\bK\u0001\fg\"\f'/\u001a3Ti\u0006$8\u000f\u0005\u0002B\u00056\tA%\u0003\u0002DI\t12\u000b[1sK\u0012tUmZ8uS\u0006$\u0018n\u001c8Ti\u0006$8/\u0001\u0005jgN+'O^3s!\t\u0001d)\u0003\u0002Hc\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005CA!\u0001\u0011\u0015)D\u00011\u00018\u0011\u0015yD\u00011\u0001A\u0011\u0015!E\u00011\u0001F\u0005!\u0019Vm]:j_:$\u0016C\u0001)T!\t\u0001\u0014+\u0003\u0002Sc\t9aj\u001c;iS:<\u0007\u0003\u0002+W1zk\u0011!\u0016\u0006\u0003K!J!aV+\u0003\u0017A+8\u000f[*fgNLwN\u001c\t\u00033rk\u0011A\u0017\u0006\u00037*\n!![8\n\u0005uS&A\u0003\"zi\u0016\u0014V-\u00193feB\u0011\u0011lX\u0005\u0003Aj\u00131AQ;g\u0003\rawn\u001a\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K*\nq\u0001\\8hO&tw-\u0003\u0002hI\n1Aj\\4hKJ\fa!\\=OC6,\u0007C\u00016r\u001d\tYw\u000e\u0005\u0002mc5\tQN\u0003\u0002om\u00051AH]8pizJ!\u0001]\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003aF\nAC\\3h_RL\u0017\r^3D_6\u0004(/Z:tS>tGc\u0001<z}B\u0011\u0001g^\u0005\u0003qF\u0012A!\u00168ji\")!\u0010\u0003a\u0001w\u00061\u0001.\u00198eY\u0016\u0004B\u0001\u0016?Y=&\u0011Q0\u0016\u0002\u0012!V\u001c\bn\u00115b]:,G\u000eS1oI2,\u0007BB@\t\u0001\u0004\t\t!A\u0006qK\u0016\u0014\b*Z1eKJ\u001c\b#\u0002\u0019\u0002\u0004\u0005\u001d\u0011bAA\u0003c\t1q\n\u001d;j_:\u0004B!!\u0003\u0002 9!\u00111BA\u000e\u001d\u0011\ti!!\u0007\u000f\t\u0005=\u0011q\u0003\b\u0005\u0003#\t)BD\u0002m\u0003'I\u0011!L\u0005\u0003W1J!!\u000b\u0016\n\u0005\u001dB\u0013bAA\u000fM\u0005I\u0001*\u00198eg\"\f7.Z\u0005\u0005\u0003C\t\u0019CA\u0004IK\u0006$WM]:\u000b\u0007\u0005ua%A\u0004ck&dG-\u001a:\u0015\u0011\u0005%\u0012QFA\u0018\u0003s\u00012!a\u000b\u0006\u001b\u0005\u0001\u0001\"\u0002>\n\u0001\u0004Y\bbBA\u0019\u0013\u0001\u0007\u00111G\u0001\u0007oJLG/\u001a:\u0011\u0007\u0005\u000b)$C\u0002\u00028\u0011\u0012Q\"T3tg\u0006<Wm\u0016:ji\u0016\u0014\bbBA\u001e\u0013\u0001\u0007\u0011QH\u0001\bI\u0016\u001cw\u000eZ3s!\r\t\u0015qH\u0005\u0004\u0003\u0003\"#!E'vq6+7o]1hK\u0012+7m\u001c3fe\u0006\u0019\u0012m\u001d(fO>$\u0018.\u0019;j]\u001eD\u0015M\u001c3mKR1\u0011qIA'\u0003\u001f\u00022!QA%\u0013\r\tY\u0005\n\u0002\u0012\u001d\u0016<w\u000e^5bi&tw\rS1oI2,\u0007\"\u0002>\u000b\u0001\u0004Y\bBBA)\u0015\u0001\u0007\u0011.A\u0004gK\u0006$XO]3\u0002'I,Wn\u001c;f\u0003\u0012$'/Z:t'R\u0014\u0018N\\4\u0015\u0007%\f9\u0006\u0003\u0004{\u0017\u0001\u0007\u0011\u0011\f\u0019\u0007\u00037\n\t'a\u001c\u0011\rQc\u0018QLA7!\u0011\ty&!\u0019\r\u0001\u0011a\u00111MA,\u0003\u0003\u0005\tQ!\u0001\u0002f\t\u0019q\fJ\u0019\u0012\u0007A\u000b9\u0007E\u00021\u0003SJ1!a\u001b2\u0005\r\te.\u001f\t\u0005\u0003?\ny\u0007\u0002\u0007\u0002r\u0005]\u0013\u0011!A\u0001\u0006\u0003\t)GA\u0002`II\nqB\\3h_RL\u0017\r^3PaB$Fn\u001d\u000b\bm\u0006]\u0014\u0011PA>\u0011\u0015QH\u00021\u0001|\u0011\u0019yH\u00021\u0001\u0002\u0002!9\u0011Q\u0010\u0007A\u0002\u0005}\u0014AF8o)2\u001c\b*\u00198eg\"\f7.Z\"p[BdW\r^3\u0011\rA\n\t)!\"w\u0013\r\t\u0019)\r\u0002\n\rVt7\r^5p]F\u0002R!a\"\u0002\u000eZl!!!#\u000b\u0007\u0005-%&\u0001\u0003vi&d\u0017\u0002BAH\u0003\u0013\u00131\u0001\u0016:z\u0003eqWmZ8uS\u0006$Xm\u00149q)2\u001ch+[1IK\u0006$WM]:\u0015\u000fY\f)*a&\u0002\u001a\")!0\u0004a\u0001w\"1q0\u0004a\u0001\u0003\u0003Aq!! \u000e\u0001\u0004\ty(A\noK\u001e|G/[1uK6+\bpU3tg&|g\u000e\u0006\u0004\u0002*\u0005}\u0015\u0011\u0015\u0005\u0006u:\u0001\ra\u001f\u0005\u0007\u007f:\u0001\r!!\u0001\u0002\u00139,wm\u001c;jCR,GCBA\u0015\u0003O\u000bI\u000bC\u0003{\u001f\u0001\u00071\u0010\u0003\u0004\u0000\u001f\u0001\u0007\u0011\u0011A\u0001\u000f]\u0016<w\u000e^5bi\u0016\f5/\u001f8d)\u0019\ty+!.\u00028B1\u0011qQAY\u0003SIA!a-\u0002\n\n1a)\u001e;ve\u0016DQA\u001f\tA\u0002mDaa \tA\u0002\u0005\u0005\u0011a\u0003(fO>$\u0018.\u0019;j_:\u0004\"!\u0011\n\u0014\u0005IyCCAA^\u0005\u0019\u0019E.[3oiN\u0011AC\u0013\u000b\u0007\u0003\u000f\fY-!4\u0011\u0007\u0005%G#D\u0001\u0013\u0011\u0015)t\u00031\u00018\u0011\u0015yt\u00031\u0001A!\r\t\u0015\u0011[\u0005\u0004\u0003'$#\u0001E'vq\u000ec\u0017.\u001a8u'\u0016\u001c8/[8o)\u00151\u0018q[Am\u0011\u0015Q\u0018\u00041\u0001|\u0011\u0019y\u0018\u00041\u0001\u0002\u0002QA\u0011qZAo\u0003?\f\t\u000fC\u0003{5\u0001\u00071\u0010C\u0004\u00022i\u0001\r!a\r\t\u000f\u0005m\"\u00041\u0001\u0002>\t11+\u001a:wKJ\u001c\"a\u0007&\u0002\u000fM,'O^5dKB9\u0011(a;\u0002p\u0006]\u0018bAAwQ\t91+\u001a:wS\u000e,\u0007\u0003BAy\u0003gl\u0011AJ\u0005\u0004\u0003k4#a\u0002*fcV,7\u000f\u001e\t\u0005\u0003c\fI0C\u0002\u0002|\u001a\u0012\u0001BU3ta>t7/\u001a\u000b\t\u0003\u007f\u0014\tAa\u0001\u0003\u0006A\u0019\u0011\u0011Z\u000e\t\u000bUz\u0002\u0019A\u001c\t\u000b}z\u0002\u0019\u0001!\t\u000f\u0005\u001dx\u00041\u0001\u0002jB\u0019\u0011I!\u0003\n\u0007\t-AE\u0001\tNkb\u001cVM\u001d<feN+7o]5p]R)aOa\u0004\u0003\u0012!)!0\ta\u0001w\"1q0\ta\u0001\u0003\u0003!\u0002Ba\u0002\u0003\u0016\t]!\u0011\u0004\u0005\u0006u\n\u0002\ra\u001f\u0005\b\u0003c\u0011\u0003\u0019AA\u001a\u0011\u001d\tYD\ta\u0001\u0003{\u0001")
public abstract class Negotiation {
    private final Stack.Params params;
    private final SharedNegotiationStats sharedStats;
    private final Logger log;
    private final String myName;

    public abstract void negotiateCompression(PushChannelHandle<ByteReader, Buf> var1, Option<Seq<Tuple2<Buf, Buf>>> var2);

    public abstract PushSession builder(PushChannelHandle<ByteReader, Buf> var1, MessageWriter var2, MuxMessageDecoder var3);

    public final NegotiatingHandle asNegotiatingHandle(PushChannelHandle<ByteReader, Buf> handle, String feature) {
        PushChannelHandle<ByteReader, Buf> pushChannelHandle = handle;
        if (!(pushChannelHandle instanceof NegotiatingHandle)) {
            throw new IllegalStateException(new StringBuilder(51).append("Expected to find a MuxChannelHandle, instead found ").append(new StringBuilder(21).append(pushChannelHandle).append(". Couldn't turn on ").append(feature).append(". ").append(this.remoteAddressString(handle)).toString()).toString());
        }
        PushChannelHandle<ByteReader, Buf> pushChannelHandle2 = pushChannelHandle;
        NegotiatingHandle negotiatingHandle = (NegotiatingHandle)pushChannelHandle2;
        return negotiatingHandle;
    }

    private String remoteAddressString(PushChannelHandle<?, ?> handle) {
        return new StringBuilder(8).append("remote: ").append(handle.remoteAddress()).toString();
    }

    private void negotiateOppTls(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders, Function1<Try<BoxedUnit>, BoxedUnit> onTlsHandshakeComplete) {
        if (handle.sslSessionInfo().usingSsl()) {
            this.log.debug(new StringBuilder(58).append(this.myName).append(": Session already encrypted. Skipping OppTls header check.").toString(), (Seq)Nil$.MODULE$);
            onTlsHandshakeComplete.apply((Object)Try$.MODULE$.Unit());
        } else {
            this.negotiateOppTlsViaHeaders(handle, peerHeaders, onTlsHandshakeComplete);
        }
    }

    private void negotiateOppTlsViaHeaders(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders, Function1<Try<BoxedUnit>, BoxedUnit> onTlsHandshakeComplete) {
        OpportunisticTls.Level level;
        OpportunisticTls.Level localEncryptLevel = (OpportunisticTls.Level)((OppTls)this.params.apply(OppTls$.MODULE$.param())).level().getOrElse((Function0 & Serializable)() -> OpportunisticTls$Off$.MODULE$);
        Option option = peerHeaders.flatMap((Function1 & Serializable)x$1 -> Handshake$.MODULE$.valueOf(OpportunisticTls$Header$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)x$1));
        if (option instanceof Some) {
            Some some = (Some)option;
            Buf buf = (Buf)some.value();
            level = OpportunisticTls$Header$.MODULE$.decodeLevel(buf);
        } else if (None$.MODULE$.equals(option)) {
            this.log.debug(new StringBuilder(77).append(new StringBuilder(2).append(this.myName).append(": ").toString()).append("Peer either didn't negotiate or didn't send an Opportunistic Tls preference: ").append(new StringBuilder(46).append("defaulting to remote encryption level of Off. ").append(this.remoteAddressString(handle)).toString()).toString(), (Seq)Nil$.MODULE$);
            level = OpportunisticTls$Off$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        OpportunisticTls.Level remoteEncryptLevel = level;
        try {
            boolean useTls = OpportunisticTls$.MODULE$.negotiate(localEncryptLevel, remoteEncryptLevel);
            if (this.log.isLoggable((Level)Level.DEBUG$.MODULE$)) {
                this.log.debug(new StringBuilder(0).append(new StringBuilder(48).append(this.myName).append(": Successfully negotiated TLS with remote peer. ").toString()).append(new StringBuilder(25).append("Using TLS: ").append(useTls).append(" local level: ").toString()).append(new StringBuilder(18).append(localEncryptLevel).append(", remote level: ").append(remoteEncryptLevel).append(". ").append(this.remoteAddressString(handle)).toString()).toString(), (Seq)Nil$.MODULE$);
            }
            if (useTls) {
                this.sharedStats.tlsSuccess().incr();
                this.asNegotiatingHandle(handle, "TLS").turnOnTls(onTlsHandshakeComplete);
            } else {
                onTlsHandshakeComplete.apply((Object)Return$.MODULE$.Unit());
            }
        }
        catch (IncompatibleNegotiationException exn) {
            this.sharedStats.tlsFailures().incr();
            this.log.fatal((Throwable)exn, new StringBuilder(0).append(new StringBuilder(51).append(this.myName).append(": The local peer wanted ").append(localEncryptLevel).append(" and the remote peer wanted").toString()).append(new StringBuilder(26).append(" ").append(remoteEncryptLevel).append(" which are incompatible. ").append(this.remoteAddressString(handle)).toString()).toString(), (Seq)Nil$.MODULE$);
            throw exn;
        }
    }

    private PushSession negotiateMuxSession(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
        int fragmentSize = BoxesRunTime.unboxToInt((Object)peerHeaders.flatMap((Function1 & Serializable)x$2 -> Handshake$.MODULE$.valueOf(MuxFramer$Header$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)x$2)).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)MuxFramer$Header$.MODULE$.decodeFrameSize(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE));
        FragmentingMessageWriter writeManager = new FragmentingMessageWriter(handle, fragmentSize, this.sharedStats);
        FragmentDecoder messageDecoder = new FragmentDecoder(this.sharedStats);
        return this.builder(handle, writeManager, messageDecoder);
    }

    public final PushSession negotiate(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
        this.negotiateOppTls(handle, peerHeaders, (Function1<Try<BoxedUnit>, BoxedUnit>)(Function1 & Serializable)x$4 -> {
            Negotiation.$anonfun$negotiate$1(this, x$4);
            return BoxedUnit.UNIT;
        });
        this.negotiateCompression(handle, peerHeaders);
        return this.negotiateMuxSession(handle, peerHeaders);
    }

    public final Future<PushSession> negotiateAsync(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
        Future future;
        Promise p = Promise$.MODULE$.apply();
        Function1 & Serializable onHandshakeComplete = (Function1 & Serializable)x$5 -> {
            Negotiation.$anonfun$negotiateAsync$1(this, p, x$5);
            return BoxedUnit.UNIT;
        };
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.negotiateOppTls(handle, peerHeaders, (Function1<Try<BoxedUnit>, BoxedUnit>)onHandshakeComplete));
        if (try_ instanceof Return) {
            future = p.map((Function1 & Serializable)x$6 -> {
                this.negotiateCompression(handle, peerHeaders);
                return this.negotiateMuxSession(handle, peerHeaders);
            });
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable t = throw_.e();
            future = Future$.MODULE$.exception(t);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$negotiate$1(Negotiation $this, Try x$4) {
        Try try_ = x$4;
        if (!$this.log.isLoggable((Level)Level.TRACE$.MODULE$)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Return) {
            $this.log.trace(new StringBuilder(42).append($this.myName).append(": Successfully negotiated oppTls handshake").toString(), (Seq)Nil$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable t = throw_.e();
            $this.log.trace(t, new StringBuilder(25).append($this.myName).append(": OppTls handshake failed").toString(), (Seq)Nil$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$negotiateAsync$1(Negotiation $this, Promise p$1, Try x$5) {
        Try try_ = x$5;
        if (try_ instanceof Return) {
            if ($this.log.isLoggable((Level)Level.TRACE$.MODULE$)) {
                $this.log.trace(new StringBuilder(42).append($this.myName).append(": successfully negotiated oppTls handshake").toString(), (Seq)Nil$.MODULE$);
            }
            p$1.setDone((.less.colon.less)$less$colon$less$.MODULE$.refl());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable t = throw_.e();
            if ($this.log.isLoggable((Level)Level.TRACE$.MODULE$)) {
                $this.log.trace(t, new StringBuilder(43).append($this.myName).append(": side failed to negotiate oppTls handshake").toString(), (Seq)Nil$.MODULE$);
            }
            p$1.setException(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public Negotiation(Stack.Params params, SharedNegotiationStats sharedStats, boolean isServer) {
        this.params = params;
        this.sharedStats = sharedStats;
        this.log = Logger$.MODULE$.get();
        String label = ((Label)params.apply(Label$.MODULE$.param())).label();
        this.myName = isServer ? new StringBuilder(8).append("Server(").append(label).append(")").toString() : new StringBuilder(8).append("Client(").append(label).append(")").toString();
    }

    public static final class Client
    extends Negotiation {
        private final Stack.Params params;
        private final SharedNegotiationStats sharedStats;

        @Override
        public void negotiateCompression(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
            CompressionNegotiation.CompressionFormats compressionFormats = (CompressionNegotiation.CompressionFormats)peerHeaders.flatMap((Function1 & Serializable)x$7 -> Handshake$.MODULE$.valueOf(CompressionNegotiation$ServerHeader$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)x$7)).map((Function1 & Serializable)x$8 -> CompressionNegotiation$ServerHeader$.MODULE$.decode((Buf)x$8)).getOrElse((Function0 & Serializable)() -> CompressionNegotiation$.MODULE$.CompressionOff());
            Option<String> option = compressionFormats.request();
            if (option instanceof Some) {
                Some some = (Some)option;
                String compression = (String)some.value();
                this.sharedStats.compressionSuccess().incr();
                NegotiatingHandle negotiatingHandle = this.asNegotiatingHandle(handle, "compression");
                negotiatingHandle.turnOnCompression(compression);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.sharedStats.compressionFailures().incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option<String> option2 = compressionFormats.response();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String decompression = (String)some.value();
                this.sharedStats.decompressionSuccess().incr();
                NegotiatingHandle negotiatingHandle = this.asNegotiatingHandle(handle, "decompression");
                negotiatingHandle.turnOnDecompression(decompression);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.sharedStats.decompressionFailures().incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        @Override
        public MuxClientSession builder(PushChannelHandle<ByteReader, Buf> handle, MessageWriter writer, MuxMessageDecoder decoder) {
            return new MuxClientSession(handle, decoder, writer, ((FailureDetector.Param)this.params.apply(FailureDetector.Param$.MODULE$.param())).param(), ((Label)this.params.apply(Label$.MODULE$.param())).label(), ((Stats)this.params.apply(Stats$.MODULE$.param())).statsReceiver());
        }

        public Client(Stack.Params params, SharedNegotiationStats sharedStats) {
            this.params = params;
            this.sharedStats = sharedStats;
            super(params, sharedStats, false);
        }
    }

    public static final class Server
    extends Negotiation {
        private final Stack.Params params;
        private final SharedNegotiationStats sharedStats;
        private final Service<Request, Response> service;

        @Override
        public void negotiateCompression(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
            Compression.PeerPreferences peerCompressionSettings = (Compression.PeerPreferences)peerHeaders.flatMap((Function1 & Serializable)x$9 -> Handshake$.MODULE$.valueOf(CompressionNegotiation$ClientHeader$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)x$9)).map((Function1 & Serializable)x$10 -> CompressionNegotiation$ClientHeader$.MODULE$.decode((Buf)x$10)).getOrElse((Function0 & Serializable)() -> Compression$.MODULE$.PeerCompressionOff());
            Compression.LocalPreferences ourCompressionSettings = ((Mux.param.CompressionPreferences)this.params.apply(Mux$param$CompressionPreferences$.MODULE$.param())).compressionPreferences();
            CompressionNegotiation.CompressionFormats compressionFormats = CompressionNegotiation$.MODULE$.negotiate(ourCompressionSettings, peerCompressionSettings);
            Option<String> option = compressionFormats.request();
            if (option instanceof Some) {
                Some some = (Some)option;
                String decompression = (String)some.value();
                this.sharedStats.decompressionSuccess().incr();
                NegotiatingHandle negotiatingHandle = this.asNegotiatingHandle(handle, "decompression");
                negotiatingHandle.turnOnDecompression(decompression);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.sharedStats.decompressionFailures().incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option<String> option2 = compressionFormats.response();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String compression = (String)some.value();
                this.sharedStats.compressionSuccess().incr();
                NegotiatingHandle negotiatingHandle = this.asNegotiatingHandle(handle, "compression");
                negotiatingHandle.turnOnCompression(compression);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.sharedStats.compressionFailures().incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        @Override
        public MuxServerSession builder(PushChannelHandle<ByteReader, Buf> handle, MessageWriter writer, MuxMessageDecoder decoder) {
            return new MuxServerSession(this.params, decoder, writer, handle, this.service);
        }

        public Server(Stack.Params params, SharedNegotiationStats sharedStats, Service<Request, Response> service) {
            this.params = params;
            this.sharedStats = sharedStats;
            this.service = service;
            super(params, sharedStats, true);
        }
    }
}

