/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.transport;

import com.twitter.finagle.Dentry;
import com.twitter.finagle.Dentry$;
import com.twitter.finagle.Dtab;
import com.twitter.finagle.Dtab$;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.NameTree$;
import com.twitter.finagle.Path;
import com.twitter.finagle.Path$;
import com.twitter.finagle.mux.ContextCodec$;
import com.twitter.finagle.mux.transport.BadMessageException;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$Init$;
import com.twitter.finagle.mux.transport.Message$ReplyStatus$;
import com.twitter.finagle.mux.transport.Message$Tags$;
import com.twitter.finagle.mux.transport.Message$Treq$Keys$;
import com.twitter.finagle.mux.transport.Message$Types$;
import com.twitter.finagle.tracing.Flags;
import com.twitter.finagle.tracing.SpanId;
import com.twitter.finagle.tracing.SpanId$;
import com.twitter.finagle.tracing.TraceId;
import com.twitter.finagle.tracing.TraceId$;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.io.ByteReader;
import com.twitter.io.ByteReader$;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Message$ {
    public static final Message$ MODULE$ = new Message$();
    private static final Buf[] com$twitter$finagle$mux$transport$Message$$bufOfChar = (Buf[])((Object[])new Buf[]{MODULE$.mkByte((byte)0), MODULE$.mkByte((byte)1), MODULE$.mkByte((byte)2)});
    public static final byte[] com$twitter$finagle$mux$transport$Message$$noBytes = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());

    private Buf mkByte(byte b) {
        return Buf.ByteArray$.Owned$.MODULE$.apply(new byte[]{b});
    }

    public Buf[] com$twitter$finagle$mux$transport$Message$$bufOfChar() {
        return com$twitter$finagle$mux$transport$Message$$bufOfChar;
    }

    public String decodeUtf8(Buf buf) {
        String str;
        Some some;
        Buf buf2 = buf;
        if (buf2 == null || (some = Buf.Utf8$.MODULE$.unapply(buf2)).isEmpty()) {
            throw new MatchError((Object)buf2);
        }
        String string = str = (String)some.get();
        return string;
    }

    public Buf encodeString(String str) {
        return Buf.Utf8$.MODULE$.apply(str);
    }

    private Message.Treq decodeTreq(int tag, ByteReader br) {
        None$ none$;
        Some some;
        Tuple3 tuple3;
        if (br.remaining() < 1) {
            throw this.throwBadMessageException("short Treq");
        }
        int nkeys = br.readByte();
        if (nkeys < 0) {
            throw this.throwBadMessageException("Treq: too many keys");
        }
        None$ trace3 = None$.MODULE$;
        long traceFlags = 0L;
        while (nkeys > 0) {
            Buf buf;
            int vsize;
            if (br.remaining() < 2) {
                throw this.throwBadMessageException("short Treq (header)");
            }
            byte key = br.readByte();
            int n = br.readByte();
            switch (n) {
                default: 
            }
            int n2 = vsize = n < 0 ? n + 256 : n;
            if (br.remaining() < vsize) {
                throw this.throwBadMessageException("short Treq (vsize)");
            }
            byte by = key;
            if (Message$Treq$Keys$.MODULE$.TraceId() == by) {
                if (vsize != 24) {
                    throw this.throwBadMessageException(new StringBuilder(17).append("bad traceid size ").append(vsize).toString());
                }
                trace3 = new Some((Object)new Tuple3((Object)SpanId$.MODULE$.apply(br.readLongBE()), (Object)SpanId$.MODULE$.apply(br.readLongBE()), (Object)SpanId$.MODULE$.apply(br.readLongBE())));
                buf = BoxedUnit.UNIT;
            } else if (Message$Treq$Keys$.MODULE$.TraceFlag() == by) {
                BoxedUnit boxedUnit;
                Object object = vsize > 1 ? br.readBytes(vsize - 1) : BoxedUnit.UNIT;
                if (vsize > 0) {
                    traceFlags = br.readByte();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                buf = boxedUnit;
            } else {
                buf = br.readBytes(vsize);
            }
            --nkeys;
        }
        None$ none$2 = trace3;
        if (none$2 instanceof Some && (tuple3 = (Tuple3)(some = (Some)none$2).value()) != null) {
            SpanId spanId = (SpanId)tuple3._1();
            SpanId parentId = (SpanId)tuple3._2();
            SpanId traceId = (SpanId)tuple3._3();
            none$ = new Some((Object)TraceId$.MODULE$.apply((Option)new Some((Object)traceId), (Option)new Some((Object)parentId), spanId, (Option)None$.MODULE$, new Flags(traceFlags)));
        } else if (None$.MODULE$.equals(none$2)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)none$2);
        }
        None$ id = none$;
        return new Message.Treq(tag, (Option<TraceId>)id, br.readAll());
    }

    private Message.Tdispatch decodeTdispatch(int tag, ByteReader br) {
        Dtab dtab;
        short n = br.readShortBE();
        Seq<Tuple2<Buf, Buf>> contexts = n == 0 ? package$.MODULE$.Nil() : ContextCodec$.MODULE$.decode(br, n);
        short ndst = br.readShortBE();
        Path dst = ndst == 0 ? Path$.MODULE$.empty() : Path$.MODULE$.read(this.decodeUtf8(br.readBytes((int)ndst)));
        int nd = br.readShortBE();
        if (nd == 0) {
            dtab = Dtab$.MODULE$.empty();
        } else {
            Dentry[] delegations = new Dentry[nd];
            for (int i = 0; i < nd; ++i) {
                String src = this.decodeUtf8(br.readBytes((int)br.readShortBE()));
                String dst2 = this.decodeUtf8(br.readBytes((int)br.readShortBE()));
                delegations[i] = Dentry$.MODULE$.apply(Path$.MODULE$.read(src), NameTree$.MODULE$.read(dst2));
            }
            dtab = new Dtab(Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)delegations));
        }
        Dtab dtab2 = dtab;
        return new Message.Tdispatch(tag, contexts, dst, dtab2, br.readAll());
    }

    private Message.Rdispatch decodeRdispatch(int tag, ByteReader br) {
        Message.Rdispatch rdispatch;
        byte status = br.readByte();
        short n = br.readShortBE();
        Seq<Tuple2<Buf, Buf>> contexts = n == 0 ? package$.MODULE$.Nil() : ContextCodec$.MODULE$.decode(br, n);
        Buf rest = br.readAll();
        byte by = status;
        if (Message$ReplyStatus$.MODULE$.Ok() == by) {
            rdispatch = new Message.RdispatchOk(tag, contexts, rest);
        } else if (Message$ReplyStatus$.MODULE$.Error() == by) {
            rdispatch = new Message.RdispatchError(tag, contexts, this.decodeUtf8(rest));
        } else if (Message$ReplyStatus$.MODULE$.Nack() == by) {
            rdispatch = new Message.RdispatchNack(tag, contexts);
        } else {
            throw this.throwBadMessageException("invalid Rdispatch status");
        }
        return rdispatch;
    }

    private Message.Rreq decodeRreq(int tag, ByteReader br) {
        Message.Rreq rreq;
        if (br.remaining() < 1) {
            throw this.throwBadMessageException("short Rreq");
        }
        byte status = br.readByte();
        Buf rest = br.readAll();
        byte by = status;
        if (Message$ReplyStatus$.MODULE$.Ok() == by) {
            rreq = new Message.RreqOk(tag, rest);
        } else if (Message$ReplyStatus$.MODULE$.Error() == by) {
            rreq = new Message.RreqError(tag, this.decodeUtf8(rest));
        } else if (Message$ReplyStatus$.MODULE$.Nack() == by) {
            rreq = new Message.RreqNack(tag);
        } else {
            throw this.throwBadMessageException("invalid Rreq status");
        }
        return rreq;
    }

    private Message.Tdiscarded decodeTdiscarded(ByteReader br) {
        if (br.remaining() < 3) {
            throw this.throwBadMessageException("short Tdiscarded message");
        }
        int which = (br.readByte() & 0xFF) << 16 | (br.readByte() & 0xFF) << 8 | br.readByte() & 0xFF;
        return new Message.Tdiscarded(which, this.decodeUtf8(br.readAll()));
    }

    private Message.Tlease decodeTlease(ByteReader br) {
        if (br.remaining() < 9) {
            throw this.throwBadMessageException("short Tlease message");
        }
        byte unit = br.readByte();
        long howMuch = br.readLongBE();
        return new Message.Tlease(unit, howMuch);
    }

    public Message decode(Buf buf) {
        Message message;
        try (ByteReader br = ByteReader$.MODULE$.apply(buf);){
            message = this.decode(br);
        }
        return message;
    }

    public Message decode(ByteReader byteReader) {
        if (byteReader.remaining() < 4) {
            throw this.throwBadMessageException(new StringBuilder(15).append("short message: ").append(Buf$.MODULE$.slowHexString(byteReader.readAll())).toString());
        }
        int head = byteReader.readIntBE();
        byte typ = Message$Tags$.MODULE$.extractType(head);
        int tag = Message$Tags$.MODULE$.extractTag(head);
        return this.decodeMessageBody(typ, tag, byteReader);
    }

    public Message decodeMessageBody(byte typ, int tag, ByteReader byteReader) {
        Product product;
        if (Message$Tags$.MODULE$.isFragment(tag)) {
            product = new Message.Fragment(typ, tag, byteReader.readAll());
        } else {
            Message message;
            byte by = typ;
            if (Message$Types$.MODULE$.Tinit() == by) {
                Tuple2<Object, Seq<Tuple2<Buf, Buf>>> tuple2 = Message$Init$.MODULE$.decode(byteReader);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Seq ctx = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)ctx);
                Tuple2 tuple23 = tuple22;
                short version2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                Seq ctx2 = (Seq)tuple23._2();
                message = new Message.Tinit(tag, version2, (Seq<Tuple2<Buf, Buf>>)ctx2);
            } else if (Message$Types$.MODULE$.Rinit() == by) {
                Tuple2<Object, Seq<Tuple2<Buf, Buf>>> tuple2 = Message$Init$.MODULE$.decode(byteReader);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Seq ctx = (Seq)tuple2._2();
                Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)ctx);
                Tuple2 tuple25 = tuple24;
                short version3 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                Seq ctx3 = (Seq)tuple25._2();
                message = new Message.Rinit(tag, version3, (Seq<Tuple2<Buf, Buf>>)ctx3);
            } else if (Message$Types$.MODULE$.Treq() == by) {
                message = this.decodeTreq(tag, byteReader);
            } else if (Message$Types$.MODULE$.Rreq() == by) {
                message = this.decodeRreq(tag, byteReader);
            } else if (Message$Types$.MODULE$.Tdispatch() == by) {
                message = this.decodeTdispatch(tag, byteReader);
            } else if (Message$Types$.MODULE$.Rdispatch() == by) {
                message = this.decodeRdispatch(tag, byteReader);
            } else if (Message$Types$.MODULE$.Tdrain() == by) {
                message = new Message.Tdrain(tag);
            } else if (Message$Types$.MODULE$.Rdrain() == by) {
                message = new Message.Rdrain(tag);
            } else if (Message$Types$.MODULE$.Tping() == by) {
                message = new Message.Tping(tag);
            } else if (Message$Types$.MODULE$.Rping() == by) {
                message = new Message.Rping(tag);
            } else {
                boolean bl = Message$Types$.MODULE$.Rerr() == by ? true : Message$Types$.MODULE$.BAD_Rerr() == by;
                if (bl) {
                    message = new Message.Rerr(tag, this.decodeUtf8(byteReader.readAll()));
                } else if (Message$Types$.MODULE$.Rdiscarded() == by) {
                    message = new Message.Rdiscarded(tag);
                } else {
                    boolean bl2 = Message$Types$.MODULE$.Tdiscarded() == by ? true : Message$Types$.MODULE$.BAD_Tdiscarded() == by;
                    if (bl2) {
                        message = this.decodeTdiscarded(byteReader);
                    } else if (Message$Types$.MODULE$.Tlease() == by) {
                        message = this.decodeTlease(byteReader);
                    } else {
                        throw this.throwBadMessageException(this.unknownMessageDescription(by, tag, byteReader));
                    }
                }
            }
            product = message;
        }
        return product;
    }

    public Buf com$twitter$finagle$mux$transport$Message$$makeHeader(byte typ, int tag) {
        byte[] arr = new byte[]{typ, (byte)(tag >> 16 & 0xFF), (byte)(tag >> 8 & 0xFF), (byte)(tag & 0xFF)};
        return new Buf.ByteArray(arr, 0, 4);
    }

    public Buf encode(Message msg) {
        Buf buf;
        Message message = msg;
        if (message instanceof Message.PreEncoded) {
            Message.PreEncoded preEncoded = (Message.PreEncoded)message;
            buf = preEncoded.encodedBuf();
        } else if (message != null) {
            Message message2 = message;
            if (message2.tag() < Message$Tags$.MODULE$.MarkerTag() || (message2.tag() & ~Message$Tags$.MODULE$.TagMSB()) > Message$Tags$.MODULE$.MaxTag()) {
                throw this.throwBadMessageException(new StringBuilder(19).append("invalid tag number ").append(message2.tag()).toString());
            }
            buf = this.com$twitter$finagle$mux$transport$Message$$makeHeader(message2.typ(), message2.tag()).concat(message2.buf());
        } else {
            throw new MatchError((Object)message);
        }
        return buf;
    }

    public Iterator<Buf> encodeFragments(Message msg, int maxSize) {
        Iterator iterator;
        Message message = msg;
        if (message instanceof Message.Fragmentable) {
            Message.Fragmentable fragmentable = (Message.Fragmentable)message;
            iterator = new Message.FragmentIterator(fragmentable, maxSize);
        } else {
            iterator = package$.MODULE$.Iterator().single((Object)this.encode(msg));
        }
        return iterator;
    }

    private Nothing$ throwBadMessageException(String why) {
        throw Failure$.MODULE$.wrap((Throwable)new BadMessageException(why));
    }

    private String unknownMessageDescription(byte tpe, int tag, ByteReader payload) {
        int remaining = payload.remaining();
        Buf toWrite = payload.readBytes(16);
        String bytesStr = Buf$.MODULE$.slowHexString(toWrite);
        return new StringBuilder(0).append(new StringBuilder(48).append("unknown message type: ").append(tpe).append(" [tag=").append(tag).append("]. Payload bytes: ").append(remaining).append(". ").toString()).append(new StringBuilder(31).append("First ").append(toWrite.length()).append(" bytes of the payload: '").append(bytesStr).append("'").toString()).toString();
    }

    private Message$() {
    }
}

