/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty3.channel;

import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeLike;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u00015\u00111c\u00115b]:,Gn\u0015;biND\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000f\rD\u0017M\u001c8fY*\u0011QAB\u0001\u0007]\u0016$H/_\u001a\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010/5\t\u0001C\u0003\u0002\u0004#)\u0011!cE\u0001\u0006]\u0016$H/\u001f\u0006\u0003)U\tQA\u001b2pgNT\u0011AF\u0001\u0004_J<\u0017B\u0001\r\u0011\u0005Q\u0019\u0016.\u001c9mK\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\"A!\u0004\u0001B\u0001B\u0003%1$A\u0007ti\u0006$8OU3dK&4XM\u001d\t\u00039}i\u0011!\b\u0006\u0003=\u0019\tQa\u001d;biNL!\u0001I\u000f\u0003\u001bM#\u0018\r^:SK\u000e,\u0017N^3s\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u00065\u0005\u0002\ra\u0007\u0005\u0007Q\u0001\u0001\u000b\u0011B\u0015\u0002\u00071|w\r\u0005\u0002+[5\t1F\u0003\u0002-\u0011\u00059An\\4hS:<\u0017B\u0001\u0018,\u0005\u0019aunZ4fe\"1\u0001\u0007\u0001Q\u0001\nE\nqbY8o]\u0016\u001cG/[8o\u0007>,h\u000e\u001e\t\u0003emj\u0011a\r\u0006\u0003iU\na!\u0019;p[&\u001c'B\u0001\u001c8\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003qe\nA!\u001e;jY*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f4\u0005)\tEo\\7jG2{gn\u001a\u0005\u0007}\u0001\u0001\u000b\u0011B \u0002\u000f\u0015d\u0017\r]:fIB\u0019!\u0007\u0011\"\n\u0005\u0005\u001b$aD!u_6L7MU3gKJ,gnY3\u0011\u0005\rCeB\u0001#G\u001b\u0005)%B\u0001\u001d\t\u0013\t9U)A\u0005Ti>\u0004x/\u0019;dQ&\u0011\u0011J\u0013\u0002\b\u000b2\f\u0007o]3e\u0013\tYUIA\u0005Ti>\u0004x/\u0019;dQ\"1Q\n\u0001Q\u0001\n9\u000b\u0001bY8o]\u0016\u001cGo\u001d\t\u00039=K!\u0001U\u000f\u0003\u000f\r{WO\u001c;fe\"1!\u000b\u0001Q\u0001\nM\u000b!cY8o]\u0016\u001cG/[8o\tV\u0014\u0018\r^5p]B\u0011A\u0004V\u0005\u0003+v\u0011Aa\u0015;bi\"1q\u000b\u0001Q\u0001\nM\u000bqcY8o]\u0016\u001cG/[8o%\u0016\u001cW-\u001b<fI\nKH/Z:\t\re\u0003\u0001\u0015!\u0003T\u0003M\u0019wN\u001c8fGRLwN\\*f]R\u0014\u0015\u0010^3t\u0011\u0019Y\u0006\u0001)A\u0005\u001d\u0006i!/Z2fSZ,GMQ=uKNDa!\u0018\u0001!\u0002\u0013q\u0015!C:f]R\u0014\u0015\u0010^3t\u0011\u0019y\u0006\u0001)A\u0005\u001d\u0006AqO]5uC\ndW\r\u0003\u0004b\u0001\u0001\u0006IAT\u0001\u000bk:<(/\u001b;bE2,\u0007BB2\u0001A\u0003%1$\u0001\u0006fq\u000e,\u0007\u000f^5p]NDa!\u001a\u0001!\u0002\u0013q\u0015aC2m_N,7oQ8v]RDaa\u001a\u0001!\u0002\u0013A\u0017aC2p]:,7\r^5p]N\u0004\"\u0001H5\n\u0005)l\"!B$bk\u001e,\u0007\"\u00027\u0001\t\u0003j\u0017aC2iC:tW\r\\(qK:$2A\u001c;z!\ty'/D\u0001q\u0015\u0005\t\u0018!B:dC2\f\u0017BA:q\u0005\u0011)f.\u001b;\t\u000bU\\\u0007\u0019\u0001<\u0002\u0007\r$\b\u0010\u0005\u0002\u0010o&\u0011\u0001\u0010\u0005\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u0015Q8\u000e1\u0001|\u0003\u0005)\u0007CA\b}\u0013\ti\bCA\tDQ\u0006tg.\u001a7Ti\u0006$X-\u0012<f]RDaa \u0001\u0005B\u0005\u0005\u0011!D<sSR,7i\\7qY\u0016$X\rF\u0003o\u0003\u0007\t)\u0001C\u0003v}\u0002\u0007a\u000f\u0003\u0004{}\u0002\u0007\u0011q\u0001\t\u0004\u001f\u0005%\u0011bAA\u0006!\t!rK]5uK\u000e{W\u000e\u001d7fi&|g.\u0012<f]RDq!a\u0004\u0001\t\u0003\n\t\"A\bnKN\u001c\u0018mZ3SK\u000e,\u0017N^3e)\u0015q\u00171CA\u000b\u0011\u0019)\u0018Q\u0002a\u0001m\"9!0!\u0004A\u0002\u0005]\u0001cA\b\u0002\u001a%\u0019\u00111\u0004\t\u0003\u00195+7o]1hK\u00163XM\u001c;\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005q1\r\\8tKJ+\u0017/^3ti\u0016$G#\u00028\u0002$\u0005\u0015\u0002BB;\u0002\u001e\u0001\u0007a\u000f\u0003\u0004{\u0003;\u0001\ra\u001f\u0005\b\u0003S\u0001A\u0011IA\u0016\u00035\u0019\u0007.\u00198oK2\u001cEn\\:fIR)a.!\f\u00020!1Q/a\nA\u0002YDaA_A\u0014\u0001\u0004Y\bbBA\u001a\u0001\u0011\u0005\u0013QG\u0001\u0010Kb\u001cW\r\u001d;j_:\u001c\u0015-^4iiR)a.a\u000e\u0002:!1Q/!\rA\u0002YD\u0001\"a\u000f\u00022\u0001\u0007\u0011QH\u0001\u0004KZ$\bcA\b\u0002@%\u0019\u0011\u0011\t\t\u0003\u001d\u0015C8-\u001a9uS>tWI^3oi\"A\u0011Q\t\u0001!B\u0013\t9%A\biCN\u0014U-\u001a8Xe&$\u0018M\u00197f!\ry\u0017\u0011J\u0005\u0004\u0003\u0017\u0002(a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u001f\u0002\u0001\u0015)\u0003\u0002R\u0005)1/\u001b8dKB\u0019A)a\u0015\n\u0007\u0005USI\u0001\u0003US6,\u0007\u0002CA-\u0001\u0001&I!a\u0017\u0002\u001dM|7m[3u\tV\u0014\u0018\r^5p]R!\u0011QLA2!\r!\u0015qL\u0005\u0004\u0003C*%\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u0011\u0005\u0015\u0014q\u000ba\u0001\u0003#\n1A\\8x\u0011\u001d\tI\u0007\u0001C!\u0003W\nac\u00195b]:,G.\u00138uKJ,7\u000f^\"iC:<W\r\u001a\u000b\u0006]\u00065\u0014q\u000e\u0005\u0007k\u0006\u001d\u0004\u0019\u0001<\t\ri\f9\u00071\u0001|\u0001")
public class ChannelStatsHandler
extends SimpleChannelHandler {
    private final Logger log = Logger$.MODULE$.get(((Object)((Object)this)).getClass());
    public final AtomicLong com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount = new AtomicLong();
    private final AtomicReference<Function0<Duration>> elapsed = new AtomicReference<Object>(null);
    private final Counter connects;
    private final Stat connectionDuration;
    private final Stat connectionReceivedBytes;
    private final Stat connectionSentBytes;
    private final Counter receivedBytes;
    private final Counter sentBytes;
    private final Counter writable;
    private final Counter unwritable;
    private final StatsReceiver exceptions;
    private final Counter closesCount;
    private final Gauge connections;
    private boolean hasBeenWritable;
    private Time since;

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (this.elapsed.getAndSet((Function0<Duration>)Stopwatch$.MODULE$.start()) != null) {
            this.log.warning("channelOpen() called when channel was already open, clobbering an existing timer", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        ctx.setAttachment((Object)new Tuple2((Object)new AtomicLong(0L), (Object)new AtomicLong(0L)));
        this.connects.incr();
        this.com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount.incrementAndGet();
        super.channelOpen(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        Tuple2 tuple2 = (Tuple2)ctx.getAttachment();
        if (tuple2 != null) {
            AtomicLong channelWriteCount;
            AtomicLong atomicLong;
            AtomicLong channelWriteCount2 = atomicLong = (channelWriteCount = (AtomicLong)tuple2._2());
            channelWriteCount2.getAndAdd(e.getWrittenAmount());
            this.sentBytes.incr((long)((int)e.getWrittenAmount()));
            super.writeComplete(ctx, e);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (object instanceof ChannelBuffer) {
            AtomicLong channelReadCount;
            AtomicLong atomicLong;
            ChannelBuffer channelBuffer = (ChannelBuffer)object;
            Tuple2 tuple2 = (Tuple2)ctx.getAttachment();
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            AtomicLong channelReadCount2 = atomicLong = (channelReadCount = (AtomicLong)tuple2._1());
            int readableBytes = channelBuffer.readableBytes();
            channelReadCount2.getAndAdd(readableBytes);
            this.receivedBytes.incr((long)readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer read", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.messageReceived(ctx, e);
    }

    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.closesCount.incr();
        super.closeRequested(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Tuple2 tuple2;
        block4: {
            block3: {
                Tuple2 tuple22;
                Object object;
                Function0 currentElapsed;
                block2: {
                    currentElapsed = this.elapsed.getAndSet(null);
                    if (currentElapsed != null) break block2;
                    object = BoxedUnit.UNIT;
                    break block3;
                }
                tuple2 = (Tuple2)ctx.getAttachment();
                if (tuple2 == null) break block4;
                AtomicLong channelReadCount = (AtomicLong)tuple2._1();
                AtomicLong channelWriteCount = (AtomicLong)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)channelReadCount, (Object)channelWriteCount);
                AtomicLong channelReadCount2 = (AtomicLong)tuple23._1();
                AtomicLong channelWriteCount2 = (AtomicLong)tuple23._2();
                this.connectionReceivedBytes.add((float)channelReadCount2.get());
                this.connectionSentBytes.add((float)channelWriteCount2.get());
                this.connectionDuration.add((float)((TimeLike)currentElapsed.apply()).inMilliseconds());
                object = BoxesRunTime.boxToLong((long)this.com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount.decrementAndGet());
            }
            super.channelClosed(ctx, e);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent evt) {
        String m = evt.getCause() == null ? "unknown" : evt.getCause().getClass().getName();
        this.exceptions.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{m})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Throwable throwable = evt.getCause();
            Object object = throwable instanceof IOException ? Level.DEBUG$.MODULE$ : Level.WARNING$.MODULE$;
            Level.DEBUG$ level = object;
            this.log.log((Level)level, evt.getCause(), "ChannelStatsHandler caught an exception", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        super.exceptionCaught(ctx, evt);
    }

    private Duration socketDuration(Time now) {
        return now.$minus(this.since);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Time now = Time$.MODULE$.now();
        super.channelInterestChanged(ctx, e);
        boolean isWritable = ctx.getChannel().isWritable();
        if (isWritable != this.hasBeenWritable) {
            Counter stat = this.hasBeenWritable ? this.writable : this.unwritable;
            stat.incr((long)((int)this.socketDuration(now).inMillis()));
            this.hasBeenWritable = isWritable;
            this.since = now;
        }
    }

    public ChannelStatsHandler(StatsReceiver statsReceiver) {
        this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
        this.connectionDuration = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
        this.connectionReceivedBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
        this.connectionSentBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
        this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
        this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
        this.writable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
        this.unwritable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
        this.exceptions = statsReceiver.scope("exn");
        this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
        this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChannelStatsHandler $outer;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return this.$outer.com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.hasBeenWritable = true;
        this.since = Time$.MODULE$.now();
    }
}

