/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.netty4.ByteBufConversion$;
import com.twitter.finagle.netty4.http.StreamTransports$;
import com.twitter.finagle.transport.Transport;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.io.Reader;
import com.twitter.io.Reader$;
import com.twitter.io.Writer;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class StreamTransports$ {
    public static StreamTransports$ MODULE$;
    private final Logger log;
    private final Function1<Object, Object> isLast;

    static {
        new StreamTransports$();
    }

    public Logger log() {
        return this.log;
    }

    public <A> Future<BoxedUnit> copyToWriter(Transport<?, A> trans, Writer writer, Function1<A, Object> eos, Function1<A, Buf> chunkOfA) {
        return trans.read().flatMap((Function1 & Serializable & scala.Serializable)a -> {
            Buf chunk = (Buf)chunkOfA.apply(a);
            Future writeF = !chunk.isEmpty() ? writer.write(chunk) : Future$.MODULE$.Done();
            return BoxesRunTime.unboxToBoolean((Object)eos.apply(a)) ? writeF : writeF.before((Function0 & Serializable & scala.Serializable)() -> MODULE$.copyToWriter(trans, writer, eos, chunkOfA), Predef$.MODULE$.$conforms());
        });
    }

    public <A> Future<BoxedUnit> collate(Transport<?, A> trans, Function1<A, Buf> chunkOfA, Function1<A, Object> eos) {
        return new Reader(trans, chunkOfA, eos){
            private final Reader.Writable rw;
            private final Future<BoxedUnit> writes;

            public Future<Option<Buf>> read(int n) {
                return this.rw.read(n);
            }

            public void discard() {
                this.rw.discard();
                this.raise((Throwable)new Reader.ReaderDiscarded());
            }

            public static final /* synthetic */ void $anonfun$new$1(anon.1 $this, Try x0$1) {
                Try try_ = x0$1;
                if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable t = throw_.e();
                    $this.updateIfEmpty((Try)throw_);
                    $this.rw.fail(t);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Return) {
                    Return return_ = (Return)try_;
                    $this.updateIfEmpty((Try)return_);
                    $this.rw.close();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
            }
            {
                this.rw = Reader$.MODULE$.writable();
                this.writes = StreamTransports$.MODULE$.copyToWriter(trans$2, (Writer)this.rw, eos$2, chunkOfA$2);
                this.forwardInterruptsTo(this.writes);
                this.writes.respond((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    anon.1.$anonfun$new$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(com.twitter.finagle.netty4.http.StreamTransports$$anon$1 com.twitter.util.Try )}, serializedLambda);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Buf readChunk(Object chunk) {
        boolean bl = false;
        HttpContent httpContent = null;
        Object object = chunk;
        if (object instanceof HttpContent) {
            bl = true;
            httpContent = (HttpContent)object;
            if (httpContent.content().readableBytes() == 0) {
                return Buf$.MODULE$.Empty();
            }
        }
        if (!bl) throw new IllegalArgumentException("Expected a HttpContent, but read an instance of " + object.getClass().getSimpleName());
        return ByteBufConversion$.MODULE$.byteBufAsBuf(httpContent.content());
    }

    public HttpContent chunkOfBuf(Buf buf) {
        return new DefaultHttpContent(ByteBufConversion$.MODULE$.bufAsByteBuf(buf));
    }

    public Future<BoxedUnit> streamChunks(Transport<Object, Object> trans, Reader r, int bufSize) {
        return r.read(bufSize).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Future future;
            Option option = x0$2;
            if (None$.MODULE$.equals(option)) {
                future = trans.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Buf buf = (Buf)some.value();
                future = trans.write((Object)MODULE$.chunkOfBuf(buf)).transform((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Future future;
                    Try try_ = x0$3;
                    if (try_ instanceof Return) {
                        future = MODULE$.streamChunks(trans, r, bufSize);
                    } else if (try_ instanceof Throw) {
                        Throw throw_ = (Throw)try_;
                        Throwable t = throw_.e();
                        MODULE$.log().debug(t, "Failure while writing chunk to stream", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                        future = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> r.discard());
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return future;
                });
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        });
    }

    public int streamChunks$default$3() {
        return Integer.MAX_VALUE;
    }

    public Function1<Object, Object> isLast() {
        return this.isLast;
    }

    public static final /* synthetic */ boolean $anonfun$isLast$1(Object x$1) {
        return x$1 instanceof LastHttpContent;
    }

    private StreamTransports$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.get();
        this.isLast = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamTransports$.$anonfun$isLast$1(x$1));
    }
}

