/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.conversions.storage$;
import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.http.param.AutomaticContinue;
import com.twitter.finagle.http.param.AutomaticContinue$;
import com.twitter.finagle.http.param.CompressionLevel;
import com.twitter.finagle.http.param.CompressionLevel$;
import com.twitter.finagle.http.param.Decompression;
import com.twitter.finagle.http.param.Decompression$;
import com.twitter.finagle.http.param.MaxChunkSize;
import com.twitter.finagle.http.param.MaxChunkSize$;
import com.twitter.finagle.http.param.MaxHeaderSize;
import com.twitter.finagle.http.param.MaxHeaderSize$;
import com.twitter.finagle.http.param.MaxInitialLineSize;
import com.twitter.finagle.http.param.MaxInitialLineSize$;
import com.twitter.finagle.http.param.MaxRequestSize;
import com.twitter.finagle.http.param.MaxRequestSize$;
import com.twitter.finagle.http.param.MaxResponseSize;
import com.twitter.finagle.http.param.MaxResponseSize$;
import com.twitter.finagle.http.param.Streaming;
import com.twitter.finagle.http.param.Streaming$;
import com.twitter.finagle.netty4.Netty4Listener$;
import com.twitter.finagle.netty4.Netty4Transporter$;
import com.twitter.finagle.netty4.http.FinagleHttpObjectAggregator;
import com.twitter.finagle.netty4.http.TextualContentCompressor;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler$;
import com.twitter.finagle.netty4.http.handler.ClientExceptionMapper$;
import com.twitter.finagle.netty4.http.handler.FixedLengthMessageAggregator;
import com.twitter.finagle.netty4.http.handler.FixedLengthMessageAggregator$;
import com.twitter.finagle.netty4.http.handler.PayloadSizeHandler;
import com.twitter.finagle.netty4.http.handler.UnpoolHttpHandler$;
import com.twitter.finagle.param.Logger$;
import com.twitter.finagle.server.Listener;
import com.twitter.finagle.transport.TransportContext;
import com.twitter.util.StorageUnit;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.logging.Logger;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class package$ {
    public static package$ MODULE$;
    private final String HttpCodecName;
    private final String Http2CodecName;
    private final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit;
    private final Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object, TransportContext>>> Netty4HttpTransporter;
    private final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit;
    private final Function1<Stack.Params, Listener<Object, Object, TransportContext>> Netty4HttpListener;

    static {
        new package$();
    }

    public String HttpCodecName() {
        return this.HttpCodecName;
    }

    public String Http2CodecName() {
        return this.Http2CodecName;
    }

    public Function1<ChannelPipeline, BoxedUnit> initClientBefore(String role, Stack.Params params) {
        return (Function1 & Serializable & scala.Serializable)pipeline -> {
            package$.$anonfun$initClientBefore$1(role, params, pipeline);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<ChannelPipeline, BoxedUnit> initClient(Stack.Params params) {
        return (Function1 & Serializable & scala.Serializable)pipeline -> {
            package$.$anonfun$initClient$1(params, pipeline);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<ChannelPipeline, BoxedUnit> initClientFn(Stack.Params params, Function2<String, ChannelHandler, BoxedUnit> fn) {
        StorageUnit maxResponseSize = ((MaxResponseSize)params.apply(MaxResponseSize$.MODULE$.maxResponseSizeParam())).size();
        boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
        boolean streaming = ((Streaming)params.apply(Streaming$.MODULE$.maxResponseSizeParam())).enabled();
        return (Function1 & Serializable & scala.Serializable)pipeline -> {
            package$.$anonfun$initClientFn$1(fn, maxResponseSize, decompressionEnabled, streaming, pipeline);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit() {
        return this.ClientPipelineInit;
    }

    public Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object, TransportContext>>> Netty4HttpTransporter() {
        return this.Netty4HttpTransporter;
    }

    public Function1<ChannelPipeline, BoxedUnit> initServer(Stack.Params params) {
        boolean autoContinue = ((AutomaticContinue)params.apply(AutomaticContinue$.MODULE$.automaticContinue())).enabled();
        StorageUnit maxRequestSize = ((MaxRequestSize)params.apply(MaxRequestSize$.MODULE$.maxRequestSizeParam())).size();
        boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
        int compressionLevel = ((CompressionLevel)params.apply(CompressionLevel$.MODULE$.compressionLevelParam())).level();
        boolean streaming = ((Streaming)params.apply(Streaming$.MODULE$.maxResponseSizeParam())).enabled();
        Logger log = ((com.twitter.finagle.param.Logger)params.apply(Logger$.MODULE$.param())).log();
        return (Function1 & Serializable & scala.Serializable)pipeline -> {
            package$.$anonfun$initServer$1(autoContinue, maxRequestSize, decompressionEnabled, compressionLevel, streaming, log, pipeline);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit() {
        return this.ServerPipelineInit;
    }

    public Function1<Stack.Params, Listener<Object, Object, TransportContext>> Netty4HttpListener() {
        return this.Netty4HttpListener;
    }

    public static final /* synthetic */ void $anonfun$initClientBefore$1(String role$1, Stack.Params params$1, ChannelPipeline pipeline) {
        MODULE$.initClientFn(params$1, (Function2<String, ChannelHandler, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            pipeline.addBefore(role$1, x$1, x$2);
            return BoxedUnit.UNIT;
        }).apply((Object)pipeline);
    }

    public static final /* synthetic */ void $anonfun$initClient$1(Stack.Params params$2, ChannelPipeline pipeline) {
        MODULE$.initClientFn(params$2, (Function2<String, ChannelHandler, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$3, x$4) -> {
            pipeline.addLast(x$3, x$4);
            return BoxedUnit.UNIT;
        }).apply((Object)pipeline);
    }

    public static final /* synthetic */ void $anonfun$initClientFn$1(Function2 fn$1, StorageUnit maxResponseSize$1, boolean decompressionEnabled$1, boolean streaming$1, ChannelPipeline pipeline) {
        Object object = decompressionEnabled$1 ? fn$1.apply((Object)"httpDecompressor", (Object)new HttpContentDecompressor()) : BoxedUnit.UNIT;
        Object object2 = streaming$1 ? fn$1.apply((Object)"fixedLenAggregator", (Object)new FixedLengthMessageAggregator(storage$.MODULE$.intToStorageUnitableWholeNumber(8).kilobytes(), FixedLengthMessageAggregator$.MODULE$.$lessinit$greater$default$2())) : fn$1.apply((Object)"httpDechunker", (Object)new HttpObjectAggregator((int)maxResponseSize$1.inBytes()));
        fn$1.apply((Object)"clientExceptionMapper", (Object)ClientExceptionMapper$.MODULE$);
        fn$1.apply((Object)"unpoolHttp", (Object)UnpoolHttpHandler$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$ClientPipelineInit$2(Stack.Params params$3, ChannelPipeline pipeline) {
        StorageUnit maxChunkSize = ((MaxChunkSize)params$3.apply(MaxChunkSize$.MODULE$.maxChunkSizeParam())).size();
        StorageUnit maxHeaderSize = ((MaxHeaderSize)params$3.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)params$3.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
        HttpClientCodec codec = new HttpClientCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), (int)maxChunkSize.inBytes());
        pipeline.addLast(MODULE$.HttpCodecName(), (ChannelHandler)codec);
        MODULE$.initClient(params$3).apply((Object)pipeline);
    }

    public static final /* synthetic */ void $anonfun$initServer$1(boolean autoContinue$1, StorageUnit maxRequestSize$1, boolean decompressionEnabled$2, int compressionLevel$1, boolean streaming$2, Logger log$1, ChannelPipeline pipeline) {
        ChannelPipeline channelPipeline;
        int n = compressionLevel$1;
        Object object = n > 0 ? pipeline.addLast("httpCompressor", (ChannelHandler)new HttpContentCompressor(n)) : (-1 == n ? pipeline.addLast("httpCompressor", (ChannelHandler)new TextualContentCompressor()) : BoxedUnit.UNIT);
        Object object2 = decompressionEnabled$2 ? pipeline.addLast("httpDecompressor", (ChannelHandler)new HttpContentDecompressor()) : BoxedUnit.UNIT;
        if (streaming$2) {
            pipeline.addLast("payloadSizeHandler", (ChannelHandler)new PayloadSizeHandler(maxRequestSize$1, (Option<Logger>)new Some((Object)log$1)));
            Object object3 = autoContinue$1 ? pipeline.addLast("expectContinue", (ChannelHandler)new HttpServerExpectContinueHandler()) : BoxedUnit.UNIT;
            channelPipeline = pipeline.addLast("fixedLenAggregator", (ChannelHandler)new FixedLengthMessageAggregator(maxRequestSize$1, false));
        } else {
            channelPipeline = pipeline.addLast("httpDechunker", (ChannelHandler)new FinagleHttpObjectAggregator((int)maxRequestSize$1.inBytes(), autoContinue$1));
        }
        pipeline.addLast("badRequestHandler", (ChannelHandler)BadRequestHandler$.MODULE$);
        pipeline.addLast("unpoolHttp", (ChannelHandler)UnpoolHttpHandler$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$ServerPipelineInit$2(Stack.Params params$5, ChannelPipeline pipeline) {
        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)params$5.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
        StorageUnit maxHeaderSize = ((MaxHeaderSize)params$5.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
        StorageUnit maxRequestSize = ((MaxRequestSize)params$5.apply(MaxRequestSize$.MODULE$.maxRequestSizeParam())).size();
        HttpServerCodec codec = new HttpServerCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), (int)maxRequestSize.inBytes());
        pipeline.addLast(MODULE$.HttpCodecName(), (ChannelHandler)codec);
        MODULE$.initServer(params$5).apply((Object)pipeline);
    }

    private package$() {
        MODULE$ = this;
        this.HttpCodecName = "httpCodec";
        this.Http2CodecName = "http2Codec";
        this.ClientPipelineInit = (Function1 & Serializable & scala.Serializable)params -> (Function1 & Serializable & scala.Serializable)pipeline -> {
            package$.$anonfun$ClientPipelineInit$2(params, pipeline);
            return BoxedUnit.UNIT;
        };
        this.Netty4HttpTransporter = (Function1 & Serializable & scala.Serializable)params -> (Function1 & Serializable & scala.Serializable)addr -> Netty4Transporter$.MODULE$.raw((Function1)MODULE$.ClientPipelineInit().apply(params), addr, params, ManifestFactory$.MODULE$.Any());
        this.ServerPipelineInit = (Function1 & Serializable & scala.Serializable)params -> (Function1 & Serializable & scala.Serializable)pipeline -> {
            package$.$anonfun$ServerPipelineInit$2(params, pipeline);
            return BoxedUnit.UNIT;
        };
        this.Netty4HttpListener = (Function1 & Serializable & scala.Serializable)params -> Netty4Listener$.MODULE$.apply((Function1)MODULE$.ServerPipelineInit().apply(params), params, ManifestFactory$.MODULE$.Any(), ManifestFactory$.MODULE$.Any());
    }
}

