/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http.handler;

import com.twitter.finagle.http.Rfc7230HeaderValidation;
import com.twitter.finagle.http.Rfc7230HeaderValidation$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.Iterator;
import java.util.Map;
import scala.MatchError;
import scala.runtime.BoxedUnit;

@ChannelHandler.Sharable
public final class HeaderValidatorHandler$
extends ChannelInboundHandlerAdapter {
    public static HeaderValidatorHandler$ MODULE$;
    private final String HandlerName;

    static {
        new HeaderValidatorHandler$();
    }

    public String HandlerName() {
        return this.HandlerName;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof FullHttpMessage) {
            FullHttpMessage fullHttpMessage = (FullHttpMessage)object;
            this.validateObject(ctx, (HttpObject)fullHttpMessage, fullHttpMessage.headers());
            this.validateObject(ctx, (HttpObject)fullHttpMessage, fullHttpMessage.trailingHeaders());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof HttpMessage) {
            HttpMessage httpMessage = (HttpMessage)object;
            this.validateObject(ctx, (HttpObject)httpMessage, httpMessage.headers());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof LastHttpContent) {
            LastHttpContent lastHttpContent = (LastHttpContent)object;
            this.validateObject(ctx, (HttpObject)lastHttpContent, lastHttpContent.trailingHeaders());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ctx.fireChannelRead(msg);
    }

    private void validateObject(ChannelHandlerContext ctx, HttpObject obj, HttpHeaders headers) {
        Try<BoxedUnit> try_ = this.validateHeaders(headers);
        if (try_ instanceof Return) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable ex = throw_.e();
            headers.clear();
            obj.setDecoderResult(DecoderResult.failure((Throwable)ex));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    private Try<BoxedUnit> validateHeaders(HttpHeaders headers) {
        Iterator it = headers.iteratorCharSequence();
        while (it.hasNext()) {
            String string;
            Map.Entry header = (Map.Entry)it.next();
            CharSequence name = (CharSequence)header.getKey();
            CharSequence value = (CharSequence)header.getValue();
            Rfc7230HeaderValidation.NameValidationResult nameValidationResult = Rfc7230HeaderValidation$.MODULE$.validateName(name);
            if (nameValidationResult instanceof Rfc7230HeaderValidation.ValidationFailure) {
                Rfc7230HeaderValidation.ValidationFailure validationFailure = (Rfc7230HeaderValidation.ValidationFailure)nameValidationResult;
                Rfc7230HeaderValidation.HeaderValidationException e = validationFailure.ex();
                return new Throw((Throwable)e);
            }
            if (!Rfc7230HeaderValidation.ValidationSuccess$.MODULE$.equals(nameValidationResult)) {
                throw new MatchError((Object)nameValidationResult);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Rfc7230HeaderValidation.ValueValidationResult valueValidationResult = Rfc7230HeaderValidation$.MODULE$.validateValue(name, value);
            if (valueValidationResult instanceof Rfc7230HeaderValidation.ValidationFailure) {
                Rfc7230HeaderValidation.ValidationFailure validationFailure = (Rfc7230HeaderValidation.ValidationFailure)valueValidationResult;
                Rfc7230HeaderValidation.HeaderValidationException e = validationFailure.ex();
                return new Throw((Throwable)e);
            }
            if (Rfc7230HeaderValidation.ObsFoldDetected$.MODULE$.equals(valueValidationResult)) {
                string = header.setValue(Rfc7230HeaderValidation$.MODULE$.replaceObsFold(value));
                continue;
            }
            if (Rfc7230HeaderValidation.ValidationSuccess$.MODULE$.equals(valueValidationResult)) {
                string = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)valueValidationResult);
        }
        return Try$.MODULE$.Unit();
    }

    private HeaderValidatorHandler$() {
        MODULE$ = this;
        this.HandlerName = "headerValidationHandler";
    }
}

