/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.netty4.http.Bijections$finagle$;
import com.twitter.finagle.netty4.http.Bijections$netty$;
import com.twitter.finagle.netty4.http.handler.UnpoolHttpHandler$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import scala.Option;
import scala.Predef$;

public final class Netty4HttpCodec$ {
    public static Netty4HttpCodec$ MODULE$;

    static {
        new Netty4HttpCodec$();
    }

    public String encodeRequestToString(Request request) {
        return new String(this.encodeRequestToBytes(request), "UTF-8");
    }

    public byte[] encodeRequestToBytes(Request request) {
        byte[] byArray;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestEncoder()});
        ch.writeOneOutbound((Object)Bijections$finagle$.MODULE$.requestToNetty(request, (Option<Object>)request.contentLength()));
        ch.flushOutbound();
        CompositeByteBuf acc = ch.alloc().compositeBuffer();
        try {
            while (!ch.outboundMessages().isEmpty()) {
                acc.addComponent(true, (ByteBuf)ch.readOutbound());
            }
            byte[] out = new byte[acc.readableBytes()];
            acc.readBytes(out);
            byArray = out;
        }
        finally {
            acc.release();
            ch.finishAndReleaseAll();
        }
        return byArray;
    }

    public Request decodeStringToRequest(String s) {
        return this.decodeBytesToRequest(s.getBytes(StandardCharsets.UTF_8));
    }

    public Request decodeBytesToRequest(byte[] b) {
        Request request;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new HttpObjectAggregator(Integer.MAX_VALUE), UnpoolHttpHandler$.MODULE$});
        try {
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b)});
            ch.flushInbound();
            Predef$.MODULE$.assert(ch.inboundMessages().size() == 1);
            FullHttpRequest nettyReq = (FullHttpRequest)ch.readInbound();
            request = Bijections$netty$.MODULE$.fullRequestToFinagle(nettyReq, new InetSocketAddress(0));
        }
        finally {
            ch.finishAndReleaseAll();
        }
        return request;
    }

    public String encodeResponseToString(Response response) {
        String string;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        CompositeByteBuf acc = ch.alloc().compositeBuffer();
        try {
            ch.writeOutbound(new Object[]{Bijections$finagle$.MODULE$.fullResponseToNetty(response)});
            ch.flushOutbound();
            while (!ch.outboundMessages().isEmpty()) {
                acc.addComponent(true, (ByteBuf)ch.readOutbound());
            }
            string = acc.toString(StandardCharsets.UTF_8);
        }
        finally {
            acc.release();
            ch.finishAndReleaseAll();
        }
        return string;
    }

    public Response decodeStringToResponse(String s) {
        return this.decodeBytesToResponse(s.getBytes(StandardCharsets.UTF_8));
    }

    public Response decodeBytesToResponse(byte[] b) {
        Response response;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new HttpObjectAggregator(Integer.MAX_VALUE), UnpoolHttpHandler$.MODULE$});
        try {
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b)});
            ch.flushInbound();
            Predef$.MODULE$.assert(ch.inboundMessages().size() == 1);
            FullHttpResponse resp = (FullHttpResponse)ch.readInbound();
            response = Bijections$netty$.MODULE$.fullResponseToFinagle(resp);
        }
        finally {
            ch.finishAndReleaseAll();
        }
        return response;
    }

    private Netty4HttpCodec$() {
        MODULE$ = this;
    }
}

