/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http.handler;

import com.twitter.finagle.http.BadRequestResponse$;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation;
import com.twitter.finagle.netty4.http.Bijections$finagle$;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Logger;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005-r!B\b\u0011\u0011\u0003ib!B\u0010\u0011\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%\tA\u000b\u0005\u0007c\u0005\u0001\u000b\u0011B\u0016\t\u000fI\n!\u0019!C\u0001g!1q(\u0001Q\u0001\nQ2Qa\b\t\u0001)\u0001C\u0001bS\u0004\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006O\u001d!\t!\u0015\u0005\u0007)\u001e\u0001\u000b\u0011B+\t\ra;\u0001\u0015!\u0003V\u0011\u0015Iv\u0001\"\u0011[\u0011\u0019Aw\u0001)C\u0005S\"1Qo\u0002Q\u0005\nY\f\u0011CQ1e%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0015\t\t\"#A\u0004iC:$G.\u001a:\u000b\u0005M!\u0012\u0001\u00025uiBT!!\u0006\f\u0002\r9,G\u000f^=5\u0015\t9\u0002$A\u0004gS:\fw\r\\3\u000b\u0005eQ\u0012a\u0002;xSR$XM\u001d\u0006\u00027\u0005\u00191m\\7\u0004\u0001A\u0011a$A\u0007\u0002!\t\t\")\u00193SKF,Xm\u001d;IC:$G.\u001a:\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005\u0019An\\4\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\r\u0002\u000f1|wmZ5oO&\u0011\u0001'\f\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\f\u0011\u0006tG\r\\3s\u001d\u0006lW-F\u00015!\t)DH\u0004\u00027uA\u0011qgI\u0007\u0002q)\u0011\u0011\bH\u0001\u0007yI|w\u000e\u001e \n\u0005m\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!aO\u0012\u0002\u0019!\u000bg\u000e\u001a7fe:\u000bW.\u001a\u0011\u0014\u0005\u001d\t\u0005C\u0001\"J\u001b\u0005\u0019%B\u0001#F\u0003\u001d\u0019\u0007.\u00198oK2T!AR$\u0002\u000b9,G\u000f^=\u000b\u0003!\u000b!![8\n\u0005)\u001b%\u0001H\"iC:tW\r\\%oE>,h\u000e\u001a%b]\u0012dWM]!eCB$XM]\u0001\u0006gR\fGo\u001d\t\u0003\u001b>k\u0011A\u0014\u0006\u0003\u0017ZI!\u0001\u0015(\u0003\u001bM#\u0018\r^:SK\u000e,\u0017N^3s)\t\u00116\u000b\u0005\u0002\u001f\u000f!)1*\u0003a\u0001\u0019\u0006\u0011\u0012N\u001c<bY&$\u0007*Z1eKJt\u0015-\\3t!\tie+\u0003\u0002X\u001d\n91i\\;oi\u0016\u0014\u0018aE5om\u0006d\u0017\u000e\u001a%fC\u0012,'OV1mk\u0016\u001c\u0018aC2iC:tW\r\u001c*fC\u0012$2a\u00170d!\t\u0011C,\u0003\u0002^G\t!QK\\5u\u0011\u0015yF\u00021\u0001a\u0003\r\u0019G\u000f\u001f\t\u0003\u0005\u0006L!AY\"\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")A\r\u0004a\u0001K\u0006\u0019Qn]4\u0011\u0005\t2\u0017BA4$\u0005\r\te._\u0001\u0014Q\u0006tG\r\\3EK\u000e|G-\u001a$bS2,(/\u001a\u000b\u00047*\\\u0007\"B0\u000e\u0001\u0004\u0001\u0007\"\u00027\u000e\u0001\u0004i\u0017aA8cUB\u0011an]\u0007\u0002_*\u00111\u0003\u001d\u0006\u0003cJ\fQaY8eK\u000eT!!E#\n\u0005Q|'A\u0003%uiB|%M[3di\u0006\u0019R\r_2faRLwN\u001c+p%\u0016\u001c\bo\u001c8tKR\u0011q\u000f \t\u0003qjl\u0011!\u001f\u0006\u0003'YI!a_=\u0003\u0011I+7\u000f]8og\u0016DQ! \bA\u0002y\f!!\u001a=\u0011\u0007}\fIA\u0004\u0003\u0002\u0002\u0005\u0015abA\u001c\u0002\u0004%\tA%C\u0002\u0002\b\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00055!!\u0003+ie><\u0018M\u00197f\u0015\r\t9a\t\u0015\u0004\u000f\u0005E\u0001\u0003BA\n\u0003KqA!!\u0006\u0002\"9!\u0011qCA\u0010\u001d\u0011\tI\"!\b\u000f\u0007]\nY\"C\u0001I\u0013\t1u)\u0003\u0002E\u000b&\u0019\u00111E\"\u0002\u001d\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe&!\u0011qEA\u0015\u0005!\u0019\u0006.\u0019:bE2,'bAA\u0012\u0007\u0002")
public class BadRequestHandler
extends ChannelInboundHandlerAdapter {
    private final Counter invalidHeaderNames;
    private final Counter invalidHeaderValues;

    public static String HandlerName() {
        return BadRequestHandler$.MODULE$.HandlerName();
    }

    public static Logger log() {
        return BadRequestHandler$.MODULE$.log();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpObject httpObject;
        Object object = msg;
        if (object instanceof HttpObject && (httpObject = (HttpObject)object).decoderResult().isFailure()) {
            ReferenceCountUtil.release((Object)httpObject);
            this.handleDecodeFailure(ctx, httpObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ctx.fireChannelRead(msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void handleDecodeFailure(ChannelHandlerContext ctx, HttpObject obj) {
        HttpObject httpObject = obj;
        if (httpObject instanceof HttpMessage) {
            Throwable failure = obj.decoderResult().cause();
            Response resp = this.exceptionToResponse(failure);
            FullHttpResponse nettyResp = Bijections$finagle$.MODULE$.fullResponseToNetty(resp);
            Throwable throwable = failure;
            if (throwable instanceof Rfc7230HeaderValidation.NameValidationException) {
                this.invalidHeaderNames.incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (throwable instanceof Rfc7230HeaderValidation.ValueValidationException) {
                this.invalidHeaderValues.incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ctx.writeAndFlush((Object)nettyResp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BadRequestHandler$.MODULE$.log().debug("Detected invalid trailing headers in the HTTP stream. Tearing down the connection.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Response exceptionToResponse(Throwable ex) {
        TooLongFrameException tooLongFrameException;
        Throwable throwable = ex;
        Response response = throwable instanceof TooLongFrameException ? ((tooLongFrameException = (TooLongFrameException)throwable).getMessage().startsWith("An HTTP line is larger than ") ? BadRequestResponse$.MODULE$.uriTooLong() : BadRequestResponse$.MODULE$.headerTooLong()) : BadRequestResponse$.MODULE$.apply();
        return response;
    }

    public BadRequestHandler(StatsReceiver stats) {
        this.invalidHeaderNames = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rejected_invalid_header_names"}));
        this.invalidHeaderValues = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rejected_invalid_header_values"}));
    }
}

