/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.http.param.AutomaticContinue;
import com.twitter.finagle.http.param.AutomaticContinue$;
import com.twitter.finagle.http.param.CompressionLevel;
import com.twitter.finagle.http.param.CompressionLevel$;
import com.twitter.finagle.http.param.Decompression;
import com.twitter.finagle.http.param.Decompression$;
import com.twitter.finagle.http.param.MaxHeaderSize;
import com.twitter.finagle.http.param.MaxHeaderSize$;
import com.twitter.finagle.http.param.MaxInitialLineSize;
import com.twitter.finagle.http.param.MaxInitialLineSize$;
import com.twitter.finagle.http.param.MaxRequestSize;
import com.twitter.finagle.http.param.MaxRequestSize$;
import com.twitter.finagle.http.param.MaxResponseSize;
import com.twitter.finagle.http.param.MaxResponseSize$;
import com.twitter.finagle.http.param.Streaming;
import com.twitter.finagle.http.param.Streaming$;
import com.twitter.finagle.netty4.Netty4Listener$;
import com.twitter.finagle.netty4.Netty4Transporter$;
import com.twitter.finagle.netty4.http.FinagleHttpObjectAggregator;
import com.twitter.finagle.netty4.http.TextualContentCompressor;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler$;
import com.twitter.finagle.netty4.http.handler.ClientExceptionMapper$;
import com.twitter.finagle.netty4.http.handler.FixedLengthMessageAggregator;
import com.twitter.finagle.netty4.http.handler.FixedLengthMessageAggregator$;
import com.twitter.finagle.netty4.http.handler.HeaderValidatorHandler$;
import com.twitter.finagle.netty4.http.handler.UnpoolHttpHandler$;
import com.twitter.finagle.netty4.http.handler.UriValidatorHandler$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.server.Listener;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.TransportContext;
import com.twitter.util.StorageUnit;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import java.io.Serializable;
import java.net.SocketAddress;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final String HttpCodecName = "httpCodec";
    private static final String Http2CodecName = "http2Codec";
    private static final String Http2MultiplexHandlerName = "Http2MultiplexHandler";
    private static final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit = (Function1 & Serializable)params -> (Function1 & Serializable)pipeline -> {
        package$.$anonfun$ClientPipelineInit$2(params, pipeline);
        return BoxedUnit.UNIT;
    };
    private static final Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object, TransportContext>>> Netty4HttpTransporter = (Function1 & Serializable)params -> (Function1 & Serializable)addr -> Netty4Transporter$.MODULE$.raw((Function1)MODULE$.ClientPipelineInit().apply(params), addr, params, ManifestFactory$.MODULE$.Any());
    private static final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit = (Function1 & Serializable)params -> (Function1 & Serializable)pipeline -> {
        package$.$anonfun$ServerPipelineInit$2(params, pipeline);
        return BoxedUnit.UNIT;
    };
    private static final Function1<Stack.Params, Listener<Object, Object, TransportContext>> Netty4HttpListener = (Function1 & Serializable)params -> Netty4Listener$.MODULE$.apply((Function1)MODULE$.ServerPipelineInit().apply(params), params, ManifestFactory$.MODULE$.Any(), ManifestFactory$.MODULE$.Any());

    public String HttpCodecName() {
        return HttpCodecName;
    }

    public String Http2CodecName() {
        return Http2CodecName;
    }

    public String Http2MultiplexHandlerName() {
        return Http2MultiplexHandlerName;
    }

    public HttpClientCodec newHttpClientCodec(Stack.Params params) {
        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)params.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
        StorageUnit maxHeaderSize = ((MaxHeaderSize)params.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
        return new HttpClientCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), Integer.MAX_VALUE, false, false);
    }

    public HttpServerCodec newHttpServerCodec(Stack.Params params) {
        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)params.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
        StorageUnit maxHeaderSize = ((MaxHeaderSize)params.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
        return new HttpServerCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), Integer.MAX_VALUE, false);
    }

    public Function1<ChannelPipeline, BoxedUnit> initClientBefore(String role, Stack.Params params) {
        return (Function1 & Serializable)pipeline -> {
            package$.MODULE$.initClientFn(params, (Function2<String, ChannelHandler, BoxedUnit>)(Function2 & Serializable)(x$1, x$2) -> {
                pipeline.addBefore(role$1, x$1, x$2);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
    }

    public Function1<ChannelPipeline, BoxedUnit> initClient(Stack.Params params) {
        return (Function1 & Serializable)pipeline -> {
            package$.MODULE$.initClientFn(params, (Function2<String, ChannelHandler, BoxedUnit>)(Function2 & Serializable)(x$3, x$4) -> {
                pipeline.addLast(x$3, x$4);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
    }

    public void initClientFn(Stack.Params params, Function2<String, ChannelHandler, BoxedUnit> fn) {
        StorageUnit maxResponseSize = ((MaxResponseSize)params.apply(MaxResponseSize$.MODULE$.maxResponseSizeParam())).size();
        boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
        Object object = decompressionEnabled ? fn.apply((Object)"httpDecompressor", (Object)new HttpContentDecompressor()) : BoxedUnit.UNIT;
        Streaming streaming = (Streaming)params.apply(Streaming$.MODULE$.streamingParam());
        if (streaming instanceof Streaming.Enabled) {
            Streaming.Enabled enabled = (Streaming.Enabled)streaming;
            StorageUnit fixedLengthStreamedAfter = enabled.fixedLengthStreamedAfter();
            BoxedUnit boxedUnit = (BoxedUnit)fn.apply((Object)"fixedLenAggregator", (Object)new FixedLengthMessageAggregator(fixedLengthStreamedAfter, FixedLengthMessageAggregator$.MODULE$.$lessinit$greater$default$2()));
        } else if (Streaming.Disabled$.MODULE$.equals(streaming)) {
            BoxedUnit boxedUnit = (BoxedUnit)fn.apply((Object)"httpDechunker", (Object)new HttpObjectAggregator((int)maxResponseSize.inBytes()));
        } else {
            throw new MatchError((Object)streaming);
        }
        fn.apply((Object)HeaderValidatorHandler$.MODULE$.HandlerName(), (Object)HeaderValidatorHandler$.MODULE$);
        fn.apply((Object)UriValidatorHandler$.MODULE$.HandlerName(), (Object)UriValidatorHandler$.MODULE$);
        fn.apply((Object)"clientExceptionMapper", (Object)ClientExceptionMapper$.MODULE$);
        fn.apply((Object)"unpoolHttp", (Object)UnpoolHttpHandler$.MODULE$);
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit() {
        return ClientPipelineInit;
    }

    public Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object, TransportContext>>> Netty4HttpTransporter() {
        return Netty4HttpTransporter;
    }

    public Function1<ChannelPipeline, BoxedUnit> initServer(Stack.Params params) {
        boolean autoContinue = ((AutomaticContinue)params.apply(AutomaticContinue$.MODULE$.automaticContinue())).enabled();
        StorageUnit maxRequestSize = ((MaxRequestSize)params.apply(MaxRequestSize$.MODULE$.maxRequestSizeParam())).size();
        boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
        int compressionLevel = ((CompressionLevel)params.apply(CompressionLevel$.MODULE$.compressionLevelParam())).level();
        StatsReceiver stats = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        BadRequestHandler badRequestHandler = new BadRequestHandler(stats);
        return (Function1 & Serializable)pipeline -> {
            package$.$anonfun$initServer$1(compressionLevel, decompressionEnabled, params, autoContinue, maxRequestSize, badRequestHandler, pipeline);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit() {
        return ServerPipelineInit;
    }

    public Function1<Stack.Params, Listener<Object, Object, TransportContext>> Netty4HttpListener() {
        return Netty4HttpListener;
    }

    public static final /* synthetic */ void $anonfun$ClientPipelineInit$2(Stack.Params params$3, ChannelPipeline pipeline) {
        pipeline.addLast(MODULE$.HttpCodecName(), (ChannelHandler)MODULE$.newHttpClientCodec(params$3));
        MODULE$.initClient(params$3).apply((Object)pipeline);
    }

    public static final /* synthetic */ void $anonfun$initServer$1(int compressionLevel$1, boolean decompressionEnabled$1, Stack.Params params$5, boolean autoContinue$1, StorageUnit maxRequestSize$1, BadRequestHandler badRequestHandler$1, ChannelPipeline pipeline) {
        ChannelPipeline channelPipeline;
        int n = compressionLevel$1;
        Object object = n > 0 ? pipeline.addLast("httpCompressor", (ChannelHandler)new HttpContentCompressor(n)) : (-1 == n ? pipeline.addLast("httpCompressor", (ChannelHandler)new TextualContentCompressor()) : BoxedUnit.UNIT);
        Object object2 = decompressionEnabled$1 ? pipeline.addLast("httpDecompressor", (ChannelHandler)new HttpContentDecompressor()) : BoxedUnit.UNIT;
        Streaming streaming = (Streaming)params$5.apply(Streaming$.MODULE$.streamingParam());
        if (streaming instanceof Streaming.Enabled) {
            Streaming.Enabled enabled = (Streaming.Enabled)streaming;
            StorageUnit fixedLengthStreamedAfter = enabled.fixedLengthStreamedAfter();
            Object object3 = autoContinue$1 ? pipeline.addLast("expectContinue", (ChannelHandler)new HttpServerExpectContinueHandler()) : BoxedUnit.UNIT;
            channelPipeline = pipeline.addLast("fixedLenAggregator", (ChannelHandler)new FixedLengthMessageAggregator(fixedLengthStreamedAfter, false));
        } else if (Streaming.Disabled$.MODULE$.equals(streaming)) {
            channelPipeline = pipeline.addLast("httpDechunker", (ChannelHandler)new FinagleHttpObjectAggregator((int)maxRequestSize$1.inBytes(), autoContinue$1));
        } else {
            throw new MatchError((Object)streaming);
        }
        pipeline.addLast(UriValidatorHandler$.MODULE$.HandlerName(), (ChannelHandler)UriValidatorHandler$.MODULE$);
        pipeline.addLast(HeaderValidatorHandler$.MODULE$.HandlerName(), (ChannelHandler)HeaderValidatorHandler$.MODULE$);
        pipeline.addLast(BadRequestHandler$.MODULE$.HandlerName(), (ChannelHandler)badRequestHandler$1);
        pipeline.addLast("unpoolHttp", (ChannelHandler)UnpoolHttpHandler$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$ServerPipelineInit$2(Stack.Params params$6, ChannelPipeline pipeline) {
        pipeline.addLast(MODULE$.HttpCodecName(), (ChannelHandler)MODULE$.newHttpServerCodec(params$6));
        MODULE$.initServer(params$6).apply((Object)pipeline);
    }

    private package$() {
    }
}

