/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4;

import com.twitter.finagle.CancelledConnectionException;
import com.twitter.finagle.ConnectionFailedException;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.ProxyConnectException;
import com.twitter.finagle.Stack;
import com.twitter.finagle.client.LatencyCompensation;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.netty4.Netty4Transporter;
import com.twitter.finagle.netty4.Netty4Transporter$Backpressure$;
import com.twitter.finagle.netty4.nativeEpoll$;
import com.twitter.finagle.netty4.param.Allocator;
import com.twitter.finagle.netty4.param.Allocator$;
import com.twitter.finagle.netty4.param.WorkerPool;
import com.twitter.finagle.netty4.param.WorkerPool$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.Transport;
import com.twitter.logging.Level;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0007\u0017\t\t2i\u001c8oK\u000e$\u0018n\u001c8Ck&dG-\u001a:\u000b\u0005\r!\u0011A\u00028fiRLHG\u0003\u0002\u0006\r\u00059a-\u001b8bO2,'BA\u0004\t\u0003\u001d!x/\u001b;uKJT\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\t%t\u0017\u000e\u001e\t\u0004+qqR\"\u0001\f\u000b\u0005]A\u0012aB2iC:tW\r\u001c\u0006\u00033i\tQA\\3uifT\u0011aG\u0001\u0003S>L!!\b\f\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\t\u0003+}I!\u0001\t\f\u0003\u000f\rC\u0017M\u001c8fY\"A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0003bI\u0012\u0014\bC\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\rqW\r\u001e\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSEA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u00051\u0001/\u0019:b[N\u0004\"A\f\u001a\u000f\u0005=\u0002T\"\u0001\u0003\n\u0005E\"\u0011!B*uC\u000e\\\u0017BA\u001a5\u0005\u0019\u0001\u0016M]1ng*\u0011\u0011\u0007\u0002\u0005\u0006m\u0001!\taN\u0001\u0007y%t\u0017\u000e\u001e \u0015\taR4\b\u0010\t\u0003s\u0001i\u0011A\u0001\u0005\u0006'U\u0002\r\u0001\u0006\u0005\u0006EU\u0002\ra\t\u0005\u0006YU\u0002\r!\f\u0005\u0007}\u0001\u0001\u000b\u0011B \u0002\u001bM$\u0018\r^:SK\u000e,\u0017N^3s!\t\u00015)D\u0001B\u0015\t\u0011E!A\u0003ti\u0006$8/\u0003\u0002E\u0003\ni1\u000b^1ugJ+7-Z5wKJDaA\u0012\u0001!\u0002\u00139\u0015AE2p]:,7\r\u001e'bi\u0016t7-_*uCR\u0004\"\u0001\u0011%\n\u0005%\u000b%\u0001B*uCRDaa\u0013\u0001!\u0002\u00139\u0015\u0001\u00074bS2,GmQ8o]\u0016\u001cG\u000fT1uK:\u001c\u0017p\u0015;bi\"1Q\n\u0001Q\u0001\n9\u000b\u0011cY1oG\u0016dG.\u001a3D_:tWm\u0019;t!\t\u0001u*\u0003\u0002Q\u0003\n91i\\;oi\u0016\u0014\b\"\u0002*\u0001\t\u0003\u0019\u0016!\u00022vS2$WC\u0001+^)\t)f\rE\u0002W3nk\u0011a\u0016\u0006\u00031\u001a\tA!\u001e;jY&\u0011!l\u0016\u0002\u0007\rV$XO]3\u0011\u0005qkF\u0002\u0001\u0003\u0006=F\u0013\ra\u0018\u0002\u0002)F\u0011\u0001m\u0019\t\u0003\u001b\u0005L!A\u0019\b\u0003\u000f9{G\u000f[5oOB\u0011Q\u0002Z\u0005\u0003K:\u00111!\u00118z\u0011\u00159\u0017\u000b1\u0001i\u0003\u001d\u0011W/\u001b7eKJ\u0004B!D5\u001f+&\u0011!N\u0004\u0002\n\rVt7\r^5p]F\u0002")
public final class ConnectionBuilder {
    private final ChannelInitializer<Channel> init;
    public final SocketAddress com$twitter$finagle$netty4$ConnectionBuilder$$addr;
    private final Stack.Params params;
    private final StatsReceiver statsReceiver;
    public final Stat com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat;
    public final Stat com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat;
    public final Counter com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects;

    public <T> Future<T> build(Function1<Channel, Future<T>> builder) {
        Transport.Options options = (Transport.Options)this.params.apply(Transport.Options$.MODULE$.param());
        if (options != null) {
            Tuple2.mcZZ.sp sp2;
            boolean noDelay = options.noDelay();
            boolean reuseAddr = options.reuseAddr();
            Tuple2.mcZZ.sp sp3 = sp2 = new Tuple2.mcZZ.sp(noDelay, reuseAddr);
            boolean noDelay2 = sp3._1$mcZ$sp();
            boolean reuseAddr2 = sp3._2$mcZ$sp();
            LatencyCompensation.Compensation compensation = (LatencyCompensation.Compensation)this.params.apply(LatencyCompensation.Compensation$.MODULE$.param());
            if (compensation != null) {
                Duration compensation2;
                Duration duration;
                Duration compensation3 = duration = (compensation2 = compensation.howlong());
                Transporter.ConnectTimeout connectTimeout = (Transporter.ConnectTimeout)this.params.apply(Transporter.ConnectTimeout$.MODULE$.param());
                if (connectTimeout != null) {
                    Duration connectTimeout2;
                    Duration duration2;
                    Duration connectTimeout3 = duration2 = (connectTimeout2 = connectTimeout.howlong());
                    Transport.BufferSizes bufferSizes = (Transport.BufferSizes)this.params.apply(Transport.BufferSizes$.MODULE$.param());
                    if (bufferSizes != null) {
                        Tuple2 tuple2;
                        Option sendBufSize = bufferSizes.send();
                        Option recvBufSize = bufferSizes.recv();
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)sendBufSize, (Object)recvBufSize);
                        Option sendBufSize2 = (Option)tuple22._1();
                        Option recvBufSize2 = (Option)tuple22._2();
                        Netty4Transporter.Backpressure backpressure = (Netty4Transporter.Backpressure)this.params.apply(Netty4Transporter$Backpressure$.MODULE$.param());
                        if (backpressure != null) {
                            boolean backpressure2;
                            boolean bl;
                            boolean backpressure3 = bl = (backpressure2 = backpressure.backpressure());
                            Allocator allocator = (Allocator)this.params.apply(Allocator$.MODULE$.allocatorParam());
                            if (allocator != null) {
                                ByteBufAllocator allocator2;
                                ByteBufAllocator byteBufAllocator;
                                ByteBufAllocator allocator3 = byteBufAllocator = (allocator2 = allocator.allocator());
                                long compensatedConnectTimeoutMs = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(compensation3.$plus(connectTimeout3).inMillis()), Integer.MAX_VALUE);
                                Class channelClass = nativeEpoll$.MODULE$.enabled() ? EpollSocketChannel.class : NioSocketChannel.class;
                                Bootstrap bootstrap = (Bootstrap)new Bootstrap().group(((WorkerPool)this.params.apply(WorkerPool$.MODULE$.workerPoolParam())).eventLoopGroup()).channel(channelClass).option(ChannelOption.ALLOCATOR, (Object)allocator3).option(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(noDelay2)).option(ChannelOption.SO_REUSEADDR, (Object)Predef$.MODULE$.boolean2Boolean(reuseAddr2)).option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(!backpressure3)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Predef$.MODULE$.int2Integer((int)compensatedConnectTimeoutMs)).handler(this.init);
                                Transport.Liveness liveness = (Transport.Liveness)this.params.apply(Transport.Liveness$.MODULE$.param());
                                if (liveness != null) {
                                    Option keepAlive;
                                    Option option;
                                    Option keepAlive2 = option = (keepAlive = liveness.keepAlive());
                                    keepAlive2.foreach((Function1)new Serializable(this, bootstrap){
                                        public static final long serialVersionUID = 0L;
                                        private final Bootstrap bootstrap$1;

                                        public final Bootstrap apply(boolean x$3) {
                                            return (Bootstrap)this.bootstrap$1.option(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(x$3));
                                        }
                                        {
                                            this.bootstrap$1 = bootstrap$1;
                                        }
                                    });
                                    sendBufSize2.foreach((Function1)new Serializable(this, bootstrap){
                                        public static final long serialVersionUID = 0L;
                                        private final Bootstrap bootstrap$1;

                                        public final Bootstrap apply(int x$4) {
                                            return (Bootstrap)this.bootstrap$1.option(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(x$4));
                                        }
                                        {
                                            this.bootstrap$1 = bootstrap$1;
                                        }
                                    });
                                    recvBufSize2.foreach((Function1)new Serializable(this, bootstrap){
                                        public static final long serialVersionUID = 0L;
                                        private final Bootstrap bootstrap$1;

                                        public final Bootstrap apply(int x$5) {
                                            return (Bootstrap)this.bootstrap$1.option(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(x$5));
                                        }
                                        {
                                            this.bootstrap$1 = bootstrap$1;
                                        }
                                    });
                                    Function0 elapsed = Stopwatch$.MODULE$.start();
                                    ChannelFuture nettyConnectF = bootstrap.connect(this.com$twitter$finagle$netty4$ConnectionBuilder$$addr);
                                    Promise transportP = new Promise();
                                    transportP.setInterruptHandler((PartialFunction)new Serializable(this, nettyConnectF){
                                        public static final long serialVersionUID = 0L;
                                        private final ChannelFuture nettyConnectF$1;

                                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                            A1 A1 = x1;
                                            this.nettyConnectF$1.cancel(true);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return (B1)boxedUnit;
                                        }

                                        public final boolean isDefinedAt(Throwable x1) {
                                            Throwable throwable = x1;
                                            boolean bl = true;
                                            return bl;
                                        }
                                        {
                                            this.nettyConnectF$1 = nettyConnectF$1;
                                        }
                                    });
                                    nettyConnectF.addListener((GenericFutureListener)new ChannelFutureListener(this, builder, elapsed, transportP){
                                        private final /* synthetic */ ConnectionBuilder $outer;
                                        private final Function1 builder$1;
                                        private final Function0 elapsed$1;
                                        private final Promise transportP$1;

                                        /*
                                         * Enabled aggressive block sorting
                                         * Enabled unnecessary exception pruning
                                         * Enabled aggressive exception aggregation
                                         */
                                        public void operationComplete(ChannelFuture channelF) {
                                            Future future;
                                            Channel ch;
                                            long latency = ((TimeLike)this.elapsed$1.apply()).inMilliseconds();
                                            if (channelF.isCancelled()) {
                                                this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects.incr();
                                                this.transportP$1.setException((Throwable)Failure$.MODULE$.apply((Throwable)new CancelledConnectionException(), Failure$.MODULE$.Interrupted() | Failure$.MODULE$.Restartable(), (Level)Level.DEBUG$.MODULE$));
                                                return;
                                            }
                                            if (channelF.cause() == null) {
                                                if (!channelF.channel().isOpen()) {
                                                    this.transportP$1.setException((Throwable)Failure$.MODULE$.rejected("Netty4 Channel was found in a closed state"));
                                                    return;
                                                }
                                                this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat.add((float)latency);
                                                ch = channelF.channel();
                                                try {
                                                    future = (Future)this.builder$1.apply((Object)ch);
                                                }
                                                catch (Throwable throwable2) {
                                                    Future future2;
                                                    Throwable throwable22 = throwable2;
                                                    Option option = NonFatal$.MODULE$.unapply(throwable22);
                                                    if (option.isEmpty()) {
                                                        throw throwable2;
                                                    }
                                                    Throwable t = (Throwable)option.get();
                                                    ch.close();
                                                    future = future2 = Future$.MODULE$.exception(t);
                                                }
                                            } else {
                                                UnresolvedAddressException unresolvedAddressException;
                                                this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat.add((float)latency);
                                                Throwable throwable = channelF.cause();
                                                if (throwable instanceof UnresolvedAddressException) {
                                                    UnresolvedAddressException unresolvedAddressException2;
                                                    unresolvedAddressException = unresolvedAddressException2 = (UnresolvedAddressException)throwable;
                                                } else if (throwable instanceof ProxyConnectException) {
                                                    ProxyConnectException proxyConnectException = (ProxyConnectException)throwable;
                                                    unresolvedAddressException = proxyConnectException;
                                                } else {
                                                    Option option = NonFatal$.MODULE$.unapply(throwable);
                                                    if (option.isEmpty()) {
                                                        throw new MatchError((Object)throwable);
                                                    }
                                                    Throwable e = (Throwable)option.get();
                                                    unresolvedAddressException = Failure$.MODULE$.rejected((Throwable)new ConnectionFailedException(e, this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$addr));
                                                }
                                                this.transportP$1.setException((Throwable)unresolvedAddressException);
                                                return;
                                            }
                                            Future result = future;
                                            result.proxyTo(this.transportP$1);
                                            this.transportP$1.setInterruptHandler((PartialFunction)new Serializable(this, ch, result){
                                                public static final long serialVersionUID = 0L;
                                                private final Channel ch$1;
                                                private final Future result$1;

                                                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                                    A1 A1 = x2;
                                                    this.ch$1.close();
                                                    this.result$1.raise(A1);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    return (B1)boxedUnit;
                                                }

                                                public final boolean isDefinedAt(Throwable x2) {
                                                    Throwable throwable = x2;
                                                    boolean bl = true;
                                                    return bl;
                                                }
                                                {
                                                    this.ch$1 = ch$1;
                                                    this.result$1 = result$1;
                                                }
                                            });
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.builder$1 = builder$1;
                                            this.elapsed$1 = elapsed$1;
                                            this.transportP$1 = transportP$1;
                                        }
                                    });
                                    return transportP;
                                }
                                throw new MatchError((Object)liveness);
                            }
                            throw new MatchError((Object)allocator);
                        }
                        throw new MatchError((Object)backpressure);
                    }
                    throw new MatchError((Object)bufferSizes);
                }
                throw new MatchError((Object)connectTimeout);
            }
            throw new MatchError((Object)compensation);
        }
        throw new MatchError((Object)options);
    }

    public ConnectionBuilder(ChannelInitializer<Channel> init, SocketAddress addr, Stack.Params params) {
        this.init = init;
        this.com$twitter$finagle$netty4$ConnectionBuilder$$addr = addr;
        this.params = params;
        Stats stats = (Stats)params.apply(Stats$.MODULE$.param());
        if (stats != null) {
            StatsReceiver statsReceiver;
            StatsReceiver statsReceiver2;
            this.statsReceiver = statsReceiver2 = (statsReceiver = stats.statsReceiver());
            this.com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat = this.statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connect_latency_ms"}));
            this.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat = this.statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed_connect_latency_ms"}));
            this.com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects = this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cancelled_connects"}));
            return;
        }
        throw new MatchError((Object)stats);
    }
}

