/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.IOExceptionStrings$;
import com.twitter.finagle.ReadTimedOutException;
import com.twitter.finagle.WriteTimedOutException;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001)4Q!\u0001\u0002\u0001\t1\u0011qc\u00115b]:,G.\u0012=dKB$\u0018n\u001c8IC:$G.\u001a:\u000b\u0005\r!\u0011aB2iC:tW\r\u001c\u0006\u0003\u000b\u0019\taA\\3uif$$BA\u0004\t\u0003\u001d1\u0017N\\1hY\u0016T!!\u0003\u0006\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1\"A\u0002d_6\u001c\"\u0001A\u0007\u0011\u00059!R\"A\b\u000b\u0005\r\u0001\"BA\t\u0013\u0003\u0015qW\r\u001e;z\u0015\u0005\u0019\u0012AA5p\u0013\t)rB\u0001\u000fDQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:BI\u0006\u0004H/\u001a:\t\u0011]\u0001!\u0011!Q\u0001\ne\tQa\u001d;biN\u001c\u0001\u0001\u0005\u0002\u001b95\t1D\u0003\u0002\u0018\r%\u0011Qd\u0007\u0002\u000e'R\fGo\u001d*fG\u0016Lg/\u001a:\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n1\u0001\\8h!\t\t\u0003&D\u0001#\u0015\t\u0019C%A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u00152\u0013\u0001B;uS2T\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*E\t1Aj\\4hKJDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDcA\u00170aA\u0011a\u0006A\u0007\u0002\u0005!)qC\u000ba\u00013!)qD\u000ba\u0001A!1!\u0007\u0001Q\u0001\nM\n!C]3bIRKW.Z8vi\u000e{WO\u001c;feB\u0011!\u0004N\u0005\u0003km\u0011qaQ8v]R,'\u000f\u0003\u00048\u0001\u0001\u0006IaM\u0001\u0014oJLG/\u001a+j[\u0016|W\u000f^\"pk:$XM\u001d\u0005\u0007s\u0001\u0001K\u0011\u0002\u001e\u0002\u0011M,g/\u001a:jif$\"a\u000f \u0011\u0005\u0005b\u0014BA\u001f#\u0005\u0015aUM^3m\u0011\u0015y\u0004\b1\u0001A\u0003\r)\u0007p\u0019\t\u0003\u0003.s!A\u0011%\u000f\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0012A\u0002\u001fs_>$h(C\u0001H\u0003\u0015\u00198-\u00197b\u0013\tI%*A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u001dK!\u0001T'\u0003\u0013QC'o\\<bE2,'BA%K\u0011\u0015y\u0005\u0001\"\u0011Q\u0003=)\u0007pY3qi&|gnQ1vO\"$HcA)V5B\u0011!kU\u0007\u0002\u0015&\u0011AK\u0013\u0002\u0005+:LG\u000fC\u0003W\u001d\u0002\u0007q+A\u0002dib\u0004\"A\u0004-\n\u0005e{!!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u00067:\u0003\r\u0001Q\u0001\u0002i\"\u0012\u0001!\u0018\t\u0003=\u001et!aX3\u000f\u0005\u0001$gBA1d\u001d\t\u0019%-C\u0001\u0014\u0013\t\t\"#\u0003\u0002\u0004!%\u0011amD\u0001\u000f\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0013\tA\u0017N\u0001\u0005TQ\u0006\u0014\u0018M\u00197f\u0015\t1w\u0002")
public class ChannelExceptionHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log;
    private final Counter readTimeoutCounter;
    private final Counter writeTimeoutCounter;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private java.util.logging.Level severity(Throwable exc) {
        void var4_8;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure = (Failure)throwable;
            Level level = failure.logLevel();
            return var4_8;
        }
        boolean bl = throwable instanceof ClosedChannelException ? true : (throwable instanceof SSLException ? true : (throwable instanceof ReadTimeoutException ? true : (throwable instanceof WriteTimeoutException ? true : throwable instanceof SSLException)));
        if (bl) {
            java.util.logging.Level level = java.util.logging.Level.FINEST;
            return var4_8;
        }
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            if (IOExceptionStrings$.MODULE$.FinestIOExceptionMessages().contains((Object)iOException.getMessage())) {
                java.util.logging.Level level = java.util.logging.Level.FINEST;
                return var4_8;
            }
        }
        java.util.logging.Level level = java.util.logging.Level.WARNING;
        return var4_8;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        Throwable throwable;
        Throwable throwable2 = t;
        if (throwable2 instanceof ReadTimeoutException) {
            this.readTimeoutCounter.incr();
            throwable = new ReadTimedOutException(ctx.channel().remoteAddress());
        } else if (throwable2 instanceof WriteTimeoutException) {
            this.writeTimeoutCounter.incr();
            throwable = new WriteTimedOutException(ctx.channel().remoteAddress());
        } else {
            throwable = throwable2;
        }
        Throwable wrappedException = throwable;
        String remoteAddr = (String)Option$.MODULE$.apply((Object)ctx.channel().remoteAddress()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SocketAddress x$1) {
                return x$1.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown remote address";
            }
        });
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled exception in connection with ", ", shutting down connection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{remoteAddr}));
        this.log.log(this.severity(t), msg, t);
        super.exceptionCaught(ctx, wrappedException);
    }

    public ChannelExceptionHandler(StatsReceiver stats, Logger log) {
        this.log = log;
        this.readTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_timeout"}));
        this.writeTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write_timeout"}));
    }
}

