/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.Verbosity$;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.TimeoutException;
import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\u0005q!B\u0001\u0003\u0011\u0013i\u0011aE\"iC:tW\r\\*uCR\u001c\b*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0019\u0007.\u00198oK2T!!\u0002\u0004\u0002\r9,G\u000f^=5\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0005#\t\u00192\t[1o]\u0016d7\u000b^1ug\"\u000bg\u000e\u001a7feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%I!H\u0001\u0004Y><W#\u0001\u0010\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003G\u0011\nA!\u001e;jY*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014!\u0005\u0019aunZ4fe\"1\u0011f\u0004Q\u0001\ny\tA\u0001\\8hA\u0019!1f\u0004\u0001-\u0005I\u0019\u0006.\u0019:fI\u000eC\u0017M\u001c8fYN#\u0018\r^:\u0014\u0005)\u0012\u0002\u0002\u0003\u0018+\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u001bM$\u0018\r^:SK\u000e,\u0017N^3s!\t\u00014'D\u00012\u0015\t\u0011d!A\u0003ti\u0006$8/\u0003\u00025c\ti1\u000b^1ugJ+7-Z5wKJDQ!\u0007\u0016\u0005\u0002Y\"\"aN\u001d\u0011\u0005aRS\"A\b\t\u000b9*\u0004\u0019A\u0018\t\u000fmR#\u0019!C\u0005y\u0005y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG/F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0005\n\n!bY8oGV\u0014(/\u001a8u\u0013\t!uHA\u0005M_:<\u0017\t\u001a3fe\"1aI\u000bQ\u0001\nu\n\u0001cY8o]\u0016\u001cG/[8o\u0007>,h\u000e\u001e\u0011\t\u000b!SC\u0011A%\u00021\r|gN\\3di&|gnQ8v]RLen\u0019:f[\u0016tG\u000fF\u0001K!\t\u00192*\u0003\u0002M)\t!QK\\5u\u0011\u0015q%\u0006\"\u0001J\u0003a\u0019wN\u001c8fGRLwN\\\"pk:$H)Z2sK6,g\u000e\u001e\u0005\b!*\u0012\r\u0011\"\u0001R\u0003!\u0019wN\u001c8fGR\u001cX#\u0001*\u0011\u0005A\u001a\u0016B\u0001+2\u0005\u001d\u0019u.\u001e8uKJDaA\u0016\u0016!\u0002\u0013\u0011\u0016!C2p]:,7\r^:!\u0011\u001dA&F1A\u0005\u0002e\u000b!cY8o]\u0016\u001cG/[8o\tV\u0014\u0018\r^5p]V\t!\f\u0005\u000217&\u0011A,\r\u0002\u0005'R\fG\u000f\u0003\u0004_U\u0001\u0006IAW\u0001\u0014G>tg.Z2uS>tG)\u001e:bi&|g\u000e\t\u0005\bA*\u0012\r\u0011\"\u0001Z\u0003]\u0019wN\u001c8fGRLwN\u001c*fG\u0016Lg/\u001a3CsR,7\u000f\u0003\u0004cU\u0001\u0006IAW\u0001\u0019G>tg.Z2uS>t'+Z2fSZ,GMQ=uKN\u0004\u0003b\u00023+\u0005\u0004%\t!W\u0001\u0014G>tg.Z2uS>t7+\u001a8u\u0005f$Xm\u001d\u0005\u0007M*\u0002\u000b\u0011\u0002.\u0002)\r|gN\\3di&|gnU3oi\nKH/Z:!\u0011\u001dA'F1A\u0005\u0002E\u000b\u0001b\u001e:ji\u0006\u0014G.\u001a\u0005\u0007U*\u0002\u000b\u0011\u0002*\u0002\u0013]\u0014\u0018\u000e^1cY\u0016\u0004\u0003b\u00027+\u0005\u0004%\t!U\u0001\u000bk:<(/\u001b;bE2,\u0007B\u00028+A\u0003%!+A\u0006v]^\u0014\u0018\u000e^1cY\u0016\u0004\u0003b\u00029+\u0005\u0004%\t!U\u0001\u000ee\u0016\u001cW-\u001b<fI\nKH/Z:\t\rIT\u0003\u0015!\u0003S\u00039\u0011XmY3jm\u0016$')\u001f;fg\u0002Bq\u0001\u001e\u0016C\u0002\u0013\u0005\u0011+A\u0005tK:$()\u001f;fg\"1aO\u000bQ\u0001\nI\u000b!b]3oi\nKH/Z:!\u0011\u001dA(F1A\u0005\u0002e\f!\"\u001a=dKB$\u0018n\u001c8t+\u0005y\u0003BB>+A\u0003%q&A\u0006fq\u000e,\u0007\u000f^5p]N\u0004\u0003bB?+\u0005\u0004%\t!U\u0001\fG2|7/Z:D_VtG\u000f\u0003\u0004\u0000U\u0001\u0006IAU\u0001\rG2|7/Z:D_VtG\u000f\t\u0005\n\u0003\u0007Q#\u0019!C\u0005\u0003\u000b\t1bY8o]\u0016\u001cG/[8ogV\u0011\u0011q\u0001\t\u0004a\u0005%\u0011bAA\u0006c\t)q)Y;hK\"A\u0011q\u0002\u0016!\u0002\u0013\t9!\u0001\u0007d_:tWm\u0019;j_:\u001c\bEB\u0003\u0011\u0005\u0011\t\u0019b\u0005\u0003\u0002\u0012\u0005U\u0001\u0003BA\f\u0003Gi!!!\u0007\u000b\u0007\r\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!\u00028fiRL(BAA\u0011\u0003\tIw.\u0003\u0003\u0002&\u0005e!\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'\u000fC\u0006\u0002*\u0005E!\u0011!Q\u0001\n\u0005-\u0012AE:iCJ,Gm\u00115b]:,Gn\u0015;biN\u00042!!\f+\u001d\r\ty\u0003\u0001\b\u0005\u0003c\t9E\u0004\u0003\u00024\u0005\u0015c\u0002BA\u001b\u0003\u0007rA!a\u000e\u0002B9!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t!9\u0011$!\u0005\u0005\u0002\u0005-C\u0003BA'\u0003\u001f\u00022ADA\t\u0011!\tI#!\u0013A\u0002\u0005-\u0002\u0002DA*\u0003#\u0001\r\u0011!Q!\n\u0005U\u0013\u0001E2iC:tW\r\u001c\"zi\u0016\u001c(+Z1e!\r\u0019\u0012qK\u0005\u0004\u00033\"\"\u0001\u0002'p]\u001eDA\"!\u0018\u0002\u0012\u0001\u0007\t\u0011)Q\u0005\u0003+\n1c\u00195b]:,GNQ=uKN<&/\u001b;uK:D1\u0002WA\t\u0001\u0004\u0005\t\u0015)\u0003\u0002bA!\u00111MA7\u001d\u0011\t)'!\u001b\u000e\u0005\u0005\u001d$BA\u0012\t\u0013\u0011\tY'a\u001a\u0002\u0013M#x\u000e]<bi\u000eD\u0017\u0002BA8\u0003c\u0012q!\u00127baN,G-\u0003\u0003\u0002t\u0005\u001d$!C*u_B<\u0018\r^2i\u00111\t9(!\u0005A\u0002\u0003\u0005\u000b\u0015BA=\u0003I\u0019\u0007.\u00198oK2<\u0016m],sSR\f'\r\\3\u0011\u0007M\tY(C\u0002\u0002~Q\u0011qAQ8pY\u0016\fg\u000e\u0003\u0007\u0002\u0002\u0006E\u0001\u0019!A!B\u0013\t\t'A\fdQ\u0006tg.\u001a7Xe&$\u0018M\u00197f\tV\u0014\u0018\r^5p]\"I\u0011QQA\tA\u0003&\u0011\u0011P\u0001\u000eG\"\fgN\\3m\u0003\u000e$\u0018N^3\t\u0011\u0005%\u0015\u0011\u0003C!\u0003\u0017\u000bA\u0002[1oI2,'/\u00113eK\u0012$2ASAG\u0011!\ty)a\"A\u0002\u0005E\u0015aA2uqB!\u0011qCAJ\u0013\u0011\t)*!\u0007\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\"A\u0011QQA\t\t\u0003\nI\nF\u0002K\u00037C\u0001\"a$\u0002\u0018\u0002\u0007\u0011\u0011\u0013\u0005\t\u0003?\u000b\t\u0002\"\u0011\u0002\"\u0006)qO]5uKR9!*a)\u0002&\u0006U\u0006\u0002CAH\u0003;\u0003\r!!%\t\u0011\u0005\u001d\u0016Q\u0014a\u0001\u0003S\u000b1!\\:h!\u0011\tY+!-\u000e\u0005\u00055&bAAXI\u0005!A.\u00198h\u0013\u0011\t\u0019,!,\u0003\r=\u0013'.Z2u\u0011!\t9,!(A\u0002\u0005e\u0016!\u00019\u0011\t\u0005]\u00111X\u0005\u0005\u0003{\u000bIB\u0001\bDQ\u0006tg.\u001a7Qe>l\u0017n]3\t\u0011\u0005\u0005\u0017\u0011\u0003C!\u0003\u0007\f1b\u00195b]:,GNU3bIR)!*!2\u0002H\"A\u0011qRA`\u0001\u0004\t\t\n\u0003\u0005\u0002(\u0006}\u0006\u0019AAU\u0011!\tY-!\u0005\u0005B\u00055\u0017!B2m_N,G#\u0002&\u0002P\u0006E\u0007\u0002CAH\u0003\u0013\u0004\r!!%\t\u0011\u0005]\u0016\u0011\u001aa\u0001\u0003sC\u0001\"!6\u0002\u0012\u0011\u0005\u0013q[\u0001\u0010G\"\fgN\\3m\u0013:\f7\r^5wKR\u0019!*!7\t\u0011\u0005=\u00151\u001ba\u0001\u0003#C\u0001\"!8\u0002\u0012\u0011\u0005\u0013q\\\u0001\u0010Kb\u001cW\r\u001d;j_:\u001c\u0015-^4iiR)!*!9\u0002d\"A\u0011qRAn\u0001\u0004\t\t\n\u0003\u0005\u0002f\u0006m\u0007\u0019AAt\u0003\u0015\u0019\u0017-^:f!\u0011\tI/a=\u000f\t\u0005-\u0018q\u001e\b\u0005\u0003s\ti/C\u0001\u0016\u0013\r\t\t\u0010F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)0a>\u0003\u0013QC'o\\<bE2,'bAAy)!A\u00111`A\t\t\u0003\ni0A\rdQ\u0006tg.\u001a7Xe&$\u0018MY5mSRL8\t[1oO\u0016$Gc\u0001&\u0002\u0000\"A\u0011qRA}\u0001\u0004\t\t\n")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final SharedChannelStats sharedChannelStats;
    private long channelBytesRead;
    private long channelBytesWritten;
    private Function0<Duration> connectionDuration;
    private boolean channelWasWritable;
    private Function0<Duration> channelWritableDuration;
    private boolean channelActive;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.channelBytesRead = 0L;
        this.channelBytesWritten = 0L;
        this.channelWasWritable = true;
        this.channelWritableDuration = Stopwatch$.MODULE$.start();
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.sharedChannelStats.connects().incr();
        this.sharedChannelStats.connectionCountIncrement();
        this.connectionDuration = Stopwatch$.MODULE$.start();
        this.channelActive = true;
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.sentBytes().incr((long)readableBytes);
            this.channelBytesWritten += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder().append((Object)"ChannelStatsHandler received non-ByteBuf write: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.receivedBytes().incr((long)readableBytes);
            this.channelBytesRead += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder().append((Object)"ChannelStatsHandler received non-ByteBuf read: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.sharedChannelStats.closesCount().incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channelActive) {
            long oldChannelBytesRead = this.channelBytesRead;
            long oldChannelBytesWritten = this.channelBytesWritten;
            this.channelBytesRead = 0L;
            this.channelBytesWritten = 0L;
            this.sharedChannelStats.connectionReceivedBytes().add((float)oldChannelBytesRead);
            this.sharedChannelStats.connectionSentBytes().add((float)oldChannelBytesWritten);
            Function0<Duration> oldConnectionDuration = this.connectionDuration;
            this.connectionDuration = null;
            Function0<Duration> function0 = oldConnectionDuration;
            if (function0 == null) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.sharedChannelStats.connectionDuration().add((float)((TimeLike)function0.apply()).inMilliseconds());
                this.sharedChannelStats.connectionCountDecrement();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            super.channelInactive(ctx);
        }
        this.channelActive = false;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.sharedChannelStats.exceptions().counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof TimeoutException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != this.channelWasWritable) {
            Duration elapsed = (Duration)this.channelWritableDuration.apply();
            Counter stat = this.channelWasWritable ? this.sharedChannelStats.writable() : this.sharedChannelStats.unwritable();
            stat.incr((long)((int)elapsed.inMilliseconds()));
            this.channelWasWritable = isWritable;
            this.channelWritableDuration = Stopwatch$.MODULE$.start();
        }
        super.channelWritabilityChanged(ctx);
    }

    public ChannelStatsHandler(SharedChannelStats sharedChannelStats) {
        this.sharedChannelStats = sharedChannelStats;
        this.channelActive = false;
    }

    public static class SharedChannelStats {
        private final LongAdder com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount = new LongAdder();
        private final Counter connects;
        private final Stat connectionDuration;
        private final Stat connectionReceivedBytes;
        private final Stat connectionSentBytes;
        private final Counter writable;
        private final Counter unwritable;
        private final Counter receivedBytes;
        private final Counter sentBytes;
        private final StatsReceiver exceptions;
        private final Counter closesCount;
        private final Gauge connections;

        public LongAdder com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount() {
            return this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount;
        }

        public void connectionCountIncrement() {
            this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount().increment();
        }

        public void connectionCountDecrement() {
            this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount().decrement();
        }

        public Counter connects() {
            return this.connects;
        }

        public Stat connectionDuration() {
            return this.connectionDuration;
        }

        public Stat connectionReceivedBytes() {
            return this.connectionReceivedBytes;
        }

        public Stat connectionSentBytes() {
            return this.connectionSentBytes;
        }

        public Counter writable() {
            return this.writable;
        }

        public Counter unwritable() {
            return this.unwritable;
        }

        public Counter receivedBytes() {
            return this.receivedBytes;
        }

        public Counter sentBytes() {
            return this.sentBytes;
        }

        public StatsReceiver exceptions() {
            return this.exceptions;
        }

        public Counter closesCount() {
            return this.closesCount;
        }

        private Gauge connections() {
            return this.connections;
        }

        public SharedChannelStats(StatsReceiver statsReceiver) {
            this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
            this.connectionDuration = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
            this.connectionReceivedBytes = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
            this.connectionSentBytes = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
            this.writable = statsReceiver.counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
            this.unwritable = statsReceiver.counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
            this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
            this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
            this.exceptions = statsReceiver.scope("exn");
            this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
            this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SharedChannelStats $outer;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return this.$outer.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount().sum();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }
}

