/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4;

import com.twitter.finagle.CancelledConnectionException;
import com.twitter.finagle.ConnectionFailedException;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.ProxyConnectException;
import com.twitter.finagle.Stack;
import com.twitter.finagle.netty4.ConnectionBuilder$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u0001\u0003\u0005\u0011Q!!E\"p]:,7\r^5p]\n+\u0018\u000e\u001c3fe*\u00111\u0001B\u0001\u0007]\u0016$H/\u001f\u001b\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\t%t\u0017\u000e^\u0002\u0001!\r)BDH\u0007\u0002-)\u0011q\u0003G\u0001\bG\"\fgN\\3m\u0015\tI\"$A\u0003oKR$\u0018PC\u0001\u001c\u0003\tIw.\u0003\u0002\u001e-\t\u00112\t[1o]\u0016d\u0017J\\5uS\u0006d\u0017N_3s!\t)r$\u0003\u0002!-\t91\t[1o]\u0016d\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\t\u0005$GM\u001d\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\n1A\\3u\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\u001bM{7m[3u\u0003\u0012$'/Z:t\u0011!a\u0003A!A!\u0002\u0013i\u0013A\u00029be\u0006l7\u000f\u0005\u0002/e9\u0011q\u0006M\u0007\u0002\t%\u0011\u0011\u0007B\u0001\u0006'R\f7m[\u0005\u0003gQ\u0012a\u0001U1sC6\u001c(BA\u0019\u0005\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q!\u0001HO\u001e=!\tI\u0004!D\u0001\u0003\u0011\u0015\u0011R\u00071\u0001\u0015\u0011\u0015\u0011S\u00071\u0001$\u0011\u0015aS\u00071\u0001.\u0011\u0019q\u0004\u0001)A\u0005\u007f\u0005i1\u000f^1ugJ+7-Z5wKJ\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0003\u0002\u000bM$\u0018\r^:\n\u0005\u0011\u000b%!D*uCR\u001c(+Z2fSZ,'\u000f\u0003\u0004G\u0001\u0001\u0006IaR\u0001\u0013G>tg.Z2u\u0019\u0006$XM\\2z'R\fG\u000f\u0005\u0002A\u0011&\u0011\u0011*\u0011\u0002\u0005'R\fG\u000f\u0003\u0004L\u0001\u0001\u0006IaR\u0001\u0019M\u0006LG.\u001a3D_:tWm\u0019;MCR,gnY=Ti\u0006$\bBB'\u0001A\u0003%a*A\tdC:\u001cW\r\u001c7fI\u000e{gN\\3diN\u0004\"\u0001Q(\n\u0005A\u000b%aB\"pk:$XM\u001d\u0005\u0007%\u0002\u0001\u000b\u0011B*\u0002\u0013\t|w\u000e^:ue\u0006\u0004\bC\u0001+W\u001b\u0005)&B\u0001*\u0019\u0013\t9VKA\u0005C_>$8\u000f\u001e:ba\")\u0011\f\u0001C\u00015\u0006i!/Z7pi\u0016\fE\r\u001a:fgN,\u0012a\t\u0005\u00069\u0002!\t!X\u0001\u0006EVLG\u000eZ\u000b\u0003=\u001e$\"a\u00189\u0011\u0007\u0001\u001cW-D\u0001b\u0015\t\u0011g!\u0001\u0003vi&d\u0017B\u00013b\u0005\u00191U\u000f^;sKB\u0011am\u001a\u0007\u0001\t\u0015A7L1\u0001j\u0005\u0005!\u0016C\u00016n!\ta1.\u0003\u0002m\u001b\t9aj\u001c;iS:<\u0007C\u0001\u0007o\u0013\tyWBA\u0002B]fDQ!].A\u0002I\fqAY;jY\u0012,'\u000f\u0005\u0003\rgzy\u0016B\u0001;\u000e\u0005%1UO\\2uS>t\u0017g\u0002\u0004w\u0005!\u0005Aa^\u0001\u0012\u0007>tg.Z2uS>t')^5mI\u0016\u0014\bCA\u001dy\r\u0019\t!\u0001#\u0001\u0005sN\u0011\u0001p\u0003\u0005\u0006ma$\ta\u001f\u000b\u0002o\")Q\u0010\u001fC\u0001}\u0006I!/Y<DY&,g\u000e\u001e\u000b\u0007q}\fy!!\u0005\t\rIa\b\u0019AA\u0001!\u0019a1/a\u0001\u0002\nA\u0019Q#!\u0002\n\u0007\u0005\u001daCA\bDQ\u0006tg.\u001a7QSB,G.\u001b8f!\ra\u00111B\u0005\u0004\u0003\u001bi!\u0001B+oSRDQA\t?A\u0002\rBQ\u0001\f?A\u00025Bq!!\u0006y\t\u0013\t9\"A\u0004jg2{7-\u00197\u0015\t\u0005e\u0011q\u0004\t\u0004\u0019\u0005m\u0011bAA\u000f\u001b\t9!i\\8mK\u0006t\u0007B\u0002\u0012\u0002\u0014\u0001\u00071\u0005C\u0004\u0002$a$I!!\n\u0002\u001b5\f7.\u001a\"p_R\u001cHO]1q)\u001d\u0019\u0016qEA\u0015\u0003WAaAEA\u0011\u0001\u0004!\u0002B\u0002\u0012\u0002\"\u0001\u00071\u0005\u0003\u0004-\u0003C\u0001\r!\f")
public final class ConnectionBuilder {
    public final SocketAddress com$twitter$finagle$netty4$ConnectionBuilder$$addr;
    private final StatsReceiver statsReceiver;
    public final Stat com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat;
    public final Stat com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat;
    public final Counter com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects;
    private final Bootstrap bootstrap;

    public static ConnectionBuilder rawClient(Function1<ChannelPipeline, BoxedUnit> function1, SocketAddress socketAddress, Stack.Params params) {
        return ConnectionBuilder$.MODULE$.rawClient(function1, socketAddress, params);
    }

    public SocketAddress remoteAddress() {
        return this.com$twitter$finagle$netty4$ConnectionBuilder$$addr;
    }

    public <T> Future<T> build(Function1<Channel, Future<T>> builder) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        ChannelFuture nettyConnectF = this.bootstrap.connect(this.com$twitter$finagle$netty4$ConnectionBuilder$$addr);
        Promise transportP = new Promise();
        transportP.setInterruptHandler((PartialFunction)new Serializable(this, nettyConnectF){
            public static final long serialVersionUID = 0L;
            private final ChannelFuture nettyConnectF$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.nettyConnectF$1.cancel(false);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.nettyConnectF$1 = nettyConnectF$1;
            }
        });
        nettyConnectF.addListener((GenericFutureListener)new ChannelFutureListener(this, builder, elapsed, transportP){
            private final /* synthetic */ ConnectionBuilder $outer;
            private final Function1 builder$1;
            private final Function0 elapsed$1;
            private final Promise transportP$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void operationComplete(ChannelFuture channelF) {
                Future future;
                Channel ch;
                long latency = ((TimeLike)this.elapsed$1.apply()).inMilliseconds();
                if (channelF.isCancelled()) {
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat.add((float)latency);
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects.incr();
                    this.transportP$1.setException((Throwable)Failure$.MODULE$.apply((Throwable)new CancelledConnectionException(), FailureFlags$.MODULE$.Interrupted() | FailureFlags$.MODULE$.Retryable(), (Level)Level.DEBUG$.MODULE$));
                    return;
                }
                if (channelF.cause() == null) {
                    if (!channelF.channel().isOpen()) {
                        this.transportP$1.setException((Throwable)Failure$.MODULE$.rejected("Netty4 Channel was found in a closed state"));
                        return;
                    }
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat.add((float)latency);
                    ch = channelF.channel();
                    try {
                        future = (Future)this.builder$1.apply((Object)ch);
                    }
                    catch (Throwable throwable2) {
                        Future future2;
                        Throwable throwable22 = throwable2;
                        Option option = NonFatal$.MODULE$.unapply(throwable22);
                        if (option.isEmpty()) {
                            throw throwable2;
                        }
                        Throwable t = (Throwable)option.get();
                        ch.close();
                        future = future2 = Future$.MODULE$.exception(t);
                    }
                } else {
                    UnresolvedAddressException unresolvedAddressException;
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat.add((float)latency);
                    Throwable throwable = channelF.cause();
                    if (throwable instanceof UnresolvedAddressException) {
                        UnresolvedAddressException unresolvedAddressException2;
                        unresolvedAddressException = unresolvedAddressException2 = (UnresolvedAddressException)throwable;
                    } else if (throwable instanceof ProxyConnectException) {
                        ProxyConnectException proxyConnectException = (ProxyConnectException)throwable;
                        unresolvedAddressException = proxyConnectException;
                    } else {
                        unresolvedAddressException = Failure$.MODULE$.rejected((Throwable)new ConnectionFailedException(throwable, this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$addr));
                    }
                    this.transportP$1.setException((Throwable)unresolvedAddressException);
                    return;
                }
                Future result = future;
                result.proxyTo(this.transportP$1);
                this.transportP$1.setInterruptHandler((PartialFunction)new Serializable(this, ch, result){
                    public static final long serialVersionUID = 0L;
                    private final Channel ch$1;
                    private final Future result$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        this.ch$1.close();
                        this.result$1.raise(A1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return (B1)boxedUnit;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.ch$1 = ch$1;
                        this.result$1 = result$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.builder$1 = builder$1;
                this.elapsed$1 = elapsed$1;
                this.transportP$1 = transportP$1;
            }
        });
        return transportP;
    }

    public ConnectionBuilder(ChannelInitializer<Channel> init, SocketAddress addr, Stack.Params params) {
        this.com$twitter$finagle$netty4$ConnectionBuilder$$addr = addr;
        this.statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        this.com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat = this.statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connect_latency_ms"}));
        this.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat = this.statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed_connect_latency_ms"}));
        this.com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects = this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cancelled_connects"}));
        this.bootstrap = ConnectionBuilder$.MODULE$.com$twitter$finagle$netty4$ConnectionBuilder$$makeBootstrap(init, addr, params);
    }
}

