/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.IOExceptionStrings$;
import com.twitter.finagle.ReadTimedOutException;
import com.twitter.finagle.WriteTimedOutException;
import com.twitter.finagle.netty4.channel.ChannelExceptionHandler$Http2StreamClosedBeforeWriteException$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005%qAB\u0001\u0003\u0011\u0003!A\"A\fDQ\u0006tg.\u001a7Fq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\bG\"\fgN\\3m\u0015\t)a!\u0001\u0004oKR$\u0018\u0010\u000e\u0006\u0003\u000f!\tqAZ5oC\u001edWM\u0003\u0002\n\u0015\u00059Ao^5ui\u0016\u0014(\"A\u0006\u0002\u0007\r|W\u000e\u0005\u0002\u000e\u001d5\t!A\u0002\u0004\u0010\u0005!\u0005A\u0001\u0005\u0002\u0018\u0007\"\fgN\\3m\u000bb\u001cW\r\u001d;j_:D\u0015M\u001c3mKJ\u001c\"AD\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0011\u0015Ab\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0007\b\u000bqq\u0001\u0012A\u000f\u0002K!#H\u000f\u001d\u001aTiJ,\u0017-\\\"m_N,GMQ3g_J,wK]5uK\u0016C8-\u001a9uS>t\u0007C\u0001\u0010 \u001b\u0005qa!\u0002\u0011\u000f\u0011\u0003\t#!\n%uiB\u00144\u000b\u001e:fC6\u001cEn\\:fI\n+gm\u001c:f/JLG/Z#yG\u0016\u0004H/[8o'\ty\u0012\u0003C\u0003\u0019?\u0011\u00051\u0005F\u0001\u001e\u0011\u0015)s\u0004\"\u0001'\u0003\u001d)h.\u00199qYf$\"a\n\u0016\u0011\u0005IA\u0013BA\u0015\u0014\u0005\u001d\u0011un\u001c7fC:DQa\u000b\u0013A\u00021\n\u0011\u0001\u001e\t\u0003[Ur!AL\u001a\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0005EJ\u0012A\u0002\u001fs_>$h(C\u0001\u0015\u0013\t!4#A\u0004qC\u000e\\\u0017mZ3\n\u0005Y:$!\u0003+ie><\u0018M\u00197f\u0015\t!4CB\u0003\u0010\u0005\u0001!\u0011h\u0005\u00029uA\u00111(Q\u0007\u0002y)\u00111!\u0010\u0006\u0003}}\nQA\\3uifT\u0011\u0001Q\u0001\u0003S>L!A\u0011\u001f\u00039\rC\u0017M\u001c8fY&s'm\\;oI\"\u000bg\u000e\u001a7fe\u0006#\u0017\r\u001d;fe\"AA\t\u000fB\u0001B\u0003%Q)A\u0003ti\u0006$8\u000f\u0005\u0002G\u00116\tqI\u0003\u0002E\r%\u0011\u0011j\u0012\u0002\u000e'R\fGo\u001d*fG\u0016Lg/\u001a:\t\u0011-C$\u0011!Q\u0001\n1\u000b1\u0001\\8h!\tiE+D\u0001O\u0015\ty\u0005+A\u0004m_\u001e<\u0017N\\4\u000b\u0005E\u0013\u0016\u0001B;uS2T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V\u001d\n1Aj\\4hKJDQ\u0001\u0007\u001d\u0005\u0002]#2\u0001W-[!\ti\u0001\bC\u0003E-\u0002\u0007Q\tC\u0003L-\u0002\u0007A\n\u0003\u0004]q\u0001\u0006I!X\u0001\u0013e\u0016\fG\rV5nK>,HoQ8v]R,'\u000f\u0005\u0002G=&\u0011ql\u0012\u0002\b\u0007>,h\u000e^3s\u0011\u0019\t\u0007\b)A\u0005;\u0006\u0019rO]5uKRKW.Z8vi\u000e{WO\u001c;fe\"11\r\u000fQ\u0005\n\u0011\f\u0001b]3wKJLG/\u001f\u000b\u0003K\"\u0004\"!\u00144\n\u0005\u001dt%!\u0002'fm\u0016d\u0007\"B5c\u0001\u0004a\u0013aA3yG\")1\u000e\u000fC!Y\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000fF\u0002naV\u0004\"A\u00058\n\u0005=\u001c\"\u0001B+oSRDQ!\u001d6A\u0002I\f1a\u0019;y!\tY4/\u0003\u0002uy\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"B\u0016k\u0001\u0004a\u0003F\u0001\u001dx!\rA\u00181\u0001\b\u0003s~t!A\u001f@\u000f\u0005mlhBA\u0018}\u0013\u0005\u0001\u0015B\u0001 @\u0013\t\u0019Q(C\u0002\u0002\u0002q\nab\u00115b]:,G\u000eS1oI2,'/\u0003\u0003\u0002\u0006\u0005\u001d!\u0001C*iCJ\f'\r\\3\u000b\u0007\u0005\u0005A\b")
public class ChannelExceptionHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log;
    private final Counter readTimeoutCounter;
    private final Counter writeTimeoutCounter;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private java.util.logging.Level severity(Throwable exc) {
        void var4_9;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure = (Failure)throwable;
            Level level = failure.logLevel();
            return var4_9;
        }
        boolean bl = throwable instanceof ClosedChannelException ? true : (throwable instanceof SSLException ? true : (throwable instanceof ReadTimeoutException ? true : (throwable instanceof WriteTimeoutException ? true : throwable instanceof SSLException)));
        if (bl) {
            java.util.logging.Level level = java.util.logging.Level.FINEST;
            return var4_9;
        }
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            if (IOExceptionStrings$.MODULE$.FinestIOExceptionMessages().contains((Object)iOException.getMessage())) {
                java.util.logging.Level level = java.util.logging.Level.FINEST;
                return var4_9;
            }
        }
        if (ChannelExceptionHandler$Http2StreamClosedBeforeWriteException$.MODULE$.unapply(throwable)) {
            java.util.logging.Level level = java.util.logging.Level.FINEST;
            return var4_9;
        }
        java.util.logging.Level level = java.util.logging.Level.WARNING;
        return var4_9;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        Throwable throwable;
        Throwable throwable2 = t;
        if (throwable2 instanceof ReadTimeoutException) {
            this.readTimeoutCounter.incr();
            throwable = new ReadTimedOutException(ctx.channel().remoteAddress());
        } else if (throwable2 instanceof WriteTimeoutException) {
            this.writeTimeoutCounter.incr();
            throwable = new WriteTimedOutException(ctx.channel().remoteAddress());
        } else {
            throwable = throwable2;
        }
        Throwable wrappedException = throwable;
        String remoteAddr = (String)Option$.MODULE$.apply((Object)ctx.channel().remoteAddress()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SocketAddress x$1) {
                return x$1.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown remote address";
            }
        });
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled exception in connection with ", ", shutting down connection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{remoteAddr}));
        this.log.log(this.severity(t), msg, t);
        super.exceptionCaught(ctx, wrappedException);
    }

    public ChannelExceptionHandler(StatsReceiver stats, Logger log) {
        this.log = log;
        this.readTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_timeout"}));
        this.writeTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write_timeout"}));
    }
}

