/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.netty4.channel.SharedChannelStats;
import com.twitter.finagle.stats.Counter;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uw!B\u0001\u0003\u0011\u0013i\u0011aE\"iC:tW\r\\*uCR\u001c\b*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0019\u0007.\u00198oK2T!!\u0002\u0004\u0002\r9,G\u000f^=5\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0005#\t\u00192\t[1o]\u0016d7\u000b^1ug\"\u000bg\u000e\u001a7feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%I!H\u0001\u0004Y><W#\u0001\u0010\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003G\u0011\nA!\u001e;jY*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014!\u0005\u0019aunZ4fe\"1\u0011f\u0004Q\u0001\ny\tA\u0001\\8hA!91f\u0004b\u0001\n\u001ba\u0013A\u0006+daN#\u0018\r^:Va\u0012\fG/Z%oi\u0016\u0014h/\u00197\u0016\u00035\u0002\"A\f\u0019\u000e\u0003=R!a\t\u0005\n\u0005Ez#\u0001\u0003#ve\u0006$\u0018n\u001c8\t\rMz\u0001\u0015!\u0004.\u0003]!6\r]*uCR\u001cX\u000b\u001d3bi\u0016Le\u000e^3sm\u0006d\u0007E\u0002\u00036\u001f\u00191$a\u0004+daN#\u0018\r^:Va\u0012\fG/\u001a:\u0014\u0007Q:T\b\u0005\u00029w5\t\u0011H\u0003\u0002;I\u0005!A.\u00198h\u0013\ta\u0014H\u0001\u0004PE*,7\r\u001e\t\u0003qyJ!aP\u001d\u0003\u0011I+hN\\1cY\u0016D\u0001\"\u0011\u001b\u0003\u0002\u0003\u0006IAQ\u0001\u0013g\"\f'/\u001a3DQ\u0006tg.\u001a7Ti\u0006$8\u000f\u0005\u0002\u000f\u0007&\u0011AI\u0001\u0002\u0013'\"\f'/\u001a3DQ\u0006tg.\u001a7Ti\u0006$8\u000f\u0003\u0005\u0004i\t\u0005\t\u0015!\u0003G!\t9u*D\u0001I\u0015\tI%*A\u0003fa>dGN\u0003\u0002\u0004\u0017*\u0011A*T\u0001\u0006]\u0016$H/\u001f\u0006\u0002\u001d\u0006\u0011\u0011n\\\u0005\u0003!\"\u0013!#\u00129pY2\u001cvnY6fi\u000eC\u0017M\u001c8fY\")\u0011\u0004\u000eC\u0001%R\u00191+\u0016,\u0011\u0005Q#T\"A\b\t\u000b\u0005\u000b\u0006\u0019\u0001\"\t\u000b\r\t\u0006\u0019\u0001$\t\ra#\u0004\u0015!\u0003Z\u0003\u001d!8\r]%oM>\u0004\"a\u0012.\n\u0005mC%\u0001D#q_2dGk\u00199J]\u001a|\u0007BB/5A\u0003&a,A\bmCN$(+\u001a;sC:\u001cX.\u001b;t!\t\u0019r,\u0003\u0002a)\t!Aj\u001c8h\u0011\u0019\u0011G\u0007)Q\u0005G\u0006I1-\u00198dK2dW\r\u001a\t\u0003'\u0011L!!\u001a\u000b\u0003\u000f\t{w\u000e\\3b]\"1q\r\u000eQ\u0001\n!\fqb]2iK\u0012,H.\u001a3Va\u0012\fG/\u001a\u0019\u0003SJ\u00042A\u001b8q\u001b\u0005Y'B\u00017n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003G-K!a\\6\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004\"!\u001d:\r\u0001\u0011I1OZA\u0001\u0002\u0003\u0015\t\u0001\u001e\u0002\u0004?\u0012\n\u0014CA;y!\t\u0019b/\u0003\u0002x)\t9aj\u001c;iS:<\u0007CA\nz\u0013\tQHCA\u0002B]fDQ\u0001 \u001b\u0005\u0002u\faaY1oG\u0016dG#\u0001@\u0011\u0005My\u0018bAA\u0001)\t!QK\\5u\u0011\u0019\t)\u0001\u000eC!{\u0006\u0019!/\u001e8\t\r\u0005%A\u0007\"\u0003~\u0003E)\b\u000fZ1uKN{7m[3u'R\fGo\u001d\u0004\u0006!\t!\u0011QB\n\u0005\u0003\u0017\ty\u0001\u0005\u0003\u0002\u0012\u0005MQ\"\u0001&\n\u0007\u0005U!J\u0001\u000bDQ\u0006tg.\u001a7EkBdW\r\u001f%b]\u0012dWM\u001d\u0005\n\u0003\u0006-!\u0011!Q\u0001\n\tCq!GA\u0006\t\u0003\tY\u0002\u0006\u0003\u0002\u001e\u0005}\u0001c\u0001\b\u0002\f!1\u0011)!\u0007A\u0002\tC1\"a\t\u0002\f\u0001\u0007\t\u0011)Q\u0005=\u0006\u00012\r[1o]\u0016d')\u001f;fgJ+\u0017\r\u001a\u0005\f\u0003O\tY\u00011A\u0001B\u0003&a,A\ndQ\u0006tg.\u001a7CsR,7o\u0016:jiR,g\u000eC\u0006\u0002,\u0005-\u0001\u0019!A!B\u0013\u0019\u0017AE2iC:tW\r\\,bg^\u0013\u0018\u000e^1cY\u0016DA\"a\f\u0002\f\u0001\u0007\t\u0011)Q\u0005\u0003c\tqc\u00195b]:,Gn\u0016:ji\u0006\u0014G.\u001a#ve\u0006$\u0018n\u001c8\u0011\t\u0005M\u0012\u0011\b\b\u0004]\u0005U\u0012bAA\u001c_\u0005I1\u000b^8qo\u0006$8\r[\u0005\u0005\u0003w\tiDA\u0004FY\u0006\u00048/\u001a3\n\u0007\u0005}rFA\u0005Ti>\u0004x/\u0019;dQ\"a\u00111IA\u0006\u0001\u0004\u0005\t\u0015)\u0003\u00022\u0005\u00112m\u001c8oK\u000e$\u0018n\u001c8EkJ\fG/[8o\u0011!\t9%a\u0003!B\u0013\u0019\u0017!D2iC:tW\r\\!di&4X\r\u0003\u0005\u0002L\u0005-\u0001\u0015)\u0003d\u0003A!Hn]\"iC:tW\r\\!di&4X\r\u0003\u0007\u0002P\u0005-\u0001\u0019!A!B\u0013\t\t&A\buGB\u001cF/\u0019;t+B$\u0017\r^3s!\r\t\u0019\u0006\u000e\b\u0003\u001d\u0001A\u0001\"a\u0016\u0002\f\u0011\u0005\u0013\u0011L\u0001\rQ\u0006tG\r\\3s\u0003\u0012$W\r\u001a\u000b\u0004}\u0006m\u0003\u0002CA/\u0003+\u0002\r!a\u0018\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0012\u0005\u0005\u0014bAA2\u0015\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\u0002CA$\u0003\u0017!\t%a\u001a\u0015\u0007y\fI\u0007\u0003\u0005\u0002^\u0005\u0015\u0004\u0019AA0\u0011!\ti'a\u0003\u0005B\u0005=\u0014!B<sSR,Gc\u0002@\u0002r\u0005M\u0014q\u000f\u0005\t\u0003;\nY\u00071\u0001\u0002`!9\u0011QOA6\u0001\u00049\u0014aA7tO\"A\u0011\u0011PA6\u0001\u0004\tY(A\u0001q!\u0011\t\t\"! \n\u0007\u0005}$J\u0001\bDQ\u0006tg.\u001a7Qe>l\u0017n]3\t\u0011\u0005\r\u00151\u0002C!\u0003\u000b\u000b1b\u00195b]:,GNU3bIR)a0a\"\u0002\n\"A\u0011QLAA\u0001\u0004\ty\u0006C\u0004\u0002v\u0005\u0005\u0005\u0019A\u001c\t\u0011\u00055\u00151\u0002C!\u0003\u001f\u000bQa\u00197pg\u0016$RA`AI\u0003'C\u0001\"!\u0018\u0002\f\u0002\u0007\u0011q\f\u0005\t\u0003s\nY\t1\u0001\u0002|!A\u0011qSA\u0006\t\u0003\nI*A\bdQ\u0006tg.\u001a7J]\u0006\u001cG/\u001b<f)\rq\u00181\u0014\u0005\t\u0003;\n)\n1\u0001\u0002`!A\u0011qTA\u0006\t\u0003\n\t+A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\u0015q\u00181UAS\u0011!\ti&!(A\u0002\u0005}\u0003\u0002CAT\u0003;\u0003\r!!+\u0002\u000b\r\fWo]3\u0011\t\u0005-\u00161\u0018\b\u0005\u0003[\u000b9L\u0004\u0003\u00020\u0006UVBAAY\u0015\r\t\u0019\fD\u0001\u0007yI|w\u000e\u001e \n\u0003UI1!!/\u0015\u0003\u001d\u0001\u0018mY6bO\u0016LA!!0\u0002@\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003s#\u0002\u0002CAb\u0003\u0017!\t%!2\u00023\rD\u0017M\u001c8fY^\u0013\u0018\u000e^1cS2LG/_\"iC:<W\r\u001a\u000b\u0004}\u0006\u001d\u0007\u0002CA/\u0003\u0003\u0004\r!a\u0018\t\u0011\u0005-\u00171\u0002C!\u0003\u001b\f!#^:fe\u00163XM\u001c;Ue&<w-\u001a:fIR)a0a4\u0002R\"A\u0011QLAe\u0001\u0004\ty\u0006C\u0004\u0002T\u0006%\u0007\u0019\u0001\n\u0002\u0007\u00154H\u000f")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final SharedChannelStats sharedChannelStats;
    private long channelBytesRead;
    private long channelBytesWritten;
    private boolean channelWasWritable;
    private Function0<Duration> channelWritableDuration;
    private Function0<Duration> connectionDuration;
    private boolean channelActive;
    private boolean tlsChannelActive;
    private TcpStatsUpdater tcpStatsUpdater;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.channelBytesRead = 0L;
        this.channelBytesWritten = 0L;
        this.channelWasWritable = true;
        this.channelWritableDuration = Stopwatch$.MODULE$.start();
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.sharedChannelStats.connects().incr();
        this.sharedChannelStats.connectionCountIncrement();
        Channel channel = ctx.channel();
        if (channel instanceof EpollSocketChannel) {
            EpollSocketChannel epollSocketChannel = (EpollSocketChannel)channel;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
            }
            this.tcpStatsUpdater = new TcpStatsUpdater(this.sharedChannelStats, epollSocketChannel);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        EventLoop eventLoop = ctx.channel().eventLoop();
        if (eventLoop instanceof SingleThreadEventLoop) {
            SingleThreadEventLoop singleThreadEventLoop = (SingleThreadEventLoop)eventLoop;
            this.sharedChannelStats.registerEventLoop(singleThreadEventLoop);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.channelActive = true;
        this.connectionDuration = Stopwatch$.MODULE$.start();
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.sentBytes().incr((long)readableBytes);
            this.channelBytesWritten += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder().append((Object)"ChannelStatsHandler received non-ByteBuf write: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.receivedBytes().incr((long)readableBytes);
            this.channelBytesRead += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder().append((Object)"ChannelStatsHandler received non-ByteBuf read: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.sharedChannelStats.closesCount().incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channelActive) {
            EventLoop eventLoop;
            this.channelActive = false;
            Function0<Duration> elapsed = this.connectionDuration;
            this.connectionDuration = null;
            this.sharedChannelStats.connectionDuration().add((float)((TimeLike)elapsed.apply()).inMilliseconds());
            this.sharedChannelStats.connectionCountDecrement();
            long oldChannelBytesRead = this.channelBytesRead;
            long oldChannelBytesWritten = this.channelBytesWritten;
            this.channelBytesRead = 0L;
            this.channelBytesWritten = 0L;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
                this.tcpStatsUpdater = null;
            }
            this.sharedChannelStats.connectionReceivedBytes().add((float)oldChannelBytesRead);
            this.sharedChannelStats.connectionSentBytes().add((float)oldChannelBytesWritten);
            if (this.tlsChannelActive) {
                this.tlsChannelActive = false;
                this.sharedChannelStats.tlsConnectionCountDecrement();
            }
            if ((eventLoop = ctx.channel().eventLoop()) instanceof SingleThreadEventLoop) {
                SingleThreadEventLoop singleThreadEventLoop = (SingleThreadEventLoop)eventLoop;
                this.sharedChannelStats.unregisterEventLoop(singleThreadEventLoop);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.sharedChannelStats.exceptions().counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof TimeoutException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != this.channelWasWritable) {
            Duration elapsed = (Duration)this.channelWritableDuration.apply();
            Counter stat = this.channelWasWritable ? this.sharedChannelStats.writable() : this.sharedChannelStats.unwritable();
            stat.incr((long)((int)elapsed.inMilliseconds()));
            this.channelWasWritable = isWritable;
            this.channelWritableDuration = Stopwatch$.MODULE$.start();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (object instanceof SslHandshakeCompletionEvent) {
            BoxedUnit boxedUnit;
            if (this.channelActive) {
                this.tlsChannelActive = true;
                this.sharedChannelStats.tlsConnectionCountIncrement();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public ChannelStatsHandler(SharedChannelStats sharedChannelStats) {
        this.sharedChannelStats = sharedChannelStats;
        this.channelActive = false;
        this.tlsChannelActive = false;
    }

    public static final class TcpStatsUpdater
    implements Runnable {
        private final SharedChannelStats sharedChannelStats;
        private final EpollSocketChannel channel;
        private final EpollTcpInfo tcpInfo;
        private long lastRetransmits;
        private boolean cancelled;
        private final ScheduledFuture<?> scheduledUpdate;

        public void cancel() {
            this.cancelled = true;
            this.scheduledUpdate.cancel(false);
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                this.updateSocketStats();
            }
        }

        private void updateSocketStats() {
            try {
                this.channel.tcpInfo(this.tcpInfo);
                this.sharedChannelStats.tcpSendWindowSize().add((float)(this.tcpInfo.sndCwnd() * this.tcpInfo.sndMss()));
                long retransmits = this.tcpInfo.totalRetrans();
                this.sharedChannelStats.retransmits().incr(retransmits - this.lastRetransmits);
                this.lastRetransmits = retransmits;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ChannelException) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(Level.WARNING, "Error updating TCP info stats", t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public TcpStatsUpdater(SharedChannelStats sharedChannelStats, EpollSocketChannel channel) {
            this.sharedChannelStats = sharedChannelStats;
            this.channel = channel;
            this.tcpInfo = new EpollTcpInfo();
            this.lastRetransmits = 0L;
            this.cancelled = false;
            this.scheduledUpdate = channel.eventLoop().scheduleAtFixedRate((Runnable)this, 0L, ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$TcpStatsUpdateInterval().inMilliseconds(), TimeUnit.MILLISECONDS);
        }
    }
}

