/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.IOExceptionStrings$;
import com.twitter.finagle.ReadTimedOutException;
import com.twitter.finagle.WriteTimedOutException;
import com.twitter.finagle.netty4.channel.ChannelExceptionHandler$Http2StreamClosedBeforeWriteException$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005%qAB\b\u0011\u0011\u0003\u0011\"D\u0002\u0004\u001d!!\u0005!#\b\u0005\u0006I\u0005!\tAJ\u0004\u0006O\u0005A\t\u0001\u000b\u0004\u0006U\u0005A\ta\u000b\u0005\u0006I\u0011!\t\u0001\f\u0005\u0006[\u0011!\tA\f\u0004\u00069A\u0001!\u0003\u0011\u0005\t\u0015\u001e\u0011\t\u0011)A\u0005\u0017\"A\u0001k\u0002B\u0001B\u0003%\u0011\u000bC\u0003%\u000f\u0011\u00051\f\u0003\u0004`\u000f\u0001\u0006I\u0001\u0019\u0005\u0007G\u001e\u0001\u000b\u0011\u00021\t\r\u0011<\u0001\u0015\"\u0003f\u0011\u0015Yw\u0001\"\u0011m\u0003]\u0019\u0005.\u00198oK2,\u0005pY3qi&|g\u000eS1oI2,'O\u0003\u0002\u0012%\u000591\r[1o]\u0016d'BA\n\u0015\u0003\u0019qW\r\u001e;zi)\u0011QCF\u0001\bM&t\u0017m\u001a7f\u0015\t9\u0002$A\u0004uo&$H/\u001a:\u000b\u0003e\t1aY8n!\tY\u0012!D\u0001\u0011\u0005]\u0019\u0005.\u00198oK2,\u0005pY3qi&|g\u000eS1oI2,'o\u0005\u0002\u0002=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u00025\u0005)\u0003\n\u001e;qeM#(/Z1n\u00072|7/\u001a3CK\u001a|'/Z,sSR,W\t_2faRLwN\u001c\t\u0003S\u0011i\u0011!\u0001\u0002&\u0011R$\bOM*ue\u0016\fWn\u00117pg\u0016$')\u001a4pe\u0016<&/\u001b;f\u000bb\u001cW\r\u001d;j_:\u001c\"\u0001\u0002\u0010\u0015\u0003!\nq!\u001e8baBd\u0017\u0010\u0006\u00020eA\u0011q\u0004M\u0005\u0003c\u0001\u0012qAQ8pY\u0016\fg\u000eC\u00034\r\u0001\u0007A'A\u0001u!\t)TH\u0004\u00027w9\u0011qGO\u0007\u0002q)\u0011\u0011(J\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!\u0001\u0010\u0011\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u0010\u0011\u0014\u0005\u001d\t\u0005C\u0001\"I\u001b\u0005\u0019%BA\tE\u0015\t)e)A\u0003oKR$\u0018PC\u0001H\u0003\tIw.\u0003\u0002J\u0007\na2\t[1o]\u0016d\u0017J\u001c2pk:$\u0007*\u00198eY\u0016\u0014\u0018\tZ1qi\u0016\u0014\u0018!B:uCR\u001c\bC\u0001'O\u001b\u0005i%B\u0001&\u0015\u0013\tyUJA\u0007Ti\u0006$8OU3dK&4XM]\u0001\u0004Y><\u0007C\u0001*Z\u001b\u0005\u0019&B\u0001+V\u0003\u001dawnZ4j]\u001eT!AV,\u0002\tU$\u0018\u000e\u001c\u0006\u00021\u0006!!.\u0019<b\u0013\tQ6K\u0001\u0004M_\u001e<WM\u001d\u000b\u00049vs\u0006CA\u000e\b\u0011\u0015Q%\u00021\u0001L\u0011\u0015\u0001&\u00021\u0001R\u0003I\u0011X-\u00193US6,w.\u001e;D_VtG/\u001a:\u0011\u00051\u000b\u0017B\u00012N\u0005\u001d\u0019u.\u001e8uKJ\f1c\u001e:ji\u0016$\u0016.\\3pkR\u001cu.\u001e8uKJ\f\u0001b]3wKJLG/\u001f\u000b\u0003M&\u0004\"AU4\n\u0005!\u001c&!\u0002'fm\u0016d\u0007\"\u00026\u000e\u0001\u0004!\u0014aA3yG\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000fF\u0002naV\u0004\"a\b8\n\u0005=\u0004#\u0001B+oSRDQ!\u001d\bA\u0002I\f1a\u0019;y!\t\u00115/\u0003\u0002u\u0007\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"B\u001a\u000f\u0001\u0004!\u0004FA\u0004x!\rA\u00181\u0001\b\u0003s~t!A\u001f@\u000f\u0005mlhBA\u001c}\u0013\u00059\u0015BA#G\u0013\t\tB)C\u0002\u0002\u0002\r\u000bab\u00115b]:,G\u000eS1oI2,'/\u0003\u0003\u0002\u0006\u0005\u001d!\u0001C*iCJ\f'\r\\3\u000b\u0007\u0005\u00051\t")
public class ChannelExceptionHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log;
    private final Counter readTimeoutCounter;
    private final Counter writeTimeoutCounter;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private java.util.logging.Level severity(Throwable exc) {
        void var2_9;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure = (Failure)throwable;
            Level level = failure.logLevel();
            return var2_9;
        }
        boolean bl = throwable instanceof ClosedChannelException ? true : (throwable instanceof SSLException ? true : (throwable instanceof ReadTimeoutException ? true : (throwable instanceof WriteTimeoutException ? true : throwable instanceof SSLException)));
        if (bl) {
            java.util.logging.Level level = java.util.logging.Level.FINEST;
            return var2_9;
        }
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            if (IOExceptionStrings$.MODULE$.FinestIOExceptionMessages().contains((Object)iOException.getMessage())) {
                java.util.logging.Level level = java.util.logging.Level.FINEST;
                return var2_9;
            }
        }
        if (ChannelExceptionHandler$Http2StreamClosedBeforeWriteException$.MODULE$.unapply(throwable)) {
            java.util.logging.Level level = java.util.logging.Level.FINEST;
            return var2_9;
        }
        java.util.logging.Level level = java.util.logging.Level.WARNING;
        return var2_9;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        Throwable throwable;
        Throwable throwable2 = t;
        if (throwable2 instanceof ReadTimeoutException) {
            this.readTimeoutCounter.incr();
            throwable = new ReadTimedOutException(ctx.channel().remoteAddress());
        } else if (throwable2 instanceof WriteTimeoutException) {
            this.writeTimeoutCounter.incr();
            throwable = new WriteTimedOutException(ctx.channel().remoteAddress());
        } else {
            throwable = throwable2;
        }
        Throwable wrappedException = throwable;
        String remoteAddr = (String)Option$.MODULE$.apply((Object)ctx.channel().remoteAddress()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown remote address");
        String msg = new StringBuilder(65).append("Unhandled exception in connection with ").append(remoteAddr).append(", shutting down connection").toString();
        this.log.log(this.severity(t), msg, t);
        super.exceptionCaught(ctx, wrappedException);
    }

    public ChannelExceptionHandler(StatsReceiver stats, Logger log) {
        this.log = log;
        this.readTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_timeout"}));
        this.writeTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write_timeout"}));
    }
}

