/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.netty4.channel.SharedChannelStats;
import com.twitter.finagle.stats.Counter;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uw!\u0002\u0014(\u0011\u0013\u0011d!\u0002\u001b(\u0011\u0013)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%Ia\u0010\u0005\u0007\u0015\u0006\u0001\u000b\u0011\u0002!\t\u000f-\u000b!\u0019!C\u0007\u0019\"1!+\u0001Q\u0001\u000e53AaU\u0001\u0007)\"Aal\u0002B\u0001B\u0003%q\f\u0003\u0005)\u000f\t\u0005\t\u0015!\u0003c\u0011\u0015at\u0001\"\u0001n\u0011\u0019\u0011x\u0001)A\u0005g\"1ao\u0002Q!\n]DaA_\u0004!B\u0013Y\bB\u0002@\bA\u0003%q\u0010C\u0004\u0002&\u001d!\t!a\n\t\u000f\u0005=r\u0001\"\u0011\u0002(!9\u0011\u0011G\u0004\u0005\n\u0005\u001db!\u0002\u001b(\t\u0005M\u0002\u0002\u00030\u0013\u0005\u0003\u0005\u000b\u0011B0\t\rq\u0012B\u0011AA\u001f\u0011)\t\u0019E\u0005a\u0001\u0002\u0003\u0006Ka\u001e\u0005\u000b\u0003\u000b\u0012\u0002\u0019!A!B\u00139\bBCA$%\u0001\u0007\t\u0011)Q\u0005w\"Y\u0011\u0011\n\nA\u0002\u0003\u0005\u000b\u0015BA&\u0011-\tYF\u0005a\u0001\u0002\u0003\u0006K!a\u0013\t\u000f\u0005u#\u0003)Q\u0005w\"9\u0011q\f\n!B\u0013Y\bbCA1%\u0001\u0007\t\u0011)Q\u0005\u0003GBq!a\u001a\u0013\t\u0003\nI\u0007C\u0004\u0002^I!\t%!\u001e\t\u000f\u0005e$\u0003\"\u0011\u0002|!9\u0011Q\u0012\n\u0005B\u0005=\u0005bBAK%\u0011\u0005\u0013q\u0013\u0005\b\u0003;\u0013B\u0011IAP\u0011\u001d\t\u0019K\u0005C!\u0003KCq!!2\u0013\t\u0003\n9\rC\u0004\u0002LJ!\t%!4\u0002'\rC\u0017M\u001c8fYN#\u0018\r^:IC:$G.\u001a:\u000b\u0005!J\u0013aB2iC:tW\r\u001c\u0006\u0003U-\naA\\3uif$$B\u0001\u0017.\u0003\u001d1\u0017N\\1hY\u0016T!AL\u0018\u0002\u000fQ<\u0018\u000e\u001e;fe*\t\u0001'A\u0002d_6\u001c\u0001\u0001\u0005\u00024\u00035\tqEA\nDQ\u0006tg.\u001a7Ti\u0006$8\u000fS1oI2,'o\u0005\u0002\u0002mA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001a\u0002\u00071|w-F\u0001A!\t\t\u0005*D\u0001C\u0015\t\u0019E)A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u00153\u0015\u0001B;uS2T\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\u0005\n1Aj\\4hKJ\fA\u0001\\8hA\u00051Bk\u00199Ti\u0006$8/\u00169eCR,\u0017J\u001c;feZ\fG.F\u0001N!\tq\u0005+D\u0001P\u0015\t)U&\u0003\u0002R\u001f\nAA)\u001e:bi&|g.A\fUGB\u001cF/\u0019;t+B$\u0017\r^3J]R,'O^1mA\tyAk\u00199Ti\u0006$8/\u00169eCR,'oE\u0002\b+n\u0003\"AV-\u000e\u0003]S!\u0001\u0017$\u0002\t1\fgnZ\u0005\u00035^\u0013aa\u00142kK\u000e$\bC\u0001,]\u0013\tivK\u0001\u0005Sk:t\u0017M\u00197f\u0003I\u0019\b.\u0019:fI\u000eC\u0017M\u001c8fYN#\u0018\r^:\u0011\u0005M\u0002\u0017BA1(\u0005I\u0019\u0006.\u0019:fI\u000eC\u0017M\u001c8fYN#\u0018\r^:\u0011\u0005\r\\W\"\u00013\u000b\u0005\u00154\u0017!B3q_2d'B\u0001\u0015h\u0015\tA\u0017.A\u0003oKR$\u0018PC\u0001k\u0003\tIw.\u0003\u0002mI\n\u0011R\t]8mYN{7m[3u\u0007\"\fgN\\3m)\rq\u0007/\u001d\t\u0003_\u001ei\u0011!\u0001\u0005\u0006=*\u0001\ra\u0018\u0005\u0006Q)\u0001\rAY\u0001\bi\u000e\u0004\u0018J\u001c4p!\t\u0019G/\u0003\u0002vI\naQ\t]8mYR\u001b\u0007/\u00138g_\u0006yA.Y:u%\u0016$(/\u00198t[&$8\u000f\u0005\u00028q&\u0011\u0011\u0010\u000f\u0002\u0005\u0019>tw-A\u0005dC:\u001cW\r\u001c7fIB\u0011q\u0007`\u0005\u0003{b\u0012qAQ8pY\u0016\fg.A\btG\",G-\u001e7fIV\u0003H-\u0019;fa\u0011\t\t!a\u0005\u0011\r\u0005\r\u00111BA\b\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011AC2p]\u000e,(O]3oi*\u0011QiZ\u0005\u0005\u0003\u001b\t)AA\bTG\",G-\u001e7fI\u001a+H/\u001e:f!\u0011\t\t\"a\u0005\r\u0001\u0011Y\u0011Q\u0003\b\u0002\u0002\u0003\u0005)\u0011AA\f\u0005\ryF%M\t\u0005\u00033\ty\u0002E\u00028\u00037I1!!\b9\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aNA\u0011\u0013\r\t\u0019\u0003\u000f\u0002\u0004\u0003:L\u0018AB2b]\u000e,G\u000e\u0006\u0002\u0002*A\u0019q'a\u000b\n\u0007\u00055\u0002H\u0001\u0003V]&$\u0018a\u0001:v]\u0006\tR\u000f\u001d3bi\u0016\u001cvnY6fiN#\u0018\r^:\u0014\u0007I\t)\u0004\u0005\u0003\u00028\u0005eR\"\u00014\n\u0007\u0005mbM\u0001\u000bDQ\u0006tg.\u001a7EkBdW\r\u001f%b]\u0012dWM\u001d\u000b\u0005\u0003\u007f\t\t\u0005\u0005\u00024%!)a\f\u0006a\u0001?\u0006\u00012\r[1o]\u0016d')\u001f;fgJ+\u0017\rZ\u0001\u0014G\"\fgN\\3m\u0005f$Xm],sSR$XM\\\u0001\u0013G\"\fgN\\3m/\u0006\u001cxK]5uC\ndW-A\fdQ\u0006tg.\u001a7Xe&$\u0018M\u00197f\tV\u0014\u0018\r^5p]B!\u0011QJA*\u001d\rq\u0015qJ\u0005\u0004\u0003#z\u0015!C*u_B<\u0018\r^2i\u0013\u0011\t)&a\u0016\u0003\u000f\u0015c\u0017\r]:fI&\u0019\u0011\u0011L(\u0003\u0013M#x\u000e]<bi\u000eD\u0017AE2p]:,7\r^5p]\u0012+(/\u0019;j_:\fQb\u00195b]:,G.Q2uSZ,\u0017\u0001\u0005;mg\u000eC\u0017M\u001c8fY\u0006\u001bG/\u001b<f\u0003=!8\r]*uCR\u001cX\u000b\u001d3bi\u0016\u0014\bcAA3\u000f9\u00111\u0007A\u0001\rQ\u0006tG\r\\3s\u0003\u0012$W\r\u001a\u000b\u0005\u0003S\tY\u0007C\u0004\u0002nu\u0001\r!a\u001c\u0002\u0007\r$\b\u0010\u0005\u0003\u00028\u0005E\u0014bAA:M\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$H\u0003BA\u0015\u0003oBq!!\u001c\u001f\u0001\u0004\ty'A\u0003xe&$X\r\u0006\u0005\u0002*\u0005u\u0014qPAB\u0011\u001d\tig\ba\u0001\u0003_Ba!!! \u0001\u0004)\u0016aA7tO\"9\u0011QQ\u0010A\u0002\u0005\u001d\u0015!\u00019\u0011\t\u0005]\u0012\u0011R\u0005\u0004\u0003\u00173'AD\"iC:tW\r\u001c)s_6L7/Z\u0001\fG\"\fgN\\3m%\u0016\fG\r\u0006\u0004\u0002*\u0005E\u00151\u0013\u0005\b\u0003[\u0002\u0003\u0019AA8\u0011\u0019\t\t\t\ta\u0001+\u0006)1\r\\8tKR1\u0011\u0011FAM\u00037Cq!!\u001c\"\u0001\u0004\ty\u0007C\u0004\u0002\u0006\u0006\u0002\r!a\"\u0002\u001f\rD\u0017M\u001c8fY&s\u0017m\u0019;jm\u0016$B!!\u000b\u0002\"\"9\u0011Q\u000e\u0012A\u0002\u0005=\u0014aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\r\u0005%\u0012qUAU\u0011\u001d\tig\ta\u0001\u0003_Bq!a+$\u0001\u0004\ti+A\u0003dCV\u001cX\r\u0005\u0003\u00020\u0006}f\u0002BAY\u0003wsA!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003o\u000b\u0014A\u0002\u001fs_>$h(C\u0001:\u0013\r\ti\fO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t-a1\u0003\u0013QC'o\\<bE2,'bAA_q\u0005I2\r[1o]\u0016dwK]5uC\nLG.\u001b;z\u0007\"\fgnZ3e)\u0011\tI#!3\t\u000f\u00055D\u00051\u0001\u0002p\u0005\u0011Ro]3s\u000bZ,g\u000e\u001e+sS\u001e<WM]3e)\u0019\tI#a4\u0002R\"9\u0011QN\u0013A\u0002\u0005=\u0004BBAjK\u0001\u0007a'A\u0002fmR\u0004")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final SharedChannelStats sharedChannelStats;
    private long channelBytesRead;
    private long channelBytesWritten;
    private boolean channelWasWritable;
    private Function0<Duration> channelWritableDuration;
    private Function0<Duration> connectionDuration;
    private boolean channelActive;
    private boolean tlsChannelActive;
    private TcpStatsUpdater tcpStatsUpdater;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.channelBytesRead = 0L;
        this.channelBytesWritten = 0L;
        this.channelWasWritable = true;
        this.channelWritableDuration = Stopwatch$.MODULE$.start();
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.sharedChannelStats.connects().incr();
        this.sharedChannelStats.connectionCountIncrement();
        Channel channel = ctx.channel();
        if (channel instanceof EpollSocketChannel) {
            EpollSocketChannel epollSocketChannel = (EpollSocketChannel)channel;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
            }
            this.tcpStatsUpdater = new TcpStatsUpdater(this.sharedChannelStats, epollSocketChannel);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        EventLoop eventLoop = ctx.channel().eventLoop();
        if (eventLoop instanceof SingleThreadEventLoop) {
            SingleThreadEventLoop singleThreadEventLoop = (SingleThreadEventLoop)eventLoop;
            this.sharedChannelStats.registerEventLoop(singleThreadEventLoop);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.channelActive = true;
        this.connectionDuration = Stopwatch$.MODULE$.start();
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.sentBytes().incr((long)readableBytes);
            this.channelBytesWritten += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder(48).append("ChannelStatsHandler received non-ByteBuf write: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.receivedBytes().incr((long)readableBytes);
            this.channelBytesRead += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder(47).append("ChannelStatsHandler received non-ByteBuf read: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.sharedChannelStats.closesCount().incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channelActive) {
            EventLoop eventLoop;
            this.channelActive = false;
            Function0<Duration> elapsed = this.connectionDuration;
            this.connectionDuration = null;
            this.sharedChannelStats.connectionDuration().add((float)((TimeLike)elapsed.apply()).inMilliseconds());
            this.sharedChannelStats.connectionCountDecrement();
            long oldChannelBytesRead = this.channelBytesRead;
            long oldChannelBytesWritten = this.channelBytesWritten;
            this.channelBytesRead = 0L;
            this.channelBytesWritten = 0L;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
                this.tcpStatsUpdater = null;
            }
            this.sharedChannelStats.connectionReceivedBytes().add((float)oldChannelBytesRead);
            this.sharedChannelStats.connectionSentBytes().add((float)oldChannelBytesWritten);
            if (this.tlsChannelActive) {
                this.tlsChannelActive = false;
                this.sharedChannelStats.tlsConnectionCountDecrement();
            }
            if ((eventLoop = ctx.channel().eventLoop()) instanceof SingleThreadEventLoop) {
                SingleThreadEventLoop singleThreadEventLoop = (SingleThreadEventLoop)eventLoop;
                this.sharedChannelStats.unregisterEventLoop(singleThreadEventLoop);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.sharedChannelStats.exceptions().counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof TimeoutException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != this.channelWasWritable) {
            Duration elapsed = (Duration)this.channelWritableDuration.apply();
            Counter stat = this.channelWasWritable ? this.sharedChannelStats.writable() : this.sharedChannelStats.unwritable();
            stat.incr((long)((int)elapsed.inMilliseconds()));
            this.channelWasWritable = isWritable;
            this.channelWritableDuration = Stopwatch$.MODULE$.start();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (object instanceof SslHandshakeCompletionEvent) {
            BoxedUnit boxedUnit;
            if (this.channelActive) {
                this.tlsChannelActive = true;
                this.sharedChannelStats.tlsConnectionCountIncrement();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public ChannelStatsHandler(SharedChannelStats sharedChannelStats) {
        this.sharedChannelStats = sharedChannelStats;
        this.channelActive = false;
        this.tlsChannelActive = false;
    }

    public static final class TcpStatsUpdater
    implements Runnable {
        private final SharedChannelStats sharedChannelStats;
        private final EpollSocketChannel channel;
        private final EpollTcpInfo tcpInfo;
        private long lastRetransmits;
        private boolean cancelled;
        private final ScheduledFuture<?> scheduledUpdate;

        public void cancel() {
            this.cancelled = true;
            this.scheduledUpdate.cancel(false);
        }

        @Override
        public void run() {
            block0: {
                if (this.cancelled) break block0;
                this.updateSocketStats();
            }
        }

        private void updateSocketStats() {
            try {
                this.channel.tcpInfo(this.tcpInfo);
                this.sharedChannelStats.tcpSendWindowSize().add((float)(this.tcpInfo.sndCwnd() * this.tcpInfo.sndMss()));
                long retransmits = this.tcpInfo.totalRetrans();
                this.sharedChannelStats.retransmits().incr(retransmits - this.lastRetransmits);
                this.lastRetransmits = retransmits;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ChannelException) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(Level.WARNING, "Error updating TCP info stats", t);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        public TcpStatsUpdater(SharedChannelStats sharedChannelStats, EpollSocketChannel channel) {
            this.sharedChannelStats = sharedChannelStats;
            this.channel = channel;
            this.tcpInfo = new EpollTcpInfo();
            this.lastRetransmits = 0L;
            this.cancelled = false;
            this.scheduledUpdate = channel.eventLoop().scheduleAtFixedRate((Runnable)this, 0L, ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$TcpStatsUpdateInterval().inMilliseconds(), TimeUnit.MILLISECONDS);
        }
    }
}

