/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4;

import com.twitter.finagle.CancelledConnectionException;
import com.twitter.finagle.ConnectionFailedException;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.ProxyConnectException;
import com.twitter.finagle.Stack;
import com.twitter.finagle.netty4.ConnectionBuilder$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055b!\u0002\n\u0014\u0005UY\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u0011E\u0002!\u0011!Q\u0001\nIB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B&\t\rE\u0003\u0001\u0015!\u0003S\u0011\u0019)\u0006\u0001)A\u0005%\"1a\u000b\u0001Q\u0001\n]CaA\u0017\u0001!\u0002\u0013Y\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00022\u0001\t\u0003\u0019wAB>\u0014\u0011\u0003)BP\u0002\u0004\u0013'!\u0005Q# \u0005\u0006\u00076!\tA \u0005\u0007\u007f6!\t!!\u0001\t\u000f\u0005]Q\u0002\"\u0003\u0002\u001a!9\u00111E\u0007\u0005\n\u0005\u0015\"!E\"p]:,7\r^5p]\n+\u0018\u000e\u001c3fe*\u0011A#F\u0001\u0007]\u0016$H/\u001f\u001b\u000b\u0005Y9\u0012a\u00024j]\u0006<G.\u001a\u0006\u00031e\tq\u0001^<jiR,'OC\u0001\u001b\u0003\r\u0019w.\\\n\u0003\u0001q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0017\u0001B5oSR\u001c\u0001\u0001E\u0002&Y9j\u0011A\n\u0006\u0003O!\nqa\u00195b]:,GN\u0003\u0002*U\u0005)a.\u001a;us*\t1&\u0001\u0002j_&\u0011QF\n\u0002\u0013\u0007\"\fgN\\3m\u0013:LG/[1mSj,'\u000f\u0005\u0002&_%\u0011\u0001G\n\u0002\b\u0007\"\fgN\\3m\u0003\u0011\tG\r\u001a:\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014a\u00018fi*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u00055\u0019vnY6fi\u0006#GM]3tg\u00061\u0001/\u0019:b[N\u0004\"\u0001\u0010!\u000f\u0005urT\"A\u000b\n\u0005}*\u0012!B*uC\u000e\\\u0017BA!C\u0005\u0019\u0001\u0016M]1ng*\u0011q(F\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0015;\u0005*\u0013\t\u0003\r\u0002i\u0011a\u0005\u0005\u0006E\u0011\u0001\r\u0001\n\u0005\u0006c\u0011\u0001\rA\r\u0005\u0006u\u0011\u0001\raO\u0001\u000egR\fGo\u001d*fG\u0016Lg/\u001a:\u0011\u00051{U\"A'\u000b\u00059+\u0012!B:uCR\u001c\u0018B\u0001)N\u00055\u0019F/\u0019;t%\u0016\u001cW-\u001b<fe\u0006\u00112m\u001c8oK\u000e$H*\u0019;f]\u000eL8\u000b^1u!\ta5+\u0003\u0002U\u001b\n!1\u000b^1u\u0003a1\u0017-\u001b7fI\u000e{gN\\3di2\u000bG/\u001a8dsN#\u0018\r^\u0001\u0012G\u0006t7-\u001a7mK\u0012\u001cuN\u001c8fGR\u001c\bC\u0001'Y\u0013\tIVJA\u0004D_VtG/\u001a:\u0002\u0013\t|w\u000e^:ue\u0006\u0004\bC\u0001/_\u001b\u0005i&B\u0001.)\u0013\tyVLA\u0005C_>$8\u000f\u001e:ba\u0006i!/Z7pi\u0016\fE\r\u001a:fgN,\u0012AM\u0001\u0006EVLG\u000eZ\u000b\u0003I6$\"!\u001a<\u0011\u0007\u0019L7.D\u0001h\u0015\tAw#\u0001\u0003vi&d\u0017B\u00016h\u0005\u00191U\u000f^;sKB\u0011A.\u001c\u0007\u0001\t\u0015q7B1\u0001p\u0005\u0005!\u0016C\u00019t!\ti\u0012/\u0003\u0002s=\t9aj\u001c;iS:<\u0007CA\u000fu\u0013\t)hDA\u0002B]fDQa^\u0006A\u0002a\fqAY;jY\u0012,'\u000f\u0005\u0003\u001es:*\u0017B\u0001>\u001f\u0005%1UO\\2uS>t\u0017'A\tD_:tWm\u0019;j_:\u0014U/\u001b7eKJ\u0004\"AR\u0007\u0014\u00055aB#\u0001?\u0002\u0013I\fwo\u00117jK:$HcB#\u0002\u0004\u0005M\u0011Q\u0003\u0005\u0007E=\u0001\r!!\u0002\u0011\ruI\u0018qAA\u0007!\r)\u0013\u0011B\u0005\u0004\u0003\u00171#aD\"iC:tW\r\u001c)ja\u0016d\u0017N\\3\u0011\u0007u\ty!C\u0002\u0002\u0012y\u0011A!\u00168ji\")\u0011g\u0004a\u0001e!)!h\u0004a\u0001w\u00059\u0011n\u001d'pG\u0006dG\u0003BA\u000e\u0003C\u00012!HA\u000f\u0013\r\tyB\b\u0002\b\u0005>|G.Z1o\u0011\u0015\t\u0004\u00031\u00013\u00035i\u0017m[3C_>$8\u000f\u001e:baR91,a\n\u0002*\u0005-\u0002\"\u0002\u0012\u0012\u0001\u0004!\u0003\"B\u0019\u0012\u0001\u0004\u0011\u0004\"\u0002\u001e\u0012\u0001\u0004Y\u0004")
public final class ConnectionBuilder {
    public final SocketAddress com$twitter$finagle$netty4$ConnectionBuilder$$addr;
    private final StatsReceiver statsReceiver;
    public final Stat com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat;
    public final Stat com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat;
    public final Counter com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects;
    private final Bootstrap bootstrap;

    public static ConnectionBuilder rawClient(Function1<ChannelPipeline, BoxedUnit> function1, SocketAddress socketAddress, Stack.Params params) {
        return ConnectionBuilder$.MODULE$.rawClient(function1, socketAddress, params);
    }

    public SocketAddress remoteAddress() {
        return this.com$twitter$finagle$netty4$ConnectionBuilder$$addr;
    }

    public <T> Future<T> build(Function1<Channel, Future<T>> builder) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        ChannelFuture nettyConnectF = this.bootstrap.connect(this.com$twitter$finagle$netty4$ConnectionBuilder$$addr);
        Promise transportP = new Promise();
        transportP.setInterruptHandler((PartialFunction)new Serializable(null, nettyConnectF){
            public static final long serialVersionUID = 0L;
            private final ChannelFuture nettyConnectF$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.nettyConnectF$1.cancel(false);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.nettyConnectF$1 = nettyConnectF$1;
            }
        });
        nettyConnectF.addListener((GenericFutureListener)new ChannelFutureListener(this, elapsed, transportP, builder){
            private final /* synthetic */ ConnectionBuilder $outer;
            private final Function0 elapsed$1;
            private final Promise transportP$1;
            private final Function1 builder$1;

            public void operationComplete(ChannelFuture channelF) {
                long latency = ((TimeLike)this.elapsed$1.apply()).inMilliseconds();
                if (channelF.isCancelled()) {
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat.add((float)latency);
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects.incr();
                    this.transportP$1.setException((Throwable)Failure$.MODULE$.apply((Throwable)new CancelledConnectionException(), FailureFlags$.MODULE$.Interrupted() | FailureFlags$.MODULE$.Retryable(), (Level)Level.DEBUG$.MODULE$));
                } else if (channelF.cause() != null) {
                    UnresolvedAddressException unresolvedAddressException;
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat.add((float)latency);
                    Throwable throwable = channelF.cause();
                    if (throwable instanceof UnresolvedAddressException) {
                        UnresolvedAddressException unresolvedAddressException2;
                        unresolvedAddressException = unresolvedAddressException2 = (UnresolvedAddressException)throwable;
                    } else if (throwable instanceof ProxyConnectException) {
                        ProxyConnectException proxyConnectException = (ProxyConnectException)throwable;
                        unresolvedAddressException = proxyConnectException;
                    } else {
                        unresolvedAddressException = Failure$.MODULE$.rejected((Throwable)new ConnectionFailedException(throwable, this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$addr));
                    }
                    this.transportP$1.setException((Throwable)unresolvedAddressException);
                } else if (!channelF.channel().isOpen()) {
                    this.transportP$1.setException((Throwable)Failure$.MODULE$.rejected("Netty4 Channel was found in a closed state"));
                } else {
                    Future future;
                    this.$outer.com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat.add((float)latency);
                    Channel ch = channelF.channel();
                    try {
                        future = (Future)this.builder$1.apply((Object)ch);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable t = (Throwable)option.get();
                        ch.close();
                        Future future2 = Future$.MODULE$.exception(t);
                        future = future2;
                    }
                    Future result = future;
                    result.proxyTo(this.transportP$1);
                    this.transportP$1.setInterruptHandler((PartialFunction)new Serializable(null, ch, result){
                        public static final long serialVersionUID = 0L;
                        private final Channel ch$1;
                        private final Future result$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            this.ch$1.close();
                            this.result$1.raise(A1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return (B1)boxedUnit;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = true;
                            return bl;
                        }
                        {
                            this.ch$1 = ch$1;
                            this.result$1 = result$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.elapsed$1 = elapsed$1;
                this.transportP$1 = transportP$1;
                this.builder$1 = builder$1;
            }
        });
        return transportP;
    }

    public ConnectionBuilder(ChannelInitializer<Channel> init, SocketAddress addr, Stack.Params params) {
        this.com$twitter$finagle$netty4$ConnectionBuilder$$addr = addr;
        this.statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        this.com$twitter$finagle$netty4$ConnectionBuilder$$connectLatencyStat = this.statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connect_latency_ms"}));
        this.com$twitter$finagle$netty4$ConnectionBuilder$$failedConnectLatencyStat = this.statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed_connect_latency_ms"}));
        this.com$twitter$finagle$netty4$ConnectionBuilder$$cancelledConnects = this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cancelled_connects"}));
        this.bootstrap = ConnectionBuilder$.MODULE$.com$twitter$finagle$netty4$ConnectionBuilder$$makeBootstrap(init, addr, params);
    }
}

