/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.netty4.channel.SharedChannelStats;
import com.twitter.finagle.stats.Counter;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ew!B\u0014)\u0011\u0013\u0019d!B\u001b)\u0011\u00131\u0004\"B\u001f\u0002\t\u0003q\u0004bB \u0002\u0005\u0004%I\u0001\u0011\u0005\u0007\u0017\u0006\u0001\u000b\u0011B!\t\u000f1\u000b!\u0019!C\u0007\u001b\"11+\u0001Q\u0001\u000e93A\u0001V\u0001\u0007+\"Aql\u0002B\u0001B\u0003%\u0001\r\u0003\u0005*\u000f\t\u0005\t\u0015!\u0003d\u0011\u0015it\u0001\"\u0001o\u0011\u0019\u0019x\u0001)A\u0005i\"1qo\u0002Q!\naDaa_\u0004!B\u0013a\bbB@\bA\u0003%\u0011\u0011\u0001\u0005\b\u0003O9A\u0011AA\u0015\u0011\u001d\t\td\u0002C!\u0003SAq!a\r\b\t\u0013\tICB\u00036Q\u0011\t)\u0004\u0003\u0005`%\t\u0005\t\u0015!\u0003a\u0011\u0019i$\u0003\"\u0001\u0002@!Q\u0011Q\t\nA\u0002\u0003\u0005\u000b\u0015\u0002=\t\u0015\u0005\u001d#\u00031A\u0001B\u0003&\u0001\u0010\u0003\u0006\u0002JI\u0001\r\u0011!Q!\nqD1\"a\u0013\u0013\u0001\u0004\u0005\t\u0015)\u0003\u0002N!Y\u0011Q\f\nA\u0002\u0003\u0005\u000b\u0015BA'\u0011\u001d\tyF\u0005Q!\nqDq!!\u0019\u0013A\u0003&A\u0010C\u0004\u0002dI\u0001\u000b\u0015\u0002?\t\u0017\u0005\u0015$\u00031A\u0001B\u0003&\u0011q\r\u0005\b\u0003W\u0012B\u0011IA7\u0011\u001d\tyF\u0005C!\u0003sBq!! \u0013\t\u0003\ny\bC\u0004\u0002\u0012J!\t%a%\t\u000f\u0005e%\u0003\"\u0011\u0002\u001c\"9\u0011\u0011\u0015\n\u0005B\u0005\r\u0006bBAT%\u0011\u0005\u0013\u0011\u0016\u0005\b\u0003\u0013\u0014B\u0011IAf\u0011\u001d\tyM\u0005C!\u0003#\f1c\u00115b]:,Gn\u0015;biND\u0015M\u001c3mKJT!!\u000b\u0016\u0002\u000f\rD\u0017M\u001c8fY*\u00111\u0006L\u0001\u0007]\u0016$H/\u001f\u001b\u000b\u00055r\u0013a\u00024j]\u0006<G.\u001a\u0006\u0003_A\nq\u0001^<jiR,'OC\u00012\u0003\r\u0019w.\\\u0002\u0001!\t!\u0014!D\u0001)\u0005M\u0019\u0005.\u00198oK2\u001cF/\u0019;t\u0011\u0006tG\r\\3s'\t\tq\u0007\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\n1\u0001\\8h+\u0005\t\u0005C\u0001\"J\u001b\u0005\u0019%B\u0001#F\u0003\u001dawnZ4j]\u001eT!AR$\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQ5I\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\fUGB\u001cF/\u0019;t+B$\u0017\r^3J]R,'O^1m+\u0005q\u0005CA(R\u001b\u0005\u0001&B\u0001$/\u0013\t\u0011\u0006K\u0001\u0005EkJ\fG/[8o\u0003]!6\r]*uCR\u001cX\u000b\u001d3bi\u0016Le\u000e^3sm\u0006d\u0007EA\bUGB\u001cF/\u0019;t+B$\u0017\r^3s'\r9a\u000b\u0018\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u001e\u000bA\u0001\\1oO&\u00111\f\u0017\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]k\u0016B\u00010Y\u0005!\u0011VO\u001c8bE2,\u0017AE:iCJ,Gm\u00115b]:,Gn\u0015;biN\u0004\"\u0001N1\n\u0005\tD#AE*iCJ,Gm\u00115b]:,Gn\u0015;biN\u0004\"\u0001\u001a7\u000e\u0003\u0015T!AZ4\u0002\u000b\u0015\u0004x\u000e\u001c7\u000b\u0005%B'BA5k\u0003\u0015qW\r\u001e;z\u0015\u0005Y\u0017AA5p\u0013\tiWM\u0001\nFa>dGnU8dW\u0016$8\t[1o]\u0016dGcA8reB\u0011\u0001oB\u0007\u0002\u0003!)qL\u0003a\u0001A\")\u0011F\u0003a\u0001G\u00069Ao\u00199J]\u001a|\u0007C\u00013v\u0013\t1XM\u0001\u0007Fa>dG\u000eV2q\u0013:4w.A\bmCN$(+\u001a;sC:\u001cX.\u001b;t!\tA\u00140\u0003\u0002{s\t!Aj\u001c8h\u0003%\u0019\u0017M\\2fY2,G\r\u0005\u00029{&\u0011a0\u000f\u0002\b\u0005>|G.Z1o\u0003=\u00198\r[3ek2,G-\u00169eCR,\u0007\u0007BA\u0002\u0003+\u0001b!!\u0002\u0002\u000e\u0005EQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002GQ&!\u0011qBA\u0004\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007\u0003BA\n\u0003+a\u0001\u0001B\u0006\u0002\u00189\t\t\u0011!A\u0003\u0002\u0005e!aA0%cE!\u00111DA\u0011!\rA\u0014QD\u0005\u0004\u0003?I$a\u0002(pi\"Lgn\u001a\t\u0004q\u0005\r\u0012bAA\u0013s\t\u0019\u0011I\\=\u0002\r\r\fgnY3m)\t\tY\u0003E\u00029\u0003[I1!a\f:\u0005\u0011)f.\u001b;\u0002\u0007I,h.A\tva\u0012\fG/Z*pG.,Go\u0015;biN\u001c2AEA\u001c!\u0011\tI$a\u000f\u000e\u0003\u001dL1!!\u0010h\u0005Q\u0019\u0005.\u00198oK2$U\u000f\u001d7fq\"\u000bg\u000e\u001a7feR!\u0011\u0011IA\"!\t!$\u0003C\u0003`)\u0001\u0007\u0001-\u0001\tdQ\u0006tg.\u001a7CsR,7OU3bI\u0006\u00192\r[1o]\u0016d')\u001f;fg^\u0013\u0018\u000e\u001e;f]\u0006\u00112\r[1o]\u0016dw+Y:Xe&$\u0018M\u00197f\u0003]\u0019\u0007.\u00198oK2<&/\u001b;bE2,G)\u001e:bi&|g\u000e\u0005\u0003\u0002P\u0005UcbA(\u0002R%\u0019\u00111\u000b)\u0002\u0013M#x\u000e]<bi\u000eD\u0017\u0002BA,\u00033\u0012q!\u00127baN,G-C\u0002\u0002\\A\u0013\u0011b\u0015;pa^\fGo\u00195\u0002%\r|gN\\3di&|g\u000eR;sCRLwN\\\u0001\u000eG\"\fgN\\3m\u0003\u000e$\u0018N^3\u0002!Qd7o\u00115b]:,G.Q2uSZ,\u0017aC2m_N,7)\u00197mK\u0012\fq\u0002^2q'R\fGo]+qI\u0006$XM\u001d\t\u0004\u0003S:aB\u0001\u001b\u0001\u00031A\u0017M\u001c3mKJ\fE\rZ3e)\u0011\tY#a\u001c\t\u000f\u0005Ed\u00041\u0001\u0002t\u0005\u00191\r\u001e=\u0011\t\u0005e\u0012QO\u0005\u0004\u0003o:'!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u000b\u0005\u0003W\tY\bC\u0004\u0002r}\u0001\r!a\u001d\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0011\u0005-\u0012\u0011QAB\u0003\u000fCq!!\u001d!\u0001\u0004\t\u0019\b\u0003\u0004\u0002\u0006\u0002\u0002\rAV\u0001\u0004[N<\u0007bBAEA\u0001\u0007\u00111R\u0001\u0002aB!\u0011\u0011HAG\u0013\r\tyi\u001a\u0002\u000f\u0007\"\fgN\\3m!J|W.[:f\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\r\u0005-\u0012QSAL\u0011\u001d\t\t(\ta\u0001\u0003gBa!!\"\"\u0001\u00041\u0016!B2m_N,GCBA\u0016\u0003;\u000by\nC\u0004\u0002r\t\u0002\r!a\u001d\t\u000f\u0005%%\u00051\u0001\u0002\f\u0006y1\r[1o]\u0016d\u0017J\\1di&4X\r\u0006\u0003\u0002,\u0005\u0015\u0006bBA9G\u0001\u0007\u00111O\u0001\u0010Kb\u001cW\r\u001d;j_:\u001c\u0015-^4iiR1\u00111FAV\u0003[Cq!!\u001d%\u0001\u0004\t\u0019\bC\u0004\u00020\u0012\u0002\r!!-\u0002\u000b\r\fWo]3\u0011\t\u0005M\u00161\u0019\b\u0005\u0003k\u000byL\u0004\u0003\u00028\u0006uVBAA]\u0015\r\tYLM\u0001\u0007yI|w\u000e\u001e \n\u0003iJ1!!1:\u0003\u001d\u0001\u0018mY6bO\u0016LA!!2\u0002H\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003L\u0014!G2iC:tW\r\\,sSR\f'-\u001b7jif\u001c\u0005.\u00198hK\u0012$B!a\u000b\u0002N\"9\u0011\u0011O\u0013A\u0002\u0005M\u0014AE;tKJ,e/\u001a8u)JLwmZ3sK\u0012$b!a\u000b\u0002T\u0006U\u0007bBA9M\u0001\u0007\u00111\u000f\u0005\u0007\u0003/4\u0003\u0019A\u001c\u0002\u0007\u00154H\u000f")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final SharedChannelStats sharedChannelStats;
    private long channelBytesRead;
    private long channelBytesWritten;
    private boolean channelWasWritable;
    private Function0<Duration> channelWritableDuration;
    private Function0<Duration> connectionDuration;
    private boolean channelActive;
    private boolean tlsChannelActive;
    private boolean closeCalled;
    private TcpStatsUpdater tcpStatsUpdater;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.channelBytesRead = 0L;
        this.channelBytesWritten = 0L;
        this.channelWasWritable = true;
        this.channelWritableDuration = Stopwatch$.MODULE$.start();
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.sharedChannelStats.connectionIncrement();
        Channel channel = ctx.channel();
        if (channel instanceof EpollSocketChannel) {
            EpollSocketChannel epollSocketChannel = (EpollSocketChannel)channel;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
            }
            this.tcpStatsUpdater = new TcpStatsUpdater(this.sharedChannelStats, epollSocketChannel);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.channelActive = true;
        this.connectionDuration = Stopwatch$.MODULE$.start();
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.sentBytes().incr((long)readableBytes);
            this.channelBytesWritten += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder(48).append("ChannelStatsHandler received non-ByteBuf write: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.receivedBytes().incr((long)readableBytes);
            this.channelBytesRead += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder(47).append("ChannelStatsHandler received non-ByteBuf read: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.sharedChannelStats.closesCount().incr();
        }
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channelActive) {
            this.channelActive = false;
            Function0<Duration> elapsed = this.connectionDuration;
            this.connectionDuration = null;
            this.sharedChannelStats.connectionDuration().add((float)((TimeLike)elapsed.apply()).inMilliseconds());
            this.sharedChannelStats.connectionDecrement();
            long oldChannelBytesRead = this.channelBytesRead;
            long oldChannelBytesWritten = this.channelBytesWritten;
            this.channelBytesRead = 0L;
            this.channelBytesWritten = 0L;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
                this.tcpStatsUpdater = null;
            }
            this.sharedChannelStats.connectionReceivedBytes().add((float)oldChannelBytesRead);
            this.sharedChannelStats.connectionSentBytes().add((float)oldChannelBytesWritten);
            if (this.tlsChannelActive) {
                this.tlsChannelActive = false;
                this.sharedChannelStats.tlsConnectionDecrement();
            }
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.sharedChannelStats.exceptions().counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof TimeoutException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != this.channelWasWritable) {
            Duration elapsed = (Duration)this.channelWritableDuration.apply();
            Counter stat = this.channelWasWritable ? this.sharedChannelStats.writable() : this.sharedChannelStats.unwritable();
            stat.incr((long)((int)elapsed.inMilliseconds()));
            this.channelWasWritable = isWritable;
            this.channelWritableDuration = Stopwatch$.MODULE$.start();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        SslHandshakeCompletionEvent sslHandshakeCompletionEvent;
        Object object = evt;
        if (object instanceof SslHandshakeCompletionEvent && (sslHandshakeCompletionEvent = (SslHandshakeCompletionEvent)object).isSuccess() && this.channelActive) {
            this.tlsChannelActive = true;
            this.sharedChannelStats.tlsConnectionIncrement();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public ChannelStatsHandler(SharedChannelStats sharedChannelStats) {
        this.sharedChannelStats = sharedChannelStats;
        this.channelActive = false;
        this.tlsChannelActive = false;
        this.closeCalled = false;
    }

    public static final class TcpStatsUpdater
    implements Runnable {
        private final SharedChannelStats sharedChannelStats;
        private final EpollSocketChannel channel;
        private final EpollTcpInfo tcpInfo;
        private long lastRetransmits;
        private boolean cancelled;
        private final ScheduledFuture<?> scheduledUpdate;

        public void cancel() {
            this.cancelled = true;
            this.scheduledUpdate.cancel(false);
        }

        @Override
        public void run() {
            block0: {
                if (this.cancelled) break block0;
                this.updateSocketStats();
            }
        }

        private void updateSocketStats() {
            try {
                this.channel.tcpInfo(this.tcpInfo);
                this.sharedChannelStats.tcpSendWindowSize().add((float)(this.tcpInfo.sndCwnd() * this.tcpInfo.sndMss()));
                long retransmits = this.tcpInfo.totalRetrans();
                this.sharedChannelStats.retransmits().incr(retransmits - this.lastRetransmits);
                this.lastRetransmits = retransmits;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ChannelException) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(Level.WARNING, "Error updating TCP info stats", t);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        public TcpStatsUpdater(SharedChannelStats sharedChannelStats, EpollSocketChannel channel) {
            this.sharedChannelStats = sharedChannelStats;
            this.channel = channel;
            this.tcpInfo = new EpollTcpInfo();
            this.lastRetransmits = 0L;
            this.cancelled = false;
            this.scheduledUpdate = channel.eventLoop().scheduleAtFixedRate((Runnable)this, 0L, ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$TcpStatsUpdateInterval().inMilliseconds(), TimeUnit.MILLISECONDS);
        }
    }
}

