/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.ReadTimedOutException;
import com.twitter.finagle.WriteTimedOutException;
import com.twitter.finagle.netty4.channel.ChannelExceptionHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005=qAB\u0001\u0003\u0011\u0003!A\"A\fDQ\u0006tg.\u001a7Fq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\bG\"\fgN\\3m\u0015\t)a!\u0001\u0004oKR$\u0018\u0010\u000e\u0006\u0003\u000f!\tqAZ5oC\u001edWM\u0003\u0002\n\u0015\u00059Ao^5ui\u0016\u0014(\"A\u0006\u0002\u0007\r|W\u000e\u0005\u0002\u000e\u001d5\t!A\u0002\u0004\u0010\u0005!\u0005A\u0001\u0005\u0002\u0018\u0007\"\fgN\\3m\u000bb\u001cW\r\u001d;j_:D\u0015M\u001c3mKJ\u001c\"AD\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0011\u0015Ab\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0007\t\u000fqq!\u0019!C\u0005;\u0005Ib)\u001b8fgRLu*\u0012=dKB$\u0018n\u001c8NKN\u001c\u0018mZ3t+\u0005q\u0002cA\u0010%M5\t\u0001E\u0003\u0002\"E\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003GM\t!bY8mY\u0016\u001cG/[8o\u0013\t)\u0003EA\u0002TKR\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\u0007_9\u0001\u000b\u0011\u0002\u0010\u00025\u0019Kg.Z:u\u0013>+\u0005pY3qi&|g.T3tg\u0006<Wm\u001d\u0011\u0007\u000b=\u0011\u0001\u0001B\u0019\u0014\u0005A\u0012\u0004CA\u001a:\u001b\u0005!$BA\u00026\u0015\t1t'A\u0003oKR$\u0018PC\u00019\u0003\tIw.\u0003\u0002;i\ta2\t[1o]\u0016d\u0017J\u001c2pk:$\u0007*\u00198eY\u0016\u0014\u0018\tZ1qi\u0016\u0014\b\u0002\u0003\u001f1\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u000bM$\u0018\r^:\u0011\u0005y\u0002U\"A \u000b\u0005q2\u0011BA!@\u00055\u0019F/\u0019;t%\u0016\u001cW-\u001b<fe\"A1\t\rB\u0001B\u0003%A)A\u0002m_\u001e\u0004\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u000f1|wmZ5oO*\u0011\u0011JK\u0001\u0005kRLG.\u0003\u0002L\r\n1Aj\\4hKJDQ\u0001\u0007\u0019\u0005\u00025#2AT(Q!\ti\u0001\u0007C\u0003=\u0019\u0002\u0007Q\bC\u0003D\u0019\u0002\u0007A\t\u0003\u0004Sa\u0001\u0006IaU\u0001\u0013e\u0016\fG\rV5nK>,HoQ8v]R,'\u000f\u0005\u0002?)&\u0011Qk\u0010\u0002\b\u0007>,h\u000e^3s\u0011\u00199\u0006\u0007)A\u0005'\u0006\u0019rO]5uKRKW.Z8vi\u000e{WO\u001c;fe\"1\u0011\f\rQ\u0005\ni\u000b\u0001b]3wKJLG/\u001f\u000b\u00037z\u0003\"!\u0012/\n\u0005u3%!\u0002'fm\u0016d\u0007\"B0Y\u0001\u0004\u0001\u0017aA3yGB\u0011\u0011-\u001b\b\u0003E\u001et!a\u00194\u000e\u0003\u0011T!!Z\r\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012B\u00015\u0014\u0003\u001d\u0001\u0018mY6bO\u0016L!A[6\u0003\u0013QC'o\\<bE2,'B\u00015\u0014\u0011\u0015i\u0007\u0007\"\u0011o\u0003=)\u0007pY3qi&|gnQ1vO\"$HcA8soB\u0011!\u0003]\u0005\u0003cN\u0011A!\u00168ji\")1\u000f\u001ca\u0001i\u0006\u00191\r\u001e=\u0011\u0005M*\u0018B\u0001<5\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQ\u0001\u001f7A\u0002\u0001\f\u0011\u0001\u001e\u0015\u0003ai\u00042a_A\u0005\u001d\ra\u0018Q\u0001\b\u0004{\u0006\rab\u0001@\u0002\u00029\u00111m`\u0005\u0002q%\u0011agN\u0005\u0003\u0007UJ1!a\u00025\u00039\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJLA!a\u0003\u0002\u000e\tA1\u000b[1sC\ndWMC\u0002\u0002\bQ\u0002")
public class ChannelExceptionHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log;
    private final Counter readTimeoutCounter;
    private final Counter writeTimeoutCounter;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private java.util.logging.Level severity(Throwable exc) {
        void var2_8;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure = (Failure)throwable;
            Level level = failure.logLevel();
            return var2_8;
        }
        boolean bl = throwable instanceof ClosedChannelException ? true : (throwable instanceof SSLException ? true : (throwable instanceof ReadTimeoutException ? true : (throwable instanceof WriteTimeoutException ? true : throwable instanceof SSLException)));
        if (bl) {
            java.util.logging.Level level = java.util.logging.Level.FINEST;
            return var2_8;
        }
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            if (ChannelExceptionHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelExceptionHandler$$FinestIOExceptionMessages().contains((Object)iOException.getMessage())) {
                java.util.logging.Level level = java.util.logging.Level.FINEST;
                return var2_8;
            }
        }
        java.util.logging.Level level = java.util.logging.Level.WARNING;
        return var2_8;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        Throwable throwable;
        Throwable throwable2 = t;
        if (throwable2 instanceof ReadTimeoutException) {
            this.readTimeoutCounter.incr();
            throwable = new ReadTimedOutException(ctx.channel().remoteAddress());
        } else if (throwable2 instanceof WriteTimeoutException) {
            this.writeTimeoutCounter.incr();
            throwable = new WriteTimedOutException(ctx.channel().remoteAddress());
        } else {
            throwable = throwable2;
        }
        Throwable wrappedException = throwable;
        String remoteAddr = (String)Option$.MODULE$.apply((Object)ctx.channel().remoteAddress()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown remote address");
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled exception in connection with ", ", shutting down connection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{remoteAddr}));
        this.log.log(this.severity(t), msg, t);
        super.exceptionCaught(ctx, wrappedException);
    }

    public ChannelExceptionHandler(StatsReceiver stats, Logger log) {
        this.log = log;
        this.readTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_timeout"}));
        this.writeTimeoutCounter = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write_timeout"}));
    }
}

