/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.ssl;

import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.TrustCredentials;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import scala.MatchError;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public final class Netty4SslConfigurations$ {
    public static Netty4SslConfigurations$ MODULE$;

    static {
        new Netty4SslConfigurations$();
    }

    public SslContextBuilder configureTrust(SslContextBuilder builder, TrustCredentials trustCredentials) {
        SslContextBuilder sslContextBuilder;
        TrustCredentials trustCredentials2 = trustCredentials;
        if (TrustCredentials.Unspecified$.MODULE$.equals(trustCredentials2)) {
            sslContextBuilder = builder;
        } else if (TrustCredentials.Insecure$.MODULE$.equals(trustCredentials2)) {
            sslContextBuilder = builder.sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (trustCredentials2 instanceof TrustCredentials.CertCollection) {
            TrustCredentials.CertCollection certCollection = (TrustCredentials.CertCollection)trustCredentials2;
            File file = certCollection.file();
            sslContextBuilder = builder.trustManager(file);
        } else {
            throw new MatchError((Object)trustCredentials2);
        }
        return sslContextBuilder;
    }

    public SslContextBuilder configureApplicationProtocols(SslContextBuilder builder, ApplicationProtocols applicationProtocols) {
        SslContextBuilder sslContextBuilder;
        ApplicationProtocols applicationProtocols2 = applicationProtocols;
        if (ApplicationProtocols.Unspecified$.MODULE$.equals(applicationProtocols2)) {
            sslContextBuilder = builder;
        } else if (applicationProtocols2 instanceof ApplicationProtocols.Supported) {
            ApplicationProtocols.Supported supported = (ApplicationProtocols.Supported)applicationProtocols2;
            Seq protos = supported.appProtocols();
            sslContextBuilder = builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(protos).asJava()));
        } else {
            throw new MatchError((Object)applicationProtocols2);
        }
        return sslContextBuilder;
    }

    public SslContextBuilder configureProvider(SslContextBuilder builder, boolean forceJdk) {
        return forceJdk ? builder.sslProvider(SslProvider.JDK) : builder;
    }

    private Netty4SslConfigurations$() {
        MODULE$ = this;
    }
}

