/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.ssl;

import com.twitter.finagle.Address;
import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.netty4.ssl.Alpn;
import com.twitter.finagle.netty4.ssl.Alpn$;
import com.twitter.finagle.netty4.ssl.SslConnectHandler;
import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.SessionVerifier;
import com.twitter.finagle.ssl.SessionVerifier$;
import com.twitter.finagle.transport.TlsConfig;
import com.twitter.finagle.transport.Transport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud!B\u0001\u0003\u0001\u0011a!\u0001\u0005(fiRLHgU:m\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0002tg2T!!\u0002\u0004\u0002\r9,G\u000f^=5\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0014\u0005\u0001i\u0001c\u0001\b\u0016/5\tqB\u0003\u0002\u0011#\u000591\r[1o]\u0016d'B\u0001\n\u0014\u0003\u0015qW\r\u001e;z\u0015\u0005!\u0012AA5p\u0013\t1rB\u0001\nDQ\u0006tg.\u001a7J]&$\u0018.\u00197ju\u0016\u0014\bC\u0001\b\u0019\u0013\tIrBA\u0004DQ\u0006tg.\u001a7\t\u0011m\u0001!\u0011!Q\u0001\nu\ta\u0001]1sC6\u001c8\u0001\u0001\t\u0003=\tr!a\b\u0011\u000e\u0003\u0019I!!\t\u0004\u0002\u000bM#\u0018mY6\n\u0005\r\"#A\u0002)be\u0006l7O\u0003\u0002\"\r!)a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001\u000b\u0016\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000bm)\u0003\u0019A\u000f\t\r1\u0002\u0001\u0015!\u0003.\u0003\u0019\u0019wN\u001c4jOB\u0011a&M\u0007\u0002_)\u0011\u0001GB\u0001\niJ\fgn\u001d9peRL!AM\u0018\u0003\u0013Qc7oQ8oM&<\u0007\"\u0002\u001b\u0001\t\u0003)\u0014aC5oSR\u001c\u0005.\u00198oK2$\"A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006{M\u0002\raF\u0001\u0003G\"Daa\u0010\u0001!\u0002\u0013\u0001\u0015!G2m_N,7\t[1o]\u0016dwJ\\\"m_N,gj\u001c;jMf\u00142!Q\"L\r\u0011\u0011e\b\u0001!\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u00027b]\u001eT\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n1qJ\u00196fGR\u00042\u0001T)T\u001b\u0005i%B\u0001(P\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003!F\tA!\u001e;jY&\u0011!+\u0014\u0002\u0016\u000f\u0016tWM]5d\rV$XO]3MSN$XM\\3s!\raEkF\u0005\u0003+6\u0013aAR;ukJ,\u0007BB,\u0001A\u0013%\u0001,A\bi_N$h.Y7f\u0003:$\u0007k\u001c:u)\tIV\u000eE\u000285rK!a\u0017\u001d\u0003\r=\u0003H/[8o!\u00119Tl\u00186\n\u0005yC$A\u0002+va2,'\u0007\u0005\u0002aO:\u0011\u0011-\u001a\t\u0003Ebj\u0011a\u0019\u0006\u0003Ir\ta\u0001\u0010:p_Rt\u0014B\u000149\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019D\u0004CA\u001cl\u0013\ta\u0007HA\u0002J]RDQa\u0007,A\u0002uAaa\u001c\u0001!\n\u0013\u0001\u0018a\u00064j]&\u001c\bnU3sm\u0016\u00148+\u001b3f\u0011\u0006tG\r\\3s)\r1\u0014O\u001d\u0005\u0006{9\u0004\ra\u0006\u0005\u0006\u00079\u0004\ra\u001d\t\u0003ibl\u0011!\u001e\u0006\u0003\u0007YT!a^\t\u0002\u000f!\fg\u000e\u001a7fe&\u0011\u00110\u001e\u0002\u000b'Nd\u0007*\u00198eY\u0016\u0014\bBB>\u0001A\u0013%A0A\fgS:L7\u000f[\"mS\u0016tGoU5eK\"\u000bg\u000e\u001a7feR!a' @\u0000\u0011\u0015i$\u00101\u0001\u0018\u0011\u0015\u0019!\u00101\u0001t\u0011\u001d\t\tA\u001fa\u0001\u0003\u0007\ta\u0002[8ti:\fW.Z(qi&|g\u000eE\u000285~C\u0001\"a\u0002\u0001A\u0013%\u0011\u0011B\u0001\u0016G2LWM\u001c;Ge>l'*\u0019<b\u0007>tG/\u001a=u)\u001d1\u00141BA\u0007\u0003GAa!PA\u0003\u0001\u00049\u0002\u0002CA\b\u0003\u000b\u0001\r!!\u0005\u0002\u000f\r|g\u000e^3yiB!\u00111CA\u0010\u001b\t\t)BC\u0002\u0004\u0003/QA!!\u0007\u0002\u001c\u0005\u0019a.\u001a;\u000b\u0005\u0005u\u0011!\u00026bm\u0006D\u0018\u0002BA\u0011\u0003+\u0011!bU*M\u0007>tG/\u001a=u\u0011!\t\t!!\u0002A\u0002\u0005\r\u0001\u0002CA\u0014\u0001\u0001&I!!\u000b\u0002-\rd\u0017.\u001a8u\rJ|WNT3uif\u001cuN\u001c;fqR$rANA\u0016\u0003[\t)\u0004\u0003\u0004>\u0003K\u0001\ra\u0006\u0005\t\u0003\u001f\t)\u00031\u0001\u00020A\u0019A/!\r\n\u0007\u0005MRO\u0001\u0006Tg2\u001cuN\u001c;fqRD\u0001\"!\u0001\u0002&\u0001\u0007\u00111\u0001\u0005\t\u0003s\u0001\u0001\u0015\"\u0003\u0002<\u0005q\u0011\r\u001d9Qe>$xnQ8oM&<G\u0003BA\u001f\u0003\u0007\u00022\u0001^A \u0013\r\t\t%\u001e\u0002\u001a\u0003B\u0004H.[2bi&|g\u000e\u0015:pi>\u001cw\u000e\\\"p]\u001aLw\r\u0003\u0005\u0002F\u0005]\u0002\u0019AA$\u00035qW\r\u001f;Qe>$xnY8mgB)\u0011\u0011JA*?:!\u00111JA(\u001d\r\u0011\u0017QJ\u0005\u0002s%\u0019\u0011\u0011\u000b\u001d\u0002\u000fA\f7m[1hK&!\u0011QKA,\u0005!IE/\u001a:bE2,'bAA)q!A\u00111\f\u0001!\n\u0013\ti&A\u0006qe>$xnQ8oM&<WCAA0!\u0015\tI%!\u0019`\u0013\u0011\t\u0019'a\u0016\u0003\u0007M+\u0017\u000f\u0003\u0005\u0002h\u0001\u0001K\u0011BA5\u00039\tG\r\u001a)s_R|7i\u001c8gS\u001e$B!a\u0012\u0002l!A\u0011QIA3\u0001\u0004\t9\u0005\u0003\u0005\u0002p\u0001\u0001K\u0011BA9\u0003\u001dIg.\u001b;UYN$2ANA:\u0011\u0019i\u0014Q\u000ea\u0001/\u0001")
public class Netty4SslHandler
extends ChannelInitializer<Channel> {
    private final Stack.Params params;
    private final TlsConfig config;
    private final GenericFutureListener<Future<Channel>> closeChannelOnCloseNotify;

    public void initChannel(Channel ch) {
        this.initTls(ch);
    }

    private Option<Tuple2<String, Object>> hostnameAndPort(Stack.Params params) {
        None$ none$;
        Address addr;
        Address addr2;
        Transporter.EndpointAddr endpointAddr = (Transporter.EndpointAddr)params.apply(Transporter.EndpointAddr$.MODULE$.param());
        if (endpointAddr == null) {
            throw new MatchError((Object)endpointAddr);
        }
        Address address = addr2 = endpointAddr.addr();
        Address address2 = addr = address;
        if (address2 instanceof Address.Inet) {
            Address.Inet inet = (Address.Inet)address2;
            InetSocketAddress isa = inet.addr();
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)isa.getHostName()), (Object)BoxesRunTime.boxToInteger((int)isa.getPort())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void finishServerSideHandler(Channel ch, SslHandler ssl) {
        ssl.engine().setUseClientMode(false);
        ch.pipeline().addFirst("ssl", (ChannelHandler)ssl);
    }

    private void finishClientSideHandler(Channel ch, SslHandler ssl, Option<String> hostnameOption) {
        ssl.engine().setUseClientMode(true);
        ssl.sslCloseFuture().addListener(this.closeChannelOnCloseNotify);
        SessionVerifier sessionValidation = (SessionVerifier)hostnameOption.map((Function1 & Serializable & scala.Serializable)hostname -> SessionVerifier$.MODULE$.hostname(hostname)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SessionVerifier$.MODULE$.AlwaysValid());
        ch.pipeline().addFirst("sslConnect", (ChannelHandler)new SslConnectHandler(ssl, (Function1<SSLSession, Option<Throwable>>)sessionValidation));
        ch.pipeline().addFirst("ssl", (ChannelHandler)ssl);
    }

    private void clientFromJavaContext(Channel ch, SSLContext context, Option<String> hostnameOption) {
        SslHandler handler = new SslHandler((SSLEngine)this.hostnameAndPort(this.params).fold((Function0 & Serializable & scala.Serializable)() -> context.createSSLEngine(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String hostname = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            SSLEngine sSLEngine = context.createSSLEngine((String)hostnameOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> hostname), port);
            return sSLEngine;
        }));
        this.finishClientSideHandler(ch, handler, hostnameOption);
    }

    private void clientFromNettyContext(Channel ch, SslContext context, Option<String> hostnameOption) {
        SslHandler handler = (SslHandler)this.hostnameAndPort(this.params).fold((Function0 & Serializable & scala.Serializable)() -> context.newHandler(ch.alloc()), (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String hostname = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            SslHandler sslHandler = context.newHandler(ch.alloc(), (String)hostnameOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> hostname), port);
            return sslHandler;
        });
        this.finishClientSideHandler(ch, handler, hostnameOption);
    }

    private ApplicationProtocolConfig appProtoConfig(Iterable<String> nextProtocols) {
        return !OpenSsl.isAvailable() || nextProtocols.isEmpty() ? ApplicationProtocolConfig.DISABLED : new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(nextProtocols).asJava());
    }

    private Seq<String> protoConfig() {
        Nil$ nil$;
        ApplicationProtocols protocols;
        ApplicationProtocols protocols2;
        Alpn alpn = (Alpn)this.params.apply(Alpn$.MODULE$.param());
        if (alpn == null) {
            throw new MatchError((Object)alpn);
        }
        ApplicationProtocols applicationProtocols = protocols2 = alpn.protocols();
        ApplicationProtocols applicationProtocols2 = protocols = applicationProtocols;
        if (ApplicationProtocols.Unspecified$.MODULE$.equals(applicationProtocols2)) {
            nil$ = Nil$.MODULE$;
        } else if (applicationProtocols2 instanceof ApplicationProtocols.Supported) {
            ApplicationProtocols.Supported supported = (ApplicationProtocols.Supported)applicationProtocols2;
            Seq protos = supported.appProtocols();
            nil$ = protos;
        } else {
            throw new MatchError((Object)applicationProtocols2);
        }
        return nil$;
    }

    private Iterable<String> addProtoConfig(Iterable<String> nextProtocols) {
        return (Iterable)((SeqLike)this.protoConfig().$plus$plus(nextProtocols, Seq$.MODULE$.canBuildFrom())).distinct();
    }

    private void initTls(Channel ch) {
        TlsConfig tlsConfig = this.config;
        if (tlsConfig instanceof TlsConfig.ServerCertAndKey) {
            TlsConfig.ServerCertAndKey serverCertAndKey = (TlsConfig.ServerCertAndKey)tlsConfig;
            String certPath = serverCertAndKey.certificatePath();
            String keyPath = serverCertAndKey.keyPath();
            Option caCertPath = serverCertAndKey.caCertificatePath();
            Option ciphers = serverCertAndKey.ciphers();
            Option nextProtocols = serverCertAndKey.nextProtocols();
            ApplicationProtocolConfig protos = this.appProtoConfig(this.addProtoConfig((Iterable<String>)((Iterable)nextProtocols.toList().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(","))), List$.MODULE$.canBuildFrom()))));
            this.finishServerSideHandler(ch, SslContextBuilder.forServer((File)new File(certPath), (File)new File(keyPath)).trustManager((File)caCertPath.map((Function1 & Serializable & scala.Serializable)path -> new File((String)path)).orNull(Predef$.MODULE$.$conforms())).ciphers((java.lang.Iterable)ciphers.map((Function1 & Serializable & scala.Serializable)s -> (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(":"))).toIterable()).asJava()).orNull(Predef$.MODULE$.$conforms())).applicationProtocolConfig(protos).build().newHandler(ch.alloc()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tlsConfig instanceof TlsConfig.ServerSslContext) {
            TlsConfig.ServerSslContext serverSslContext = (TlsConfig.ServerSslContext)tlsConfig;
            SSLContext e = serverSslContext.context();
            this.finishServerSideHandler(ch, new SslHandler(e.createSSLEngine()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tlsConfig instanceof TlsConfig.ClientHostname) {
            TlsConfig.ClientHostname clientHostname = (TlsConfig.ClientHostname)tlsConfig;
            String hostname = clientHostname.hostname();
            this.clientFromNettyContext(ch, SslContextBuilder.forClient().applicationProtocolConfig(this.appProtoConfig((Iterable<String>)this.protoConfig())).build(), (Option<String>)new Some((Object)hostname));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TlsConfig.Client$.MODULE$.equals(tlsConfig)) {
            this.clientFromNettyContext(ch, SslContextBuilder.forClient().applicationProtocolConfig(this.appProtoConfig((Iterable<String>)this.protoConfig())).build(), (Option<String>)None$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TlsConfig.ClientNoValidation$.MODULE$.equals(tlsConfig)) {
            this.clientFromNettyContext(ch, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(this.appProtoConfig((Iterable<String>)this.protoConfig())).build(), (Option<String>)None$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tlsConfig instanceof TlsConfig.ClientSslContext) {
            TlsConfig.ClientSslContext clientSslContext = (TlsConfig.ClientSslContext)tlsConfig;
            SSLContext context = clientSslContext.context();
            this.clientFromJavaContext(ch, context, (Option<String>)None$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tlsConfig instanceof TlsConfig.ClientSslContextAndHostname) {
            TlsConfig.ClientSslContextAndHostname clientSslContextAndHostname = (TlsConfig.ClientSslContextAndHostname)tlsConfig;
            SSLContext context = clientSslContextAndHostname.context();
            String hostname = clientSslContextAndHostname.hostname();
            this.clientFromJavaContext(ch, context, (Option<String>)new Some((Object)hostname));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TlsConfig.Disabled$.MODULE$.equals(tlsConfig)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tlsConfig);
        }
    }

    public Netty4SslHandler(Stack.Params params) {
        TlsConfig config;
        this.params = params;
        Transport.Tls tls = (Transport.Tls)params.apply(Transport.Tls$.MODULE$.param());
        if (tls == null) {
            throw new MatchError((Object)tls);
        }
        TlsConfig tlsConfig = config = tls.config();
        this.config = tlsConfig;
        this.closeChannelOnCloseNotify = new GenericFutureListener<Future<Channel>>(null){

            public void operationComplete(Future<Channel> f) {
                block0: {
                    Channel channel = (Channel)f.getNow();
                    if (channel == null || !f.isSuccess()) break block0;
                    channel.eventLoop().execute(new Runnable(null, channel){
                        private final Channel channel$1;

                        public void run() {
                            this.channel$1.close();
                        }
                        {
                            this.channel$1 = channel$1;
                        }
                    });
                }
            }
        };
    }
}

