/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.threading;

import com.twitter.concurrent.NamedPoolThreadFactory;
import com.twitter.finagle.netty4.threading.EventLoopGroupExecutionDelayTrackingRunnable;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Logger;
import com.twitter.util.Duration;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import java.util.Iterator;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.internal.util.WeakHashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class EventLoopGroupExecutionDelayTracker$ {
    public static final EventLoopGroupExecutionDelayTracker$ MODULE$ = new EventLoopGroupExecutionDelayTracker$();
    private static final WeakHashSet<EventLoopGroup> trackedEventLoopGroups = new WeakHashSet();

    public WeakHashSet<EventLoopGroup> trackedEventLoopGroups() {
        return trackedEventLoopGroups;
    }

    public void track(EventLoopGroup nettyEventLoopGroup, Duration injectionPeriod, Duration dumpThreshold, StatsReceiver statsReceiver, String dumpThreadPoolName, Logger logger) {
        EventLoopGroupExecutionDelayTracker$ eventLoopGroupExecutionDelayTracker$ = this;
        synchronized (eventLoopGroupExecutionDelayTracker$) {
            Object object;
            if (!this.trackedEventLoopGroups().contains((Object)nettyEventLoopGroup)) {
                boolean threadDumpEnabled = dumpThreshold.inMillis() > 0L;
                None$ dumpThresholdExceededThreadPool = threadDumpEnabled ? new Some((Object)new ScheduledThreadPoolExecutor(2, (ThreadFactory)new NamedPoolThreadFactory(dumpThreadPoolName))) : None$.MODULE$;
                Iterator workerIter = nettyEventLoopGroup.iterator();
                Stat stat = statsReceiver.stat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"workerpool", "deviation_ms"}));
                while (workerIter.hasNext()) {
                    EventExecutor loop = (EventExecutor)workerIter.next();
                    new EventLoopGroupExecutionDelayTrackingRunnable(loop, injectionPeriod, stat, dumpThreshold, (Option<ScheduledThreadPoolExecutor>)dumpThresholdExceededThreadPool, logger);
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.trackedEventLoopGroups().add((Object)nettyEventLoopGroup));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    private EventLoopGroupExecutionDelayTracker$() {
    }
}

