/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.codec.compression.zstd;

import com.github.luben.zstd.ZstdDirectBufferCompressingStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdByteBufDirectBufferCompressingStream
extends ZstdDirectBufferCompressingStream {
    private final ChannelHandlerContext ctx;
    private ByteBuf currentByteBuf;
    private static final int DEFAULT_BUFFER_SIZE = ZstdDirectBufferCompressingStream.recommendedOutputBufferSize();
    private static final int BUFFER_COPY_THRESHOLD = DEFAULT_BUFFER_SIZE / 8;

    private static ByteBuffer byteBufferView(ByteBuf byteBuf) {
        return byteBuf.internalNioBuffer(byteBuf.writerIndex(), DEFAULT_BUFFER_SIZE).slice();
    }

    private static ByteBuf allocateByteBuf(ChannelHandlerContext channelHandlerContext) {
        return channelHandlerContext.alloc().directBuffer(DEFAULT_BUFFER_SIZE);
    }

    public ZstdByteBufDirectBufferCompressingStream(ChannelHandlerContext channelHandlerContext, int n) throws IOException {
        this(channelHandlerContext, ZstdByteBufDirectBufferCompressingStream.allocateByteBuf(channelHandlerContext), n);
    }

    private ZstdByteBufDirectBufferCompressingStream(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n) throws IOException {
        super(ZstdByteBufDirectBufferCompressingStream.byteBufferView(byteBuf), n);
        this.ctx = channelHandlerContext;
        this.currentByteBuf = byteBuf;
    }

    public void compressByteBuf(ByteBuf byteBuf) throws IOException {
        if (byteBuf.isDirect() && byteBuf.isContiguous()) {
            this.compressDirect(byteBuf);
        } else {
            this.compressHeap(byteBuf);
        }
    }

    private void compressHeap(ByteBuf byteBuf) throws IOException {
        ByteBuf byteBuf2 = this.ctx.alloc().directBuffer(byteBuf.readableBytes());
        try {
            byteBuf2.writeBytes(byteBuf);
            this.compressDirect(byteBuf2);
        }
        finally {
            byteBuf2.release();
        }
    }

    private void compressDirect(ByteBuf byteBuf) throws IOException {
        int n = byteBuf.readableBytes();
        ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n);
        while (byteBuffer.hasRemaining()) {
            this.compress(byteBuffer);
        }
        byteBuf.readerIndex(byteBuf.readerIndex() + n);
    }

    protected ByteBuffer flushBuffer(ByteBuffer byteBuffer) {
        ByteBuf byteBuf;
        int n = DEFAULT_BUFFER_SIZE - byteBuffer.remaining();
        if (n < BUFFER_COPY_THRESHOLD) {
            byteBuf = this.ctx.alloc().directBuffer(n);
            byteBuf.writeBytes(this.currentByteBuf, this.currentByteBuf.writerIndex(), n);
        } else {
            this.currentByteBuf.writerIndex(this.currentByteBuf.writerIndex() + n);
            byteBuf = this.currentByteBuf;
            this.currentByteBuf = ZstdByteBufDirectBufferCompressingStream.allocateByteBuf(this.ctx);
        }
        this.ctx.write((Object)byteBuf, this.ctx.voidPromise());
        return ZstdByteBufDirectBufferCompressingStream.byteBufferView(this.currentByteBuf);
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.currentByteBuf != null) {
            this.currentByteBuf.release();
            this.currentByteBuf = null;
        }
    }
}

