/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.Service;
import com.twitter.finagle.redis.ServerError;
import com.twitter.finagle.redis.protocol.Auth;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.Command;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.ErrorReply;
import com.twitter.finagle.redis.protocol.FlushDB$;
import com.twitter.finagle.redis.protocol.Info;
import com.twitter.finagle.redis.protocol.Quit$;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.Select;
import com.twitter.finagle.redis.protocol.StatusReply;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001-\u0011!BQ1tK\u000ec\u0017.\u001a8u\u0015\t\u0019A!A\u0003sK\u0012L7O\u0003\u0002\u0006\r\u00059a-\u001b8bO2,'BA\u0004\t\u0003\u001d!x/\u001b;uKJT\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u000fM,'O^5dKB!QC\u0006\r\u001f\u001b\u0005!\u0011BA\f\u0005\u0005\u001d\u0019VM\u001d<jG\u0016\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0002\u0002\u0011A\u0014x\u000e^8d_2L!!\b\u000e\u0003\u000f\r{W.\\1oIB\u0011\u0011dH\u0005\u0003Ai\u0011QAU3qYfDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\u0003\u0011\u0015\u0019\u0012\u00051\u0001\u0015\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0011\tW\u000f\u001e5\u0015\u0005)\u001a\u0004cA\u0016/a5\tAF\u0003\u0002.\r\u0005!Q\u000f^5m\u0013\tyCF\u0001\u0004GkR,(/\u001a\t\u0003\u001bEJ!A\r\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006i\u001d\u0002\r!N\u0001\ta\u0006\u001c8o^8sIB\u0011agP\u0007\u0002o)\u0011\u0001(O\u0001\u0007EV4g-\u001a:\u000b\u0005iZ\u0014!\u00028fiRL(B\u0001\u001f>\u0003\u0015Q'm\\:t\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000e\u0002\u000e\u0007\"\fgN\\3m\u0005V4g-\u001a:\t\u000b\t\u0003A\u0011A\"\u0002\t%tgm\u001c\u000b\u0003\t\"\u00032a\u000b\u0018F!\ria)N\u0005\u0003\u000f:\u0011aa\u00149uS>t\u0007bB%B!\u0003\u0005\r!N\u0001\bg\u0016\u001cG/[8o\u0011\u0015Y\u0005\u0001\"\u0001M\u0003\u001d1G.^:i\t\n#\u0012A\u000b\u0005\u0006\u001d\u0002!\t\u0001T\u0001\u0005cVLG\u000fC\u0003Q\u0001\u0011\u0005\u0011+\u0001\u0004tK2,7\r\u001e\u000b\u0003UICQaU(A\u0002Q\u000bQ!\u001b8eKb\u0004\"!D+\n\u0005Ys!aA%oi\")\u0001\f\u0001C\u0001\u0019\u00069!/\u001a7fCN,\u0007B\u0002.\u0001\t\u0003\u00111,A\u0005e_J+\u0017/^3tiV\u0011A,\u0019\u000b\u0003;>$\"A\u00186\u0011\u0007-rs\f\u0005\u0002aC2\u0001A!\u00022Z\u0005\u0004\u0019'!\u0001+\u0012\u0005\u0011<\u0007CA\u0007f\u0013\t1gBA\u0004O_RD\u0017N\\4\u0011\u00055A\u0017BA5\u000f\u0005\r\te.\u001f\u0005\u0006Wf\u0003\r\u0001\\\u0001\bQ\u0006tG\r\\3s!\u0011iQN\b0\n\u00059t!a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\t\u000bAL\u0006\u0019\u0001\r\u0002\u0007\rlG\r\u0003\u0004s\u0001\u0011\u0005!a]\u0001\fe\u0016$XO\u001d8QC&\u00148\u000f\u0006\u0002u{B\u0019Q\u000f\u001f>\u000e\u0003YT!a\u001e\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002zm\n\u00191+Z9\u0011\t5YX'N\u0005\u0003y:\u0011a\u0001V;qY\u0016\u0014\u0004\"\u0002@r\u0001\u0004y\u0018\u0001C7fgN\fw-Z:\u0011\u000b\u0005\u0005\u0011\u0011C\u001b\u000f\t\u0005\r\u0011Q\u0002\b\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\b\u001d\u00059\u0001/Y2lC\u001e,\u0017bA=\u0002\u0014)\u0019\u0011q\u0002\b\t\u0013\u0005]\u0001!%A\u0005\u0002\u0005e\u0011AD5oM>$C-\u001a4bk2$H%M\u000b\u0003\u00037Q3!NA\u000fW\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0015\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class BaseClient {
    private final Service<Command, Reply> service;

    public Future<BoxedUnit> auth(ChannelBuffer password) {
        return this.doRequest(new Auth(password), (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<Option<ChannelBuffer>> info(ChannelBuffer section) {
        return this.doRequest(new Info(section), (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public ChannelBuffer info$default$1() {
        return ChannelBuffers.EMPTY_BUFFER;
    }

    public Future<BoxedUnit> flushDB() {
        return this.doRequest(FlushDB$.MODULE$, (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<BoxedUnit> quit() {
        return this.doRequest(Quit$.MODULE$, (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                A1 A1 = x5;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x5);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<BoxedUnit> select(int index) {
        return this.doRequest(new Select(index), (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                A1 A1 = x6;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x6);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x6) {
                Reply reply = x6;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<BoxedUnit> release() {
        return this.service.close();
    }

    public <T> Future<T> doRequest(Command cmd, PartialFunction<Reply, Future<T>> handler) {
        return this.service.apply((Object)cmd).flatMap((Function1)handler.orElse((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future future;
                A1 A1 = x1;
                if (A1 instanceof ErrorReply) {
                    ErrorReply errorReply = (ErrorReply)A1;
                    String message = errorReply.message();
                    future = Future$.MODULE$.exception((Throwable)new ServerError(message));
                } else {
                    future = Future$.MODULE$.exception((Throwable)new IllegalStateException());
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof ErrorReply ? true : true;
                return bl;
            }
        }));
    }

    public Seq<Tuple2<ChannelBuffer, ChannelBuffer>> returnPairs(Seq<ChannelBuffer> messages) {
        Predef$.MODULE$.assert(messages.length() % 2 == 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Odd number of items in response";
            }
        });
        return (Seq)messages.grouped(2).toSeq().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<ChannelBuffer, ChannelBuffer>> apply(Seq<ChannelBuffer> x0$1) {
                Iterable iterable;
                Seq<ChannelBuffer> seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    ChannelBuffer a = (ChannelBuffer)((SeqLike)some.get()).apply(0);
                    ChannelBuffer b = (ChannelBuffer)((SeqLike)some.get()).apply(1);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)a, (Object)b)));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BaseClient(Service<Command, Reply> service) {
        this.service = service;
    }
}

