/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.redis.BaseClient;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.EmptyMBulkReply;
import com.twitter.finagle.redis.protocol.IntegerReply;
import com.twitter.finagle.redis.protocol.MBulkReply;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.SAdd;
import com.twitter.finagle.redis.protocol.SCard;
import com.twitter.finagle.redis.protocol.SInter;
import com.twitter.finagle.redis.protocol.SIsMember;
import com.twitter.finagle.redis.protocol.SMembers;
import com.twitter.finagle.redis.protocol.SPop;
import com.twitter.finagle.redis.protocol.SRandMember;
import com.twitter.finagle.redis.protocol.SRem;
import com.twitter.finagle.redis.util.ReplyFormat$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;

public abstract class Sets$class {
    public static Future sAdd(BaseClient $this, ChannelBuffer key, List members) {
        return $this.doRequest(new SAdd(key, (Seq<ChannelBuffer>)members), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future sMembers(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new SMembers(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> list = mBulkReply.messages();
                    object = Future$.MODULE$.value((Object)ReplyFormat$.MODULE$.toChannelBuffers(list).toSet());
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.value((Object)Set$.MODULE$.apply((Seq)Nil$.MODULE$)) : function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
        });
    }

    public static Future sIsMember(BaseClient $this, ChannelBuffer key, ChannelBuffer member) {
        return $this.doRequest(new SIsMember(key, member), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x3;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future sCard(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new SCard(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future sRem(BaseClient $this, ChannelBuffer key, List members) {
        return $this.doRequest(new SRem(key, (List<ChannelBuffer>)members), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x5;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x5);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future sPop(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new SPop(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x6;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x6) {
                Reply reply = x6;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future sRandMember(BaseClient $this, ChannelBuffer key, Option count) {
        return $this.doRequest(new SRandMember(key, (Option<Object>)count), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x7;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{message})));
                } else if (A1 instanceof EmptyBulkReply) {
                    object = Future$.MODULE$.Nil();
                } else if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> messages = mBulkReply.messages();
                    object = Future$.MODULE$.value(ReplyFormat$.MODULE$.toChannelBuffers(messages));
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.Nil() : function1.apply(x7);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x7) {
                Reply reply = x7;
                boolean bl = reply instanceof BulkReply ? true : (reply instanceof EmptyBulkReply ? true : (reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply));
                return bl;
            }
        });
    }

    public static Option sRandMember$default$2(BaseClient $this) {
        return None$.MODULE$;
    }

    public static Future sInter(BaseClient $this, Seq keys2) {
        return $this.doRequest(new SInter((Seq<ChannelBuffer>)keys2), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x8;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> messages = mBulkReply.messages();
                    object = Future$.MODULE$.value((Object)ReplyFormat$.MODULE$.toChannelBuffers(messages).toSet());
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.value((Object)Set$.MODULE$.apply((Seq)Nil$.MODULE$)) : function1.apply(x8);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x8) {
                Reply reply = x8;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
        });
    }

    public static void $init$(BaseClient $this) {
    }
}

