/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis.util;

import com.twitter.util.RandomSocket$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u001b\tiQ\t\u001f;fe:\fGNU3eSNT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\tQA]3eSNT!a\u0002\u0005\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011BC\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0011aA2p[\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00075\u0001\u0001\u000b\u0011B\u000e\u0002\tI\fg\u000e\u001a\t\u00039yi\u0011!\b\u0006\u0003\u0007AI!aH\u000f\u0003\rI\u000bg\u000eZ8n\u0011\u0019\t\u0003\u0001)Q\u0005E\u00059\u0001O]8dKN\u001c\bcA\b$K%\u0011A\u0005\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001\u00027b]\u001eT\u0011AK\u0001\u0005U\u00064\u0018-\u0003\u0002-O\t9\u0001K]8dKN\u001c\bB\u0002\u0018\u0001A\u0003%q&\u0001\bg_J\u0014\u0017\u000e\u001a3f]B{'\u000f^:\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014!C5n[V$\u0018M\u00197f\u0015\t!\u0004#\u0001\u0006d_2dWm\u0019;j_:L!AN\u0019\u0003\u000bI\u000bgnZ3\t\u000fa\u0002\u0001\u0019!C\u0001s\u00059\u0011\r\u001a3sKN\u001cX#\u0001\u001e\u0011\u0007=\u00193\b\u0005\u0002=\u007f5\tQH\u0003\u0002?S\u0005\u0019a.\u001a;\n\u0005\u0001k$!E%oKR\u001cvnY6fi\u0006#GM]3tg\"9!\t\u0001a\u0001\n\u0003\u0019\u0015aC1eIJ,7o]0%KF$\"\u0001R$\u0011\u0005=)\u0015B\u0001$\u0011\u0005\u0011)f.\u001b;\t\u000f!\u000b\u0015\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\t\r)\u0003\u0001\u0015)\u0003;\u0003!\tG\r\u001a:fgN\u0004\u0003B\u0002'\u0001A\u0013%Q*\u0001\rbgN,'\u000f\u001e*fI&\u001c()\u001b8bef\u0004&/Z:f]R$\u0012\u0001\u0012\u0005\u0007\u001f\u0002\u0001K\u0011B'\u0002\u0017\u0019Lg\u000eZ!eIJ,7o\u001d\u0005\u0006#\u0002!\tBU\u0001\u0011GJ,\u0017\r^3D_:4\u0017n\u001a$jY\u0016$\"aU-\u0011\u0005Q;V\"A+\u000b\u0005YK\u0013AA5p\u0013\tAVK\u0001\u0003GS2,\u0007\"\u0002.Q\u0001\u0004Y\u0016\u0001\u00029peR\u0004\"a\u0004/\n\u0005u\u0003\"aA%oi\")q\f\u0001C\u0001\u001b\u0006)1\u000f^1si\")\u0011\r\u0001C\u0001\u001b\u0006!1\u000f^8q\u0011\u0015\u0019\u0007\u0001\"\u0001N\u0003\u001d\u0011Xm\u001d;beR\u0004")
public class ExternalRedis {
    private final Random rand = new Random();
    private Option<Process> process = None$.MODULE$;
    private final Range forbiddenPorts = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(6300), 7300);
    private Option<InetSocketAddress> address = None$.MODULE$;

    public Option<InetSocketAddress> address() {
        return this.address;
    }

    public void address_$eq(Option<InetSocketAddress> x$1) {
        this.address = x$1;
    }

    private void assertRedisBinaryPresent() {
        Process p = new ProcessBuilder("redis-server", "--help").start();
        p.waitFor();
        int exitValue = p.exitValue();
        Predef$.MODULE$.require(exitValue == 0 || exitValue == 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "redis-server binary must be present.";
            }
        });
    }

    private void findAddress() {
        int tries = 100;
        while (true) {
            Option<InetSocketAddress> option = this.address();
            None$ none$ = None$.MODULE$;
            if ((option != null ? !option.equals((Object)none$) : none$ != null) || tries < 0) break;
            this.address_$eq((Option<InetSocketAddress>)new Some((Object)RandomSocket$.MODULE$.nextAddress()));
            if (!this.forbiddenPorts.contains(((InetSocketAddress)this.address().get()).getPort())) continue;
            this.address_$eq((Option<InetSocketAddress>)None$.MODULE$);
            --tries;
            Thread.sleep(5L);
        }
        this.address().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("Couldn't get an address for the external redis instance");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public File createConfigFile(int port) {
        void var2_2;
        File f = File.createTempFile(new StringBuilder().append((Object)"redis-").append((Object)BoxesRunTime.boxToInteger((int)this.rand.nextInt(1000))).toString(), ".tmp");
        f.deleteOnExit();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        String conf = new StringOps(Predef$.MODULE$.augmentString("port %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)}));
        out.write(conf);
        out.println();
        out.close();
        return var2_2;
    }

    public void start() {
        int port = ((InetSocketAddress)this.address().get()).getPort();
        String conf = this.createConfigFile(port).getAbsolutePath();
        Seq cmd = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"redis-server", conf}));
        ProcessBuilder builder = new ProcessBuilder(JavaConversions$.MODULE$.seqAsJavaList((Seq)cmd.toList()));
        this.process = new Some((Object)builder.start());
        Thread.sleep(200L);
    }

    public void stop() {
        this.process.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Process p) {
                p.destroy();
                return p.waitFor();
            }
        });
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public ExternalRedis() {
        this.assertRedisBinaryPresent();
        this.findAddress();
    }
}

