/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.twitter.common.stats.Histogram;
import com.twitter.finagle.stats.BucketAndCount;
import com.twitter.finagle.stats.BucketedHistogram$;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055rAB\u0001\u0003\u0011\u00031!\"A\tCk\u000e\\W\r^3e\u0011&\u001cHo\\4sC6T!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\u001c\t\u0003\u00171i\u0011A\u0001\u0004\u0007\u001b\tA\tA\u0002\b\u0003#\t+8m[3uK\u0012D\u0015n\u001d;pOJ\fWn\u0005\u0002\r\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001aDQA\u0006\u0007\u0005\u0002a\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002\u0015!1!\u0004\u0004Q\u0005\nm\tQ\"\\1lK2KW.\u001b;t\r>\u0014HC\u0001\u000f#!\r\u0001RdH\u0005\u0003=E\u0011Q!\u0011:sCf\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\")1%\u0007a\u0001I\u0005)QM\u001d:peB\u0011\u0001#J\u0005\u0003ME\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0015\r\u0005\u0004%\tAA\u0015\u0002'\u0011+g-Y;mi\u0016\u0013(o\u001c:QKJ\u001cWM\u001c;\u0016\u0003\u0011Baa\u000b\u0007!\u0002\u0013!\u0013\u0001\u0006#fM\u0006,H\u000e^#se>\u0014\b+\u001a:dK:$\b\u0005\u0003\u0004.\u0019\u0001\u0006I\u0001H\u0001\u000e\t\u00164\u0017-\u001e7u\u0019&l\u0017\u000e^:\t\u000b=bA\u0011\u0002\u0019\u0002\u0019\u0005\u001c8/\u001a:u\u0019&l\u0017\u000e^:\u0015\u0005E\"\u0004C\u0001\t3\u0013\t\u0019\u0014C\u0001\u0003V]&$\b\"B\u001b/\u0001\u0004a\u0012A\u00027j[&$8\u000fC\u00038\u0019\u0011\u0005\u0001(A\u0003baBd\u0017\u0010F\u0001:!\tY!HB\u0003\u000e\u0005\u0001\u00111hE\u0002;y\u0011\u0003\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\t1\fgn\u001a\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019eH\u0001\u0004PE*,7\r\u001e\t\u0003\u000b&k\u0011A\u0012\u0006\u0003\u0007\u001dS!\u0001\u0013\u0004\u0002\r\r|W.\\8o\u0013\tQeIA\u0005ISN$xn\u001a:b[\"AQG\u000fB\u0001B\u0003%A\u0004C\u0003\u0017u\u0011\u0005Q\n\u0006\u0002:\u001d\")Q\u0007\u0014a\u00019!1\u0001K\u000fQ\u0005\nE\u000bAbY8v]R\u001cH*\u001a8hi\",\u0012a\b\u0005\u0007'j\u0002\u000b\u0011\u0002\u000f\u0002\r\r|WO\u001c;t\u0011\u0019)&\b)Q\u0005-\u0006\u0019a.^7\u0011\u0005A9\u0016B\u0001-\u0012\u0005\u0011auN\\4\t\riS\u0004\u0015)\u0003W\u0003\u0015!x\u000e^1m\u0011\u0015a&\b\"\u0001^\u0003\r\tG\r\u001a\u000b\u0003cyCQaX.A\u0002Y\u000bQA^1mk\u0016DQ!\u0019\u001e\u0005B\t\fQa\u00197fCJ$\u0012!\r\u0005\u0006Ij\"\t!Z\u0001\u000ba\u0016\u00148-\u001a8uS2,GC\u0001,g\u0011\u001597\r1\u0001%\u0003\u0005\u0001\b\"B5;\t\u0003Q\u0017aB7bq&lW/\\\u000b\u0002-\")AN\u000fC\u0001U\u00069Q.\u001b8j[Vl\u0007B\u00028;A\u0013%q.A\u0007mS6LG/T5ea>Lg\u000e\u001e\u000b\u0003-BDQ!]7A\u0002}\t\u0011!\u001b\u0005\u0006gj\"\t\u0005^\u0001\fO\u0016$\u0018+^1oi&dW\r\u0006\u0002Wk\")aO\u001da\u0001I\u0005A\u0011/^1oi&dW\rC\u0003yu\u0011\u0005\u00130\u0001\u0007hKR\fV/\u00198uS2,7\u000f\u0006\u0002{wB\u0019\u0001#\b,\t\u000bq<\b\u0019A?\u0002\u0013E,\u0018M\u001c;jY\u0016\u001c\bc\u0001\t\u001eI!)qP\u000fC\u0001U\u0006\u00191/^7\t\r\u0005\r!\b\"\u0001k\u0003\u0015\u0019w.\u001e8u\u0011\u0019\t9A\u000fC\u0001S\u00059\u0011M^3sC\u001e,\u0007bBA\u0006u\u0011\u0005\u0011QB\u0001\u0010EV\u001c7.\u001a;B]\u0012\u001cu.\u001e8ugV\u0011\u0011q\u0002\t\u0007\u0003#\t\t#a\n\u000f\t\u0005M\u0011Q\u0004\b\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012bAA\u0010#\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003K\u00111aU3r\u0015\r\ty\"\u0005\t\u0004\u0017\u0005%\u0012bAA\u0016\u0005\tq!)^2lKR\fe\u000eZ\"pk:$\b")
public class BucketedHistogram
implements Histogram {
    public final int[] com$twitter$finagle$stats$BucketedHistogram$$limits;
    private final int[] counts;
    private long num;
    private long total;

    public static BucketedHistogram apply() {
        return BucketedHistogram$.MODULE$.apply();
    }

    private int countsLength() {
        return this.com$twitter$finagle$stats$BucketedHistogram$$limits.length + 1;
    }

    public void add(long value) {
        int n;
        if (value >= Integer.MAX_VALUE) {
            this.total += Integer.MAX_VALUE;
            n = this.countsLength() - 1;
        } else {
            this.total += value;
            int asInt = (int)value;
            n = Math.abs(Arrays.binarySearch(this.com$twitter$finagle$stats$BucketedHistogram$$limits, asInt) + 1);
        }
        int index = n;
        this.counts[index] = this.counts[index] + 1;
        ++this.num;
    }

    public void clear() {
        for (int i = 0; i < this.countsLength(); ++i) {
            this.counts[i] = 0;
        }
        this.num = 0L;
        this.total = 0L;
    }

    public long percentile(double p) {
        long l;
        int i;
        if (p < 0.0 || p > 1.0) {
            throw new AssertionError((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile must be within 0.0 to 1.0 inclusive: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)p)})));
        }
        long target = Math.round(p * (double)this.num);
        long total = 0L;
        for (i = 0; i < this.countsLength() && total < target; total += (long)this.counts[i], ++i) {
        }
        int n = i;
        switch (n) {
            default: {
                if (i == this.countsLength()) {
                    l = this.maximum();
                    break;
                }
                l = this.limitMidpoint(i - 1);
                break;
            }
            case 0: {
                l = 0L;
            }
        }
        return l;
    }

    public long maximum() {
        long l;
        if (this.num == 0L) {
            l = 0L;
        } else if (this.counts[this.countsLength() - 1] > 0) {
            l = Integer.MAX_VALUE;
        } else {
            int i;
            for (i = this.countsLength() - 2; i >= 0 && this.counts[i] == 0; --i) {
            }
            l = i == 0 ? 0L : this.limitMidpoint(i);
        }
        return l;
    }

    public long minimum() {
        long l;
        if (this.num == 0L) {
            l = 0L;
        } else {
            int i;
            for (i = 0; i < this.countsLength() && this.counts[i] == 0; ++i) {
            }
            l = this.limitMidpoint(i);
        }
        return l;
    }

    private long limitMidpoint(int i) {
        long l;
        int n = i;
        switch (n) {
            default: {
                if (i >= this.com$twitter$finagle$stats$BucketedHistogram$$limits.length) {
                    l = Integer.MAX_VALUE;
                    break;
                }
                l = ((long)this.com$twitter$finagle$stats$BucketedHistogram$$limits[i - 1] + (long)this.com$twitter$finagle$stats$BucketedHistogram$$limits[i]) / 2L;
                break;
            }
            case 0: {
                l = 0L;
            }
        }
        return l;
    }

    public long getQuantile(double quantile) {
        return this.percentile(quantile);
    }

    /*
     * WARNING - void declaration
     */
    public long[] getQuantiles(double[] quantiles) {
        void var2_2;
        long[] ps = new long[quantiles.length];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = this.percentile(quantiles[i]);
        }
        return var2_2;
    }

    public long sum() {
        return this.total;
    }

    public long count() {
        return this.num;
    }

    public double average() {
        return this.num == 0L ? 0.0 : (double)this.total / (double)this.num;
    }

    public Seq<BucketAndCount> bucketAndCounts() {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(this.counts).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BucketedHistogram $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int count = A1._1$mcI$sp();
                    int idx = A1._2$mcI$sp();
                    if (count != 0) {
                        int upperLimit = idx != this.$outer.com$twitter$finagle$stats$BucketedHistogram$$limits.length ? this.$outer.com$twitter$finagle$stats$BucketedHistogram$$limits[idx] : Integer.MAX_VALUE;
                        int lowerLimit = idx != 0 ? this.$outer.com$twitter$finagle$stats$BucketedHistogram$$limits[idx - 1] : 0;
                        object = new BucketAndCount((long)lowerLimit, (long)upperLimit, count);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int count;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (count = tuple2._1$mcI$sp()) != 0;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BucketAndCount.class)))).toSeq();
    }

    public BucketedHistogram(int[] limits) {
        this.com$twitter$finagle$stats$BucketedHistogram$$limits = limits;
        BucketedHistogram$.MODULE$.com$twitter$finagle$stats$BucketedHistogram$$assertLimits(limits);
        this.counts = new int[this.countsLength()];
        this.num = 0L;
        this.total = 0L;
    }
}

